/*
 * Decompiled with CFR 0.152.
 */
package com.lightdev.app.shtm;

import com.lightdev.app.shtm.ActionBuilder;
import com.lightdev.app.shtm.AttributeComponent;
import com.lightdev.app.shtm.AttributeMapper;
import com.lightdev.app.shtm.DefaultTextResources;
import com.lightdev.app.shtm.DocNameMissingException;
import com.lightdev.app.shtm.DocumentPane;
import com.lightdev.app.shtm.DynamicResource;
import com.lightdev.app.shtm.ManagePluginsAction;
import com.lightdev.app.shtm.PluginManager;
import com.lightdev.app.shtm.SHTMLAction;
import com.lightdev.app.shtm.SHTMLDocument;
import com.lightdev.app.shtm.SHTMLEditorKitActions;
import com.lightdev.app.shtm.SHTMLEditorPane;
import com.lightdev.app.shtm.SHTMLHelpBroker;
import com.lightdev.app.shtm.SHTMLMenuBar;
import com.lightdev.app.shtm.SHTMLPanel;
import com.lightdev.app.shtm.SHTMLPlugin;
import com.lightdev.app.shtm.SplashScreen;
import com.lightdev.app.shtm.SplitPanel;
import com.lightdev.app.shtm.StyleSelector;
import com.lightdev.app.shtm.TagSelector;
import com.lightdev.app.shtm.TextResources;
import com.lightdev.app.shtm.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import javax.swing.undo.UndoManager;

public class SHTMLPanelImpl
extends SHTMLPanel
implements CaretListener {
    public static final String APP_TEMP_DIR = "temp";
    public static final String IMAGE_DIR = "images";
    public static final String ACTION_SELECTED_KEY = "selected";
    public static final String ACTION_SELECTED = "true";
    public static final String ACTION_UNSELECTED = "false";
    public static final String FILE_LAST_OPEN = "lastOpenFileName";
    public static final String FILE_LAST_SAVE = "lastSaveFileName";
    public DynamicResource dynRes = new DynamicResource();
    private static TextResources textResources = null;
    public static PluginManager pluginManager;
    protected ActionListener openHyperlinkHandler = null;
    private final SHTMLMenuBar menuBar;
    private DocumentPane documentPane;
    private SHTMLEditorPane editorPane;
    protected SHTMLDocument doc;
    private JToolBar formatToolBar;
    private JToolBar paraToolBar;
    public final String pluginMenuId = "plugin";
    public final String helpMenuId = "help";
    private final String emptyIcon = "emptyIcon";
    private final RepeatKeyWatcher rkw = new RepeatKeyWatcher(40L);
    int newDocCounter = 0;
    private static File appTempDir;
    private static ActionBuilder actionBuilder;
    private TagSelector tagSelector;
    SplitPanel splitPanel;
    boolean ignoreActivateDoc = false;
    private final JPopupMenu editorPopup;
    public static final String exitAction = "exit";
    public static final String undoAction = "undo";
    public static final String redoAction = "redo";
    public static final String cutAction = "cut";
    public static final String copyAction = "copy";
    public static final String pasteAction = "paste";
    public static final String pasteOtherAction = "pasteOther";
    public static final String selectAllAction = "selectAll";
    public static final String clearFormatAction = "clearFormat";
    public static final String fontAction = "font";
    public static final String fontFamilyAction = "fontFamily";
    public static final String fontSizeAction = "fontSize";
    public static final String fontBoldAction = "fontBold";
    public static final String fontStrikethroughAction = "fontStrikethrough";
    public static final String fontItalicAction = "fontItalic";
    public static final String fontUnderlineAction = "fontUnderline";
    public static final String fontColorAction = "fontColor";
    public static final String helpTopicsAction = "helpTopics";
    public static final String aboutAction = "about";
    public static final String gcAction = "gc";
    public static final String elemTreeAction = "elemTree";
    public static final String testAction = "test";
    public static final String insertTableAction = "insertTable";
    public static final String formatTableAction = "formatTable";
    public static final String toggleTableHeaderCellAction = "toggleTableHeaderCell";
    public static final String insertTableColAction = "insertTableCol";
    public static final String insertTableRowAction = "insertTableRow";
    public static final String insertTableRowHeaderAction = "insertTableRowHeader";
    public static final String appendTableRowAction = "appendTableRow";
    public static final String appendTableColAction = "appendTableCol";
    public static final String deleteTableRowAction = "deleteTableRow";
    public static final String deleteTableColAction = "deleteTableCol";
    public static final String nextTableCellAction = "nextTableCell";
    public static final String prevTableCellAction = "prevTableCell";
    public static final String moveTableRowUpAction = "moveTableRowUp";
    public static final String moveTableColumnLeftAction = "moveTableColumnLeft";
    public static final String moveTableColumnRightAction = "moveTableColumnRight";
    public static final String moveTableRowDownAction = "moveTableRowDown";
    public static final String toggleBulletsAction = "toggleBullets";
    public static final String toggleNumbersAction = "toggleNumbers";
    public static final String formatListAction = "formatList";
    public static final String editPrefsAction = "editPrefs";
    public static final String insertImageAction = "insertImage";
    public static final String formatImageAction = "formatImage";
    public static final String formatParaAction = "formatPara";
    public static final String editNamedStyleAction = "editNamedStyle";
    public static final String paraAlignLeftAction = "paraAlignLeft";
    public static final String paraAlignCenterAction = "paraAlignCenter";
    public static final String paraAlignRightAction = "paraAlignRight";
    public static final String insertLinkAction = "insertLink";
    public static final String editLinkAction = "editLink";
    public static final String openLinkAction = "openLink";
    public static final String setTagAction = "setTag";
    public static final String editAnchorsAction = "editAnchors";
    public static final String saveAllAction = "saveAll";
    public static final String documentTitleAction = "documentTitle";
    public static final String setDefaultStyleRefAction = "setDefaultStyleRef";
    public static final String findReplaceAction = "findReplace";
    public static final String setStyleAction = "setStyle";
    public static final String formatAsCodeAction = "formatAsCode";
    public static final String printAction = "print";
    private final UndoableEditListener undoHandler = new UndoHandler();
    private UndoManager undo = new UndoManager();
    static final String[] FONT_SIZES;

    public static TextResources getResources() {
        if (textResources == null) {
            textResources = SHTMLPanelImpl.readDefaultResources();
        }
        return textResources;
    }

    public static void setTextResources(TextResources textResources) {
        if (SHTMLPanelImpl.textResources != null) {
            return;
        }
        SHTMLPanelImpl.textResources = textResources != null ? textResources : SHTMLPanelImpl.readDefaultResources();
    }

    private static TextResources readDefaultResources() {
        try {
            String propsLoc = "com/lightdev/app/shtm/resources/SimplyHTML_common.properties";
            URL defaultPropsURL = ClassLoader.getSystemResource("com/lightdev/app/shtm/resources/SimplyHTML_common.properties");
            Properties props = new Properties();
            InputStream in = null;
            in = defaultPropsURL.openStream();
            props.load(in);
            in.close();
            ResourceBundle resourceBundle = ResourceBundle.getBundle("com.lightdev.app.shtm.resources.SimplyHTML", Locale.getDefault());
            return new DefaultTextResources(resourceBundle, props);
        }
        catch (Exception ex) {
            Util.errMsg(null, "resources not found", ex);
            return null;
        }
    }

    public static SHTMLPanelImpl getOwnerSHTMLPanel(Component c) {
        while (c != null) {
            if (c instanceof SHTMLPanelImpl) {
                return (SHTMLPanelImpl)c;
            }
            c = c.getParent();
        }
        return null;
    }

    SHTMLPanelImpl() {
        super(new BorderLayout());
        SplashScreen.showInstance();
        this.enableEvents(64L);
        this.initActions();
        if (actionBuilder != null) {
            actionBuilder.initActions(this);
        }
        this.menuBar = this.dynRes.createMenubar(textResources, "menubar");
        this.editorPopup = this.dynRes.createPopupMenu(textResources, "popup");
        this.setJMenuBar(this.menuBar);
        this.customizeFrame();
        this.initAppTempDir();
        this.initPlugins();
        this.initDocumentPane();
        this.updateActions();
        this.initJavaHelp();
        SplashScreen.hideInstance();
    }

    private void setJMenuBar(JMenuBar bar) {
        this.add((Component)bar, "North");
    }

    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        if (super.processKeyBinding(ks, e, condition, pressed)) {
            return true;
        }
        return this.menuBar.handleKeyBinding(ks, e, condition, pressed);
    }

    public JMenuItem newActionMenuItem(String actionName) {
        return this.dynRes.createMenuItem(SHTMLPanelImpl.getResources(), actionName);
    }

    public Action getAction(String actionName) {
        return this.dynRes.getAction(actionName);
    }

    DynamicResource getDynRes() {
        return this.dynRes;
    }

    static File getAppTempDir() {
        return appTempDir;
    }

    File getCurrentFile() {
        File file = null;
        URL url = this.getDocumentPane().getSource();
        if (url != null) {
            file = new File(url.getFile());
        }
        return file;
    }

    String getCurrentDocName() {
        return this.getDocumentPane().getDocumentName();
    }

    public String getDocumentText() {
        return this.getDocumentPane().getDocumentText();
    }

    Document getCurrentDocument() {
        return this.getDocumentPane().getDocument();
    }

    public boolean needsSaving() {
        return this.getDocumentPane().needsSaving();
    }

    void purgeUndos() {
        if (this.undo != null) {
            this.undo.discardAllEdits();
            this.dynRes.getAction(undoAction).putValue("enabled", Boolean.FALSE);
            this.dynRes.getAction(redoAction).putValue("enabled", Boolean.FALSE);
            this.updateFormatControls();
        }
    }

    public void setCurrentDocumentContent(String sText) {
        this.getDocumentPane().setDocumentText(sText);
        this.purgeUndos();
    }

    public void setContentPanePreferredSize(Dimension prefSize) {
        this.getDocumentPane().setContentPanePreferredSize(prefSize);
    }

    public HTMLDocument getDocument() {
        return this.doc;
    }

    DocumentPane getCurrentDocumentPane() {
        return this.getDocumentPane();
    }

    void addDocumentPaneListener(DocumentPane.DocumentPaneListener listener) {
        if (this.getDocumentPane() != null) {
            this.getDocumentPane().addDocumentPaneListener(listener);
        }
    }

    void removeDocumentPaneListener(DocumentPane.DocumentPaneListener listener) {
        if (this.getDocumentPane() != null) {
            this.getDocumentPane().removeDocumentPaneListener(listener);
        }
    }

    private void initAppTempDir() {
        appTempDir = new File(System.getProperty("user.home") + File.separator + "." + "SimplyHTML".toLowerCase() + File.separator + APP_TEMP_DIR + File.separator);
    }

    void initPlugins() {
        pluginManager = new PluginManager(this);
        JMenu pMenu = this.dynRes.getMenu("plugin");
        if (pMenu != null) {
            SHTMLPanelImpl contentPane = this;
            pluginManager.loadPlugins();
            Enumeration plugins = pluginManager.plugins();
            while (plugins.hasMoreElements()) {
                SHTMLPlugin pi = (SHTMLPlugin)plugins.nextElement();
                if (!pi.isActive()) continue;
                this.refreshPluginDisplay(pi);
            }
        }
        this.adjustDividers();
    }

    public void adjustDividers() {
        this.splitPanel.adjustDividerSizes();
    }

    public void clearDockPanels() {
        this.splitPanel.removeAllOuterPanels();
    }

    public void refreshPluginDisplay(SHTMLPlugin pi) {
        JMenu pMenu = this.dynRes.getMenu("plugin");
        JMenu hMenu = this.dynRes.getMenu("help");
        JMenuItem pluginMenu = pi.getPluginMenu();
        JMenuItem helpMenu = pi.getHelpMenu();
        JTabbedPane p = null;
        if (pi.isActive()) {
            JComponent pc = pi.getComponent();
            if (pc != null) {
                int panelNo = 3;
                double loc = 0.3;
                switch (pi.getDockLocation()) {
                    case 4: {
                        break;
                    }
                    case 2: {
                        panelNo = 1;
                        loc = 0.7;
                        break;
                    }
                    case 3: {
                        panelNo = 2;
                        loc = 0.7;
                        break;
                    }
                    case 1: {
                        panelNo = 0;
                    }
                }
                p = this.splitPanel.getPanel(panelNo);
                p.setVisible(true);
                p.add(pi.getGUIName(), pc);
                if (panelNo == 3 && this.splitPanel.getDivLoc(panelNo) < this.getWidth() / 10 || panelNo == 0 && this.splitPanel.getDivLoc(panelNo) < this.getHeight() / 10 || panelNo == 1 && this.splitPanel.getDivLoc(panelNo) > this.getWidth() - this.getWidth() / 10 || panelNo == 2 && this.splitPanel.getDivLoc(panelNo) > this.getHeight() - this.getHeight() / 10) {
                    this.splitPanel.setDivLoc(panelNo, loc);
                }
            }
            if (pluginMenu != null) {
                URL url;
                Icon menuIcon = pluginMenu.getIcon();
                if (menuIcon == null && (url = DynamicResource.getResource(textResources, "emptyIcon")) != null) {
                    menuIcon = new ImageIcon(url);
                    pluginMenu.setIcon(new ImageIcon(url));
                }
                pMenu.add(pluginMenu);
            }
            if (helpMenu != null) {
                URL url;
                Icon menuIcon;
                if (helpMenu.getSubElements().length > 0 && (menuIcon = helpMenu.getIcon()) == null && (url = DynamicResource.getResource(textResources, "emptyIcon")) != null) {
                    menuIcon = new ImageIcon(url);
                    helpMenu.setIcon(new ImageIcon(url));
                }
                hMenu.insert(helpMenu, hMenu.getItemCount() - 2);
            }
            SwingUtilities.invokeLater(new PluginInfo(pi));
        } else {
            if (pluginMenu != null) {
                pMenu.remove(pluginMenu);
            }
            if (helpMenu != null) {
                hMenu.remove(helpMenu);
            }
        }
    }

    private void initJavaHelp() {
        try {
            JMenuItem mi = this.dynRes.getMenuItem(helpTopicsAction);
            if (mi == null) {
                return;
            }
            SHTMLHelpBroker.initJavaHelpItem(mi, "item15");
        }
        catch (Throwable e) {
            System.err.println("Simply HTML : Warning : loading help failed.");
        }
    }

    protected void initDocumentPane() {
    }

    protected void initActions() {
        this.addAction(setDefaultStyleRefAction, new SHTMLEditorKitActions.SetDefaultStyleRefAction(this));
        this.addAction(documentTitleAction, new SHTMLEditorKitActions.DocumentTitleAction(this));
        this.addAction(editAnchorsAction, new SHTMLEditorKitActions.EditAnchorsAction(this));
        this.addAction(setTagAction, new SHTMLEditorKitActions.SetTagAction(this));
        this.addAction(formatAsCodeAction, new SHTMLEditorKitActions.SetTagAction(this, "code"));
        this.addAction(editLinkAction, new SHTMLEditorKitActions.EditLinkAction(this));
        this.addAction(openLinkAction, new SHTMLEditorKitActions.OpenLinkAction(this));
        this.addAction(prevTableCellAction, new SHTMLEditorKitActions.PrevTableCellAction(this));
        this.addAction(nextTableCellAction, new SHTMLEditorKitActions.NextTableCellAction(this));
        this.addAction(editNamedStyleAction, new SHTMLEditorKitActions.EditNamedStyleAction(this));
        this.addAction(clearFormatAction, new SHTMLEditorKitActions.ClearFormatAction(this));
        this.addAction(formatParaAction, new SHTMLEditorKitActions.FormatParaAction(this));
        this.addAction(formatImageAction, new SHTMLEditorKitActions.FormatImageAction(this));
        this.addAction(insertImageAction, new SHTMLEditorKitActions.InsertImageAction(this));
        this.addAction(editPrefsAction, new SHTMLEditorKitActions.SHTMLEditPrefsAction(this));
        this.addAction(toggleBulletsAction, new SHTMLEditorKitActions.ToggleListAction(this, toggleBulletsAction, HTML.Tag.UL));
        this.addAction(toggleNumbersAction, new SHTMLEditorKitActions.ToggleListAction(this, toggleNumbersAction, HTML.Tag.OL));
        this.addAction(formatListAction, new SHTMLEditorKitActions.FormatListAction(this));
        this.addAction("managePlugins", new ManagePluginsAction());
        this.addAction(elemTreeAction, new SHTMLEditorKitActions.ShowElementTreeAction(this));
        this.addAction(gcAction, new SHTMLEditorKitActions.GarbageCollectionAction(this));
        this.addAction(undoAction, new SHTMLEditorKitActions.UndoAction(this));
        this.addAction(redoAction, new SHTMLEditorKitActions.RedoAction(this));
        this.addAction(cutAction, new SHTMLEditorKitActions.SHTMLEditCutAction(this));
        this.addAction(copyAction, new SHTMLEditorKitActions.SHTMLEditCopyAction(this));
        this.addAction(pasteAction, new SHTMLEditorKitActions.SHTMLEditPasteAction(this));
        this.addAction(pasteOtherAction, new SHTMLEditorKitActions.SHTMLEditPasteOtherAction(this));
        this.addAction(selectAllAction, new SHTMLEditorKitActions.SHTMLEditSelectAllAction(this));
        this.addAction(aboutAction, new SHTMLEditorKitActions.SHTMLHelpAppInfoAction(this));
        this.addAction(fontAction, new SHTMLEditorKitActions.FontAction(this));
        this.addAction(fontFamilyAction, new SHTMLEditorKitActions.FontFamilyAction(this));
        this.addAction(fontSizeAction, new SHTMLEditorKitActions.FontSizeAction(this));
        this.addAction(insertTableAction, new SHTMLEditorKitActions.InsertTableAction(this));
        this.addAction(insertTableRowAction, new SHTMLEditorKitActions.InsertTableRowAction(this, null, insertTableRowAction));
        this.addAction(insertTableRowHeaderAction, new SHTMLEditorKitActions.InsertTableRowAction(this, "th", insertTableRowHeaderAction));
        this.addAction(insertTableColAction, new SHTMLEditorKitActions.InsertTableColAction(this));
        this.addAction(appendTableColAction, new SHTMLEditorKitActions.AppendTableColAction(this));
        this.addAction(appendTableRowAction, new SHTMLEditorKitActions.AppendTableRowAction(this));
        this.addAction(deleteTableRowAction, new SHTMLEditorKitActions.DeleteTableRowAction(this));
        this.addAction(deleteTableColAction, new SHTMLEditorKitActions.DeleteTableColAction(this));
        this.addAction(moveTableRowUpAction, new SHTMLEditorKitActions.MoveTableRowUpAction(this));
        this.addAction(moveTableRowDownAction, new SHTMLEditorKitActions.MoveTableRowDownAction(this));
        this.addAction(moveTableColumnLeftAction, new SHTMLEditorKitActions.MoveTableColumnLeftAction(this));
        this.addAction(moveTableColumnRightAction, new SHTMLEditorKitActions.MoveTableColumnRightAction(this));
        this.addAction(formatTableAction, new SHTMLEditorKitActions.FormatTableAction(this));
        this.addAction(toggleTableHeaderCellAction, new SHTMLEditorKitActions.ToggleTableHeaderCellAction(this));
        this.addAction(fontBoldAction, new SHTMLEditorKitActions.BoldAction(this));
        this.addAction(fontItalicAction, new SHTMLEditorKitActions.ItalicAction(this));
        this.addAction(fontUnderlineAction, new SHTMLEditorKitActions.UnderlineAction(this));
        this.addAction(fontColorAction, new SHTMLEditorKitActions.FontColorAction(this));
        this.addAction(fontStrikethroughAction, new SHTMLEditorKitActions.ApplyCSSAttributeAction(this, fontStrikethroughAction, CSS.Attribute.TEXT_DECORATION, "line-through", false));
        this.addAction(paraAlignLeftAction, new SHTMLEditorKitActions.ApplyCSSAttributeAction(this, paraAlignLeftAction, CSS.Attribute.TEXT_ALIGN, "left", true));
        this.addAction(paraAlignCenterAction, new SHTMLEditorKitActions.ApplyCSSAttributeAction(this, paraAlignCenterAction, CSS.Attribute.TEXT_ALIGN, "center", true));
        this.addAction(paraAlignRightAction, new SHTMLEditorKitActions.ApplyCSSAttributeAction(this, paraAlignRightAction, CSS.Attribute.TEXT_ALIGN, "right", true));
        this.addAction(testAction, new SHTMLEditorKitActions.SHTMLTestAction(this));
        this.addAction(printAction, new SHTMLEditorKitActions.PrintAction(this));
    }

    public static void setActionBuilder(ActionBuilder ab) {
        actionBuilder = ab;
    }

    public void addAction(String text, Action action) {
        this.dynRes.addAction(text, action);
    }

    public void updateActions() {
        Enumeration actions = this.dynRes.getActions();
        while (actions.hasMoreElements()) {
            Action action = (Action)actions.nextElement();
            if (!(action instanceof SHTMLAction)) continue;
            ((SHTMLAction)action).update();
        }
    }

    protected void customizeFrame() {
        this.splitPanel = new SplitPanel();
        for (int i = 0; i < 4; ++i) {
            JTabbedPane p = new JTabbedPane();
            p.setVisible(false);
            this.splitPanel.addComponent(p, i);
        }
        final JPanel toolBarPanel = new JPanel(new FlowLayout(0, 0, 0)){
            private static final long serialVersionUID = 1L;

            public Dimension getPreferredSize() {
                int maxWidth = SHTMLPanelImpl.this.splitPanel.getWidth();
                int height = 0;
                int rowHeight = 0;
                int width = 0;
                for (int i = 0; i < this.getComponentCount(); ++i) {
                    Component component = this.getComponent(i);
                    Dimension compPreferredSize = component.getPreferredSize();
                    if (maxWidth < compPreferredSize.width) {
                        height += rowHeight + compPreferredSize.height;
                        rowHeight = 0;
                        width = 0;
                        continue;
                    }
                    if (maxWidth < width + compPreferredSize.width) {
                        height += rowHeight;
                        rowHeight = compPreferredSize.height;
                        width = compPreferredSize.width;
                        continue;
                    }
                    rowHeight = Math.max(rowHeight, compPreferredSize.height);
                    width += compPreferredSize.width;
                }
                return new Dimension(maxWidth, height += rowHeight);
            }
        };
        JPanel contentPane = new JPanel(){
            private static final long serialVersionUID = 1L;

            public Dimension getPreferredSize() {
                Dimension splitPreferredSize = SHTMLPanelImpl.this.splitPanel.getPreferredSize();
                Dimension toolbaPreferredSize = toolBarPanel.getPreferredSize();
                return new Dimension(splitPreferredSize.width, splitPreferredSize.height + toolbaPreferredSize.height);
            }
        };
        contentPane.setLayout(new BorderLayout());
        toolBarPanel.add(this.createToolBar("toolBar"));
        this.formatToolBar = this.createToolBar("formatToolBar");
        this.paraToolBar = this.createToolBar("paraToolBar");
        toolBarPanel.add(this.formatToolBar);
        toolBarPanel.add(this.paraToolBar);
        if (Util.getPreference("show_toolbars", ACTION_SELECTED).equalsIgnoreCase(ACTION_SELECTED)) {
            contentPane.add((Component)toolBarPanel, "North");
        }
        contentPane.add((Component)this.splitPanel, "Center");
        this.add((Component)contentPane, "Center");
        this.splitPanel.addComponentListener(new ComponentListener(){

            public void componentHidden(ComponentEvent e) {
            }

            public void componentMoved(ComponentEvent e) {
            }

            public void componentResized(ComponentEvent e) {
                SHTMLPanelImpl.this.resizeToolbarPane(toolBarPanel);
            }

            public void componentShown(ComponentEvent e) {
            }
        });
        toolBarPanel.addContainerListener(new ContainerListener(){

            public void componentAdded(ContainerEvent e) {
                SHTMLPanelImpl.this.resizeToolbarPane(toolBarPanel);
            }

            public void componentRemoved(ContainerEvent e) {
                SHTMLPanelImpl.this.resizeToolbarPane(toolBarPanel);
            }
        });
    }

    private void resizeToolbarPane(JComponent toolBarPanel) {
        if (toolBarPanel.getPreferredSize().height != toolBarPanel.getHeight()) {
            toolBarPanel.revalidate();
        }
    }

    JToolBar createToolBar(String nm) {
        String[] itemKeys = Util.tokenize(Util.getResourceString(textResources, nm), " ");
        JToolBar toolBar = new JToolBar();
        toolBar.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        for (int i = 0; i < itemKeys.length; ++i) {
            String itemKey = itemKeys[i];
            this.createToolbarItem(toolBar, itemKey);
        }
        return toolBar;
    }

    protected void createToolbarItem(JToolBar toolBar, String itemKey) {
        ToggleBorderListener tbl = new ToggleBorderListener();
        Dimension buttonSize = new Dimension(24, 24);
        Dimension comboBoxSize = new Dimension(300, 24);
        Dimension separatorSize = new Dimension(3, 24);
        if (itemKey.equals("-")) {
            JSeparator separator = new JSeparator(1);
            separator.setMaximumSize(separatorSize);
            toolBar.add(separator);
        } else if (itemKey.equalsIgnoreCase(fontFamilyAction)) {
            FontFamilyPicker fontFamily = new FontFamilyPicker();
            fontFamily.setPreferredSize(new Dimension(180, 23));
            fontFamily.setAction(this.dynRes.getAction(fontFamilyAction));
            fontFamily.setMaximumSize(comboBoxSize);
            toolBar.add(fontFamily);
        } else if (itemKey.equalsIgnoreCase(fontSizeAction)) {
            FontSizePicker fontSize = new FontSizePicker();
            fontSize.setPreferredSize(new Dimension(50, 23));
            fontSize.setAction(this.dynRes.getAction(fontSizeAction));
            fontSize.setMaximumSize(comboBoxSize);
            toolBar.add(fontSize);
        } else if (itemKey.equalsIgnoreCase(setTagAction)) {
            this.tagSelector = new TagSelector();
            this.tagSelector.setAction(this.dynRes.getAction(setTagAction));
            toolBar.add(this.tagSelector);
        } else {
            try {
                AbstractButton newButton;
                if (itemKey.equalsIgnoreCase(helpTopicsAction)) {
                    newButton = SHTMLHelpBroker.createHelpButton("item15");
                    Icon icon = DynamicResource.getIconForCommand(SHTMLPanelImpl.getResources(), helpTopicsAction);
                    newButton.setIcon(icon);
                    newButton.setToolTipText(Util.getResourceString("helpTopicsTip"));
                    toolBar.add(newButton);
                } else {
                    Action action = this.dynRes.getAction(itemKey);
                    if (action instanceof AttributeComponent) {
                        newButton = new JToggleButton("", (Icon)action.getValue("SmallIcon"));
                        newButton.addMouseListener(tbl);
                        newButton.setAction(action);
                        newButton.setText("");
                        newButton.setBorderPainted(false);
                        action.addPropertyChangeListener(new ToggleActionChangedListener((JToggleButton)newButton));
                        Icon si = DynamicResource.getIconForName(textResources, action.getValue("Name") + "SelectedIcon");
                        if (si != null) {
                            newButton.setSelectedIcon(si);
                        }
                        newButton.setMargin(new Insets(0, 0, 0, 0));
                        newButton.setIconTextGap(0);
                        newButton.setContentAreaFilled(false);
                        newButton.setHorizontalAlignment(0);
                        newButton.setVerticalAlignment(0);
                        toolBar.add(newButton);
                    } else {
                        newButton = toolBar.add(action);
                    }
                }
                newButton.setMinimumSize(buttonSize);
                newButton.setPreferredSize(buttonSize);
                newButton.setMaximumSize(buttonSize);
                newButton.setFocusPainted(false);
                newButton.setRequestFocusEnabled(false);
                if (System.getProperty("os.name").equals("Mac OS X")) {
                    newButton.putClientProperty("JButton.buttonType", "segmented");
                    newButton.putClientProperty("JButton.segmentPosition", "middle");
                }
            }
            catch (Exception ex) {
            }
            catch (NoClassDefFoundError e) {
                // empty catch block
            }
        }
    }

    protected void registerDocument() {
        this.doc.addUndoableEditListener(this.undoHandler);
        this.getSHTMLEditorPane().addCaretListener(this);
        this.getSHTMLEditorPane().addKeyListener(this.rkw);
    }

    protected void unregisterDocument() {
        this.getSHTMLEditorPane().removeCaretListener(this);
        this.getSHTMLEditorPane().removeKeyListener(this.rkw);
        if (this.doc != null) {
            this.doc.removeUndoableEditListener(this.undoHandler);
        }
        this.getDocumentPane().removeAllListeners();
    }

    void doSave(DocumentPane documentPane) {
        try {
            documentPane.saveDocument();
        }
        catch (DocNameMissingException e) {
            Util.errMsg(this, Util.getResourceString(textResources, "docNameMissingError"), e);
        }
    }

    public boolean isHtmlEditorActive() {
        return this.getDocumentPane() != null && this.getDocumentPane().getSelectedTab() == 1;
    }

    public static void getActionProperties(Action action, String cmd) {
        String toolTip;
        String name;
        Icon icon = DynamicResource.getIconForCommand(textResources, cmd);
        if (icon != null) {
            action.putValue("SmallIcon", icon);
        }
        if ((name = Util.getResourceString(textResources, cmd + "Label")) != null) {
            action.putValue("Name", name);
        }
        if ((toolTip = Util.getResourceString(textResources, cmd + "Tip")) != null) {
            action.putValue("ShortDescription", toolTip);
        }
    }

    public void caretUpdate(CaretEvent e) {
        if (!this.rkw.isRepeating()) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    SHTMLPanelImpl.this.updateFormatControls();
                }
            });
        }
    }

    void updateFormatControls() {
        this.updateAToolBar(this.formatToolBar);
        this.updateAToolBar(this.paraToolBar);
        if (this.tagSelector != null) {
            SHTMLEditorKitActions.SetTagAction sta = (SHTMLEditorKitActions.SetTagAction)this.tagSelector.getAction();
            sta.setIgnoreActions(true);
            Element e = this.doc.getParagraphElement(this.getSHTMLEditorPane().getCaretPosition());
            this.tagSelector.setSelectedTag(e.getName());
            sta.setIgnoreActions(false);
        }
    }

    private void updateAToolBar(JToolBar bar) {
        int count = bar.getComponentCount();
        AttributeSet a = this.getMaxAttributes(this.getSHTMLEditorPane(), null);
        for (int i = 0; i < count; ++i) {
            Action action;
            Component c = bar.getComponentAtIndex(i);
            if (c instanceof AttributeComponent) {
                if (c instanceof StyleSelector) {
                    SHTMLEditorKitActions.SetStyleAction ssa = (SHTMLEditorKitActions.SetStyleAction)((StyleSelector)c).getAction();
                    AttributeSet oldAttibuteSet = ((AttributeComponent)((Object)c)).getValue();
                    if (a.isEqual(oldAttibuteSet)) continue;
                    ssa.setIgnoreActions(true);
                    ((AttributeComponent)((Object)c)).setValue(a);
                    ssa.setIgnoreActions(false);
                    continue;
                }
                ((AttributeComponent)((Object)c)).setValue(a);
                continue;
            }
            if (!(c instanceof AbstractButton) || (action = ((AbstractButton)c).getAction()) == null || !(action instanceof AttributeComponent)) continue;
            ((AttributeComponent)((Object)action)).setValue(a);
        }
    }

    public AttributeSet getMaxAttributes(int caretPosition) {
        Element paragraphElement = this.getSHTMLDocument().getParagraphElement(caretPosition);
        StyleSheet styleSheet = this.getSHTMLDocument().getStyleSheet();
        return SHTMLPanelImpl.getMaxAttributes(paragraphElement, styleSheet);
    }

    AttributeSet getMaxAttributes(SHTMLEditorPane editorPane, String elemName) {
        Element element = this.doc.getCharacterElement(editorPane.getSelectionStart());
        StyleSheet styleSheet = this.doc.getStyleSheet();
        if (elemName != null && elemName.length() > 0) {
            element = Util.findElementUp(elemName, element);
            return SHTMLPanelImpl.getMaxAttributes(element, styleSheet);
        }
        MutableAttributeSet maxAttributes = (MutableAttributeSet)SHTMLPanelImpl.getMaxAttributes(element, styleSheet);
        StyledEditorKit editorKit = (StyledEditorKit)editorPane.getEditorKit();
        MutableAttributeSet inputAttributes = editorKit.getInputAttributes();
        maxAttributes.addAttributes(inputAttributes);
        return maxAttributes;
    }

    Frame getMainFrame() {
        return JOptionPane.getFrameForComponent(this);
    }

    static AttributeSet getMaxAttributes(Element e, StyleSheet s) {
        SimpleAttributeSet a = new SimpleAttributeSet();
        Element cElem = e;
        Vector<Element> elements = new Vector<Element>();
        while (e != null) {
            elements.insertElementAt(e, 0);
            e = e.getParentElement();
        }
        for (int i = 0; i < elements.size(); ++i) {
            Style attrs;
            String elemName;
            e = (Element)elements.elementAt(i);
            Object classAttr = e.getAttributes().getAttribute(HTML.Attribute.CLASS);
            String styleName = elemName = e.getName();
            if (classAttr != null) {
                styleName = elemName + "." + classAttr.toString();
                a.addAttribute(HTML.Attribute.CLASS, classAttr);
            }
            if ((attrs = s.getStyle(styleName)) != null) {
                a.addAttributes(Util.resolveAttributes(attrs));
            } else {
                attrs = s.getStyle(elemName);
                if (attrs != null) {
                    a.addAttributes(Util.resolveAttributes(attrs));
                }
            }
            a.addAttributes(Util.resolveAttributes(e.getAttributes()));
        }
        if (cElem != null) {
            a.addAttributes(cElem.getAttributes());
        }
        return new AttributeMapper(a).getMappedAttributes(2);
    }

    void setDocumentPane(DocumentPane documentPane) {
        this.documentPane = documentPane;
    }

    public DocumentPane getDocumentPane() {
        return this.documentPane;
    }

    protected void setEditorPane(SHTMLEditorPane editorPane) {
        if (editorPane != null) {
            editorPane.setPopup(this.editorPopup);
        }
        this.editorPane = editorPane;
    }

    public SHTMLEditorPane getSHTMLEditorPane() {
        return (SHTMLEditorPane)this.getEditorPane();
    }

    public JEditorPane getEditorPane() {
        return this.editorPane;
    }

    public JEditorPane getSourceEditorPane() {
        return this.getDocumentPane().getHtmlEditor();
    }

    SHTMLDocument getSHTMLDocument() {
        return this.doc;
    }

    void setUndo(UndoManager undo) {
        this.undo = undo;
    }

    UndoManager getUndo() {
        return this.undo;
    }

    void setTagSelector(TagSelector tagSelector) {
        this.tagSelector = tagSelector;
    }

    TagSelector getTagSelector() {
        return this.tagSelector;
    }

    void savePrefs() {
        this.splitPanel.savePrefs();
    }

    boolean close() {
        return true;
    }

    public JEditorPane getMostRecentFocusOwner() {
        if (this.getDocumentPane() != null) {
            return this.getDocumentPane().getMostRecentFocusOwner();
        }
        return null;
    }

    public int getCaretPosition() {
        return this.getSHTMLEditorPane().getCaretPosition();
    }

    public JMenuBar getMenuBar() {
        return this.menuBar;
    }

    public void switchViews() {
        this.getDocumentPane().switchViews();
    }

    public void setOpenHyperlinkHandler(ActionListener openHyperlinkHandler) {
        this.openHyperlinkHandler = openHyperlinkHandler;
    }

    public void openHyperlink(String linkURL) {
        if (this.openHyperlinkHandler != null) {
            this.openHyperlinkHandler.actionPerformed(new ActionEvent(this, 0, linkURL));
        }
    }

    static {
        FONT_SIZES = new String[]{"8", "10", "12", "14", "18", "24"};
    }

    private class ToggleActionChangedListener
    implements PropertyChangeListener {
        JToggleButton button;

        ToggleActionChangedListener(JToggleButton button) {
            this.button = button;
        }

        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            if (e.getPropertyName().equals(SHTMLPanelImpl.ACTION_SELECTED_KEY)) {
                if (e.getNewValue().toString().equals(SHTMLPanelImpl.ACTION_SELECTED)) {
                    this.button.setSelected(true);
                } else {
                    this.button.setSelected(false);
                }
            }
        }
    }

    class FontSizePicker
    extends JComboBox
    implements AttributeComponent {
        private boolean ignoreActions;
        private final Object key;

        FontSizePicker() {
            super(FONT_SIZES);
            this.ignoreActions = false;
            this.key = CSS.Attribute.FONT_SIZE;
        }

        boolean ignore() {
            return this.ignoreActions;
        }

        public boolean setValue(AttributeSet a) {
            this.ignoreActions = true;
            int size = Util.styleSheet().getFont(a).getSize();
            String newSelection = Integer.toString(size);
            this.setEditable(true);
            this.setSelectedItem(newSelection);
            this.setEditable(false);
            this.ignoreActions = false;
            return true;
        }

        public AttributeSet getValue() {
            SimpleAttributeSet set = new SimpleAttributeSet();
            String relativeSize = Integer.toString(this.getSelectedIndex() + 1);
            set.addAttribute(HTML.Attribute.SIZE, relativeSize);
            Util.styleSheet().addCSSAttributeFromHTML(set, CSS.Attribute.FONT_SIZE, relativeSize);
            return set;
        }

        public AttributeSet getValue(boolean includeUnchanged) {
            return this.getValue();
        }
    }

    class FontFamilyPicker
    extends JComboBox
    implements AttributeComponent {
        private boolean ignoreActions;

        FontFamilyPicker() {
            super(GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames());
            this.ignoreActions = false;
        }

        boolean ignore() {
            return this.ignoreActions;
        }

        public boolean setValue(AttributeSet a) {
            this.ignoreActions = true;
            String newSelection = Util.styleSheet().getFont(a).getFamily();
            this.setSelectedItem(newSelection);
            this.ignoreActions = false;
            return true;
        }

        public AttributeSet getValue() {
            SimpleAttributeSet set = new SimpleAttributeSet();
            Util.styleSheet().addCSSAttribute(set, CSS.Attribute.FONT_FAMILY, (String)this.getSelectedItem());
            set.addAttribute(HTML.Attribute.FACE, (String)this.getSelectedItem());
            return set;
        }

        public AttributeSet getValue(boolean includeUnchanged) {
            return this.getValue();
        }
    }

    class UndoHandler
    implements UndoableEditListener {
        UndoHandler() {
        }

        public void undoableEditHappened(UndoableEditEvent e) {
            if (SHTMLPanelImpl.this.getCurrentDocumentPane().getSelectedTab() != 0) {
                return;
            }
            SHTMLPanelImpl.this.getUndo().addEdit(e.getEdit());
        }
    }

    private class ToggleBorderListener
    implements MouseListener {
        private final EtchedBorder border = new EtchedBorder(1);
        private JToggleButton button;

        private ToggleBorderListener() {
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
            Object src = e.getSource();
            if (src instanceof JToggleButton) {
                this.button = (JToggleButton)src;
                if (this.button.isEnabled()) {
                    ((JToggleButton)src).setBorder(this.border);
                }
            }
        }

        public void mouseExited(MouseEvent e) {
            Object src = e.getSource();
            if (src instanceof JToggleButton) {
                ((JToggleButton)src).setBorder(null);
            }
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }
    }

    class PluginInfo
    implements Runnable {
        SHTMLPlugin pi;

        PluginInfo(SHTMLPlugin pi) {
            this.pi = pi;
        }

        public void run() {
            this.pi.showInitialInfo();
        }
    }

    class RepeatKeyWatcher
    implements KeyListener {
        private final Timer releaseTimer = new Timer();
        private ReleaseTask nextTask;
        private long lastWhen = 0L;
        private long when;
        private final long delay;
        private boolean repeating = false;

        RepeatKeyWatcher(long delay) {
            this.delay = delay;
        }

        public void keyPressed(KeyEvent e) {
            if (this.nextTask != null) {
                this.nextTask.cancel();
            }
            this.when = e.getWhen();
            this.repeating = this.when - this.lastWhen <= this.delay;
            this.lastWhen = this.when;
        }

        public void keyReleased(KeyEvent e) {
            this.nextTask = new ReleaseTask();
            this.releaseTimer.schedule((TimerTask)this.nextTask, this.delay);
        }

        public void keyTyped(KeyEvent e) {
        }

        boolean isRepeating() {
            return this.repeating;
        }

        private class ReleaseTask
        extends TimerTask
        implements Runnable {
            private ReleaseTask() {
            }

            public void run() {
                if (EventQueue.isDispatchThread()) {
                    RepeatKeyWatcher.this.repeating = false;
                    SHTMLPanelImpl.this.updateFormatControls();
                } else {
                    try {
                        EventQueue.invokeAndWait(this);
                    }
                    catch (InterruptedException e) {
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

