/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.conflict;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.openstreetmap.josm.data.conflict.Conflict;
import org.openstreetmap.josm.data.conflict.IConflictListener;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.SubclassFilteredCollection;

public class ConflictCollection
implements Iterable<Conflict<? extends OsmPrimitive>> {
    private final List<Conflict<? extends OsmPrimitive>> conflicts = new ArrayList<Conflict<? extends OsmPrimitive>>();
    private final CopyOnWriteArrayList<IConflictListener> listeners = new CopyOnWriteArrayList();

    public void addConflictListener(IConflictListener listener) {
        if (listener != null) {
            this.listeners.addIfAbsent(listener);
        }
    }

    public void removeConflictListener(IConflictListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireConflictAdded() {
        for (IConflictListener listener : this.listeners) {
            listener.onConflictsAdded(this);
        }
    }

    protected void fireConflictRemoved() {
        for (IConflictListener listener : this.listeners) {
            listener.onConflictsRemoved(this);
        }
    }

    protected void addConflict(Conflict<?> conflict) {
        if (this.hasConflictForMy((OsmPrimitive)conflict.getMy())) {
            throw new IllegalStateException(I18n.tr("Already registered a conflict for primitive ''{0}''.", conflict.getMy().toString()));
        }
        if (!this.conflicts.contains(conflict)) {
            this.conflicts.add(conflict);
        }
    }

    public void add(Conflict<?> conflict) {
        CheckParameterUtil.ensureParameterNotNull(conflict, "conflict");
        this.addConflict(conflict);
        this.fireConflictAdded();
    }

    public void add(Collection<Conflict<?>> otherConflicts) {
        if (otherConflicts == null) {
            return;
        }
        for (Conflict<?> c : otherConflicts) {
            this.addConflict(c);
        }
        this.fireConflictAdded();
    }

    public void add(OsmPrimitive my, OsmPrimitive their) {
        this.addConflict(new Conflict<OsmPrimitive>(my, their));
        this.fireConflictAdded();
    }

    public void remove(Conflict<?> conflict) {
        this.conflicts.remove(conflict);
        this.fireConflictRemoved();
    }

    public void remove(OsmPrimitive my) {
        Iterator<Conflict<?>> it = this.iterator();
        while (it.hasNext()) {
            if (!it.next().isMatchingMy(my)) continue;
            it.remove();
        }
        this.fireConflictRemoved();
    }

    public Conflict<?> getConflictForMy(OsmPrimitive my) {
        for (Conflict<? extends OsmPrimitive> c : this.conflicts) {
            if (!c.isMatchingMy(my)) continue;
            return c;
        }
        return null;
    }

    public Conflict<?> getConflictForTheir(OsmPrimitive their) {
        for (Conflict<? extends OsmPrimitive> c : this.conflicts) {
            if (!c.isMatchingTheir(their)) continue;
            return c;
        }
        return null;
    }

    public boolean hasConflictForMy(OsmPrimitive my) {
        return this.getConflictForMy(my) != null;
    }

    public boolean hasConflict(Conflict<?> c) {
        return this.hasConflictForMy((OsmPrimitive)c.getMy());
    }

    public boolean hasConflictForTheir(OsmPrimitive their) {
        return this.getConflictForTheir(their) != null;
    }

    public void removeForMy(OsmPrimitive my) {
        Iterator<Conflict<?>> it = this.iterator();
        while (it.hasNext()) {
            if (!it.next().isMatchingMy(my)) continue;
            it.remove();
        }
    }

    public void removeForTheir(OsmPrimitive their) {
        Iterator<Conflict<?>> it = this.iterator();
        while (it.hasNext()) {
            if (!it.next().isMatchingTheir(their)) continue;
            it.remove();
        }
    }

    public List<Conflict<?>> get() {
        return this.conflicts;
    }

    public int size() {
        return this.conflicts.size();
    }

    public Conflict<?> get(int idx) {
        return this.conflicts.get(idx);
    }

    @Override
    public Iterator<Conflict<?>> iterator() {
        return this.conflicts.iterator();
    }

    public void add(ConflictCollection other) {
        for (Conflict<?> c : other) {
            this.add(c);
        }
    }

    public Set<OsmPrimitive> getMyConflictParties() {
        HashSet<OsmPrimitive> ret = new HashSet<OsmPrimitive>();
        for (Conflict<? extends OsmPrimitive> c : this.conflicts) {
            ret.add(c.getMy());
        }
        return ret;
    }

    public Set<OsmPrimitive> getTheirConflictParties() {
        HashSet<OsmPrimitive> ret = new HashSet<OsmPrimitive>();
        for (Conflict<? extends OsmPrimitive> c : this.conflicts) {
            ret.add(c.getTheir());
        }
        return ret;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public String toString() {
        return this.conflicts.toString();
    }

    public final Collection<Conflict<? extends OsmPrimitive>> getNodeConflicts() {
        return SubclassFilteredCollection.filter(this.conflicts, c -> c != null && c.getMy() instanceof Node);
    }

    public final Collection<Conflict<? extends OsmPrimitive>> getWayConflicts() {
        return SubclassFilteredCollection.filter(this.conflicts, c -> c != null && c.getMy() instanceof Way);
    }

    public final Collection<Conflict<? extends OsmPrimitive>> getRelationConflicts() {
        return SubclassFilteredCollection.filter(this.conflicts, c -> c != null && c.getMy() instanceof Relation);
    }

    public int hashCode() {
        return Objects.hash(this.conflicts, this.listeners);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ConflictCollection conflicts1 = (ConflictCollection)obj;
        return Objects.equals(this.conflicts, conflicts1.conflicts) && Objects.equals(this.listeners, conflicts1.listeners);
    }
}

