/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions;

import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointAndAreaListener;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.util.containers.ContainerUtilRt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SmartExtensionPoint<Extension, V> {
    private final Collection<V> myExplicitExtensions;
    private volatile ExtensionPoint<Extension> myExtensionPoint;
    private volatile List<V> myCache;
    private final ExtensionPointAndAreaListener<Extension> myExtensionPointAndAreaListener;

    protected SmartExtensionPoint(@NotNull Collection<V> explicitExtensions) {
        if (explicitExtensions == null) {
            SmartExtensionPoint.$$$reportNull$$$0(0);
        }
        this.myExplicitExtensions = explicitExtensions;
        this.myExtensionPointAndAreaListener = new ExtensionPointAndAreaListener<Extension>(){

            @Override
            public void areaReplaced(@NotNull ExtensionsArea oldArea) {
                if (oldArea == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.dropCache();
            }

            @Override
            public final void extensionRemoved(@NotNull Extension extension, @Nullable PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    1.$$$reportNull$$$0(1);
                }
                this.dropCache();
            }

            @Override
            public final void extensionAdded(@NotNull Extension extension, @Nullable PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    1.$$$reportNull$$$0(2);
                }
                this.dropCache();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void dropCache() {
                if (SmartExtensionPoint.this.myCache == null) {
                    return;
                }
                Collection collection = SmartExtensionPoint.this.myExplicitExtensions;
                synchronized (collection) {
                    if (SmartExtensionPoint.this.myCache != null) {
                        SmartExtensionPoint.this.myCache = null;
                        ExtensionPoint extensionPoint = SmartExtensionPoint.this.myExtensionPoint;
                        if (extensionPoint != null) {
                            extensionPoint.removeExtensionPointListener(this);
                            SmartExtensionPoint.this.myExtensionPoint = null;
                        }
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "oldArea";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "extension";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/openapi/extensions/SmartExtensionPoint$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "areaReplaced";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @NotNull
    protected abstract ExtensionPoint<Extension> getExtensionPoint();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addExplicitExtension(@NotNull V extension) {
        if (extension == null) {
            SmartExtensionPoint.$$$reportNull$$$0(1);
        }
        Collection<V> collection = this.myExplicitExtensions;
        synchronized (collection) {
            this.myExplicitExtensions.add(extension);
            this.myCache = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeExplicitExtension(@NotNull V extension) {
        if (extension == null) {
            SmartExtensionPoint.$$$reportNull$$$0(2);
        }
        Collection<V> collection = this.myExplicitExtensions;
        synchronized (collection) {
            this.myExplicitExtensions.remove(extension);
            this.myCache = null;
        }
    }

    @Nullable
    protected abstract V getExtension(@NotNull Extension var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public final List<V> getExtensions() {
        List<V> result2 = this.myCache;
        if (result2 != null) {
            List<V> list2 = result2;
            if (list2 != null) return list2;
            SmartExtensionPoint.$$$reportNull$$$0(3);
            return list2;
        }
        ExtensionPoint<Extension> extensionPoint = this.myExtensionPoint;
        if (extensionPoint == null) {
            extensionPoint = this.getExtensionPoint();
            this.myExtensionPoint = extensionPoint;
        }
        List<Object> registeredExtensions = ContainerUtilRt.mapNotNull(extensionPoint.getExtensionList(), this::getExtension);
        Collection<V> collection = this.myExplicitExtensions;
        // MONITORENTER : collection
        result2 = this.myCache;
        if (result2 != null) {
            List<V> list3 = result2;
            // MONITOREXIT : collection
            if (list3 != null) return list3;
            SmartExtensionPoint.$$$reportNull$$$0(4);
            return list3;
        }
        extensionPoint.addExtensionPointListener(this.myExtensionPointAndAreaListener, false, null);
        result2 = new ArrayList<V>(this.myExplicitExtensions.size() + registeredExtensions.size());
        result2.addAll(this.myExplicitExtensions);
        result2.addAll(registeredExtensions);
        this.myCache = result2;
        List<V> list4 = result2;
        // MONITOREXIT : collection
        if (list4 != null) return list4;
        SmartExtensionPoint.$$$reportNull$$$0(5);
        return list4;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "explicitExtensions";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/extensions/SmartExtensionPoint";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/extensions/SmartExtensionPoint";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addExplicitExtension";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "removeExplicitExtension";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

