/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower.loops;

import java.util.Iterator;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.common.lower.loops.ArrayHeaderInfo;
import org.jetbrains.kotlin.backend.common.lower.loops.ExpressionHandler;
import org.jetbrains.kotlin.backend.common.lower.loops.HeaderInfo;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.Scope;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/loops/ArrayIterationHandler;", "Lorg/jetbrains/kotlin/backend/common/lower/loops/ExpressionHandler;", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;)V", "build", "Lorg/jetbrains/kotlin/backend/common/lower/loops/HeaderInfo;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "scopeOwner", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "match", "", "ir.backend.common"})
public final class ArrayIterationHandler
implements ExpressionHandler {
    private final CommonBackendContext context;

    public boolean match(@NotNull IrExpression expression2) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        return KotlinBuiltIns.isArrayOrPrimitiveArray(IrTypesKt.toKotlinType(expression2.getType()));
    }

    @Override
    @Nullable
    public HeaderInfo build(@NotNull IrExpression expression2, @NotNull IrSymbol scopeOwner) {
        IrProperty element$iv;
        IrVariable arrayReference;
        DeclarationIrBuilder $this$with;
        block3: {
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            Intrinsics.checkParameterIsNotNull(scopeOwner, "scopeOwner");
            DeclarationIrBuilder declarationIrBuilder = LowerUtilsKt.createIrBuilder(this.context, scopeOwner, expression2.getStartOffset(), expression2.getEndOffset());
            boolean bl = false;
            boolean bl2 = false;
            $this$with = declarationIrBuilder;
            boolean bl3 = false;
            arrayReference = Scope.createTemporaryVariable$default($this$with.getScope(), expression2, "array", false, null, IrDeclarationOrigin.FOR_LOOP_IMPLICIT_VARIABLE.INSTANCE, null, 44, null);
            IrClass irClass = IrTypesKt.getClass(arrayReference.getType());
            if (irClass == null) {
                Intrinsics.throwNpe();
            }
            Sequence<IrProperty> $this$first$iv = IrUtilsKt.getProperties(irClass);
            boolean $i$f$first = false;
            Iterator<IrProperty> iterator2 = $this$first$iv.iterator();
            while (iterator2.hasNext()) {
                IrProperty it = element$iv = iterator2.next();
                boolean bl4 = false;
                if (!Intrinsics.areEqual(it.getName().asString(), "size")) continue;
                break block3;
            }
            throw (Throwable)new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        IrProperty arraySizeProperty = element$iv;
        IrBuilderWithScope irBuilderWithScope = $this$with;
        IrSimpleFunction irSimpleFunction = arraySizeProperty.getGetter();
        if (irSimpleFunction == null) {
            Intrinsics.throwNpe();
        }
        IrMemberAccessExpression irMemberAccessExpression = ExpressionHelpersKt.irCall(irBuilderWithScope, irSimpleFunction);
        boolean bl = false;
        boolean bl5 = false;
        IrMemberAccessExpression $this$apply = irMemberAccessExpression;
        boolean bl6 = false;
        $this$apply.setDispatchReceiver(ExpressionHelpersKt.irGet($this$with, arrayReference));
        IrMemberAccessExpression last2 = irMemberAccessExpression;
        return new ArrayHeaderInfo(ExpressionHelpersKt.irInt($this$with, 0), last2, ExpressionHelpersKt.irInt($this$with, 1), arrayReference);
    }

    public ArrayIterationHandler(@NotNull CommonBackendContext context) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        this.context = context;
    }

    @Override
    @Nullable
    public HeaderInfo build(@NotNull IrExpression expression2, @Nullable Void data, @NotNull IrSymbol scopeOwner) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(scopeOwner, "scopeOwner");
        return ExpressionHandler.DefaultImpls.build(this, expression2, data, scopeOwner);
    }

    @Nullable
    public HeaderInfo handle(@NotNull IrExpression expression2, @Nullable Void data, @NotNull IrSymbol scopeOwner) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(scopeOwner, "scopeOwner");
        return ExpressionHandler.DefaultImpls.handle(this, expression2, data, scopeOwner);
    }
}

