/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.resolve.calls.CallInfo;
import org.jetbrains.kotlin.fir.resolve.calls.Candidate;
import org.jetbrains.kotlin.fir.resolve.calls.CandidateApplicability;
import org.jetbrains.kotlin.fir.resolve.calls.CheckerSinkImpl;
import org.jetbrains.kotlin.fir.resolve.calls.InferenceComponents;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionStage;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001aJ\u0016\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u000bJ\u0018\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u000bH\u0004J\u0006\u0010 \u001a\u00020!J\u0006\u0010\"\u001a\u00020\u001cR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\r\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/CandidateCollector;", "", "callInfo", "Lorg/jetbrains/kotlin/fir/resolve/calls/CallInfo;", "components", "Lorg/jetbrains/kotlin/fir/resolve/calls/InferenceComponents;", "(Lorg/jetbrains/kotlin/fir/resolve/calls/CallInfo;Lorg/jetbrains/kotlin/fir/resolve/calls/InferenceComponents;)V", "getCallInfo", "()Lorg/jetbrains/kotlin/fir/resolve/calls/CallInfo;", "candidates", "", "Lorg/jetbrains/kotlin/fir/resolve/calls/Candidate;", "getCandidates", "()Ljava/util/List;", "getComponents", "()Lorg/jetbrains/kotlin/fir/resolve/calls/InferenceComponents;", "currentApplicability", "Lorg/jetbrains/kotlin/fir/resolve/calls/CandidateApplicability;", "getCurrentApplicability", "()Lorg/jetbrains/kotlin/fir/resolve/calls/CandidateApplicability;", "setCurrentApplicability", "(Lorg/jetbrains/kotlin/fir/resolve/calls/CandidateApplicability;)V", "groupNumbers", "", "getGroupNumbers", "bestCandidates", "", "consumeCandidate", "", "group", "candidate", "getApplicability", "isSuccess", "", "newDataSet", "resolve"})
public final class CandidateCollector {
    @NotNull
    private final List<Integer> groupNumbers;
    @NotNull
    private final List<Candidate> candidates;
    @NotNull
    private CandidateApplicability currentApplicability;
    @NotNull
    private final CallInfo callInfo;
    @NotNull
    private final InferenceComponents components;

    @NotNull
    public final List<Integer> getGroupNumbers() {
        return this.groupNumbers;
    }

    @NotNull
    public final List<Candidate> getCandidates() {
        return this.candidates;
    }

    @NotNull
    public final CandidateApplicability getCurrentApplicability() {
        return this.currentApplicability;
    }

    public final void setCurrentApplicability(@NotNull CandidateApplicability candidateApplicability) {
        Intrinsics.checkParameterIsNotNull((Object)candidateApplicability, "<set-?>");
        this.currentApplicability = candidateApplicability;
    }

    public final void newDataSet() {
        this.groupNumbers.clear();
        this.candidates.clear();
        this.currentApplicability = CandidateApplicability.HIDDEN;
    }

    @NotNull
    protected final CandidateApplicability getApplicability(int group, @NotNull Candidate candidate2) {
        Intrinsics.checkParameterIsNotNull(candidate2, "candidate");
        CheckerSinkImpl sink = new CheckerSinkImpl(this.components);
        Iterable $this$forEach$iv = this.callInfo.getCallKind().sequence();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ResolutionStage it = (ResolutionStage)element$iv;
            boolean bl = false;
            it.check(candidate2, sink, this.callInfo);
        }
        return sink.getCurrent();
    }

    public final void consumeCandidate(int group, @NotNull Candidate candidate2) {
        Intrinsics.checkParameterIsNotNull(candidate2, "candidate");
        CandidateApplicability applicability = this.getApplicability(group, candidate2);
        if (applicability.compareTo((Enum)this.currentApplicability) > 0) {
            this.groupNumbers.clear();
            this.candidates.clear();
            this.currentApplicability = applicability;
        }
        if (applicability == this.currentApplicability) {
            this.candidates.add(candidate2);
            this.groupNumbers.add(group);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Candidate> bestCandidates() {
        if (this.groupNumbers.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        boolean bl = false;
        List result2 = new ArrayList();
        int bestGroup = ((Number)CollectionsKt.first(this.groupNumbers)).intValue();
        boolean bl2 = false;
        for (Candidate candidate2 : (Iterable)this.candidates) {
            void index2;
            int group = ((Number)this.groupNumbers.get((int)index2)).intValue();
            if (bestGroup > group) {
                bestGroup = group;
                result2.clear();
            }
            if (bestGroup == group) {
                result2.add(candidate2);
            }
            ++index2;
        }
        return result2;
    }

    public final boolean isSuccess() {
        return this.currentApplicability == CandidateApplicability.RESOLVED;
    }

    @NotNull
    public final CallInfo getCallInfo() {
        return this.callInfo;
    }

    @NotNull
    public final InferenceComponents getComponents() {
        return this.components;
    }

    public CandidateCollector(@NotNull CallInfo callInfo, @NotNull InferenceComponents components) {
        List list2;
        Intrinsics.checkParameterIsNotNull(callInfo, "callInfo");
        Intrinsics.checkParameterIsNotNull(components, "components");
        this.callInfo = callInfo;
        this.components = components;
        CandidateCollector candidateCollector = this;
        boolean bl = false;
        candidateCollector.groupNumbers = list2 = (List)new ArrayList();
        candidateCollector = this;
        bl = false;
        candidateCollector.candidates = list2 = (List)new ArrayList();
        this.currentApplicability = CandidateApplicability.HIDDEN;
    }
}

