/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.noding;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.impl.CoordinateArraySequence;
import org.locationtech.jts.io.WKTWriter;
import org.locationtech.jts.noding.Octant;
import org.locationtech.jts.noding.SegmentString;

public class BasicSegmentString
implements SegmentString {
    private Coordinate[] pts;
    private Object data;

    public BasicSegmentString(Coordinate[] pts, Object data) {
        this.pts = pts;
        this.data = data;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public int size() {
        return this.pts.length;
    }

    public Coordinate getCoordinate(int i) {
        return this.pts[i];
    }

    public Coordinate[] getCoordinates() {
        return this.pts;
    }

    public boolean isClosed() {
        return this.pts[0].equals(this.pts[this.pts.length - 1]);
    }

    public int getSegmentOctant(int index) {
        if (index == this.pts.length - 1) {
            return -1;
        }
        return Octant.octant(this.getCoordinate(index), this.getCoordinate(index + 1));
    }

    public String toString() {
        return WKTWriter.toLineString(new CoordinateArraySequence(this.pts));
    }
}

