/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.qtesla;

import org.bouncycastle.pqc.crypto.qtesla.CommonFunction;
import org.bouncycastle.pqc.crypto.qtesla.HashUtils;
import org.bouncycastle.pqc.crypto.qtesla.PolynomialHeuristic;
import org.bouncycastle.pqc.crypto.qtesla.PolynomialProvablySecure;
import org.bouncycastle.util.Arrays;

class Polynomial {
    public static final int RANDOM = 32;
    public static final int SEED = 32;
    public static final int HASH = 32;
    public static final int MESSAGE = 64;
    public static final int SIGNATURE_I = 1376;
    public static final int SIGNATURE_III_SIZE = 2720;
    public static final int SIGNATURE_III_SPEED = 2848;
    public static final int SIGNATURE_I_P = 2848;
    public static final int SIGNATURE_III_P = 6176;
    public static final int PUBLIC_KEY_I = 1504;
    public static final int PUBLIC_KEY_III_SIZE = 2976;
    public static final int PUBLIC_KEY_III_SPEED = 3104;
    public static final int PUBLIC_KEY_I_P = 14880;
    public static final int PUBLIC_KEY_III_P = 39712;
    public static final int PRIVATE_KEY_I = 1344;
    public static final int PRIVATE_KEY_III_SIZE = 2112;
    public static final int PRIVATE_KEY_III_SPEED = 2368;
    public static final int PRIVATE_KEY_I_P = 5184;
    public static final int PRIVATE_KEY_III_P = 12352;

    Polynomial() {
    }

    private static int montgomery(long l, int n, long l2) {
        return (int)(l + (l * l2 & 0xFFFFFFFFL) * (long)n >> 32);
    }

    private static long montgomeryP(long l, int n, long l2) {
        return l + (l * l2 & 0xFFFFFFFFL) * (long)n >> 32;
    }

    public static int barrett(int n, int n2, int n3, int n4) {
        return n - (int)((long)n * (long)n3 >> n4) * n2;
    }

    public static long barrett(long l, int n, int n2, int n3) {
        return l - (l * (long)n2 >> n3) * (long)n;
    }

    private static void numberTheoreticTransform(int[] nArray, int[] nArray2, int n, int n2, long l) {
        int n3 = 0;
        for (int i = n >> 1; i > 0; i >>= 1) {
            int n4 = 0;
            int n5 = 0;
            while (n5 < n) {
                long l2 = nArray2[n3++];
                for (n4 = n5; n4 < n5 + i; ++n4) {
                    int n6 = Polynomial.montgomery(l2 * (long)nArray[n4 + i], n2, l);
                    nArray[n4 + i] = nArray[n4] - n6;
                    nArray[n4] = nArray[n4] + n6;
                }
                n5 = n4 + i;
            }
        }
    }

    private static void numberTheoreticTransformIP(long[] lArray, long[] lArray2) {
        int n = 0;
        for (int i = 512; i > 0; i >>= 1) {
            int n2 = 0;
            int n3 = 0;
            while (n3 < 1024) {
                long l = lArray2[n++];
                for (n2 = n3; n2 < n3 + i; ++n2) {
                    long l2 = Polynomial.montgomeryP(l * lArray[n2 + i], 485978113, 3421990911L);
                    lArray[n2 + i] = lArray[n2] + (485978113L - l2);
                    lArray[n2] = lArray[n2] + l2;
                }
                n3 = n2 + i;
            }
        }
    }

    private static void numberTheoreticTransformIIIP(long[] lArray, long[] lArray2) {
        int n = 0;
        for (int i = 1024; i > 0; i >>= 1) {
            int n2 = 0;
            int n3 = 0;
            while (n3 < 2048) {
                int n4 = (int)lArray2[n++];
                for (n2 = n3; n2 < n3 + i; ++n2) {
                    long l = Polynomial.barrett(Polynomial.montgomeryP((long)n4 * lArray[n2 + i], 1129725953, 861290495L), 1129725953, 15, 34);
                    lArray[n2 + i] = Polynomial.barrett(lArray[n2] + (2259451906L - l), 1129725953, 15, 34);
                    lArray[n2] = Polynomial.barrett(lArray[n2] + l, 1129725953, 15, 34);
                }
                n3 = n2 + i;
            }
        }
    }

    private static void inverseNumberTheoreticTransformI(int[] nArray, int[] nArray2) {
        int n;
        int n2 = 0;
        for (n = 1; n < 512; n *= 2) {
            int n3 = 0;
            int n4 = 0;
            while (n4 < 512) {
                long l = nArray2[n2++];
                for (n3 = n4; n3 < n4 + n; ++n3) {
                    int n5 = nArray[n3];
                    nArray[n3] = n5 + nArray[n3 + n];
                    nArray[n3 + n] = Polynomial.montgomery(l * (long)(n5 - nArray[n3 + n]), 4205569, 3098553343L);
                }
                n4 = n3 + n;
            }
        }
        for (n = 0; n < 256; ++n) {
            nArray[n] = Polynomial.montgomery(1081347L * (long)nArray[n], 4205569, 3098553343L);
        }
    }

    private static void inverseNumberTheoreticTransform(int[] nArray, int[] nArray2, int n, int n2, long l, int n3, int n4, int n5) {
        int n6;
        int n7 = 0;
        for (n6 = 1; n6 < n; n6 *= 2) {
            int n8 = 0;
            int n9 = 0;
            while (n9 < n) {
                long l2 = nArray2[n7++];
                for (n8 = n9; n8 < n9 + n6; ++n8) {
                    int n10 = nArray[n8];
                    nArray[n8] = n6 == 16 ? Polynomial.barrett(n10 + nArray[n8 + n6], n2, n4, n5) : n10 + nArray[n8 + n6];
                    nArray[n8 + n6] = Polynomial.montgomery(l2 * (long)(n10 - nArray[n8 + n6]), n2, l);
                }
                n9 = n8 + n6;
            }
        }
        for (n6 = 0; n6 < n / 2; ++n6) {
            nArray[n6] = Polynomial.montgomery((long)n3 * (long)nArray[n6], n2, l);
        }
    }

    private static void inverseNumberTheoreticTransformIP(long[] lArray, int n, long[] lArray2, int n2) {
        int n3 = 0;
        for (int i = 1; i < 1024; i *= 2) {
            long l;
            long l2;
            int n4 = 0;
            int n5 = 0;
            while (n5 < 1024) {
                l2 = lArray2[n2 + n3++];
                for (n4 = n5; n4 < n5 + i; ++n4) {
                    l = lArray[n + n4];
                    lArray[n + n4] = l + lArray[n + n4 + i];
                    lArray[n + n4 + i] = Polynomial.montgomeryP(l2 * (l + (971956226L - lArray[n + n4 + i])), 485978113, 3421990911L);
                }
                n5 = n4 + i;
            }
            i *= 2;
            n5 = 0;
            while (n5 < 1024) {
                l2 = lArray2[n2 + n3++];
                for (n4 = n5; n4 < n5 + i; ++n4) {
                    l = lArray[n + n4];
                    lArray[n + n4] = Polynomial.barrett(l + lArray[n + n4 + i], 485978113, 1, 29);
                    lArray[n + n4 + i] = Polynomial.montgomeryP(l2 * (l + (971956226L - lArray[n + n4 + i])), 485978113, 3421990911L);
                }
                n5 = n4 + i;
            }
        }
    }

    private static void inverseNumberTheoreticTransformIIIP(long[] lArray, int n, long[] lArray2, int n2) {
        int n3 = 0;
        for (int i = 1; i < 2048; i *= 2) {
            int n4 = 0;
            int n5 = 0;
            while (n5 < 2048) {
                long l = lArray2[n2 + n3++];
                for (n4 = n5; n4 < n5 + i; ++n4) {
                    long l2 = lArray[n + n4];
                    lArray[n + n4] = Polynomial.barrett(l2 + lArray[n + n4 + i], 1129725953, 15, 34);
                    lArray[n + n4 + i] = Polynomial.barrett(Polynomial.montgomeryP(l * (l2 + (2259451906L - lArray[n + n4 + i])), 1129725953, 861290495L), 1129725953, 15, 34);
                }
                n5 = n4 + i;
            }
        }
    }

    private static void componentWisePolynomialMultiplication(int[] nArray, int[] nArray2, int[] nArray3, int n, int n2, long l) {
        for (int i = 0; i < n; ++i) {
            nArray[i] = Polynomial.montgomery((long)nArray2[i] * (long)nArray3[i], n2, l);
        }
    }

    private static void componentWisePolynomialMultiplication(long[] lArray, int n, long[] lArray2, int n2, long[] lArray3, int n3, int n4, int n5, long l) {
        for (int i = 0; i < n4; ++i) {
            lArray[n + i] = Polynomial.montgomeryP(lArray2[n2 + i] * lArray3[n3 + i], n5, l);
        }
    }

    public static void polynomialNumberTheoreticTransform(long[] lArray, long[] lArray2, int n) {
        for (int i = 0; i < n; ++i) {
            lArray[i] = lArray2[i];
        }
        if (n == 1024) {
            Polynomial.numberTheoreticTransformIP(lArray, PolynomialProvablySecure.ZETA_I_P);
        }
        if (n == 2048) {
            Polynomial.numberTheoreticTransformIIIP(lArray, PolynomialProvablySecure.ZETA_III_P);
        }
    }

    public static void polynomialMultiplication(int[] nArray, int[] nArray2, int[] nArray3, int n, int n2, long l, int[] nArray4) {
        int[] nArray5 = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray5[i] = nArray3[i];
        }
        Polynomial.numberTheoreticTransform(nArray5, nArray4, n, n2, l);
        Polynomial.componentWisePolynomialMultiplication(nArray, nArray2, nArray5, n, n2, l);
        if (n2 == 4205569) {
            Polynomial.inverseNumberTheoreticTransformI(nArray, PolynomialHeuristic.ZETA_INVERSE_I);
        }
        if (n2 == 4206593) {
            Polynomial.inverseNumberTheoreticTransform(nArray, PolynomialHeuristic.ZETA_INVERSE_III_SIZE, 1024, 4206593, 4148178943L, 35843, 1021, 32);
        }
        if (n2 == 8404993) {
            Polynomial.inverseNumberTheoreticTransform(nArray, PolynomialHeuristic.ZETA_INVERSE_III_SPEED, 1024, 8404993, 4034936831L, 15873, 511, 32);
        }
    }

    public static void polynomialMultiplication(long[] lArray, int n, long[] lArray2, int n2, long[] lArray3, int n3, int n4, int n5, long l) {
        Polynomial.componentWisePolynomialMultiplication(lArray, n, lArray2, n2, lArray3, n3, n4, n5, l);
        if (n5 == 485978113) {
            Polynomial.inverseNumberTheoreticTransformIP(lArray, n, PolynomialProvablySecure.ZETA_INVERSE_I_P, 0);
        }
        if (n5 == 1129725953) {
            Polynomial.inverseNumberTheoreticTransformIIIP(lArray, n, PolynomialProvablySecure.ZETA_INVERSE_III_P, 0);
        }
    }

    public static void polynomialAddition(int[] nArray, int[] nArray2, int[] nArray3, int n) {
        for (int i = 0; i < n; ++i) {
            nArray[i] = nArray2[i] + nArray3[i];
        }
    }

    public static void polynomialAddition(long[] lArray, int n, long[] lArray2, int n2, long[] lArray3, int n3, int n4) {
        for (int i = 0; i < n4; ++i) {
            lArray[n + i] = lArray2[n2 + i] + lArray3[n3 + i];
        }
    }

    public static void polynomialAdditionCorrection(int[] nArray, int[] nArray2, int[] nArray3, int n, int n2) {
        for (int i = 0; i < n; ++i) {
            nArray[i] = nArray2[i] + nArray3[i];
            int n3 = i;
            nArray[n3] = nArray[n3] + (nArray[i] >> 31 & n2);
            int n4 = i;
            nArray[n4] = nArray[n4] - n2;
            int n5 = i;
            nArray[n5] = nArray[n5] + (nArray[i] >> 31 & n2);
        }
    }

    public static void polynomialSubtractionCorrection(int[] nArray, int[] nArray2, int[] nArray3, int n, int n2) {
        for (int i = 0; i < n; ++i) {
            nArray[i] = nArray2[i] - nArray3[i];
            int n3 = i;
            nArray[n3] = nArray[n3] + (nArray[i] >> 31 & n2);
        }
    }

    public static void polynomialSubtractionMontgomery(int[] nArray, int[] nArray2, int[] nArray3, int n, int n2, long l, int n3) {
        for (int i = 0; i < n; ++i) {
            nArray[i] = Polynomial.montgomery((long)n3 * (long)(nArray2[i] - nArray3[i]), n2, l);
        }
    }

    public static void polynomialSubtraction(long[] lArray, int n, long[] lArray2, int n2, long[] lArray3, int n3, int n4, int n5, int n6, int n7) {
        for (int i = 0; i < n4; ++i) {
            lArray[n + i] = Polynomial.barrett(lArray2[n2 + i] - lArray3[n3 + i], n5, n6, n7);
        }
    }

    public static void polynomialUniform(int[] nArray, byte[] byArray, int n, int n2, int n3, long l, int n4, int n5, int n6) {
        int n7 = 0;
        int n8 = 0;
        int n9 = (n4 + 7) / 8;
        int n10 = n5;
        short s = 0;
        int n11 = (1 << n4) - 1;
        byte[] byArray2 = new byte[168 * n5];
        short s2 = s;
        s = (short)(s + 1);
        HashUtils.customizableSecureHashAlgorithmKECCAK128Simple(byArray2, 0, 168 * n5, s2, byArray, n, 32);
        while (n8 < n2) {
            if (n7 > 168 * n10 - 4 * n9) {
                n10 = 1;
                short s3 = s;
                s = (short)(s + 1);
                HashUtils.customizableSecureHashAlgorithmKECCAK128Simple(byArray2, 0, 168 * n10, s3, byArray, n, 32);
                n7 = 0;
            }
            int n12 = CommonFunction.load32(byArray2, n7) & n11;
            int n13 = CommonFunction.load32(byArray2, n7 += n9) & n11;
            int n14 = CommonFunction.load32(byArray2, n7 += n9) & n11;
            int n15 = CommonFunction.load32(byArray2, n7 += n9) & n11;
            n7 += n9;
            if (n12 < n3 && n8 < n2) {
                nArray[n8++] = Polynomial.montgomery((long)n12 * (long)n6, n3, l);
            }
            if (n13 < n3 && n8 < n2) {
                nArray[n8++] = Polynomial.montgomery((long)n13 * (long)n6, n3, l);
            }
            if (n14 < n3 && n8 < n2) {
                nArray[n8++] = Polynomial.montgomery((long)n14 * (long)n6, n3, l);
            }
            if (n15 >= n3 || n8 >= n2) continue;
            nArray[n8++] = Polynomial.montgomery((long)n15 * (long)n6, n3, l);
        }
    }

    public static void polynomialUniform(long[] lArray, byte[] byArray, int n, int n2, int n3, int n4, long l, int n5, int n6, int n7) {
        int n8 = 0;
        int n9 = 0;
        int n10 = (n5 + 7) / 8;
        int n11 = n6;
        short s = 0;
        int n12 = (1 << n5) - 1;
        byte[] byArray2 = new byte[168 * n11];
        short s2 = s;
        s = (short)(s + 1);
        HashUtils.customizableSecureHashAlgorithmKECCAK128Simple(byArray2, 0, 168 * n11, s2, byArray, n, 32);
        while (n9 < n2 * n3) {
            if (n8 > 168 * n11 - 4 * n10) {
                n11 = 1;
                short s3 = s;
                s = (short)(s + 1);
                HashUtils.customizableSecureHashAlgorithmKECCAK128Simple(byArray2, 0, 168 * n11, s3, byArray, n, 32);
                n8 = 0;
            }
            int n13 = CommonFunction.load32(byArray2, n8) & n12;
            int n14 = CommonFunction.load32(byArray2, n8 += n10) & n12;
            int n15 = CommonFunction.load32(byArray2, n8 += n10) & n12;
            int n16 = CommonFunction.load32(byArray2, n8 += n10) & n12;
            n8 += n10;
            if (n13 < n4 && n9 < n2 * n3) {
                lArray[n9++] = Polynomial.montgomeryP((long)n13 * (long)n7, n4, l);
            }
            if (n14 < n4 && n9 < n2 * n3) {
                lArray[n9++] = Polynomial.montgomeryP((long)n14 * (long)n7, n4, l);
            }
            if (n15 < n4 && n9 < n2 * n3) {
                lArray[n9++] = Polynomial.montgomeryP((long)n15 * (long)n7, n4, l);
            }
            if (n16 >= n4 || n9 >= n2 * n3) continue;
            lArray[n9++] = Polynomial.montgomeryP((long)n16 * (long)n7, n4, l);
        }
    }

    public static void sparsePolynomialMultiplication16(int[] nArray, short[] sArray, int[] nArray2, short[] sArray2, int n, int n2) {
        Arrays.fill(nArray, 0);
        for (int i = 0; i < n2; ++i) {
            int n3;
            int n4 = nArray2[i];
            for (n3 = 0; n3 < n4; ++n3) {
                int n5 = n3;
                nArray[n5] = nArray[n5] - sArray2[i] * sArray[n + n3 - n4];
            }
            for (n3 = n4; n3 < n; ++n3) {
                int n6 = n3;
                nArray[n6] = nArray[n6] + sArray2[i] * sArray[n3 - n4];
            }
        }
    }

    public static void sparsePolynomialMultiplication8(long[] lArray, int n, byte[] byArray, int n2, int[] nArray, short[] sArray, int n3, int n4) {
        Arrays.fill(lArray, 0L);
        for (int i = 0; i < n4; ++i) {
            int n5;
            int n6 = nArray[i];
            for (n5 = 0; n5 < n6; ++n5) {
                int n7 = n + n5;
                lArray[n7] = lArray[n7] - (long)(sArray[i] * byArray[n2 + n3 + n5 - n6]);
            }
            for (n5 = n6; n5 < n3; ++n5) {
                int n8 = n + n5;
                lArray[n8] = lArray[n8] + (long)(sArray[i] * byArray[n2 + n5 - n6]);
            }
        }
    }

    public static void sparsePolynomialMultiplication32(int[] nArray, int[] nArray2, int[] nArray3, short[] sArray, int n, int n2) {
        Arrays.fill(nArray, 0);
        for (int i = 0; i < n2; ++i) {
            int n3;
            int n4 = nArray3[i];
            for (n3 = 0; n3 < n4; ++n3) {
                int n5 = n3;
                nArray[n5] = nArray[n5] - sArray[i] * nArray2[n + n3 - n4];
            }
            for (n3 = n4; n3 < n; ++n3) {
                int n6 = n3;
                nArray[n6] = nArray[n6] + sArray[i] * nArray2[n3 - n4];
            }
        }
    }

    public static void sparsePolynomialMultiplication32(long[] lArray, int n, int[] nArray, int n2, int[] nArray2, short[] sArray, int n3, int n4, int n5, int n6, int n7) {
        int n8;
        Arrays.fill(lArray, 0L);
        for (n8 = 0; n8 < n4; ++n8) {
            int n9;
            int n10 = nArray2[n8];
            for (n9 = 0; n9 < n10; ++n9) {
                int n11 = n + n9;
                lArray[n11] = lArray[n11] - (long)(sArray[n8] * nArray[n2 + n3 + n9 - n10]);
            }
            for (n9 = n10; n9 < n3; ++n9) {
                int n12 = n + n9;
                lArray[n12] = lArray[n12] + (long)(sArray[n8] * nArray[n2 + n9 - n10]);
            }
        }
        for (n8 = 0; n8 < n3; ++n8) {
            lArray[n + n8] = Polynomial.barrett(lArray[n + n8], n5, n6, n7);
        }
    }
}

