/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.join.aggregations;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.plain.SortedSetDVOrdinalsIndexFieldData;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.join.aggregations.ChildrenToParentAggregator;
import org.elasticsearch.join.aggregations.ParentAggregatorFactory;
import org.elasticsearch.join.mapper.ParentIdFieldMapper;
import org.elasticsearch.join.mapper.ParentJoinFieldMapper;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.support.FieldContext;
import org.elasticsearch.search.aggregations.support.ValueType;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.search.internal.SearchContext;

public class ParentAggregationBuilder
extends ValuesSourceAggregationBuilder<ValuesSource.Bytes.WithOrdinals, ParentAggregationBuilder> {
    public static final String NAME = "parent";
    private final String childType;
    private Query parentFilter;
    private Query childFilter;

    public ParentAggregationBuilder(String name, String childType) {
        super(name, ValuesSourceType.BYTES, ValueType.STRING);
        if (childType == null) {
            throw new IllegalArgumentException("[childType] must not be null: [" + name + "]");
        }
        this.childType = childType;
    }

    protected ParentAggregationBuilder(ParentAggregationBuilder clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metaData) {
        super((ValuesSourceAggregationBuilder)clone, factoriesBuilder, metaData);
        this.childType = clone.childType;
        this.childFilter = clone.childFilter;
        this.parentFilter = clone.parentFilter;
    }

    protected AggregationBuilder shallowCopy(AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metaData) {
        return new ParentAggregationBuilder(this, factoriesBuilder, metaData);
    }

    public ParentAggregationBuilder(StreamInput in) throws IOException {
        super(in, ValuesSourceType.BYTES, ValueType.STRING);
        this.childType = in.readString();
    }

    protected void innerWriteTo(StreamOutput out) throws IOException {
        out.writeString(this.childType);
    }

    protected ValuesSourceAggregatorFactory<ValuesSource.Bytes.WithOrdinals, ?> innerBuild(SearchContext context, ValuesSourceConfig<ValuesSource.Bytes.WithOrdinals> config, AggregatorFactory<?> parent, AggregatorFactories.Builder subFactoriesBuilder) throws IOException {
        return new ParentAggregatorFactory(this.name, config, this.childFilter, this.parentFilter, context, parent, subFactoriesBuilder, this.metaData);
    }

    protected ValuesSourceConfig<ValuesSource.Bytes.WithOrdinals> resolveConfig(SearchContext context) {
        ValuesSourceConfig config = new ValuesSourceConfig(ValuesSourceType.BYTES);
        this.joinFieldResolveConfig(context, (ValuesSourceConfig<ValuesSource.Bytes.WithOrdinals>)config);
        return config;
    }

    private void joinFieldResolveConfig(SearchContext context, ValuesSourceConfig<ValuesSource.Bytes.WithOrdinals> config) {
        ParentJoinFieldMapper parentJoinFieldMapper = ParentJoinFieldMapper.getMapper(context.mapperService());
        ParentIdFieldMapper parentIdFieldMapper = parentJoinFieldMapper.getParentIdFieldMapper(this.childType, false);
        if (parentIdFieldMapper != null) {
            this.parentFilter = parentIdFieldMapper.getParentFilter();
            this.childFilter = parentIdFieldMapper.getChildFilter(this.childType);
            MappedFieldType fieldType = parentIdFieldMapper.fieldType();
            SortedSetDVOrdinalsIndexFieldData fieldData = (SortedSetDVOrdinalsIndexFieldData)context.getForField(fieldType);
            config.fieldContext(new FieldContext(fieldType.name(), (IndexFieldData)fieldData, fieldType));
        } else {
            config.unmapped(true);
        }
    }

    protected XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(ChildrenToParentAggregator.TYPE_FIELD.getPreferredName(), this.childType);
        return builder;
    }

    public static ParentAggregationBuilder parse(String aggregationName, XContentParser parser) throws IOException {
        XContentParser.Token token;
        String childType = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.VALUE_STRING) {
                if ("type".equals(currentFieldName)) {
                    childType = parser.text();
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "Unknown key for a " + token + " in [" + aggregationName + "]: [" + currentFieldName + "].", new Object[0]);
            }
            throw new ParsingException(parser.getTokenLocation(), "Unexpected token " + token + " in [" + aggregationName + "].", new Object[0]);
        }
        if (childType == null) {
            throw new ParsingException(parser.getTokenLocation(), "Missing [child_type] field for parent aggregation [" + aggregationName + "]", new Object[0]);
        }
        return new ParentAggregationBuilder(aggregationName, childType);
    }

    protected int innerHashCode() {
        return Objects.hash(this.childType);
    }

    protected boolean innerEquals(Object obj) {
        ParentAggregationBuilder other = (ParentAggregationBuilder)((Object)obj);
        return Objects.equals(this.childType, other.childType);
    }

    public String getType() {
        return NAME;
    }
}

