/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.admin.cluster.snapshots.status.TransportNodesSnapshotsStatus;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.env.Environment;
import org.elasticsearch.plugins.RepositoryPlugin;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.repositories.fs.FsRepository;
import org.elasticsearch.snapshots.RestoreService;
import org.elasticsearch.snapshots.SnapshotShardsService;
import org.elasticsearch.snapshots.SnapshotsService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class RepositoriesModule
extends AbstractModule {
    private final RepositoriesService repositoriesService;

    public RepositoriesModule(Environment env, List<RepositoryPlugin> repoPlugins, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, NamedXContentRegistry namedXContentRegistry) {
        HashMap<String, Repository.Factory> factories = new HashMap<String, Repository.Factory>();
        factories.put("fs", metadata -> new FsRepository(metadata, env, namedXContentRegistry, threadPool));
        for (RepositoryPlugin repositoryPlugin : repoPlugins) {
            Map<String, Repository.Factory> newRepoTypes = repositoryPlugin.getRepositories(env, namedXContentRegistry, threadPool);
            for (Map.Entry<String, Repository.Factory> entry : newRepoTypes.entrySet()) {
                if (factories.put(entry.getKey(), entry.getValue()) == null) continue;
                throw new IllegalArgumentException("Repository type [" + entry.getKey() + "] is already registered");
            }
        }
        HashMap<String, Repository.Factory> internalFactories = new HashMap<String, Repository.Factory>();
        for (RepositoryPlugin repoPlugin : repoPlugins) {
            Map<String, Repository.Factory> newRepoTypes = repoPlugin.getInternalRepositories(env, namedXContentRegistry, threadPool);
            for (Map.Entry<String, Repository.Factory> entry : newRepoTypes.entrySet()) {
                if (internalFactories.put(entry.getKey(), entry.getValue()) != null) {
                    throw new IllegalArgumentException("Internal repository type [" + entry.getKey() + "] is already registered");
                }
                if (factories.put(entry.getKey(), entry.getValue()) == null) continue;
                throw new IllegalArgumentException("Internal repository type [" + entry.getKey() + "] is already registered as a non-internal repository");
            }
        }
        Map<String, Repository.Factory> map = Collections.unmodifiableMap(factories);
        Map<String, Repository.Factory> internalRepositoryTypes = Collections.unmodifiableMap(internalFactories);
        this.repositoriesService = new RepositoriesService(env.settings(), clusterService, transportService, map, internalRepositoryTypes, threadPool);
    }

    @Override
    protected void configure() {
        this.bind(RepositoriesService.class).toInstance(this.repositoriesService);
        this.bind(SnapshotsService.class).asEagerSingleton();
        this.bind(SnapshotShardsService.class).asEagerSingleton();
        this.bind(TransportNodesSnapshotsStatus.class).asEagerSingleton();
        this.bind(RestoreService.class).asEagerSingleton();
    }
}

