/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.metrics.GeoBoundsAggregator;
import org.elasticsearch.search.aggregations.metrics.GeoBoundsAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValueType;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.ValuesSourceParserHelper;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.search.internal.SearchContext;

public class GeoBoundsAggregationBuilder
extends ValuesSourceAggregationBuilder<ValuesSource.GeoPoint, GeoBoundsAggregationBuilder> {
    public static final String NAME = "geo_bounds";
    private static final ObjectParser<GeoBoundsAggregationBuilder, Void> PARSER = new ObjectParser("geo_bounds");
    private boolean wrapLongitude = true;

    public static AggregationBuilder parse(String aggregationName, XContentParser parser) throws IOException {
        return (AggregationBuilder)PARSER.parse(parser, (Object)new GeoBoundsAggregationBuilder(aggregationName), null);
    }

    public GeoBoundsAggregationBuilder(String name) {
        super(name, ValuesSourceType.GEOPOINT, ValueType.GEOPOINT);
    }

    protected GeoBoundsAggregationBuilder(GeoBoundsAggregationBuilder clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metaData) {
        super(clone, factoriesBuilder, metaData);
        this.wrapLongitude = clone.wrapLongitude;
    }

    @Override
    protected AggregationBuilder shallowCopy(AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metaData) {
        return new GeoBoundsAggregationBuilder(this, factoriesBuilder, metaData);
    }

    public GeoBoundsAggregationBuilder(StreamInput in) throws IOException {
        super(in, ValuesSourceType.GEOPOINT, ValueType.GEOPOINT);
        this.wrapLongitude = in.readBoolean();
    }

    @Override
    protected void innerWriteTo(StreamOutput out) throws IOException {
        out.writeBoolean(this.wrapLongitude);
    }

    public GeoBoundsAggregationBuilder wrapLongitude(boolean wrapLongitude) {
        this.wrapLongitude = wrapLongitude;
        return this;
    }

    public boolean wrapLongitude() {
        return this.wrapLongitude;
    }

    protected GeoBoundsAggregatorFactory innerBuild(SearchContext context, ValuesSourceConfig<ValuesSource.GeoPoint> config, AggregatorFactory<?> parent, AggregatorFactories.Builder subFactoriesBuilder) throws IOException {
        return new GeoBoundsAggregatorFactory(this.name, config, this.wrapLongitude, context, parent, subFactoriesBuilder, this.metaData);
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(GeoBoundsAggregator.WRAP_LONGITUDE_FIELD.getPreferredName(), this.wrapLongitude);
        return builder;
    }

    @Override
    protected int innerHashCode() {
        return Objects.hash(this.wrapLongitude);
    }

    @Override
    protected boolean innerEquals(Object obj) {
        GeoBoundsAggregationBuilder other = (GeoBoundsAggregationBuilder)obj;
        return Objects.equals(this.wrapLongitude, other.wrapLongitude);
    }

    @Override
    public String getType() {
        return NAME;
    }

    static {
        ValuesSourceParserHelper.declareGeoFields(PARSER, false, false);
        PARSER.declareBoolean(GeoBoundsAggregationBuilder::wrapLongitude, GeoBoundsAggregator.WRAP_LONGITUDE_FIELD);
    }
}

