/*
 * Decompiled with CFR 0.152.
 */
package org.openide.xml;

import java.io.ByteArrayInputStream;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import org.openide.util.Exceptions;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public final class XMLUtil {
    private static final char[] DEC2HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static SAXParserFactory[][] saxes = new SAXParserFactory[2][2];
    private static DocumentBuilderFactory[][] doms = new DocumentBuilderFactory[2][2];
    private static final String IDENTITY_XSLT_WITH_INDENT = "<xsl:stylesheet version='1.0' xmlns:xsl='http://www.w3.org/1999/XSL/Transform' xmlns:xalan='http://xml.apache.org/xslt' exclude-result-prefixes='xalan'><xsl:output method='xml' indent='yes' xalan:indent-amount='4'/><xsl:template match='@*|node()'><xsl:copy><xsl:apply-templates select='@*|node()'/></xsl:copy></xsl:template></xsl:stylesheet>";
    private static final String ORACLE_IS_STANDALONE = "http://www.oracle.com/xml/is-standalone";

    private XMLUtil() {
    }

    public static XMLReader createXMLReader() throws SAXException {
        return XMLUtil.createXMLReader(false, false);
    }

    public static XMLReader createXMLReader(boolean bl) throws SAXException {
        return XMLUtil.createXMLReader(bl, false);
    }

    public static synchronized XMLReader createXMLReader(boolean bl, boolean bl2) throws SAXException {
        SAXParserFactory sAXParserFactory = saxes[bl ? 0 : 1][bl2 ? 0 : 1];
        if (sAXParserFactory == null) {
            try {
                sAXParserFactory = SAXParserFactory.newInstance();
            }
            catch (FactoryConfigurationError factoryConfigurationError) {
                Exceptions.attachMessage(factoryConfigurationError, "Info about thread context classloader: " + Thread.currentThread().getContextClassLoader());
                throw factoryConfigurationError;
            }
            sAXParserFactory.setValidating(bl);
            sAXParserFactory.setNamespaceAware(bl2);
            XMLUtil.saxes[bl ? 0 : 1][bl2 ? 0 : 1] = sAXParserFactory;
        }
        try {
            return sAXParserFactory.newSAXParser().getXMLReader();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new SAXException("Cannot create parser satisfying configuration parameters", parserConfigurationException);
        }
    }

    public static Document createDocument(String string, String string2, String string3, String string4) throws DOMException {
        DOMImplementation dOMImplementation = XMLUtil.getDOMImplementation();
        if (string3 != null && string4 == null) {
            throw new IllegalArgumentException("System ID cannot be null if public ID specified. ");
        }
        DocumentType documentType = null;
        if (string4 != null) {
            documentType = dOMImplementation.createDocumentType(string, string3, string4);
        }
        return dOMImplementation.createDocument(string2, string, documentType);
    }

    private static DOMImplementation getDOMImplementation() throws DOMException {
        DocumentBuilderFactory documentBuilderFactory = XMLUtil.getFactory(false, false);
        try {
            return documentBuilderFactory.newDocumentBuilder().getDOMImplementation();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new DOMException(9, "Cannot create parser satisfying configuration parameters");
        }
        catch (RuntimeException runtimeException) {
            throw (DOMException)new DOMException(9, runtimeException.toString()).initCause(runtimeException);
        }
    }

    private static synchronized DocumentBuilderFactory getFactory(boolean bl, boolean bl2) {
        DocumentBuilderFactory documentBuilderFactory = doms[bl ? 0 : 1][bl2 ? 0 : 1];
        if (documentBuilderFactory == null) {
            documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(bl);
            documentBuilderFactory.setNamespaceAware(bl2);
            XMLUtil.doms[bl ? 0 : 1][bl2 ? 0 : 1] = documentBuilderFactory;
        }
        return documentBuilderFactory;
    }

    public static Document parse(InputSource inputSource, boolean bl, boolean bl2, ErrorHandler errorHandler, EntityResolver entityResolver) throws IOException, SAXException {
        DocumentBuilder documentBuilder = null;
        DocumentBuilderFactory documentBuilderFactory = XMLUtil.getFactory(bl, bl2);
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new SAXException("Cannot create parser satisfying configuration parameters", parserConfigurationException);
        }
        if (errorHandler != null) {
            documentBuilder.setErrorHandler(errorHandler);
        }
        if (entityResolver != null) {
            documentBuilder.setEntityResolver(entityResolver);
        }
        return documentBuilder.parse(inputSource);
    }

    public static void write(Document document, OutputStream outputStream, String string) throws IOException {
        if (string == null) {
            throw new NullPointerException("You must set an encoding; use \"UTF-8\" unless you have a good reason not to!");
        }
        Document document2 = XMLUtil.normalize(document);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return new ClassLoader(ClassLoader.getSystemClassLoader().getParent()){

                    @Override
                    public InputStream getResourceAsStream(String string) {
                        if (string.startsWith("META-INF/services/")) {
                            return new ByteArrayInputStream(new byte[0]);
                        }
                        return super.getResourceAsStream(string);
                    }
                };
            }
        }));
        try {
            Object object;
            Object object2;
            Object object3;
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer(new StreamSource(new StringReader(IDENTITY_XSLT_WITH_INDENT)));
            DocumentType documentType = document2.getDoctype();
            if (documentType != null) {
                object3 = documentType.getPublicId();
                if (object3 != null) {
                    transformer.setOutputProperty("doctype-public", (String)object3);
                }
                if ((object2 = documentType.getSystemId()) != null) {
                    transformer.setOutputProperty("doctype-system", (String)object2);
                }
            }
            transformer.setOutputProperty("encoding", string);
            try {
                transformer.setOutputProperty(ORACLE_IS_STANDALONE, "yes");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            object3 = new HashSet();
            XMLUtil.collectCDATASections(document2, (Set<String>)object3);
            if (object3.size() > 0) {
                object2 = new StringBuilder();
                object = object3.iterator();
                while (object.hasNext()) {
                    String string2 = (String)object.next();
                    ((StringBuilder)object2).append(string2).append(' ');
                }
                transformer.setOutputProperty("cdata-section-elements", ((StringBuilder)object2).toString());
            }
            object2 = new DOMSource(document2);
            object = new StreamResult(outputStream);
            transformer.transform((Source)object2, (Result)object);
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    private static void collectCDATASections(Node node, Set<String> set) {
        Object object;
        if (node instanceof CDATASection && (object = node.getParentNode()) != null) {
            String string = object.getNamespaceURI();
            if (string != null) {
                set.add("{" + string + "}" + object.getNodeName());
            } else {
                set.add(object.getNodeName());
            }
        }
        object = node.getChildNodes();
        for (int i = 0; i < object.getLength(); ++i) {
            XMLUtil.collectCDATASections(object.item(i), set);
        }
    }

    public static void validate(Element element, Schema schema) throws SAXException {
        SAXException[] sAXExceptionArray;
        block3: {
            Validator validator = schema.newValidator();
            sAXExceptionArray = new SAXException[]{null};
            validator.setErrorHandler(new ErrorHandler(){

                @Override
                public void warning(SAXParseException sAXParseException) throws SAXException {
                }

                @Override
                public void error(SAXParseException sAXParseException) throws SAXException {
                    sAXExceptionArray[0] = sAXParseException;
                }

                @Override
                public void fatalError(SAXParseException sAXParseException) throws SAXException {
                    sAXExceptionArray[0] = sAXParseException;
                }
            });
            try {
                validator.validate(new DOMSource(XMLUtil.fixupAttrs(element)));
            }
            catch (IOException iOException) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError((Object)iOException);
            }
        }
        if (sAXExceptionArray[0] != null) {
            throw sAXExceptionArray[0];
        }
    }

    private static Element fixupAttrs(Element element) {
        Element element2 = (Element)element.cloneNode(true);
        XMLUtil.fixupAttrsSingle(element2);
        NodeList nodeList = element2.getElementsByTagName("*");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            XMLUtil.fixupAttrsSingle((Element)nodeList.item(i));
        }
        return element2;
    }

    private static void fixupAttrsSingle(Element element) throws DOMException {
        XMLUtil.removeXmlBase(element);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Attr object = (Attr)namedNodeMap.item(i);
            if (object.getNamespaceURI() != null || object.getName().equals("xmlns")) continue;
            hashMap.put(object.getName(), object.getValue());
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            element.removeAttribute((String)entry.getKey());
            element.setAttributeNS(null, (String)entry.getKey(), (String)entry.getValue());
        }
    }

    private static void removeXmlBase(Element element) {
        element.removeAttributeNS("http://www.w3.org/XML/1998/namespace", "base");
        element.removeAttribute("xml:base");
    }

    public static String toAttributeValue(String string) throws CharConversionException {
        if (string == null) {
            throw new CharConversionException("null");
        }
        if (XMLUtil.checkAttributeCharacters(string)) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if ('<' == c) {
                stringBuilder.append("&lt;");
                continue;
            }
            if ('&' == c) {
                stringBuilder.append("&amp;");
                continue;
            }
            if ('\'' == c) {
                stringBuilder.append("&apos;");
                continue;
            }
            if ('\"' == c) {
                stringBuilder.append("&quot;");
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static String toElementContent(String string) throws CharConversionException {
        if (string == null) {
            throw new CharConversionException("null");
        }
        if (XMLUtil.checkContentCharacters(string)) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if ('<' == c) {
                stringBuilder.append("&lt;");
                continue;
            }
            if ('&' == c) {
                stringBuilder.append("&amp;");
                continue;
            }
            if ('>' == c && i > 1 && string.charAt(i - 2) == ']' && string.charAt(i - 1) == ']') {
                stringBuilder.append("&gt;");
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static String toHex(byte[] byArray, int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n2; ++i) {
            byte by = byArray[n + i];
            stringBuilder.append(DEC2HEX[(by & 0xF0) >> 4]);
            stringBuilder.append(DEC2HEX[by & 0xF]);
        }
        return stringBuilder.toString();
    }

    public static byte[] fromHex(char[] cArray, int n, int n2) throws IOException {
        if (cArray == null) {
            throw new IOException("null");
        }
        int n3 = cArray.length;
        if (n3 % 2 != 0) {
            throw new IOException("odd length");
        }
        byte[] byArray = new byte[n3 / 2];
        while (n3 > 0) {
            String string = new String(cArray, n3 - 2, 2);
            try {
                byArray[n3 / 2 - 1] = (byte)Integer.parseInt(string, 16);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException(numberFormatException.getLocalizedMessage());
            }
            n3 -= 2;
        }
        return byArray;
    }

    private static boolean checkAttributeCharacters(String string) throws CharConversionException {
        boolean bl = false;
        block4: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c > ']') continue;
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': {
                    continue block4;
                }
                case '\"': 
                case '&': 
                case '\'': 
                case '<': {
                    bl = true;
                    continue block4;
                }
                default: {
                    if (c >= ' ') continue block4;
                    throw new CharConversionException("Invalid XML character &#" + c + ";.");
                }
            }
        }
        return !bl;
    }

    private static boolean checkContentCharacters(String string) throws CharConversionException {
        boolean bl = false;
        block5: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c > ']') continue;
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': {
                    continue block5;
                }
                case '>': {
                    if (bl) continue block5;
                    bl = i > 0 && string.charAt(i - 1) == ']';
                    continue block5;
                }
                case '&': 
                case '<': {
                    bl = true;
                    continue block5;
                }
                default: {
                    if (c >= ' ') continue block5;
                    throw new CharConversionException("Invalid XML character &#" + c + ";.");
                }
            }
        }
        return !bl;
    }

    private static Document normalize(Document document) throws IOException {
        Node node;
        int n;
        Document document2;
        DocumentBuilder documentBuilder = null;
        DocumentBuilderFactory documentBuilderFactory = XMLUtil.getFactory(false, false);
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IOException("Cannot create parser satisfying configuration parameters: " + parserConfigurationException, parserConfigurationException);
        }
        DocumentType documentType = null;
        NodeList nodeList = document.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (!(nodeList.item(i) instanceof DocumentType)) continue;
            documentType = (DocumentType)nodeList.item(i);
        }
        if (documentType != null) {
            document2 = documentBuilder.getDOMImplementation().createDocument(document.getDocumentElement().getNamespaceURI(), document.getDocumentElement().getTagName(), documentBuilder.getDOMImplementation().createDocumentType(document.getDoctype().getName(), document.getDoctype().getPublicId(), document.getDoctype().getSystemId()));
            document2.removeChild(document2.getDocumentElement());
        } else {
            document2 = documentBuilder.newDocument();
        }
        for (n = 0; n < nodeList.getLength(); ++n) {
            node = nodeList.item(n);
            if (node instanceof DocumentType) continue;
            try {
                document2.appendChild(document2.importNode(node, true));
                continue;
            }
            catch (DOMException dOMException) {
                throw new IOException("Could not import or append " + node + " of " + node.getClass(), dOMException);
            }
        }
        document2.normalize();
        nodeList = document2.getElementsByTagName("*");
        for (n = 0; n < nodeList.getLength(); ++n) {
            node = (Element)nodeList.item(n);
            XMLUtil.removeXmlBase((Element)node);
            NodeList nodeList2 = node.getChildNodes();
            for (int i = 0; i < nodeList2.getLength(); ++i) {
                Node node2 = nodeList2.item(i);
                if (!(node2 instanceof Text) || ((Text)node2).getNodeValue().trim().length() != 0) continue;
                node.removeChild(node2);
                --i;
            }
        }
        return document2;
    }

    public static void appendChildElement(Element element, Element element2, String[] stringArray) throws IllegalArgumentException {
        List<String> list = Arrays.asList(stringArray);
        int n = list.indexOf(element2.getLocalName());
        if (n == -1) {
            throw new IllegalArgumentException("new child element '" + element2.getLocalName() + "' not specified in order " + list);
        }
        List<Element> list2 = XMLUtil.findSubElements(element);
        Element element3 = null;
        for (Element element4 : list2) {
            int n2 = list.indexOf(element4.getLocalName());
            if (n2 == -1) {
                throw new IllegalArgumentException("Existing child element '" + element4.getLocalName() + "' not specified in order " + list);
            }
            if (n2 <= n) continue;
            element3 = element4;
            break;
        }
        element.insertBefore(element2, element3);
    }

    public static List<Element> findSubElements(Element element) throws IllegalArgumentException {
        NodeList nodeList = element.getChildNodes();
        ArrayList<Element> arrayList = new ArrayList<Element>(nodeList.getLength());
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() == 1) {
                arrayList.add((Element)node);
                continue;
            }
            if (node.getNodeType() == 3) {
                String string = ((Text)node).getNodeValue();
                if (string.trim().length() <= 0) continue;
                throw new IllegalArgumentException("non-ws text encountered in " + element + ": " + string);
            }
            if (node.getNodeType() == 8) continue;
            throw new IllegalArgumentException("unexpected non-element child of " + element + ": " + node);
        }
        return arrayList;
    }

    public static Element findElement(Element element, String string, String string2) throws IllegalArgumentException {
        Element element2 = null;
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            if (nodeList.item(i).getNodeType() != 1) continue;
            Node node = nodeList.item(i);
            String string3 = node.getLocalName();
            String string4 = string3 = string3 == null ? node.getNodeName() : string3;
            if (!string.equals(string3) || string2 != null && !string2.equals(node.getNamespaceURI())) continue;
            if (element2 == null) {
                element2 = (Element)node;
                continue;
            }
            throw new IllegalArgumentException("more than one element with same name found");
        }
        return element2;
    }

    public static String findText(Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeType() != 3) continue;
            Text text = (Text)nodeList.item(i);
            return text.getNodeValue();
        }
        return null;
    }

    public static Element translateXML(Element element, String string) {
        Node node;
        Element element2 = element.getOwnerDocument().createElementNS(string, element.getLocalName());
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node2 = nodeList.item(i);
            node = node2.getNodeType() == 1 ? XMLUtil.translateXML((Element)node2, string) : node2.cloneNode(true);
            element2.appendChild(node);
        }
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            node = namedNodeMap.item(i);
            element2.setAttribute(node.getNodeName(), node.getNodeValue());
        }
        return element2;
    }

    public static void copyDocument(Element element, Element element2, String string) {
        Document document = element2.getOwnerDocument();
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            Node node2 = null;
            if (1 == node.getNodeType()) {
                Element element3 = (Element)node;
                node2 = document.createElementNS(string, element3.getTagName());
                NamedNodeMap namedNodeMap = element3.getAttributes();
                Element element4 = (Element)node2;
                for (int j = 0; j < namedNodeMap.getLength(); ++j) {
                    Node node3 = namedNodeMap.item(j);
                    element4.setAttribute(node3.getNodeName(), node3.getNodeValue());
                }
                XMLUtil.copyDocument(element3, element4, string);
            } else {
                node2 = node.cloneNode(true);
                node2 = element2.getOwnerDocument().importNode(node2, true);
            }
            if (node2 == null) continue;
            element2.appendChild(node2);
        }
    }

    public static ErrorHandler defaultErrorHandler() {
        return new ErrHandler();
    }

    private static final class ErrHandler
    implements ErrorHandler {
        ErrHandler() {
        }

        private void annotate(SAXParseException sAXParseException) throws SAXException {
            Exceptions.attachMessage(sAXParseException, "Occurred at: " + sAXParseException.getSystemId() + ":" + sAXParseException.getLineNumber());
        }

        @Override
        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            this.annotate(sAXParseException);
            throw sAXParseException;
        }

        @Override
        public void error(SAXParseException sAXParseException) throws SAXException {
            this.annotate(sAXParseException);
            throw sAXParseException;
        }

        @Override
        public void warning(SAXParseException sAXParseException) throws SAXException {
            this.annotate(sAXParseException);
            Logger.getLogger(XMLUtil.class.getName()).log(Level.INFO, null, sAXParseException);
        }
    }
}

