/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.gpx;

import java.util.ArrayList;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.Geometry;

public final class GpxDistance {
    private GpxDistance() {
    }

    public static double getLowestDistance(OsmPrimitive p, GpxData gpxData) {
        return gpxData.getTrackPoints().mapToDouble(tp -> Geometry.getDistance(p, new Node(tp.getCoor()))).filter(x -> x >= 0.0).min().orElse(Double.MAX_VALUE);
    }

    @Deprecated
    public static double getDistance(OsmPrimitive p, WayPoint waypoint) {
        return Geometry.getDistance(p, new Node(waypoint.getCoor()));
    }

    @Deprecated
    public static double getDistanceRelation(Relation relation, WayPoint waypoint) {
        double distance;
        double shortestDistance = Double.MAX_VALUE;
        ArrayList<Node> nodes = new ArrayList<Node>(relation.getMemberPrimitives(Node.class));
        ArrayList<Way> ways = new ArrayList<Way>(relation.getMemberPrimitives(Way.class));
        ArrayList<Relation> relations = new ArrayList<Relation>(relation.getMemberPrimitives(Relation.class));
        if (nodes.isEmpty() && ways.isEmpty() && relations.isEmpty()) {
            return Double.MAX_VALUE;
        }
        for (Relation nrelation : relations) {
            distance = GpxDistance.getDistanceRelation(nrelation, waypoint);
            if (!(distance < shortestDistance)) continue;
            shortestDistance = distance;
        }
        for (Way way : ways) {
            distance = GpxDistance.getDistanceWay(way, waypoint);
            if (!(distance < shortestDistance)) continue;
            shortestDistance = distance;
        }
        for (Node node : nodes) {
            distance = GpxDistance.getDistanceNode(node, waypoint);
            if (!(distance < shortestDistance)) continue;
            shortestDistance = distance;
        }
        return shortestDistance;
    }

    @Deprecated
    public static double getDistanceWay(Way way, WayPoint waypoint) {
        if (way == null || waypoint == null) {
            return Double.MAX_VALUE;
        }
        return Geometry.getDistanceWayNode(way, new Node(waypoint.getCoor()));
    }

    @Deprecated
    public static double getDistanceNode(Node node, WayPoint waypoint) {
        if (node == null || waypoint == null) {
            return Double.MAX_VALUE;
        }
        return Geometry.getDistance(node, new Node(waypoint.getCoor()));
    }

    @Deprecated
    public static double getDistanceEastNorth(EastNorth en, WayPoint waypoint) {
        if (en == null || waypoint == null) {
            return Double.MAX_VALUE;
        }
        return Geometry.getDistance(new Node(en), new Node(waypoint.getCoor()));
    }

    @Deprecated
    public static double getDistanceLatLon(LatLon latlon, WayPoint waypoint) {
        if (latlon == null || waypoint == null || waypoint.getCoor() == null) {
            return Double.MAX_VALUE;
        }
        return Geometry.getDistance(new Node(latlon), new Node(waypoint.getCoor()));
    }
}

