/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io.importexport;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.time.Year;
import java.util.Optional;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openstreetmap.josm.data.gpx.GpxConstants;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.io.importexport.FileExporter;
import org.openstreetmap.josm.gui.io.importexport.GpxImporter;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.widgets.JosmTextArea;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.io.Compression;
import org.openstreetmap.josm.io.GpxWriter;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class GpxExporter
extends FileExporter
implements GpxConstants {
    private static final String GPL_WARNING = "<html><font color='red' size='-2'>" + I18n.tr("Note: GPL is not compatible with the OSM license. Do not upload GPL licensed tracks.", new Object[0]) + "</html>";
    private static final String[] LICENSES = new String[]{"Creative Commons By-SA", "Open Database License (ODbL)", "public domain", "GNU Lesser Public License (LGPL)", "BSD License (MIT/X11)"};
    private static final String[] URLS = new String[]{"https://creativecommons.org/licenses/by-sa/3.0", "http://opendatacommons.org/licenses/odbl/1.0", "public domain", "https://www.gnu.org/copyleft/lesser.html", "http://www.opensource.org/licenses/bsd-license.php"};

    public GpxExporter() {
        super(GpxImporter.getFileFilter());
    }

    @Override
    public boolean acceptFile(File pathname, Layer layer) {
        if (!(layer instanceof OsmDataLayer) && !(layer instanceof GpxLayer)) {
            return false;
        }
        return super.acceptFile(pathname, layer);
    }

    @Override
    public void exportData(File file, Layer layer) throws IOException {
        CheckParameterUtil.ensureParameterNotNull(layer, "layer");
        if (!(layer instanceof OsmDataLayer) && !(layer instanceof GpxLayer)) {
            throw new IllegalArgumentException(MessageFormat.format("Expected instance of OsmDataLayer or GpxLayer. Got ''{0}''.", layer.getClass().getName()));
        }
        CheckParameterUtil.ensureParameterNotNull(file, "file");
        String fn = file.getPath();
        if (fn.indexOf(46) == -1) {
            fn = fn + ".gpx";
            file = new File(fn);
        }
        JPanel p = new JPanel(new GridBagLayout());
        GpxData gpxData = layer instanceof GpxLayer ? ((GpxLayer)layer).data : new GpxData();
        p.add((Component)new JLabel(I18n.tr("GPS track description", new Object[0])), GBC.eol());
        JosmTextArea desc = new JosmTextArea(3, 40);
        desc.setWrapStyleWord(true);
        desc.setLineWrap(true);
        desc.setText(gpxData.getString("meta.desc"));
        p.add((Component)new JScrollPane(desc), GBC.eop().fill(1));
        JCheckBox author = new JCheckBox(I18n.tr("Add author information", new Object[0]), Config.getPref().getBoolean("lastAddAuthor", true));
        p.add((Component)author, GBC.eol());
        JLabel nameLabel = new JLabel(I18n.tr("Real name", new Object[0]));
        p.add((Component)nameLabel, GBC.std().insets(10, 0, 5, 0));
        JosmTextField authorName = new JosmTextField();
        p.add((Component)authorName, GBC.eol().fill(2));
        nameLabel.setLabelFor(authorName);
        JLabel emailLabel = new JLabel(I18n.tr("E-Mail", new Object[0]));
        p.add((Component)emailLabel, GBC.std().insets(10, 0, 5, 0));
        JosmTextField email = new JosmTextField();
        p.add((Component)email, GBC.eol().fill(2));
        emailLabel.setLabelFor(email);
        JLabel copyrightLabel = new JLabel(I18n.tr("Copyright (URL)", new Object[0]));
        p.add((Component)copyrightLabel, GBC.std().insets(10, 0, 5, 0));
        JosmTextField copyright = new JosmTextField();
        p.add((Component)copyright, GBC.std().fill(2));
        copyrightLabel.setLabelFor(copyright);
        JButton predefined = new JButton(I18n.tr("Predefined", new Object[0]));
        p.add((Component)predefined, GBC.eol().insets(5, 0, 0, 0));
        JLabel copyrightYearLabel = new JLabel(I18n.tr("Copyright year", new Object[0]));
        p.add((Component)copyrightYearLabel, GBC.std().insets(10, 0, 5, 5));
        JosmTextField copyrightYear = new JosmTextField("");
        p.add((Component)copyrightYear, GBC.eol().fill(2));
        copyrightYearLabel.setLabelFor(copyrightYear);
        JLabel warning = new JLabel("<html><font size='-2'>&nbsp;</html");
        p.add((Component)warning, GBC.eol().fill(2).insets(15, 0, 0, 0));
        GpxExporter.addDependencies(gpxData, author, authorName, email, copyright, predefined, copyrightYear, nameLabel, emailLabel, copyrightLabel, copyrightYearLabel, warning);
        p.add((Component)new JLabel(I18n.tr("Keywords", new Object[0])), GBC.eol());
        JosmTextField keywords = new JosmTextField();
        keywords.setText(gpxData.getString("meta.keywords"));
        p.add((Component)keywords, GBC.eop().fill(2));
        ExtendedDialog ed = new ExtendedDialog((Component)MainApplication.getMainFrame(), I18n.tr("Export options", new Object[0]), I18n.tr("Export and Save", new Object[0]), I18n.tr("Cancel", new Object[0])).setButtonIcons("exportgpx", "cancel").setContent(p);
        if (ed.showDialog().getValue() != 1) {
            this.setCanceled(true);
            return;
        }
        this.setCanceled(false);
        Config.getPref().putBoolean("lastAddAuthor", author.isSelected());
        if (!authorName.getText().isEmpty()) {
            Config.getPref().put("lastAuthorName", authorName.getText());
        }
        if (!copyright.getText().isEmpty()) {
            Config.getPref().put("lastCopyright", copyright.getText());
        }
        gpxData = layer instanceof OsmDataLayer ? ((OsmDataLayer)layer).toGpxData() : (layer instanceof GpxLayer ? ((GpxLayer)layer).data : OsmDataLayer.toGpxData(MainApplication.getLayerManager().getEditDataSet(), file));
        if (author.isSelected()) {
            if (!authorName.getText().isEmpty()) {
                gpxData.put("meta.author.name", authorName.getText());
                gpxData.put("meta.copyright.author", authorName.getText());
            }
            if (!email.getText().isEmpty()) {
                gpxData.put("meta.author.email", email.getText());
            }
            if (!copyright.getText().isEmpty()) {
                gpxData.put("meta.copyright.license", copyright.getText());
            }
            if (!copyrightYear.getText().isEmpty()) {
                gpxData.put("meta.copyright.year", copyrightYear.getText());
            }
        }
        if (!desc.getText().isEmpty()) {
            gpxData.put("meta.desc", desc.getText());
        }
        if (!keywords.getText().isEmpty()) {
            gpxData.put("meta.keywords", keywords.getText());
        }
        try (OutputStream fo = Compression.getCompressedFileOutputStream(file);
             GpxWriter writer = new GpxWriter(fo);){
            writer.write(gpxData);
        }
    }

    private static void enableCopyright(GpxData data, JosmTextField copyright, JButton predefined, JosmTextField copyrightYear, JLabel copyrightLabel, JLabel copyrightYearLabel, JLabel warning, boolean enable) {
        copyright.setEnabled(enable);
        predefined.setEnabled(enable);
        copyrightYear.setEnabled(enable);
        copyrightLabel.setEnabled(enable);
        copyrightYearLabel.setEnabled(enable);
        warning.setText(enable ? GPL_WARNING : "<html><font size='-2'>&nbsp;</html");
        if (enable) {
            if (copyrightYear.getText().isEmpty()) {
                copyrightYear.setText(Optional.ofNullable(data.getString("meta.copyright.year")).orElseGet(() -> Year.now().toString()));
            }
            if (copyright.getText().isEmpty()) {
                copyright.setText(Optional.ofNullable(data.getString("meta.copyright.license")).orElseGet(() -> Config.getPref().get("lastCopyright", "https://creativecommons.org/licenses/by-sa/2.5")));
                copyright.setCaretPosition(0);
            }
        } else {
            copyrightYear.setText("");
            copyright.setText("");
        }
    }

    private static void addDependencies(final GpxData data, final JCheckBox author, final JosmTextField authorName, JosmTextField email, final JosmTextField copyright, final JButton predefined, final JosmTextField copyrightYear, JLabel nameLabel, JLabel emailLabel, final JLabel copyrightLabel, final JLabel copyrightYearLabel, final JLabel warning) {
        ActionListener authorActionListener = e -> {
            boolean b = author.isSelected();
            authorName.setEnabled(b);
            email.setEnabled(b);
            nameLabel.setEnabled(b);
            emailLabel.setEnabled(b);
            if (b) {
                authorName.setText(Optional.ofNullable(data.getString("meta.author.name")).orElseGet(() -> Config.getPref().get("lastAuthorName")));
                email.setText(Optional.ofNullable(data.getString("meta.author.email")).orElseGet(() -> Config.getPref().get("lastAuthorEmail")));
            } else {
                authorName.setText("");
                email.setText("");
            }
            boolean isAuthorSet = !authorName.getText().isEmpty();
            GpxExporter.enableCopyright(data, copyright, predefined, copyrightYear, copyrightLabel, copyrightYearLabel, warning, b && isAuthorSet);
        };
        author.addActionListener(authorActionListener);
        KeyAdapter authorNameListener = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                boolean b = !authorName.getText().isEmpty() && author.isSelected();
                GpxExporter.enableCopyright(data, copyright, predefined, copyrightYear, copyrightLabel, copyrightYearLabel, warning, b);
            }
        };
        authorName.addKeyListener(authorNameListener);
        predefined.addActionListener(e -> {
            JList<String> l = new JList<String>(LICENSES);
            l.setVisibleRowCount(LICENSES.length);
            l.setSelectionMode(2);
            int answer = JOptionPane.showConfirmDialog(MainApplication.getMainFrame(), new JScrollPane(l), I18n.tr("Choose a predefined license", new Object[0]), 2, 3);
            if (answer != 0 || l.getSelectedIndex() == -1) {
                return;
            }
            StringBuilder license = new StringBuilder();
            for (int i : l.getSelectedIndices()) {
                if (i == 2) {
                    license = new StringBuilder("public domain");
                    break;
                }
                if (license.length() > 0) {
                    license.append(", ");
                }
                license.append(URLS[i]);
            }
            copyright.setText(license.toString());
            copyright.setCaretPosition(0);
        });
        authorActionListener.actionPerformed(null);
        authorNameListener.keyReleased(null);
    }
}

