//
// Copyright (c) ZeroC, Inc. All rights reserved.
//
//
// Ice version 3.7.2
//
// <auto-generated>
//
// Generated from file `UserAccountMapper.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

#ifndef __IceGrid_UserAccountMapper_h__
#define __IceGrid_UserAccountMapper_h__

#include <IceUtil/PushDisableWarnings.h>
#include <Ice/ProxyF.h>
#include <Ice/ObjectF.h>
#include <Ice/ValueF.h>
#include <Ice/Exception.h>
#include <Ice/LocalObject.h>
#include <Ice/StreamHelpers.h>
#include <Ice/Comparable.h>
#include <Ice/Proxy.h>
#include <Ice/Object.h>
#include <Ice/GCObject.h>
#include <Ice/Value.h>
#include <Ice/Incoming.h>
#include <Ice/FactoryTableInit.h>
#include <IceUtil/ScopedArray.h>
#include <Ice/Optional.h>
#include <Ice/ExceptionHelpers.h>
#include <IceUtil/UndefSysMacros.h>
#include <IceGrid/Config.h>

#ifndef ICE_IGNORE_VERSION
#   if ICE_INT_VERSION / 100 != 307
#       error Ice version mismatch!
#   endif
#   if ICE_INT_VERSION % 100 > 50
#       error Beta header file detected
#   endif
#   if ICE_INT_VERSION % 100 < 2
#       error Ice patch level mismatch!
#   endif
#endif

#ifndef ICEGRID_API
#   if defined(ICE_STATIC_LIBS)
#       define ICEGRID_API /**/
#   elif defined(ICEGRID_API_EXPORTS)
#       define ICEGRID_API ICE_DECLSPEC_EXPORT
#   else
#       define ICEGRID_API ICE_DECLSPEC_IMPORT
#   endif
#endif

#ifdef ICE_CPP11_MAPPING // C++11 mapping

namespace IceGrid
{

class UserAccountMapper;
class UserAccountMapperPrx;

}

namespace IceGrid
{

/**
 * This exception is raised if a user account for a given session
 * identifier can't be found.
 * \headerfile IceGrid/IceGrid.h
 */
class ICE_CLASS(ICEGRID_API) UserAccountNotFoundException : public ::Ice::UserExceptionHelper<UserAccountNotFoundException, ::Ice::UserException>
{
public:

    ICE_MEMBER(ICEGRID_API) virtual ~UserAccountNotFoundException();

    UserAccountNotFoundException(const UserAccountNotFoundException&) = default;

    UserAccountNotFoundException() = default;

    /**
     * Obtains a tuple containing all of the exception's data members.
     * @return The data members in a tuple.
     */

    std::tuple<> ice_tuple() const
    {
        return std::tie();
    }

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();
};

/// \cond INTERNAL
static UserAccountNotFoundException _iceS_UserAccountNotFoundException_init;
/// \endcond

}

namespace IceGrid
{

/**
 * A user account mapper object is used by IceGrid nodes to map
 * session identifiers to user accounts.
 * \headerfile IceGrid/IceGrid.h
 */
class ICEGRID_API UserAccountMapper : public virtual ::Ice::Object
{
public:

    using ProxyType = UserAccountMapperPrx;

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(::std::string id, const ::Ice::Current& current) const override;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector<::std::string> ice_ids(const ::Ice::Current& current) const override;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual ::std::string ice_id(const ::Ice::Current& current) const override;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Get the name of the user account for the given user. This is
     * used by IceGrid nodes to figure out the user account to use
     * to run servers.
     * @param user The value of the server descriptor's <code>user</code>
     * attribute. If this attribute is not defined, and the server's
     * activation mode is <code>session</code>, the default value of
     * <code>user</code> is the session identifier.
     * @param current The Current object for the invocation.
     * @return The user account name.
     * @throws IceGrid::UserAccountNotFoundException Raised if no user account
     * is found for the given user.
     */
    virtual ::std::string getUserAccount(::std::string user, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_getUserAccount(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&) override;
    /// \endcond
};

}

namespace IceGrid
{

/**
 * A user account mapper object is used by IceGrid nodes to map
 * session identifiers to user accounts.
 * \headerfile IceGrid/IceGrid.h
 */
class ICE_CLASS(ICEGRID_API) UserAccountMapperPrx : public virtual ::Ice::Proxy<UserAccountMapperPrx, ::Ice::ObjectPrx>
{
public:

    /**
     * Get the name of the user account for the given user. This is
     * used by IceGrid nodes to figure out the user account to use
     * to run servers.
     * @param user The value of the server descriptor's <code>user</code>
     * attribute. If this attribute is not defined, and the server's
     * activation mode is <code>session</code>, the default value of
     * <code>user</code> is the session identifier.
     * @param context The Context map to send with the invocation.
     * @return The user account name.
     * @throws IceGrid::UserAccountNotFoundException Raised if no user account
     * is found for the given user.
     */
    ::std::string getUserAccount(const ::std::string& user, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::string>(true, this, &UserAccountMapperPrx::_iceI_getUserAccount, user, context).get();
    }

    /**
     * Get the name of the user account for the given user. This is
     * used by IceGrid nodes to figure out the user account to use
     * to run servers.
     * @param user The value of the server descriptor's <code>user</code>
     * attribute. If this attribute is not defined, and the server's
     * activation mode is <code>session</code>, the default value of
     * <code>user</code> is the session identifier.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getUserAccountAsync(const ::std::string& user, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::string>>().get_future())
    {
        return _makePromiseOutgoing<::std::string, P>(false, this, &UserAccountMapperPrx::_iceI_getUserAccount, user, context);
    }

    /**
     * Get the name of the user account for the given user. This is
     * used by IceGrid nodes to figure out the user account to use
     * to run servers.
     * @param user The value of the server descriptor's <code>user</code>
     * attribute. If this attribute is not defined, and the server's
     * activation mode is <code>session</code>, the default value of
     * <code>user</code> is the session identifier.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getUserAccountAsync(const ::std::string& user,
                        ::std::function<void(::std::string)> response,
                        ::std::function<void(::std::exception_ptr)> ex = nullptr,
                        ::std::function<void(bool)> sent = nullptr,
                        const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::string>(response, ex, sent, this, &IceGrid::UserAccountMapperPrx::_iceI_getUserAccount, user, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_getUserAccount(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::string>>&, const ::std::string&, const ::Ice::Context&);
    /// \endcond

    /**
     * Obtains the Slice type ID of this interface.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

protected:

    /// \cond INTERNAL
    UserAccountMapperPrx() = default;
    friend ::std::shared_ptr<UserAccountMapperPrx> IceInternal::createProxy<UserAccountMapperPrx>();

    ICE_MEMBER(ICEGRID_API) virtual ::std::shared_ptr<::Ice::ObjectPrx> _newInstance() const override;
    /// \endcond
};

}

/// \cond STREAM
namespace Ice
{

}
/// \endcond

/// \cond INTERNAL
namespace IceGrid
{

using UserAccountMapperPtr = ::std::shared_ptr<UserAccountMapper>;
using UserAccountMapperPrxPtr = ::std::shared_ptr<UserAccountMapperPrx>;

}
/// \endcond

#else // C++98 mapping

namespace IceProxy
{

namespace IceGrid
{

class UserAccountMapper;
/// \cond INTERNAL
ICEGRID_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< UserAccountMapper>&);
ICEGRID_API ::IceProxy::Ice::Object* upCast(UserAccountMapper*);
/// \endcond

}

}

namespace IceGrid
{

class UserAccountMapper;
/// \cond INTERNAL
ICEGRID_API ::Ice::Object* upCast(UserAccountMapper*);
/// \endcond
typedef ::IceInternal::Handle< UserAccountMapper> UserAccountMapperPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::UserAccountMapper> UserAccountMapperPrx;
typedef UserAccountMapperPrx UserAccountMapperPrxPtr;
/// \cond INTERNAL
ICEGRID_API void _icePatchObjectPtr(UserAccountMapperPtr&, const ::Ice::ObjectPtr&);
/// \endcond

}

namespace IceGrid
{

/**
 * This exception is raised if a user account for a given session
 * identifier can't be found.
 * \headerfile IceGrid/IceGrid.h
 */
class ICEGRID_API UserAccountNotFoundException : public ::Ice::UserException
{
public:

    UserAccountNotFoundException() {}
    virtual ~UserAccountNotFoundException() throw();

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    virtual ::std::string ice_id() const;
    /**
     * Polymporphically clones this exception.
     * @return A shallow copy of this exception.
     */
    virtual UserAccountNotFoundException* ice_clone() const;
    /**
     * Throws this exception.
     */
    virtual void ice_throw() const;

protected:

    /// \cond STREAM
    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
    /// \endcond
};

/// \cond INTERNAL
static UserAccountNotFoundException _iceS_UserAccountNotFoundException_init;
/// \endcond

}

namespace IceGrid
{

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::UserAccountMapper::begin_getUserAccount.
 * Create a wrapper instance by calling ::IceGrid::newCallback_UserAccountMapper_getUserAccount.
 */
class Callback_UserAccountMapper_getUserAccount_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_UserAccountMapper_getUserAccount_Base> Callback_UserAccountMapper_getUserAccountPtr;

}

namespace IceProxy
{

namespace IceGrid
{

class ICE_CLASS(ICEGRID_API) UserAccountMapper : public virtual ::Ice::Proxy<UserAccountMapper, ::IceProxy::Ice::Object>
{
public:

    /**
     * Get the name of the user account for the given user. This is
     * used by IceGrid nodes to figure out the user account to use
     * to run servers.
     * @param user The value of the server descriptor's <code>user</code>
     * attribute. If this attribute is not defined, and the server's
     * activation mode is <code>session</code>, the default value of
     * <code>user</code> is the session identifier.
     * @param context The Context map to send with the invocation.
     * @return The user account name.
     * @throws IceGrid::UserAccountNotFoundException Raised if no user account
     * is found for the given user.
     */
    ICE_MEMBER(ICEGRID_API) ::std::string getUserAccount(const ::std::string& user, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getUserAccount(_iceI_begin_getUserAccount(user, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Get the name of the user account for the given user. This is
     * used by IceGrid nodes to figure out the user account to use
     * to run servers.
     * @param user The value of the server descriptor's <code>user</code>
     * attribute. If this attribute is not defined, and the server's
     * activation mode is <code>session</code>, the default value of
     * <code>user</code> is the session identifier.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getUserAccount(const ::std::string& user, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getUserAccount(user, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Get the name of the user account for the given user. This is
     * used by IceGrid nodes to figure out the user account to use
     * to run servers.
     * @param user The value of the server descriptor's <code>user</code>
     * attribute. If this attribute is not defined, and the server's
     * activation mode is <code>session</code>, the default value of
     * <code>user</code> is the session identifier.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getUserAccount(const ::std::string& user, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getUserAccount(user, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get the name of the user account for the given user. This is
     * used by IceGrid nodes to figure out the user account to use
     * to run servers.
     * @param user The value of the server descriptor's <code>user</code>
     * attribute. If this attribute is not defined, and the server's
     * activation mode is <code>session</code>, the default value of
     * <code>user</code> is the session identifier.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getUserAccount(const ::std::string& user, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getUserAccount(user, context, cb, cookie);
    }

    /**
     * Get the name of the user account for the given user. This is
     * used by IceGrid nodes to figure out the user account to use
     * to run servers.
     * @param user The value of the server descriptor's <code>user</code>
     * attribute. If this attribute is not defined, and the server's
     * activation mode is <code>session</code>, the default value of
     * <code>user</code> is the session identifier.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getUserAccount(const ::std::string& user, const ::IceGrid::Callback_UserAccountMapper_getUserAccountPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getUserAccount(user, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get the name of the user account for the given user. This is
     * used by IceGrid nodes to figure out the user account to use
     * to run servers.
     * @param user The value of the server descriptor's <code>user</code>
     * attribute. If this attribute is not defined, and the server's
     * activation mode is <code>session</code>, the default value of
     * <code>user</code> is the session identifier.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getUserAccount(const ::std::string& user, const ::Ice::Context& context, const ::IceGrid::Callback_UserAccountMapper_getUserAccountPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getUserAccount(user, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getUserAccount.
     * @param result The asynchronous result object for the invocation.
     * @return The user account name.
     * @throws IceGrid::UserAccountNotFoundException Raised if no user account
     * is found for the given user.
     */
    ICE_MEMBER(ICEGRID_API) ::std::string end_getUserAccount(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_getUserAccount(const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Obtains the Slice type ID corresponding to this interface.
     * @return A fully-scoped type ID.
     */
    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

protected:
    /// \cond INTERNAL

    ICE_MEMBER(ICEGRID_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
    /// \endcond
};

}

}

namespace IceGrid
{

/**
 * A user account mapper object is used by IceGrid nodes to map
 * session identifiers to user accounts.
 * \headerfile IceGrid/IceGrid.h
 */
class ICEGRID_API UserAccountMapper : public virtual ::Ice::Object
{
public:

    typedef UserAccountMapperPrx ProxyType;
    typedef UserAccountMapperPtr PointerType;

    virtual ~UserAccountMapper();

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(const ::std::string& id, const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual const ::std::string& ice_id(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Get the name of the user account for the given user. This is
     * used by IceGrid nodes to figure out the user account to use
     * to run servers.
     * @param user The value of the server descriptor's <code>user</code>
     * attribute. If this attribute is not defined, and the server's
     * activation mode is <code>session</code>, the default value of
     * <code>user</code> is the session identifier.
     * @param current The Current object for the invocation.
     * @return The user account name.
     * @throws IceGrid::UserAccountNotFoundException Raised if no user account
     * is found for the given user.
     */
    virtual ::std::string getUserAccount(const ::std::string& user, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_getUserAccount(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

protected:

    /// \cond STREAM
    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
    /// \endcond
};

/// \cond INTERNAL
inline bool operator==(const UserAccountMapper& lhs, const UserAccountMapper& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const UserAccountMapper& lhs, const UserAccountMapper& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}
/// \endcond

}

/// \cond STREAM
namespace Ice
{

template<>
struct StreamableTraits< ::IceGrid::UserAccountNotFoundException>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

}
/// \endcond

namespace IceGrid
{

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceGrid::UserAccountMapper::begin_getUserAccount.
 * Create a wrapper instance by calling ::IceGrid::newCallback_UserAccountMapper_getUserAccount.
 */
template<class T>
class CallbackNC_UserAccountMapper_getUserAccount : public Callback_UserAccountMapper_getUserAccount_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::std::string&);

    CallbackNC_UserAccountMapper_getUserAccount(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        UserAccountMapperPrx proxy = UserAccountMapperPrx::uncheckedCast(result->getProxy());
        ::std::string ret;
        try
        {
            ret = proxy->end_getUserAccount(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::UserAccountMapper::begin_getUserAccount.
 */
template<class T> Callback_UserAccountMapper_getUserAccountPtr
newCallback_UserAccountMapper_getUserAccount(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::std::string&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_UserAccountMapper_getUserAccount<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::UserAccountMapper::begin_getUserAccount.
 */
template<class T> Callback_UserAccountMapper_getUserAccountPtr
newCallback_UserAccountMapper_getUserAccount(T* instance, void (T::*cb)(const ::std::string&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_UserAccountMapper_getUserAccount<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceGrid::UserAccountMapper::begin_getUserAccount.
 * Create a wrapper instance by calling ::IceGrid::newCallback_UserAccountMapper_getUserAccount.
 */
template<class T, typename CT>
class Callback_UserAccountMapper_getUserAccount : public Callback_UserAccountMapper_getUserAccount_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::std::string&, const CT&);

    Callback_UserAccountMapper_getUserAccount(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        UserAccountMapperPrx proxy = UserAccountMapperPrx::uncheckedCast(result->getProxy());
        ::std::string ret;
        try
        {
            ret = proxy->end_getUserAccount(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::UserAccountMapper::begin_getUserAccount.
 */
template<class T, typename CT> Callback_UserAccountMapper_getUserAccountPtr
newCallback_UserAccountMapper_getUserAccount(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::std::string&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_UserAccountMapper_getUserAccount<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::UserAccountMapper::begin_getUserAccount.
 */
template<class T, typename CT> Callback_UserAccountMapper_getUserAccountPtr
newCallback_UserAccountMapper_getUserAccount(T* instance, void (T::*cb)(const ::std::string&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_UserAccountMapper_getUserAccount<T, CT>(instance, cb, excb, sentcb);
}

}

#endif

#include <IceUtil/PopDisableWarnings.h>
#endif
