/***********************************************************************
*                                                                      *
* This file is part of CARAT.                                          *
* Copyright (C) 2015  Tilman Schulz                                    *
*                                                                      *
* CARAT is free software: you can redistribute it and/or modify        *
* it under the terms of the GNU General Public License as published by *
* the Free Software Foundation, either version 3 of the License, or    *
* (at your option) any later version.                                  *
*                                                                      *
* This program is distributed in the hope that it will be useful,      *
* but WITHOUT ANY WARRANTY; without even the implied warranty of       *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
* GNU General Public License for more details.                         *
*                                                                      *
* You should have received a copy of the GNU General Public License    *
* along with this program.  If not, see <http://www.gnu.org/licenses/> *
*                                                                      *
***********************************************************************/
#include "typedef.h"
#include "gmp.h"
/* #include "gmp-impl.h" */

/**************************************************************************\
@---------------------------------------------------------------------------
@---------------------------------------------------------------------------
@ FILE: dump_MP_mat.c
@---------------------------------------------------------------------------
@---------------------------------------------------------------------------
@
\**************************************************************************/


/**************************************************************************\
@---------------------------------------------------------------------------
@ void *dump_MP_mat(Mat,rows,cols,comment)
@ MP_int **Mat;
@ int rows,
@     cols;
@ char *comment;
@
@ dumps an array of MP_int to stdout
@ 
@---------------------------------------------------------------------------
@
\**************************************************************************/
void dump_MP_mat(Mat,rows,cols,comment)
MP_INT **Mat;

int rows,
    cols;

char *comment;

{

   int i,j;

   printf("%dx%d %% %s\n",rows,cols,comment);
   for (i=0;i<rows;i++){
      for (j=0;j<cols;j++){
         mpz_out_str(stdout,10,&Mat[i][j]);
         printf(" ");
      }
      printf("\n");
   }
}
