#ifndef _EFL_UI_LAYOUT_BASE_EO_H_
#define _EFL_UI_LAYOUT_BASE_EO_H_

#ifndef _EFL_UI_LAYOUT_BASE_EO_CLASS_TYPE
#define _EFL_UI_LAYOUT_BASE_EO_CLASS_TYPE

typedef Eo Efl_Ui_Layout_Base;

#endif

#ifndef _EFL_UI_LAYOUT_BASE_EO_TYPES
#define _EFL_UI_LAYOUT_BASE_EO_TYPES


#endif
/** Elementary layout abstract
 *
 * @since 1.22
 *
 * @ingroup Efl_Ui_Layout_Base
 */
#define EFL_UI_LAYOUT_BASE_CLASS efl_ui_layout_base_class_get()

EWAPI const Efl_Class *efl_ui_layout_base_class_get(void);

/**
 * @brief The theme of this widget, defines which edje group will be used.
 *
 * Based on the type of widget ($klass), a given @c group and a @c style
 * (usually "default"), the edje group name will be formed for this object.
 *
 * Widgets that inherit from this class will call this function automatically
 * so it should not be called by applications, unless you are dealing directly
 * with a @ref Efl_Ui_Layout object.
 *
 * Note that @c style will be the new style of this object, as retrieved by
 * @ref efl_ui_widget_style_get. As a consequence this function can only be
 * called during construction of the object, before finalize.
 *
 * If this returns @c false the widget is very likely to become
 * non-functioning.
 *
 * @param[in] obj The object.
 * @param[in] klass The class of the group, eg. "button".
 * @param[in] group The group, eg. "base".
 * @param[in] style The style to use, eg "default".
 *
 * @return Whether the theme was successfully applied or not, see the
 * Efl.Ui.Theme.Apply_Error subset of @ref Eina_Error for more information.
 *
 * @since 1.22
 *
 * @ingroup Efl_Ui_Layout_Base
 */
EOAPI Eina_Error efl_ui_layout_theme_set(Eo *obj, const char *klass, const char *group, const char *style);

/**
 * @brief The theme of this widget, defines which edje group will be used.
 *
 * Based on the type of widget ($klass), a given @c group and a @c style
 * (usually "default"), the edje group name will be formed for this object.
 *
 * Widgets that inherit from this class will call this function automatically
 * so it should not be called by applications, unless you are dealing directly
 * with a @ref Efl_Ui_Layout object.
 *
 * Note that @c style will be the new style of this object, as retrieved by
 * @ref efl_ui_widget_style_get. As a consequence this function can only be
 * called during construction of the object, before finalize.
 *
 * If this returns @c false the widget is very likely to become
 * non-functioning.
 *
 * @param[in] obj The object.
 * @param[out] klass The class of the group, eg. "button".
 * @param[out] group The group, eg. "base".
 * @param[out] style The style to use, eg "default".
 *
 * @since 1.22
 *
 * @ingroup Efl_Ui_Layout_Base
 */
EOAPI void efl_ui_layout_theme_get(const Eo *obj, const char **klass, const char **group, const char **style);

#ifdef EFL_BETA_API_SUPPORT
/**
 * @brief This flag tells if this object will automatically mirror the rotation
 * changes of the window to this object.
 *
 * @param[in] obj The object.
 * @param[in] automatic @c true to mirror orientation changes to the theme
 * @c false otherwise
 *
 * @since 1.22
 *
 * @ingroup Efl_Ui_Layout_Base
 */
EOAPI void efl_ui_layout_automatic_theme_rotation_set(Eo *obj, Eina_Bool automatic);
#endif /* EFL_BETA_API_SUPPORT */

#ifdef EFL_BETA_API_SUPPORT
/**
 * @brief This flag tells if this object will automatically mirror the rotation
 * changes of the window to this object.
 *
 * @param[in] obj The object.
 *
 * @return @c true to mirror orientation changes to the theme @c false
 * otherwise
 *
 * @since 1.22
 *
 * @ingroup Efl_Ui_Layout_Base
 */
EOAPI Eina_Bool efl_ui_layout_automatic_theme_rotation_get(const Eo *obj);
#endif /* EFL_BETA_API_SUPPORT */

#ifdef EFL_BETA_API_SUPPORT
/**
 * @brief Apply a new rotation value to this object.
 *
 * @param[in] obj The object.
 * @param[in] orientation The new rotation value.
 *
 * @since 1.22
 *
 * @ingroup Efl_Ui_Layout_Base
 */
EOAPI void efl_ui_layout_theme_rotation_apply(Eo *obj, Efl_Orient orientation);
#endif /* EFL_BETA_API_SUPPORT */

EWAPI extern const Efl_Event_Description _EFL_UI_LAYOUT_EVENT_THEME_CHANGED;

/** Called when theme changed
 *
 * @since 1.22
 *
 * @ingroup Efl_Ui_Layout_Base
 */
#define EFL_UI_LAYOUT_EVENT_THEME_CHANGED (&(_EFL_UI_LAYOUT_EVENT_THEME_CHANGED))

#endif
