/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.yaml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.springframework.beans.factory.config.YamlProcessor;
import org.springframework.boot.bind.PropertySourcesPropertyValues;
import org.springframework.boot.bind.RelaxedDataBinder;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.PropertySources;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class SpringProfileDocumentMatcher
implements YamlProcessor.DocumentMatcher {
    private String[] activeProfiles = new String[0];

    public SpringProfileDocumentMatcher() {
    }

    public SpringProfileDocumentMatcher(String ... profiles) {
        this.addActiveProfiles(profiles);
    }

    public void addActiveProfiles(String ... profiles) {
        LinkedHashSet<String> set = new LinkedHashSet<String>(Arrays.asList(this.activeProfiles));
        Collections.addAll(set, profiles);
        this.activeProfiles = set.toArray(new String[set.size()]);
    }

    public YamlProcessor.MatchStatus matches(Properties properties) {
        List<String> profiles = this.extractSpringProfiles(properties);
        ProfilesMatcher profilesMatcher = this.getProfilesMatcher();
        Set<String> negative = this.extractProfiles(profiles, ProfileType.NEGATIVE);
        Set<String> positive = this.extractProfiles(profiles, ProfileType.POSITIVE);
        if (!CollectionUtils.isEmpty(negative)) {
            if (profilesMatcher.matches(negative) == YamlProcessor.MatchStatus.FOUND) {
                return YamlProcessor.MatchStatus.NOT_FOUND;
            }
            if (CollectionUtils.isEmpty(positive)) {
                return YamlProcessor.MatchStatus.FOUND;
            }
        }
        return profilesMatcher.matches(positive);
    }

    private List<String> extractSpringProfiles(Properties properties) {
        SpringProperties springProperties = new SpringProperties();
        MutablePropertySources propertySources = new MutablePropertySources();
        propertySources.addFirst((PropertySource)new PropertiesPropertySource("profiles", properties));
        PropertySourcesPropertyValues propertyValues = new PropertySourcesPropertyValues((PropertySources)propertySources);
        new RelaxedDataBinder(springProperties, "spring").bind(propertyValues);
        List<String> profiles = springProperties.getProfiles();
        return profiles;
    }

    private ProfilesMatcher getProfilesMatcher() {
        return this.activeProfiles.length != 0 ? new ActiveProfilesMatcher(new HashSet<String>(Arrays.asList(this.activeProfiles))) : new EmptyProfilesMatcher();
    }

    private Set<String> extractProfiles(List<String> profiles, ProfileType type) {
        if (CollectionUtils.isEmpty(profiles)) {
            return null;
        }
        HashSet<String> extractedProfiles = new HashSet<String>();
        for (String candidate : profiles) {
            ProfileType candidateType = ProfileType.POSITIVE;
            if (candidate.startsWith("!")) {
                candidateType = ProfileType.NEGATIVE;
            }
            if (candidateType != type) continue;
            extractedProfiles.add(type != ProfileType.POSITIVE ? candidate.substring(1) : candidate);
        }
        return extractedProfiles;
    }

    static class SpringProperties {
        private List<String> profiles = new ArrayList<String>();

        SpringProperties() {
        }

        public List<String> getProfiles() {
            return this.profiles;
        }

        public void setProfiles(List<String> profiles) {
            this.profiles = profiles;
        }
    }

    private static class EmptyProfilesMatcher
    extends ProfilesMatcher {
        private EmptyProfilesMatcher() {
        }

        @Override
        public YamlProcessor.MatchStatus doMatches(Set<String> springProfiles) {
            if (springProfiles.isEmpty()) {
                return YamlProcessor.MatchStatus.FOUND;
            }
            for (String profile : springProfiles) {
                if (StringUtils.hasText((String)profile)) continue;
                return YamlProcessor.MatchStatus.FOUND;
            }
            return YamlProcessor.MatchStatus.NOT_FOUND;
        }
    }

    private static class ActiveProfilesMatcher
    extends ProfilesMatcher {
        private final Set<String> activeProfiles;

        ActiveProfilesMatcher(Set<String> activeProfiles) {
            this.activeProfiles = activeProfiles;
        }

        @Override
        protected YamlProcessor.MatchStatus doMatches(Set<String> profiles) {
            if (profiles.isEmpty()) {
                return YamlProcessor.MatchStatus.NOT_FOUND;
            }
            for (String activeProfile : this.activeProfiles) {
                if (!profiles.contains(activeProfile)) continue;
                return YamlProcessor.MatchStatus.FOUND;
            }
            return YamlProcessor.MatchStatus.NOT_FOUND;
        }
    }

    private static abstract class ProfilesMatcher {
        private ProfilesMatcher() {
        }

        public final YamlProcessor.MatchStatus matches(Set<String> profiles) {
            if (CollectionUtils.isEmpty(profiles)) {
                return YamlProcessor.MatchStatus.ABSTAIN;
            }
            return this.doMatches(profiles);
        }

        protected abstract YamlProcessor.MatchStatus doMatches(Set<String> var1);
    }

    static enum ProfileType {
        POSITIVE,
        NEGATIVE;

    }
}

