/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.core;

import org.sunflow.core.Instance;
import org.sunflow.core.Shader;
import org.sunflow.core.ShadingState;
import org.sunflow.image.Color;

public class ShadingCache {
    private Sample first;
    private int depth;
    long hits;
    long misses;
    long sumDepth;
    long numCaches;

    public ShadingCache() {
        this.reset();
        this.hits = 0L;
        this.misses = 0L;
    }

    public void reset() {
        this.sumDepth += (long)this.depth;
        if (this.depth > 0) {
            ++this.numCaches;
        }
        this.first = null;
        this.depth = 0;
    }

    public Color lookup(ShadingState shadingState, Shader shader) {
        if (shadingState.getNormal() == null) {
            return null;
        }
        Sample sample = this.first;
        while (sample != null) {
            if (sample.i == shadingState.getInstance() && sample.s == shader && !(shadingState.getRay().dot(sample.dx, sample.dy, sample.dz) < 0.999f) && !(shadingState.getNormal().dot(sample.nx, sample.ny, sample.nz) < 0.99f)) {
                ++this.hits;
                return sample.c;
            }
            sample = sample.next;
        }
        ++this.misses;
        return null;
    }

    public void add(ShadingState shadingState, Shader shader, Color color) {
        if (shadingState.getNormal() == null) {
            return;
        }
        ++this.depth;
        Sample sample = new Sample();
        sample.i = shadingState.getInstance();
        sample.s = shader;
        sample.c = color;
        sample.dx = shadingState.getRay().dx;
        sample.dy = shadingState.getRay().dy;
        sample.dz = shadingState.getRay().dz;
        sample.nx = shadingState.getNormal().x;
        sample.ny = shadingState.getNormal().y;
        sample.nz = shadingState.getNormal().z;
        sample.next = this.first;
        this.first = sample;
    }

    private static class Sample {
        Instance i;
        Shader s;
        float nx;
        float ny;
        float nz;
        float dx;
        float dy;
        float dz;
        Color c;
        Sample next;

        private Sample() {
        }
    }
}

