/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.api;

import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.ObjIntConsumer;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Augmentation {
    private Augmentation() {
    }

    public static <T> int getLength(List<T> receiver) {
        return receiver.size();
    }

    public static String namedGroup(Matcher receiver, String name) {
        return receiver.group(name);
    }

    public static <T> boolean any(Iterable<T> receiver, Predicate<T> predicate) {
        for (T t : receiver) {
            if (!predicate.test(t)) continue;
            return true;
        }
        return false;
    }

    public static <T> Collection<T> asCollection(Iterable<T> receiver) {
        if (receiver instanceof Collection) {
            return (Collection)receiver;
        }
        ArrayList<T> list = new ArrayList<T>();
        for (T t : receiver) {
            list.add(t);
        }
        return list;
    }

    public static <T> List<T> asList(Iterable<T> receiver) {
        if (receiver instanceof List) {
            return (List)receiver;
        }
        ArrayList<T> list = new ArrayList<T>();
        for (T t : receiver) {
            list.add(t);
        }
        return list;
    }

    public static <T> int count(Iterable<T> receiver, Predicate<T> predicate) {
        int count = 0;
        for (T t : receiver) {
            if (!predicate.test(t)) continue;
            ++count;
        }
        return count;
    }

    public static <T> Object each(Iterable<T> receiver, Consumer<T> consumer) {
        receiver.forEach(consumer);
        return receiver;
    }

    public static <T> Object eachWithIndex(Iterable<T> receiver, ObjIntConsumer<T> consumer) {
        int count = 0;
        for (T t : receiver) {
            consumer.accept(t, count++);
        }
        return receiver;
    }

    public static <T> boolean every(Iterable<T> receiver, Predicate<T> predicate) {
        for (T t : receiver) {
            if (predicate.test(t)) continue;
            return false;
        }
        return true;
    }

    public static <T, U> List<U> findResults(Iterable<T> receiver, Function<T, U> filter) {
        ArrayList<U> list = new ArrayList<U>();
        for (T t : receiver) {
            U result = filter.apply(t);
            if (result == null) continue;
            list.add(result);
        }
        return list;
    }

    public static <T, U> Map<U, List<T>> groupBy(Iterable<T> receiver, Function<T, U> mapper) {
        LinkedHashMap<U, ArrayList<T>> map = new LinkedHashMap<U, ArrayList<T>>();
        for (T t : receiver) {
            U mapped = mapper.apply(t);
            ArrayList<T> results = (ArrayList<T>)map.get(mapped);
            if (results == null) {
                results = new ArrayList<T>();
                map.put(mapped, results);
            }
            results.add(t);
        }
        return map;
    }

    public static <T> String join(Iterable<T> receiver, String separator) {
        StringBuilder sb = new StringBuilder();
        for (T t : receiver) {
            if (sb.length() > 0) {
                sb.append(separator);
            }
            sb.append(t);
        }
        return sb.toString();
    }

    public static <T extends Number> double sum(Iterable<T> receiver) {
        double sum = 0.0;
        for (Number t : receiver) {
            sum += t.doubleValue();
        }
        return sum;
    }

    public static <T> double sum(Iterable<T> receiver, ToDoubleFunction<T> function) {
        double sum = 0.0;
        for (T t : receiver) {
            sum += function.applyAsDouble(t);
        }
        return sum;
    }

    public static <T, U> List<U> collect(Collection<T> receiver, Function<T, U> function) {
        ArrayList<U> list = new ArrayList<U>();
        for (T t : receiver) {
            list.add(function.apply(t));
        }
        return list;
    }

    public static <T, U> Object collect(Collection<T> receiver, Collection<U> collection, Function<T, U> function) {
        for (T t : receiver) {
            collection.add(function.apply(t));
        }
        return collection;
    }

    public static <T> T find(Collection<T> receiver, Predicate<T> predicate) {
        for (T t : receiver) {
            if (!predicate.test(t)) continue;
            return t;
        }
        return null;
    }

    public static <T> List<T> findAll(Collection<T> receiver, Predicate<T> predicate) {
        ArrayList<T> list = new ArrayList<T>();
        for (T t : receiver) {
            if (!predicate.test(t)) continue;
            list.add(t);
        }
        return list;
    }

    public static <T, U> Object findResult(Collection<T> receiver, Function<T, U> function) {
        return Augmentation.findResult(receiver, null, function);
    }

    public static <T, U> Object findResult(Collection<T> receiver, Object defaultResult, Function<T, U> function) {
        for (T t : receiver) {
            U value = function.apply(t);
            if (value == null) continue;
            return value;
        }
        return defaultResult;
    }

    public static <T> List<List<T>> split(Collection<T> receiver, Predicate<T> predicate) {
        ArrayList<T> matched = new ArrayList<T>();
        ArrayList<T> unmatched = new ArrayList<T>();
        ArrayList<List<T>> result = new ArrayList<List<T>>(2);
        result.add(matched);
        result.add(unmatched);
        for (T t : receiver) {
            if (predicate.test(t)) {
                matched.add(t);
                continue;
            }
            unmatched.add(t);
        }
        return result;
    }

    public static <K, V, T> List<T> collect(Map<K, V> receiver, BiFunction<K, V, T> function) {
        ArrayList<T> list = new ArrayList<T>();
        for (Map.Entry<K, V> kvPair : receiver.entrySet()) {
            list.add(function.apply(kvPair.getKey(), kvPair.getValue()));
        }
        return list;
    }

    public static <K, V, T> Object collect(Map<K, V> receiver, Collection<T> collection, BiFunction<K, V, T> function) {
        for (Map.Entry<K, V> kvPair : receiver.entrySet()) {
            collection.add(function.apply(kvPair.getKey(), kvPair.getValue()));
        }
        return collection;
    }

    public static <K, V> int count(Map<K, V> receiver, BiPredicate<K, V> predicate) {
        int count = 0;
        for (Map.Entry<K, V> kvPair : receiver.entrySet()) {
            if (!predicate.test(kvPair.getKey(), kvPair.getValue())) continue;
            ++count;
        }
        return count;
    }

    public static <K, V> Object each(Map<K, V> receiver, BiConsumer<K, V> consumer) {
        receiver.forEach(consumer);
        return receiver;
    }

    public static <K, V> boolean every(Map<K, V> receiver, BiPredicate<K, V> predicate) {
        for (Map.Entry<K, V> kvPair : receiver.entrySet()) {
            if (predicate.test(kvPair.getKey(), kvPair.getValue())) continue;
            return false;
        }
        return true;
    }

    public static <K, V> Map.Entry<K, V> find(Map<K, V> receiver, BiPredicate<K, V> predicate) {
        for (Map.Entry<K, V> kvPair : receiver.entrySet()) {
            if (!predicate.test(kvPair.getKey(), kvPair.getValue())) continue;
            return kvPair;
        }
        return null;
    }

    public static <K, V> Map<K, V> findAll(Map<K, V> receiver, BiPredicate<K, V> predicate) {
        AbstractMap map = receiver instanceof TreeMap ? new TreeMap() : new LinkedHashMap();
        for (Map.Entry<K, V> kvPair : receiver.entrySet()) {
            if (!predicate.test(kvPair.getKey(), kvPair.getValue())) continue;
            map.put(kvPair.getKey(), kvPair.getValue());
        }
        return map;
    }

    public static <K, V, T> Object findResult(Map<K, V> receiver, BiFunction<K, V, T> function) {
        return Augmentation.findResult(receiver, null, function);
    }

    public static <K, V, T> Object findResult(Map<K, V> receiver, Object defaultResult, BiFunction<K, V, T> function) {
        for (Map.Entry<K, V> kvPair : receiver.entrySet()) {
            T value = function.apply(kvPair.getKey(), kvPair.getValue());
            if (value == null) continue;
            return value;
        }
        return defaultResult;
    }

    public static <K, V, T> List<T> findResults(Map<K, V> receiver, BiFunction<K, V, T> filter) {
        ArrayList<T> list = new ArrayList<T>();
        for (Map.Entry<K, V> kvPair : receiver.entrySet()) {
            T result = filter.apply(kvPair.getKey(), kvPair.getValue());
            if (result == null) continue;
            list.add(result);
        }
        return list;
    }

    public static <K, V, T> Map<T, Map<K, V>> groupBy(Map<K, V> receiver, BiFunction<K, V, T> mapper) {
        LinkedHashMap<T, TreeMap<K, V>> map = new LinkedHashMap<T, TreeMap<K, V>>();
        for (Map.Entry<K, V> kvPair : receiver.entrySet()) {
            T mapped = mapper.apply(kvPair.getKey(), kvPair.getValue());
            AbstractMap results = (TreeMap<K, V>)map.get(mapped);
            if (results == null) {
                results = receiver instanceof TreeMap ? new TreeMap<K, V>() : new LinkedHashMap();
                map.put(mapped, (TreeMap<K, V>)results);
            }
            results.put(kvPair.getKey(), kvPair.getValue());
        }
        return map;
    }

    public static String replaceAll(CharSequence receiver, Pattern pattern, Function<Matcher, String> replacementBuilder) {
        Matcher m = pattern.matcher(receiver);
        if (!m.find()) {
            return receiver.toString();
        }
        StringBuffer result = new StringBuffer(Augmentation.initialBufferForReplaceWith(receiver));
        do {
            m.appendReplacement(result, Matcher.quoteReplacement(replacementBuilder.apply(m)));
        } while (m.find());
        m.appendTail(result);
        return result.toString();
    }

    public static String replaceFirst(CharSequence receiver, Pattern pattern, Function<Matcher, String> replacementBuilder) {
        Matcher m = pattern.matcher(receiver);
        if (!m.find()) {
            return receiver.toString();
        }
        StringBuffer result = new StringBuffer(Augmentation.initialBufferForReplaceWith(receiver));
        m.appendReplacement(result, Matcher.quoteReplacement(replacementBuilder.apply(m)));
        m.appendTail(result);
        return result.toString();
    }

    private static int initialBufferForReplaceWith(CharSequence seq) {
        return seq.length() + 16;
    }

    public static String encodeBase64(String receiver) {
        return Base64.getEncoder().encodeToString(receiver.getBytes(StandardCharsets.UTF_8));
    }

    public static String decodeBase64(String receiver) {
        return new String(Base64.getDecoder().decode(receiver.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
    }

    public static String[] splitOnToken(String receiver, String token) {
        return Augmentation.splitOnToken(receiver, token, -1);
    }

    public static String[] splitOnToken(String receiver, String token, int limit) {
        int idx;
        if (receiver == null || receiver.length() == 0 || token == null || token.length() == 0 || receiver.length() < token.length()) {
            return new String[]{receiver};
        }
        ArrayList<String> result = new ArrayList<String>();
        int pos = 0;
        while (limit != 1 && (idx = receiver.indexOf(token, pos)) != -1) {
            result.add(receiver.substring(pos, idx));
            pos = idx + token.length();
            --limit;
        }
        result.add(receiver.substring(pos));
        return result.toArray(new String[0]);
    }
}

