/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.engine;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.function.Function;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.store.Directory;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.index.engine.EngineConfig;
import org.elasticsearch.index.engine.ReadOnlyEngine;
import org.elasticsearch.index.engine.SegmentsStats;

public final class NoOpEngine
extends ReadOnlyEngine {
    private final SegmentsStats stats = new SegmentsStats();

    public NoOpEngine(EngineConfig config) {
        super(config, null, null, true, Function.identity());
        Directory directory = this.store.directory();
        try (DirectoryReader reader = DirectoryReader.open((Directory)directory);){
            for (LeafReaderContext ctx : reader.getContext().leaves()) {
                SegmentReader segmentReader = Lucene.segmentReader(ctx.reader());
                this.fillSegmentStats(segmentReader, true, this.stats);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    protected DirectoryReader open(IndexCommit commit) throws IOException {
        Directory directory = commit.getDirectory();
        List indexCommits = DirectoryReader.listCommits((Directory)directory);
        final IndexCommit indexCommit = (IndexCommit)indexCommits.get(indexCommits.size() - 1);
        return new DirectoryReader(directory, new LeafReader[0]){

            protected DirectoryReader doOpenIfChanged() {
                return null;
            }

            protected DirectoryReader doOpenIfChanged(IndexCommit commit) {
                return null;
            }

            protected DirectoryReader doOpenIfChanged(IndexWriter writer, boolean applyAllDeletes) {
                return null;
            }

            public long getVersion() {
                return 0L;
            }

            public boolean isCurrent() {
                return true;
            }

            public IndexCommit getIndexCommit() {
                return indexCommit;
            }

            protected void doClose() {
            }

            public IndexReader.CacheHelper getReaderCacheHelper() {
                return null;
            }
        };
    }

    @Override
    public SegmentsStats segmentsStats(boolean includeSegmentFileSizes, boolean includeUnloadedSegments) {
        if (includeUnloadedSegments) {
            SegmentsStats stats = new SegmentsStats();
            stats.add(this.stats);
            if (!includeSegmentFileSizes) {
                stats.clearFileSizes();
            }
            return stats;
        }
        return super.segmentsStats(includeSegmentFileSizes, includeUnloadedSegments);
    }
}

