/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.io.Closeable;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Version;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.compress.Compressor;
import org.elasticsearch.common.compress.CompressorFactory;
import org.elasticsearch.common.compress.NotCompressedException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.transport.TcpChannel;
import org.elasticsearch.transport.TransportStatus;

public final class TransportLogger {
    private static final Logger logger = LogManager.getLogger(TransportLogger.class);
    private static final int HEADER_SIZE = 6;

    void logInboundMessage(TcpChannel channel, BytesReference message) {
        if (logger.isTraceEnabled()) {
            try {
                String logMessage = this.format(channel, message, "READ");
                logger.trace(logMessage);
            }
            catch (IOException e) {
                logger.trace("an exception occurred formatting a READ trace message", (Throwable)e);
            }
        }
    }

    void logOutboundMessage(TcpChannel channel, BytesReference message) {
        if (logger.isTraceEnabled()) {
            try {
                if (message.get(0) != 69) {
                    return;
                }
                BytesReference withoutHeader = message.slice(6, message.length() - 6);
                String logMessage = this.format(channel, withoutHeader, "WRITE");
                logger.trace(logMessage);
            }
            catch (IOException e) {
                logger.trace("an exception occurred formatting a WRITE trace message", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String format(TcpChannel channel, BytesReference message, String event) throws IOException {
        StreamInput streamInput;
        StringBuilder sb;
        block16: {
            sb = new StringBuilder();
            sb.append(channel);
            int messageLengthWithHeader = 6 + message.length();
            if (message.length() == 0) {
                sb.append(" [ping]").append(' ').append(event).append(": ").append(messageLengthWithHeader).append('B');
                return sb.toString();
            }
            boolean success = false;
            streamInput = message.streamInput();
            try {
                long requestId = streamInput.readLong();
                byte status = streamInput.readByte();
                boolean isRequest = TransportStatus.isRequest(status);
                String type = isRequest ? "request" : "response";
                String version = Version.fromId(streamInput.readInt()).toString();
                sb.append(" [length: ").append(messageLengthWithHeader);
                sb.append(", request id: ").append(requestId);
                sb.append(", type: ").append(type);
                sb.append(", version: ").append(version);
                if (isRequest) {
                    if (TransportStatus.isCompress(status)) {
                        Compressor compressor;
                        try {
                            int bytesConsumed = 13;
                            compressor = CompressorFactory.compressor(message.slice(13, message.length() - 13));
                        }
                        catch (NotCompressedException ex) {
                            throw new IllegalStateException(ex);
                        }
                        streamInput = compressor.streamInput(streamInput);
                    }
                    try (ThreadContext context = new ThreadContext(Settings.EMPTY);){
                        context.readHeaders(streamInput);
                    }
                    if (streamInput.getVersion().onOrAfter(Version.V_6_3_0)) {
                        streamInput.readStringArray();
                    }
                    sb.append(", action: ").append(streamInput.readString());
                }
                sb.append(']');
                sb.append(' ').append(event).append(": ").append(messageLengthWithHeader).append('B');
                success = true;
                if (!success) break block16;
            }
            catch (Throwable throwable) {
                if (success) {
                    IOUtils.close((Closeable[])new Closeable[]{streamInput});
                    throw throwable;
                } else {
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{streamInput});
                }
                throw throwable;
            }
            IOUtils.close((Closeable[])new Closeable[]{streamInput});
            return sb.toString();
        }
        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{streamInput});
        return sb.toString();
    }
}

