/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pcl.fonts;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.fop.fonts.CustomFont;
import org.apache.fop.fonts.Typeface;
import org.apache.fop.render.java2d.CustomFontMetricsMapper;
import org.apache.fop.render.pcl.fonts.PCLByteWriterUtil;
import org.apache.fop.render.pcl.fonts.PCLFontReader;
import org.apache.fop.render.pcl.fonts.PCLFontReaderFactory;
import org.apache.fop.render.pcl.fonts.PCLFontSegment;
import org.apache.fop.render.pcl.fonts.PCLSoftFont;

public class PCLSoftFontManager {
    private Map<Typeface, PCLFontReader> fontReaderMap;
    private PCLFontReader fontReader;
    private List<PCLSoftFont> fonts = new ArrayList<PCLSoftFont>();
    private static final int SOFT_FONT_SIZE = 255;

    public PCLSoftFontManager(Map<Typeface, PCLFontReader> fontReaderMap) {
        this.fontReaderMap = fontReaderMap;
    }

    public ByteArrayOutputStream makeSoftFont(Typeface font, String text) throws IOException {
        List<Map<Character, Integer>> mappedGlyphs = this.mapFontGlyphs(font);
        if (!this.fontReaderMap.containsKey(font)) {
            this.fontReaderMap.put(font, PCLFontReaderFactory.createInstance(font));
        }
        this.fontReader = this.fontReaderMap.get(font);
        if (mappedGlyphs.isEmpty()) {
            mappedGlyphs.add(new HashMap());
        }
        if (this.fontReader != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PCLSoftFont softFont = null;
            for (Map<Character, Integer> glyphSet : mappedGlyphs) {
                softFont = this.getSoftFont(font, text, mappedGlyphs, softFont);
                softFont.setMappedChars(glyphSet);
                this.writeFontID(softFont.getFontID(), baos);
                this.writeFontHeader(softFont.getMappedChars(), baos);
                softFont.setCharacterOffsets(this.fontReader.getCharacterOffsets());
                softFont.setOpenFont(this.fontReader.getFontFile());
                softFont.setReader(this.fontReader.getFontFileReader());
                softFont.setMtxCharIndexes(this.fontReader.scanMtxCharacters());
            }
            return baos;
        }
        return null;
    }

    private PCLSoftFont getSoftFont(Typeface font, String text, List<Map<Character, Integer>> mappedGlyphs, PCLSoftFont last) {
        if (text == null) {
            Iterator<PCLSoftFont> fontIterator = this.fonts.iterator();
            while (fontIterator.hasNext()) {
                PCLSoftFont sftFont = fontIterator.next();
                if (!sftFont.getTypeface().equals(font)) continue;
                fontIterator.remove();
                return sftFont;
            }
        }
        for (PCLSoftFont sftFont : this.fonts) {
            if (!sftFont.getTypeface().equals(font) || sftFont == last || sftFont.getCharCount() + this.countNonMatches(sftFont, text) >= 255) continue;
            return sftFont;
        }
        PCLSoftFont f = new PCLSoftFont(this.fonts.size() + 1, font, mappedGlyphs.get(0).size() != 0);
        this.fonts.add(f);
        return f;
    }

    private List<Map<Character, Integer>> mapFontGlyphs(Typeface tf) {
        List<Map<Character, Integer>> mappedGlyphs = new ArrayList<Map<Character, Integer>>();
        if (tf instanceof CustomFontMetricsMapper) {
            CustomFontMetricsMapper fontMetrics = (CustomFontMetricsMapper)tf;
            CustomFont customFont = (CustomFont)fontMetrics.getRealFont();
            mappedGlyphs = this.mapGlyphs(customFont.getUsedGlyphs(), customFont);
        }
        return mappedGlyphs;
    }

    private List<Map<Character, Integer>> mapGlyphs(Map<Integer, Integer> usedGlyphs, CustomFont font) {
        int charCount = 32;
        ArrayList<Map<Character, Integer>> mappedGlyphs = new ArrayList<Map<Character, Integer>>();
        HashMap<Character, Integer> fontGlyphs = new HashMap<Character, Integer>();
        for (Map.Entry<Integer, Integer> entry : usedGlyphs.entrySet()) {
            int glyphID = entry.getKey();
            if (glyphID == 0) continue;
            char unicode = font.getUnicodeFromGID(glyphID);
            if (charCount > 255) {
                mappedGlyphs.add(fontGlyphs);
                charCount = 32;
                fontGlyphs = new HashMap();
            }
            fontGlyphs.put(Character.valueOf(unicode), charCount++);
        }
        if (fontGlyphs.size() > 0) {
            mappedGlyphs.add(fontGlyphs);
        }
        return mappedGlyphs;
    }

    private void writeFontID(int fontID, OutputStream os) throws IOException {
        os.write(this.assignFontID(fontID));
    }

    public byte[] assignFontID(int fontID) throws IOException {
        return PCLByteWriterUtil.writeCommand(String.format("*c%dD", fontID));
    }

    private void writeFontHeader(Map<Character, Integer> mappedGlyphs, OutputStream os) throws IOException {
        ByteArrayOutputStream header = new ByteArrayOutputStream();
        header.write(PCLByteWriterUtil.unsignedInt(this.fontReader.getDescriptorSize()));
        header.write(PCLByteWriterUtil.unsignedByte(this.fontReader.getHeaderFormat()));
        header.write(PCLByteWriterUtil.unsignedByte(this.fontReader.getFontType()));
        header.write(PCLByteWriterUtil.unsignedByte(this.fontReader.getStyleMSB()));
        header.write(0);
        header.write(PCLByteWriterUtil.unsignedInt(this.fontReader.getBaselinePosition()));
        header.write(PCLByteWriterUtil.unsignedInt(this.fontReader.getCellWidth()));
        header.write(PCLByteWriterUtil.unsignedInt(this.fontReader.getCellHeight()));
        header.write(PCLByteWriterUtil.unsignedByte(this.fontReader.getOrientation()));
        header.write(this.fontReader.getSpacing());
        header.write(PCLByteWriterUtil.unsignedInt(this.fontReader.getSymbolSet()));
        header.write(PCLByteWriterUtil.unsignedInt(this.fontReader.getPitch()));
        header.write(PCLByteWriterUtil.unsignedInt(this.fontReader.getHeight()));
        header.write(PCLByteWriterUtil.unsignedInt(this.fontReader.getXHeight()));
        header.write(PCLByteWriterUtil.signedByte(this.fontReader.getWidthType()));
        header.write(PCLByteWriterUtil.unsignedByte(this.fontReader.getStyleLSB()));
        header.write(PCLByteWriterUtil.signedByte(this.fontReader.getStrokeWeight()));
        header.write(PCLByteWriterUtil.unsignedByte(this.fontReader.getTypefaceLSB()));
        header.write(PCLByteWriterUtil.unsignedByte(this.fontReader.getTypefaceMSB()));
        header.write(PCLByteWriterUtil.unsignedByte(this.fontReader.getSerifStyle()));
        header.write(PCLByteWriterUtil.unsignedByte(this.fontReader.getQuality()));
        header.write(PCLByteWriterUtil.signedByte(this.fontReader.getPlacement()));
        header.write(PCLByteWriterUtil.signedByte(this.fontReader.getUnderlinePosition()));
        header.write(PCLByteWriterUtil.unsignedByte(this.fontReader.getUnderlineThickness()));
        header.write(PCLByteWriterUtil.unsignedInt(this.fontReader.getTextHeight()));
        header.write(PCLByteWriterUtil.unsignedInt(this.fontReader.getTextWidth()));
        header.write(PCLByteWriterUtil.unsignedInt(this.fontReader.getFirstCode()));
        header.write(PCLByteWriterUtil.unsignedInt(this.fontReader.getLastCode()));
        header.write(PCLByteWriterUtil.unsignedByte(this.fontReader.getPitchExtended()));
        header.write(PCLByteWriterUtil.unsignedByte(this.fontReader.getHeightExtended()));
        header.write(PCLByteWriterUtil.unsignedInt(this.fontReader.getCapHeight()));
        header.write(PCLByteWriterUtil.unsignedLongInt(this.fontReader.getFontNumber()));
        header.write(PCLByteWriterUtil.padBytes(this.fontReader.getFontName().getBytes("US-ASCII"), 16, 32));
        header.write(PCLByteWriterUtil.unsignedInt(this.fontReader.getScaleFactor()));
        header.write(PCLByteWriterUtil.signedInt(this.fontReader.getMasterUnderlinePosition()));
        header.write(PCLByteWriterUtil.unsignedInt(this.fontReader.getMasterUnderlineThickness()));
        header.write(PCLByteWriterUtil.unsignedByte(this.fontReader.getFontScalingTechnology()));
        header.write(PCLByteWriterUtil.unsignedByte(this.fontReader.getVariety()));
        this.writeSegmentedFontData(header, mappedGlyphs);
        os.write(this.getFontHeaderCommand(header.size()));
        os.write(header.toByteArray());
    }

    private void writeSegmentedFontData(ByteArrayOutputStream header, Map<Character, Integer> mappedGlyphs) throws IOException {
        List<PCLFontSegment> fontSegments = this.fontReader.getFontSegments(mappedGlyphs);
        for (PCLFontSegment segment : fontSegments) {
            this.writeFontSegment(header, segment);
        }
        header.write(0);
        long sum = 0L;
        byte[] headerBytes = header.toByteArray();
        for (int i = 64; i < headerBytes.length; ++i) {
            sum += (long)headerBytes[i];
        }
        int remainder = (int)(sum % 256L);
        header.write(256 - remainder);
    }

    private byte[] getFontHeaderCommand(int headerSize) throws IOException {
        return PCLByteWriterUtil.writeCommand(String.format(")s%dW", headerSize));
    }

    private void writeFontSegment(ByteArrayOutputStream header, PCLFontSegment segment) throws IOException {
        header.write(PCLByteWriterUtil.unsignedInt(segment.getIdentifier().getValue()));
        header.write(PCLByteWriterUtil.unsignedInt(segment.getData().length));
        header.write(segment.getData());
    }

    public PCLSoftFont getSoftFont(Typeface font, String text) {
        for (PCLSoftFont sftFont : this.fonts) {
            if (!sftFont.getTypeface().equals(font) || sftFont.getCharCount() + this.countNonMatches(sftFont, text) >= 255) continue;
            return sftFont;
        }
        return null;
    }

    public PCLSoftFont getSoftFontFromID(int index) {
        return this.fonts.get(index - 1);
    }

    private int countNonMatches(PCLSoftFont font, String text) {
        int result = 0;
        for (char ch : text.toCharArray()) {
            int value = font.getUnicodeCodePoint(ch);
            if (value != -1) continue;
            ++result;
        }
        return result;
    }

    public int getSoftFontID(Typeface tf) throws IOException {
        PCLSoftFont font = this.getSoftFont(tf, "");
        for (int i = 0; i < this.fonts.size(); ++i) {
            if (!this.fonts.get(i).equals(font)) continue;
            return i + 1;
        }
        return -1;
    }

    public List<PCLTextSegment> getTextSegments(String text, Typeface font) {
        ArrayList<PCLTextSegment> textSegments = new ArrayList<PCLTextSegment>();
        int curFontID = -1;
        String current = "";
        block0: for (char ch : text.toCharArray()) {
            for (PCLSoftFont softFont : this.fonts) {
                if (curFontID == -1) {
                    curFontID = softFont.getFontID();
                }
                if (softFont.getCharIndex(ch) == -1 || !softFont.getTypeface().equals(font)) continue;
                if (current.length() > 0 && curFontID != softFont.getFontID()) {
                    textSegments.add(new PCLTextSegment(curFontID, current));
                    current = "";
                    curFontID = softFont.getFontID();
                }
                if (curFontID != softFont.getFontID()) {
                    curFontID = softFont.getFontID();
                }
                current = current + ch;
                continue block0;
            }
        }
        if (current.length() > 0) {
            textSegments.add(new PCLTextSegment(curFontID, current));
        }
        return textSegments;
    }

    public static class PCLTextSegment {
        private String text;
        private int fontID;

        public PCLTextSegment(int fontID, String text) {
            this.text = text;
            this.fontID = fontID;
        }

        public String getText() {
            return this.text;
        }

        public int getFontID() {
            return this.fontID;
        }
    }
}

