/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.ngrams;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedSentence;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.databroker.ResourceDataBroker;
import org.languagetool.languagemodel.LanguageModel;
import org.languagetool.rules.Categories;
import org.languagetool.rules.ConfusionPair;
import org.languagetool.rules.ConfusionSetLoader;
import org.languagetool.rules.ConfusionString;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.ngrams.GoogleToken;
import org.languagetool.rules.ngrams.LanguageModelUtils;
import org.languagetool.tools.StringTools;
import org.languagetool.tools.Tools;

public abstract class ConfusionProbabilityRule
extends Rule {
    public static final String RULE_ID = "CONFUSION_RULE";
    public static final float MIN_COVERAGE = 0.5f;
    private static final double MIN_PROB = 0.0;
    private static final boolean DEBUG = false;
    private static final LoadingCache<String, Map<String, List<ConfusionPair>>> confSetCache = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, Map<String, List<ConfusionPair>>>(){

        public Map<String, List<ConfusionPair>> load(@NotNull String fileInClassPath) throws IOException {
            ConfusionSetLoader confusionSetLoader = new ConfusionSetLoader();
            ResourceDataBroker dataBroker = JLanguageTool.getDataBroker();
            try (InputStream confusionSetStream = dataBroker.getFromResourceDirAsStream(fileInClassPath);){
                Map<String, List<ConfusionPair>> map = confusionSetLoader.loadConfusionPairs(confusionSetStream);
                return map;
            }
        }
    });
    private final Map<String, List<ConfusionPair>> wordToPairs = new HashMap<String, List<ConfusionPair>>();
    private final LanguageModel lm;
    private final int grams;
    private final Language language;

    public ConfusionProbabilityRule(ResourceBundle messages, LanguageModel languageModel, Language language) {
        this(messages, languageModel, language, 3);
    }

    public ConfusionProbabilityRule(ResourceBundle messages, LanguageModel languageModel, Language language, int grams) {
        super(messages);
        this.setCategory(Categories.TYPOS.getCategory(messages));
        this.setLocQualityIssueType(ITSIssueType.NonConformance);
        for (String filename : this.getFilenames()) {
            String path = "/" + language.getShortCode() + "/" + filename;
            this.wordToPairs.putAll((Map)confSetCache.getUnchecked((Object)path));
        }
        this.lm = Objects.requireNonNull(languageModel);
        this.language = Objects.requireNonNull(language);
        if (grams < 1 || grams > 5) {
            throw new IllegalArgumentException("grams must be between 1 and 5: " + grams);
        }
        this.grams = grams;
    }

    @NotNull
    protected List<String> getFilenames() {
        return Arrays.asList("confusion_sets.txt");
    }

    @Override
    public String getId() {
        return RULE_ID;
    }

    @Override
    public int estimateContextForSureMatch() {
        return this.grams;
    }

    @Override
    public RuleMatch[] match(AnalyzedSentence sentence) {
        String text = sentence.getText();
        List<GoogleToken> tokens = GoogleToken.getGoogleTokens(text, true, LanguageModelUtils.getGoogleStyleWordTokenizer(this.language));
        ArrayList<RuleMatch> matches = new ArrayList<RuleMatch>();
        int pos = 0;
        for (GoogleToken googleToken : tokens) {
            String token = googleToken.token;
            List<ConfusionPair> confusionPairs = this.wordToPairs.get(token);
            boolean uppercase = false;
            if (confusionPairs == null && token.length() > 0 && Character.isUpperCase(token.charAt(0))) {
                confusionPairs = this.wordToPairs.get(StringTools.lowercaseFirstChar(token));
                uppercase = true;
            }
            if (confusionPairs != null) {
                for (ConfusionPair confusionPair : confusionPairs) {
                    List<ConfusionString> pairs;
                    boolean isEasilyConfused = confusionPair != null;
                    if (!isEasilyConfused) continue;
                    List<ConfusionString> list = pairs = uppercase ? confusionPair.getUppercaseFirstCharTerms() : confusionPair.getTerms();
                    ConfusionString betterAlternative = this.getBetterAlternativeOrNull(tokens.get(pos), tokens, pairs, confusionPair.getFactor());
                    if (betterAlternative == null || this.isException(text) || !confusionPair.isBidirectional() && betterAlternative.getString().equals(pairs.get(0).getString())) continue;
                    ConfusionString stringFromText = this.getConfusionString(pairs, tokens.get(pos));
                    String message = this.getMessage(stringFromText, betterAlternative);
                    ArrayList<String> suggestions = new ArrayList<String>(this.getSuggestions(message));
                    if (!suggestions.contains(betterAlternative.getString())) {
                        suggestions.add(betterAlternative.getString());
                    }
                    RuleMatch match = new RuleMatch(this, sentence, googleToken.startPos, googleToken.endPos, message);
                    match.setSuggestedReplacements(suggestions);
                    matches.add(match);
                }
            }
            ++pos;
        }
        return matches.toArray(new RuleMatch[0]);
    }

    private List<String> getSuggestions(String message) {
        Matcher matcher = Pattern.compile("<suggestion>(.*?)</suggestion>").matcher(message);
        ArrayList<String> result = new ArrayList<String>();
        while (matcher.find()) {
            result.add(matcher.group(1));
        }
        return result;
    }

    protected boolean isException(String sentenceText) {
        return false;
    }

    @Override
    public String getDescription() {
        return Tools.i18n(this.messages, "statistics_rule_description", new Object[0]);
    }

    protected String getMessage(ConfusionString textString, ConfusionString suggestion) {
        if (textString.getDescription() != null && suggestion.getDescription() != null) {
            return Tools.i18n(this.messages, "statistics_suggest1", suggestion.getString(), suggestion.getDescription(), textString.getString(), textString.getDescription());
        }
        if (textString.getDescription() != null) {
            return Tools.i18n(this.messages, "statistics_suggest4", suggestion.getString(), textString, textString.getDescription());
        }
        if (suggestion.getDescription() != null) {
            return Tools.i18n(this.messages, "statistics_suggest2", suggestion.getString(), suggestion.getDescription());
        }
        return Tools.i18n(this.messages, "statistics_suggest3", suggestion.getString());
    }

    public void setConfusionPair(ConfusionPair pair) {
        this.wordToPairs.clear();
        for (ConfusionString word : pair.getTerms()) {
            this.wordToPairs.put(word.getString(), Collections.singletonList(pair));
        }
    }

    public int getNGrams() {
        return this.grams;
    }

    @Nullable
    private ConfusionString getBetterAlternativeOrNull(GoogleToken token, List<GoogleToken> tokens, List<ConfusionString> confusionSet, long factor) {
        if (confusionSet.size() != 2) {
            throw new RuntimeException("Confusion set must be of size 2: " + confusionSet);
        }
        ConfusionString other = this.getAlternativeTerm(confusionSet, token);
        return this.getBetterAlternativeOrNull(token, tokens, other, factor);
    }

    private ConfusionString getAlternativeTerm(List<ConfusionString> confusionSet, GoogleToken token) {
        for (ConfusionString s : confusionSet) {
            if (s.getString().equals(token.token)) continue;
            return s;
        }
        throw new RuntimeException("No alternative found for: " + token);
    }

    private ConfusionString getConfusionString(List<ConfusionString> confusionSet, GoogleToken token) {
        for (ConfusionString s : confusionSet) {
            if (!s.getString().equalsIgnoreCase(token.token)) continue;
            return s;
        }
        throw new RuntimeException("Not found in set '" + confusionSet + "': " + token);
    }

    private ConfusionString getBetterAlternativeOrNull(GoogleToken token, List<GoogleToken> tokens, ConfusionString otherWord, long factor) {
        double p2;
        double p1;
        String word = token.token;
        if (this.grams == 3) {
            p1 = LanguageModelUtils.get3gramProbabilityFor(this.language, this.lm, token, tokens, word);
            p2 = LanguageModelUtils.get3gramProbabilityFor(this.language, this.lm, token, tokens, otherWord.getString());
        } else if (this.grams == 4) {
            p1 = LanguageModelUtils.get4gramProbabilityFor(this.language, this.lm, token, tokens, word);
            p2 = LanguageModelUtils.get4gramProbabilityFor(this.language, this.lm, token, tokens, otherWord.getString());
        } else {
            throw new RuntimeException("Only 3grams and 4grams are supported");
        }
        this.debug("%.90f <- P(" + word + ") \n", p1);
        this.debug("%.90f <- P(" + otherWord + ")\n", p2);
        return p2 >= 0.0 && p2 > p1 * (double)factor ? otherWord : null;
    }

    List<String> getContext(GoogleToken token, List<GoogleToken> tokens, String newToken, int toLeft, int toRight) {
        return LanguageModelUtils.getContext(token, tokens, newToken, toLeft, toRight);
    }

    private void debug(String message, Object ... vars) {
    }
}

