/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core;

import java.awt.Font;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import org.protege.editor.core.platform.OSUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Fonts {
    private static final Logger logger = LoggerFactory.getLogger(Fonts.class);
    private static final Font OS_X_SMALL_DIALOG_FONT = new Font("Helvetica Neue", 0, 10);
    private static final Font OS_X_MEDIUM_DIALOG_FONT = new Font("Helvetica Neue", 0, 11);
    private static final Font SMALL_DIALOG_FONT = new Font("Dialog", 0, 10);
    private static final Font MEDIUM_DIALOG_FONT = new Font("Dialog", 0, 11);

    public static void updateUIDefaultsFontSize(int fontSize) {
        UIDefaults lookAndFeelDefaults = UIManager.getLookAndFeelDefaults();
        double scale = (double)fontSize / 12.0;
        logger.debug("Font scale factor: {}", (Object)scale);
        lookAndFeelDefaults.keySet().stream().filter(k -> k.toString().toLowerCase().endsWith("font")).forEach(k -> {
            Font font = (Font)lookAndFeelDefaults.get(k);
            if (font != null) {
                Font scaledFont = font.deriveFont((float)scale * (float)font.getSize());
                UIManager.put(k, scaledFont);
                logger.debug("Set {} to {}", k, (Object)scaledFont.getSize());
            }
        });
    }

    public static Font getSmallDialogFont() {
        if (OSUtils.isOSX()) {
            return OS_X_SMALL_DIALOG_FONT;
        }
        return SMALL_DIALOG_FONT;
    }

    public static Font getMediumDialogFont() {
        if (OSUtils.isOSX()) {
            return OS_X_MEDIUM_DIALOG_FONT;
        }
        return MEDIUM_DIALOG_FONT;
    }
}

