/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.condition;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Locale;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.taskdefs.condition.Condition;

public class Http
extends ProjectComponent
implements Condition {
    private static final int ERROR_BEGINS = 400;
    private static final String DEFAULT_REQUEST_METHOD = "GET";
    private String spec = null;
    private String requestMethod = "GET";
    private boolean followRedirects = true;
    private int errorsBeginAt = 400;
    private int readTimeout = 0;

    public void setUrl(String url) {
        this.spec = url;
    }

    public void setErrorsBeginAt(int errorsBeginAt) {
        this.errorsBeginAt = errorsBeginAt;
    }

    public void setRequestMethod(String method) {
        this.requestMethod = method == null ? DEFAULT_REQUEST_METHOD : method.toUpperCase(Locale.ENGLISH);
    }

    public void setFollowRedirects(boolean f) {
        this.followRedirects = f;
    }

    public void setReadTimeout(int t) {
        if (t >= 0) {
            this.readTimeout = t;
        }
    }

    @Override
    public boolean eval() throws BuildException {
        if (this.spec == null) {
            throw new BuildException("No url specified in http condition");
        }
        this.log("Checking for " + this.spec, 3);
        try {
            URL url = new URL(this.spec);
            try {
                URLConnection conn = url.openConnection();
                if (conn instanceof HttpURLConnection) {
                    HttpURLConnection http = (HttpURLConnection)conn;
                    http.setRequestMethod(this.requestMethod);
                    http.setInstanceFollowRedirects(this.followRedirects);
                    http.setReadTimeout(this.readTimeout);
                    int code = http.getResponseCode();
                    this.log("Result code for " + this.spec + " was " + code, 3);
                    return code > 0 && code < this.errorsBeginAt;
                }
            }
            catch (ProtocolException pe) {
                throw new BuildException("Invalid HTTP protocol: " + this.requestMethod, pe);
            }
            catch (SocketTimeoutException ste) {
                return false;
            }
            catch (IOException e) {
                return false;
            }
        }
        catch (MalformedURLException e) {
            throw new BuildException("Badly formed URL: " + this.spec, e);
        }
        return true;
    }
}

