/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex;

import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.Declaration;
import com.dickimawbooks.texparserlib.Expandable;
import com.dickimawbooks.texparserlib.Group;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXSettings;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import com.dickimawbooks.texparserlib.latex.Begin;
import com.dickimawbooks.texparserlib.latex.End;
import java.io.IOException;
import java.util.Vector;

public class Environment
extends Group {
    private String name;
    private int mode = -1;

    public Environment(String string) {
        this(string, -1);
    }

    public Environment(String string, int n) {
        this.name = string;
        this.mode = n;
    }

    @Override
    public Object clone() {
        Environment environment = new Environment(this.name, this.mode);
        environment.addAll(this);
        return environment;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String toString(TeXParser teXParser) {
        StringBuilder stringBuilder = new StringBuilder();
        char c = teXParser.getEscChar();
        char c2 = teXParser.getBgChar();
        char c3 = teXParser.getEgChar();
        stringBuilder.append(c);
        stringBuilder.append("begin");
        stringBuilder.append(c2);
        stringBuilder.append(this.name);
        stringBuilder.append(c3);
        for (TeXObject teXObject : this) {
            stringBuilder.append(teXObject.toString(teXParser));
        }
        stringBuilder.append(c);
        stringBuilder.append("end");
        stringBuilder.append(c2);
        stringBuilder.append(this.name);
        stringBuilder.append(c3);
        return stringBuilder.toString();
    }

    private boolean checkObj(TeXParser teXParser, TeXObject teXObject, TeXObjectList teXObjectList) throws IOException {
        System.out.println("searching for \\end{" + this.name + "}");
        System.out.println(teXObject + " -> " + teXObject.getClass());
        if (teXObject instanceof End) {
            System.out.println("FOUND END (list size: " + teXObjectList.size() + ")");
            TeXObject teXObject2 = teXObjectList.popArg();
            String string = teXObject2.toString(teXParser);
            System.out.println("found \\end{" + string + "}");
            if (!string.equals(this.name)) {
                throw new TeXSyntaxException(teXParser, 14, teXObject.toString(teXParser) + teXParser.getBgChar() + this.name + teXParser.getEgChar());
            }
            return true;
        }
        if (teXObject instanceof Begin) {
            System.out.println("found begin");
            TeXObject teXObject3 = teXObjectList.popArg();
            String string = teXObject3.toString(teXParser);
            Environment environment = new Environment(string);
            environment.popGroup(teXParser, teXObjectList);
        } else {
            System.out.println("not found");
            this.add((Object)teXObject);
        }
        return false;
    }

    private boolean checkObj(TeXParser teXParser, TeXObject teXObject) throws IOException {
        if (teXObject instanceof End) {
            TeXObject teXObject2 = teXParser.popNextArg();
            String string = teXObject2.toString(teXParser);
            if (!string.equals(this.name)) {
                throw new TeXSyntaxException(teXParser, 14, teXObject.toString(teXParser) + teXParser.getBgChar() + this.name + teXParser.getEgChar());
            }
            return true;
        }
        if (teXObject instanceof Begin) {
            TeXObject teXObject3 = teXParser.popNextArg();
            String string = teXObject3.toString(teXParser);
            Environment environment = new Environment(string);
            environment.popGroup(teXParser);
        } else {
            this.add((Object)teXObject);
        }
        return false;
    }

    public void popGroup(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        while (teXObjectList.size() > 0) {
            TeXObject teXObject = teXObjectList.pop();
            if (teXObject instanceof Group) {
                this.add((Object)teXObject);
                continue;
            }
            Vector vector = null;
            if (teXObject instanceof Expandable) {
                vector = ((Expandable)((Object)teXObject)).expandfully(teXParser, teXObjectList);
            }
            if (vector == null) {
                if (!this.checkObj(teXParser, teXObject, teXObjectList)) continue;
                return;
            }
            while (vector.size() > 0) {
                teXObject = ((TeXObjectList)vector).pop();
                if (!this.checkObj(teXParser, teXObject, (TeXObjectList)vector)) continue;
                return;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void popGroup(TeXParser var1_1) throws IOException {
        block0: while (true) {
            if ((var2_2 = var1_1.popStack()) instanceof Group) {
                this.add((Object)var2_2);
                continue;
            }
            var3_3 = null;
            if (var2_2 instanceof Expandable) {
                var3_3 = ((Expandable)var2_2).expandfully(var1_1);
            }
            if (var3_3 == null) {
                if (!this.checkObj(var1_1, var2_2)) continue;
                return;
            }
            do {
                if (var3_3.size() > 0) ** break;
                continue block0;
            } while (!this.checkObj(var1_1, var2_2 = var3_3.pop(), (TeXObjectList)var3_3));
            break;
        }
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        teXParser.startGroup();
        TeXSettings teXSettings = teXParser.getSettings();
        int n = teXSettings.getCurrentMode();
        teXSettings.setMode(this.mode);
        ControlSequence controlSequence = teXParser.getListener().getControlSequence(this.getName());
        if (controlSequence instanceof Declaration) {
            this.pushDeclaration((Declaration)controlSequence);
        }
        controlSequence.process(teXParser, this);
        this.processList(teXParser);
        teXSettings.setMode(n);
        teXParser.endGroup();
    }

    public int getMode() {
        return this.mode;
    }
}

