/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.data.sort;

import java.util.Comparator;
import tim.prune.data.DataPoint;
import tim.prune.data.sort.SortMode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WaypointComparer
implements Comparator<DataPoint> {
    private SortMode _sortMode;

    public WaypointComparer(SortMode sortMode) {
        this._sortMode = sortMode;
    }

    @Override
    public int compare(DataPoint dataPoint, DataPoint dataPoint2) {
        if (dataPoint2 == null || !dataPoint2.isWaypoint()) {
            return -1;
        }
        if (dataPoint == null || !dataPoint.isWaypoint()) {
            return 1;
        }
        int n = 0;
        if (this._sortMode == SortMode.SORTBY_TIME) {
            n = this.compareTimes(dataPoint, dataPoint2);
        }
        if (n == 0) {
            n = dataPoint.getWaypointName().compareTo(dataPoint2.getWaypointName());
        }
        if (n == 0) {
            int n2 = n = dataPoint.getLongitude().getDouble() > dataPoint2.getLongitude().getDouble() ? 1 : -1;
        }
        if (n == 0) {
            n = dataPoint.getLatitude().getDouble() > dataPoint2.getLatitude().getDouble() ? 1 : -1;
        }
        return n;
    }

    private int compareTimes(DataPoint dataPoint, DataPoint dataPoint2) {
        if (dataPoint.hasTimestamp() && !dataPoint2.hasTimestamp()) {
            return 1;
        }
        if (!dataPoint.hasTimestamp() && dataPoint2.hasTimestamp()) {
            return -1;
        }
        if (dataPoint.hasTimestamp() && dataPoint2.hasTimestamp()) {
            long l = dataPoint.getTimestamp().getMillisecondsSince(dataPoint2.getTimestamp());
            return l < 0L ? -1 : (l == 0L ? 0 : 1);
        }
        return 0;
    }
}

