/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server;

import java.util.Date;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.remote.Address;
import org.gradle.launcher.daemon.context.DaemonContext;
import org.gradle.launcher.daemon.registry.DaemonInfo;
import org.gradle.launcher.daemon.registry.DaemonRegistry;
import org.gradle.launcher.daemon.registry.DaemonStopEvent;
import org.gradle.launcher.daemon.server.api.DaemonStateControl;
import org.gradle.launcher.daemon.server.expiry.DaemonExpirationStatus;

class DaemonRegistryUpdater
implements Stoppable {
    private static final Logger LOGGER = Logging.getLogger(DaemonRegistryUpdater.class);
    private final DaemonRegistry daemonRegistry;
    private final DaemonContext daemonContext;
    private final byte[] token;
    private Address connectorAddress;

    public DaemonRegistryUpdater(DaemonRegistry daemonRegistry, DaemonContext daemonContext, byte[] token) {
        this.daemonRegistry = daemonRegistry;
        this.daemonContext = daemonContext;
        this.token = token;
    }

    public void onStartActivity() {
        LOGGER.info("Marking the daemon as busy, address: {}", (Object)this.connectorAddress);
        try {
            this.daemonRegistry.markState(this.connectorAddress, DaemonStateControl.State.Busy);
        }
        catch (DaemonRegistry.EmptyRegistryException e) {
            LOGGER.warn("Cannot mark daemon as busy because the registry is empty.");
        }
    }

    public void onCompleteActivity() {
        LOGGER.info("Marking the daemon as idle, address: {}", (Object)this.connectorAddress);
        try {
            this.daemonRegistry.markState(this.connectorAddress, DaemonStateControl.State.Idle);
        }
        catch (DaemonRegistry.EmptyRegistryException e) {
            LOGGER.warn("Cannot mark daemon as idle because the registry is empty.");
        }
    }

    public void onCancel() {
        LOGGER.info("Marking the daemon as canceled, address: {}", (Object)this.connectorAddress);
        try {
            this.daemonRegistry.markState(this.connectorAddress, DaemonStateControl.State.Canceled);
        }
        catch (DaemonRegistry.EmptyRegistryException e) {
            LOGGER.warn("Cannot mark daemon as canceled because the registry is empty.");
        }
    }

    public void onStart(Address connectorAddress) {
        LOGGER.info("{}{}", (Object)"Advertising the daemon address to the clients: ", (Object)connectorAddress);
        LOGGER.debug("Advertised daemon context: {}", (Object)this.daemonContext);
        this.connectorAddress = connectorAddress;
        this.daemonRegistry.store(new DaemonInfo(connectorAddress, this.daemonContext, this.token, DaemonStateControl.State.Busy));
    }

    public void onExpire(String reason, DaemonExpirationStatus status) {
        LOGGER.debug("Storing daemon stop event: {}", (Object)reason);
        Date timestamp = new Date(System.currentTimeMillis());
        this.daemonRegistry.storeStopEvent(new DaemonStopEvent(timestamp, this.daemonContext.getPid(), status, reason));
    }

    @Override
    public void stop() {
        LOGGER.debug("Removing our presence to clients, eg. removing this address from the registry: {}", (Object)this.connectorAddress);
        try {
            this.daemonRegistry.remove(this.connectorAddress);
        }
        catch (DaemonRegistry.EmptyRegistryException e) {
            LOGGER.warn("Cannot remove daemon from the registry because the registry is empty.");
        }
        LOGGER.debug("Address removed from registry.");
    }
}

