/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution;

import org.gradle.api.Describable;
import org.gradle.api.artifacts.DependencyResolveDetails;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.VersionConstraint;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.internal.artifacts.DefaultModuleIdentifier;
import org.gradle.api.internal.artifacts.DefaultModuleVersionSelector;
import org.gradle.api.internal.artifacts.DependencySubstitutionInternal;
import org.gradle.api.internal.artifacts.dependencies.DefaultMutableVersionConstraint;
import org.gradle.api.internal.artifacts.dsl.ModuleVersionSelectorParsers;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionDescriptorInternal;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionReasons;
import org.gradle.internal.Describables;
import org.gradle.internal.component.external.model.DefaultModuleComponentSelector;

public class DefaultDependencyResolveDetails
implements DependencyResolveDetails {
    private final DependencySubstitutionInternal delegate;
    private ModuleVersionSelector requested;
    private String customDescription;
    private VersionConstraint useVersion;
    private ModuleComponentSelector useSelector;
    private boolean dirty;

    public DefaultDependencyResolveDetails(DependencySubstitutionInternal delegate, ModuleVersionSelector requested) {
        this.delegate = delegate;
        this.requested = requested;
    }

    private ComponentSelectionDescriptorInternal selectionReason() {
        return this.customDescription == null ? ComponentSelectionReasons.SELECTED_BY_RULE : ComponentSelectionReasons.SELECTED_BY_RULE.withDescription((Describable)Describables.of((Object)this.customDescription));
    }

    public ModuleVersionSelector getRequested() {
        return this.requested;
    }

    public void useVersion(String version) {
        if (version == null) {
            throw new IllegalArgumentException("Configuring the dependency resolve details with 'null' version is not allowed.");
        }
        this.useSelector = null;
        this.useVersion = new DefaultMutableVersionConstraint(version);
        this.dirty = true;
    }

    public void useTarget(Object notation) {
        ModuleVersionSelector newTarget = (ModuleVersionSelector)ModuleVersionSelectorParsers.parser().parseNotation(notation);
        this.useVersion = null;
        this.useSelector = DefaultModuleComponentSelector.newSelector(newTarget);
        this.dirty = true;
    }

    public DependencyResolveDetails because(String description) {
        this.customDescription = description;
        this.dirty = true;
        return this;
    }

    public ModuleVersionSelector getTarget() {
        this.complete();
        if (this.delegate.getTarget().equals(this.delegate.getRequested())) {
            return this.requested;
        }
        if (this.delegate.getTarget() instanceof ModuleComponentSelector) {
            return DefaultModuleVersionSelector.newSelector((ModuleComponentSelector)this.delegate.getTarget());
        }
        return this.requested;
    }

    public void complete() {
        if (!this.dirty) {
            return;
        }
        ComponentSelectionDescriptorInternal selectionReason = this.selectionReason();
        if (this.useSelector != null) {
            this.delegate.useTarget(this.useSelector, selectionReason);
        } else if (this.useVersion != null) {
            if (this.delegate.getTarget() instanceof ModuleComponentSelector) {
                ModuleComponentSelector target = (ModuleComponentSelector)this.delegate.getTarget();
                if (!this.useVersion.equals(target.getVersionConstraint())) {
                    this.delegate.useTarget(DefaultModuleComponentSelector.newSelector(target.getModuleIdentifier(), this.useVersion, target.getAttributes(), target.getRequestedCapabilities()), selectionReason);
                } else {
                    this.delegate.useTarget(this.delegate.getTarget(), selectionReason);
                }
            } else {
                ModuleComponentSelector newTarget = DefaultModuleComponentSelector.newSelector(DefaultModuleIdentifier.newId(this.requested.getGroup(), this.requested.getName()), this.useVersion);
                this.delegate.useTarget(newTarget, selectionReason);
            }
        }
        this.dirty = false;
    }
}

