/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.fingerprint.impl;

import com.google.common.annotations.VisibleForTesting;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.internal.change.ChangeVisitor;
import org.gradle.internal.change.DefaultFileChange;
import org.gradle.internal.fingerprint.FileSystemLocationFingerprint;
import org.gradle.internal.fingerprint.FingerprintCompareStrategy;
import org.gradle.internal.hash.HashCode;

public abstract class AbstractFingerprintCompareStrategy
implements FingerprintCompareStrategy {
    @Override
    public boolean visitChangesSince(ChangeVisitor visitor, Map<String, FileSystemLocationFingerprint> current, Map<String, FileSystemLocationFingerprint> previous, String propertyTitle, boolean includeAdded) {
        Boolean trivialResult = AbstractFingerprintCompareStrategy.compareTrivialFingerprints(visitor, current, previous, propertyTitle, includeAdded);
        if (trivialResult != null) {
            return trivialResult;
        }
        return this.doVisitChangesSince(visitor, current, previous, propertyTitle, includeAdded);
    }

    protected abstract boolean doVisitChangesSince(ChangeVisitor var1, Map<String, FileSystemLocationFingerprint> var2, Map<String, FileSystemLocationFingerprint> var3, String var4, boolean var5);

    @Nullable
    @VisibleForTesting
    static Boolean compareTrivialFingerprints(ChangeVisitor visitor, Map<String, FileSystemLocationFingerprint> current, Map<String, FileSystemLocationFingerprint> previous, String propertyTitle, boolean includeAdded) {
        switch (current.size()) {
            case 0: {
                switch (previous.size()) {
                    case 0: {
                        return true;
                    }
                }
                for (Map.Entry<String, FileSystemLocationFingerprint> entry : previous.entrySet()) {
                    DefaultFileChange change = DefaultFileChange.removed(entry.getKey(), propertyTitle, entry.getValue().getType(), entry.getValue().getNormalizedPath());
                    if (visitor.visitChange(change)) continue;
                    return false;
                }
                return true;
            }
            case 1: {
                switch (previous.size()) {
                    case 0: {
                        return AbstractFingerprintCompareStrategy.reportAllAdded(visitor, current, propertyTitle, includeAdded);
                    }
                    case 1: {
                        Map.Entry<String, FileSystemLocationFingerprint> previousEntry = previous.entrySet().iterator().next();
                        Map.Entry<String, FileSystemLocationFingerprint> currentEntry = current.entrySet().iterator().next();
                        return AbstractFingerprintCompareStrategy.compareTrivialFingerprintEntries(visitor, currentEntry, previousEntry, propertyTitle, includeAdded);
                    }
                }
                return null;
            }
        }
        if (!previous.isEmpty()) {
            return null;
        }
        return AbstractFingerprintCompareStrategy.reportAllAdded(visitor, current, propertyTitle, includeAdded);
    }

    private static boolean reportAllAdded(ChangeVisitor visitor, Map<String, FileSystemLocationFingerprint> current, String propertyTitle, boolean includeAdded) {
        if (includeAdded) {
            for (Map.Entry<String, FileSystemLocationFingerprint> entry : current.entrySet()) {
                DefaultFileChange change = DefaultFileChange.added(entry.getKey(), propertyTitle, entry.getValue().getType(), entry.getValue().getNormalizedPath());
                if (visitor.visitChange(change)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean compareTrivialFingerprintEntries(ChangeVisitor visitor, Map.Entry<String, FileSystemLocationFingerprint> currentEntry, Map.Entry<String, FileSystemLocationFingerprint> previousEntry, String propertyTitle, boolean includeAdded) {
        FileSystemLocationFingerprint previousFingerprint = previousEntry.getValue();
        FileSystemLocationFingerprint currentFingerprint = currentEntry.getValue();
        if (currentFingerprint.getNormalizedPath().equals(previousFingerprint.getNormalizedPath())) {
            HashCode previousContent = previousFingerprint.getNormalizedContentHash();
            HashCode currentContent = currentFingerprint.getNormalizedContentHash();
            if (!currentContent.equals((Object)previousContent)) {
                String path = currentEntry.getKey();
                DefaultFileChange change = DefaultFileChange.modified(path, propertyTitle, previousFingerprint.getType(), currentFingerprint.getType(), currentFingerprint.getNormalizedPath());
                return visitor.visitChange(change);
            }
            return true;
        }
        String previousPath = previousEntry.getKey();
        DefaultFileChange remove = DefaultFileChange.removed(previousPath, propertyTitle, previousFingerprint.getType(), previousFingerprint.getNormalizedPath());
        if (includeAdded) {
            String currentPath = currentEntry.getKey();
            DefaultFileChange add = DefaultFileChange.added(currentPath, propertyTitle, currentFingerprint.getType(), currentFingerprint.getNormalizedPath());
            return visitor.visitChange(remove) && visitor.visitChange(add);
        }
        return visitor.visitChange(remove);
    }
}

