/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.swift.plugins;

import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.language.cpp.internal.NativeVariantIdentity;
import org.gradle.language.internal.DefaultBinaryCollection;
import org.gradle.language.internal.NativeComponentFactory;
import org.gradle.language.nativeplatform.internal.Dimensions;
import org.gradle.language.nativeplatform.internal.toolchains.ToolChainSelector;
import org.gradle.language.swift.SwiftApplication;
import org.gradle.language.swift.SwiftExecutable;
import org.gradle.language.swift.SwiftPlatform;
import org.gradle.language.swift.SwiftVersion;
import org.gradle.language.swift.internal.DefaultSwiftApplication;
import org.gradle.language.swift.internal.DefaultSwiftPlatform;
import org.gradle.language.swift.plugins.SwiftBasePlugin;
import org.gradle.nativeplatform.TargetMachineFactory;
import org.gradle.nativeplatform.platform.internal.Architectures;
import org.gradle.nativeplatform.platform.internal.DefaultNativePlatform;
import org.gradle.util.GUtil;

@Incubating
public class SwiftApplicationPlugin
implements Plugin<Project> {
    private final NativeComponentFactory componentFactory;
    private final ToolChainSelector toolChainSelector;
    private final ImmutableAttributesFactory attributesFactory;
    private final TargetMachineFactory targetMachineFactory;

    @Inject
    public SwiftApplicationPlugin(NativeComponentFactory componentFactory, ToolChainSelector toolChainSelector, ImmutableAttributesFactory attributesFactory, TargetMachineFactory targetMachineFactory) {
        this.componentFactory = componentFactory;
        this.toolChainSelector = toolChainSelector;
        this.attributesFactory = attributesFactory;
        this.targetMachineFactory = targetMachineFactory;
    }

    public void apply(Project project) {
        project.getPluginManager().apply(SwiftBasePlugin.class);
        ObjectFactory objectFactory = project.getObjects();
        ProviderFactory providers = project.getProviders();
        DefaultSwiftApplication application = this.componentFactory.newInstance(SwiftApplication.class, DefaultSwiftApplication.class, "main");
        project.getExtensions().add(SwiftApplication.class, "application", (Object)application);
        project.getComponents().add((Object)application);
        application.getModule().convention((Object)GUtil.toCamelCase((CharSequence)project.getName()));
        application.getTargetMachines().convention(Dimensions.useHostAsDefaultTargetMachine(this.targetMachineFactory));
        application.getDevelopmentBinary().convention(project.provider(() -> ((DefaultBinaryCollection)application.getBinaries()).get().stream().filter(SwiftExecutable.class::isInstance).map(SwiftExecutable.class::cast).filter(binary -> !binary.isOptimized() && Architectures.forInput((String)binary.getTargetMachine().getArchitecture().getName()).equals(DefaultNativePlatform.host().getArchitecture())).findFirst().orElse(((DefaultBinaryCollection)application.getBinaries()).get().stream().filter(SwiftExecutable.class::isInstance).map(SwiftExecutable.class::cast).filter(binary -> !binary.isOptimized()).findFirst().orElse(null))));
        project.afterEvaluate(p -> {
            Dimensions.applicationVariants(application.getModule(), application.getTargetMachines(), objectFactory, this.attributesFactory, (Provider<String>)providers.provider(() -> project.getGroup().toString()), (Provider<String>)providers.provider(() -> project.getVersion().toString()), (Action<NativeVariantIdentity>)((Action)variantIdentity -> {
                if (Dimensions.tryToBuildOnHost(variantIdentity)) {
                    application.getSourceCompatibility().finalizeValue();
                    ToolChainSelector.Result<DefaultSwiftPlatform> result = this.toolChainSelector.select(SwiftPlatform.class, new DefaultSwiftPlatform(variantIdentity.getTargetMachine(), (SwiftVersion)application.getSourceCompatibility().getOrNull()));
                    application.addExecutable((NativeVariantIdentity)variantIdentity, variantIdentity.isDebuggable() && !variantIdentity.isOptimized(), result.getTargetPlatform(), result.getToolChain(), result.getPlatformToolProvider());
                }
            }));
            ((DefaultBinaryCollection)application.getBinaries()).realizeNow();
        });
    }
}

