/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.lang;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.lang.MetaLanguage;
import org.jetbrains.kotlin.com.intellij.lang.ParserDefinition;
import org.jetbrains.kotlin.com.intellij.lexer.Lexer;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.Extensions;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.FileType;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.LanguageFileType;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.FileViewProvider;
import org.jetbrains.kotlin.com.intellij.psi.LanguageSubstitutors;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.testFramework.LightVirtualFile;

public final class LanguageUtil {
    public static final Comparator<Language> LANGUAGE_COMPARATOR = (o1, o2) -> StringUtil.naturalCompare(o1.getDisplayName(), o2.getDisplayName());
    private static final Key<Collection<MetaLanguage>> MATCHING_LANGUAGES = Key.create("language.matching");

    @Nullable
    public static Language getLanguageForPsi(@NotNull Project project, @Nullable VirtualFile file2) {
        Language language;
        if (project == null) {
            LanguageUtil.$$$reportNull$$$0(0);
        }
        if ((language = LanguageUtil.getFileLanguage(file2)) == null) {
            return null;
        }
        return LanguageSubstitutors.INSTANCE.substituteLanguage(language, file2, project);
    }

    @Nullable
    public static Language getFileLanguage(@Nullable VirtualFile file2) {
        if (file2 == null) {
            return null;
        }
        Language l = file2 instanceof LightVirtualFile ? ((LightVirtualFile)file2).getLanguage() : null;
        return l != null ? l : LanguageUtil.getFileTypeLanguage(file2.getFileType());
    }

    @Nullable
    public static Language getFileTypeLanguage(@Nullable FileType fileType) {
        return fileType instanceof LanguageFileType ? ((LanguageFileType)fileType).getLanguage() : null;
    }

    public static ParserDefinition.SpaceRequirements canStickTokensTogetherByLexer(ASTNode left, ASTNode right, Lexer lexer) {
        String textStr = left.getText() + right.getText();
        lexer.start(textStr, 0, textStr.length());
        if (lexer.getTokenType() != left.getElementType()) {
            return ParserDefinition.SpaceRequirements.MUST;
        }
        if (lexer.getTokenEnd() != left.getTextLength()) {
            return ParserDefinition.SpaceRequirements.MUST;
        }
        lexer.advance();
        if (lexer.getTokenEnd() != textStr.length()) {
            return ParserDefinition.SpaceRequirements.MUST;
        }
        if (lexer.getTokenType() != right.getElementType()) {
            return ParserDefinition.SpaceRequirements.MUST;
        }
        return ParserDefinition.SpaceRequirements.MAY;
    }

    @NotNull
    public static Language getRootLanguage(@NotNull PsiElement element) {
        Language language;
        PsiFile containingFile;
        FileViewProvider provider;
        Set<Language> languages;
        if (element == null) {
            LanguageUtil.$$$reportNull$$$0(6);
        }
        if ((languages = (provider = (containingFile = element.getContainingFile()).getViewProvider()).getLanguages()).size() > 1 && languages.contains(language = containingFile.getLanguage())) {
            Language language2 = language;
            if (language2 == null) {
                LanguageUtil.$$$reportNull$$$0(7);
            }
            return language2;
        }
        Language language3 = provider.getBaseLanguage();
        if (language3 == null) {
            LanguageUtil.$$$reportNull$$$0(8);
        }
        return language3;
    }

    @NotNull
    static Collection<MetaLanguage> matchingMetaLanguages(@NotNull Language language) {
        if (language == null) {
            LanguageUtil.$$$reportNull$$$0(9);
        }
        if (!Extensions.getRootArea().hasExtensionPoint(MetaLanguage.EP_NAME)) {
            List<MetaLanguage> list2 = Collections.emptyList();
            if (list2 == null) {
                LanguageUtil.$$$reportNull$$$0(10);
            }
            return list2;
        }
        Collection<MetaLanguage> cached = language.getUserData(MATCHING_LANGUAGES);
        if (cached != null) {
            Collection<MetaLanguage> collection = cached;
            if (collection == null) {
                LanguageUtil.$$$reportNull$$$0(11);
            }
            return collection;
        }
        Set result2 = MetaLanguage.getAllMatchingMetaLanguages(language).collect(Collectors.toSet());
        Collection collection = language.putUserDataIfAbsent(MATCHING_LANGUAGES, result2);
        if (collection == null) {
            LanguageUtil.$$$reportNull$$$0(12);
        }
        return collection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/lang/LanguageUtil";
                break;
            }
            case 3: 
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/lang/LanguageUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageDialects";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileLanguages";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootLanguage";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "matchingMetaLanguages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageForPsi";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageDialects";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isInjectableLanguage";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isFileLanguage";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getRootLanguage";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "matchingMetaLanguages";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getLanguageDialects$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

