/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.daemon.EventManager;
import org.jetbrains.kotlin.daemon.common.CompilerCallbackServicesFacade;
import org.jetbrains.kotlin.daemon.common.Profiler;
import org.jetbrains.kotlin.incremental.js.FunctionWithSourceInfo;
import org.jetbrains.kotlin.incremental.js.IncrementalResultsConsumer;
import org.jetbrains.kotlin.incremental.js.JsInlineFunctionHash;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0001(B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J0\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dH\u0016J\u0016\u0010\u001f\u001a\u00020 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"H\u0016J(\u0010$\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010%\u001a\u00020\u00142\u0006\u0010&\u001a\u00020\u00142\u0006\u0010'\u001a\u00020\u0014H\u0016R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/daemon/RemoteIncrementalResultsConsumer;", "Lorg/jetbrains/kotlin/incremental/js/IncrementalResultsConsumer;", "facade", "Lorg/jetbrains/kotlin/daemon/common/CompilerCallbackServicesFacade;", "eventManager", "Lorg/jetbrains/kotlin/daemon/EventManager;", "rpcProfiler", "Lorg/jetbrains/kotlin/daemon/common/Profiler;", "(Lorg/jetbrains/kotlin/daemon/common/CompilerCallbackServicesFacade;Lorg/jetbrains/kotlin/daemon/EventManager;Lorg/jetbrains/kotlin/daemon/common/Profiler;)V", "deferInlineFuncs", "", "Lorg/jetbrains/kotlin/daemon/RemoteIncrementalResultsConsumer$JsInlineFunction;", "getFacade", "()Lorg/jetbrains/kotlin/daemon/common/CompilerCallbackServicesFacade;", "getRpcProfiler", "()Lorg/jetbrains/kotlin/daemon/common/Profiler;", "flush", "", "processHeader", "headerMetadata", "", "processInlineFunction", "sourceFile", "Ljava/io/File;", "fqName", "", "inlineFunction", "", "line", "", "column", "processInlineFunctions", "", "functions", "", "Lorg/jetbrains/kotlin/incremental/js/JsInlineFunctionHash;", "processPackagePart", "packagePartMetadata", "binaryAst", "inlineData", "JsInlineFunction", "daemon"})
public final class RemoteIncrementalResultsConsumer
implements IncrementalResultsConsumer {
    private final List<JsInlineFunction> deferInlineFuncs;
    @NotNull
    private final CompilerCallbackServicesFacade facade;
    @NotNull
    private final Profiler rpcProfiler;

    @Override
    public void processHeader(@NotNull byte[] headerMetadata2) {
        Intrinsics.checkParameterIsNotNull((Object)headerMetadata2, (String)"headerMetadata");
        this.rpcProfiler.withMeasure(this, (Function0)new Function0<Unit>(this, headerMetadata2){
            final /* synthetic */ RemoteIncrementalResultsConsumer this$0;
            final /* synthetic */ byte[] $headerMetadata;

            public final void invoke() {
                this.this$0.getFacade().incrementalResultsConsumer_processHeader(this.$headerMetadata);
            }
            {
                this.this$0 = remoteIncrementalResultsConsumer;
                this.$headerMetadata = byArray;
                super(0);
            }
        });
    }

    @Override
    public void processPackagePart(@NotNull File sourceFile, @NotNull byte[] packagePartMetadata, @NotNull byte[] binaryAst, @NotNull byte[] inlineData) {
        Intrinsics.checkParameterIsNotNull((Object)sourceFile, (String)"sourceFile");
        Intrinsics.checkParameterIsNotNull((Object)packagePartMetadata, (String)"packagePartMetadata");
        Intrinsics.checkParameterIsNotNull((Object)binaryAst, (String)"binaryAst");
        Intrinsics.checkParameterIsNotNull((Object)inlineData, (String)"inlineData");
        this.rpcProfiler.withMeasure(this, (Function0)new Function0<Unit>(this, sourceFile, packagePartMetadata, binaryAst, inlineData){
            final /* synthetic */ RemoteIncrementalResultsConsumer this$0;
            final /* synthetic */ File $sourceFile;
            final /* synthetic */ byte[] $packagePartMetadata;
            final /* synthetic */ byte[] $binaryAst;
            final /* synthetic */ byte[] $inlineData;

            public final void invoke() {
                CompilerCallbackServicesFacade compilerCallbackServicesFacade = this.this$0.getFacade();
                String string = this.$sourceFile.getPath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sourceFile.path");
                compilerCallbackServicesFacade.incrementalResultsConsumer_processPackagePart(string, this.$packagePartMetadata, this.$binaryAst, this.$inlineData);
            }
            {
                this.this$0 = remoteIncrementalResultsConsumer;
                this.$sourceFile = file2;
                this.$packagePartMetadata = byArray;
                this.$binaryAst = byArray2;
                this.$inlineData = byArray3;
                super(0);
            }
        });
    }

    @Override
    public void processInlineFunction(@NotNull File sourceFile, @NotNull String fqName2, @NotNull Object inlineFunction, int line, int column) {
        Intrinsics.checkParameterIsNotNull((Object)sourceFile, (String)"sourceFile");
        Intrinsics.checkParameterIsNotNull((Object)fqName2, (String)"fqName");
        Intrinsics.checkParameterIsNotNull((Object)inlineFunction, (String)"inlineFunction");
        String string = sourceFile.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sourceFile.path");
        this.deferInlineFuncs.add(new JsInlineFunction(string, fqName2, new FunctionWithSourceInfo(inlineFunction, line, column)));
    }

    @NotNull
    public Void processInlineFunctions(@NotNull Collection<JsInlineFunctionHash> functions2) {
        Intrinsics.checkParameterIsNotNull(functions2, (String)"functions");
        String string = "Should not be called in Daemon Server";
        boolean bl = false;
        throw (Throwable)new IllegalStateException(string.toString());
    }

    public final void flush() {
        this.rpcProfiler.withMeasure(this, (Function0)new Function0<Unit>(this){
            final /* synthetic */ RemoteIncrementalResultsConsumer this$0;

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                Collection<JsInlineFunctionHash> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable iterable = RemoteIncrementalResultsConsumer.access$getDeferInlineFuncs$p(this.this$0);
                CompilerCallbackServicesFacade compilerCallbackServicesFacade = this.this$0.getFacade();
                boolean $i$f$map = false;
                void var3_4 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    JsInlineFunction jsInlineFunction = (JsInlineFunction)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    JsInlineFunctionHash jsInlineFunctionHash = new JsInlineFunctionHash(it.getSourceFilePath(), it.getFqName(), it.getInlineFunction().getMd5());
                    collection.add(jsInlineFunctionHash);
                }
                collection = (List)destination$iv$iv;
                compilerCallbackServicesFacade.incrementalResultsConsumer_processInlineFunctions(collection);
            }
            {
                this.this$0 = remoteIncrementalResultsConsumer;
                super(0);
            }
        });
    }

    @NotNull
    public final CompilerCallbackServicesFacade getFacade() {
        return this.facade;
    }

    @NotNull
    public final Profiler getRpcProfiler() {
        return this.rpcProfiler;
    }

    public RemoteIncrementalResultsConsumer(@NotNull CompilerCallbackServicesFacade facade, @NotNull EventManager eventManager, @NotNull Profiler rpcProfiler) {
        List list2;
        Intrinsics.checkParameterIsNotNull((Object)facade, (String)"facade");
        Intrinsics.checkParameterIsNotNull((Object)eventManager, (String)"eventManager");
        Intrinsics.checkParameterIsNotNull((Object)rpcProfiler, (String)"rpcProfiler");
        this.facade = facade;
        this.rpcProfiler = rpcProfiler;
        eventManager.onCompilationFinished((Function0<Unit>)((Function0)new Function0<Unit>(this){

            public final void invoke() {
                ((RemoteIncrementalResultsConsumer)this.receiver).flush();
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(RemoteIncrementalResultsConsumer.class);
            }

            public final String getName() {
                return "flush";
            }

            public final String getSignature() {
                return "flush()V";
            }
        }));
        RemoteIncrementalResultsConsumer remoteIncrementalResultsConsumer = this;
        boolean bl = false;
        remoteIncrementalResultsConsumer.deferInlineFuncs = list2 = (List)new ArrayList();
    }

    public static final /* synthetic */ List access$getDeferInlineFuncs$p(RemoteIncrementalResultsConsumer $this) {
        return $this.deferInlineFuncs;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/daemon/RemoteIncrementalResultsConsumer$JsInlineFunction;", "", "sourceFilePath", "", "fqName", "inlineFunction", "Lorg/jetbrains/kotlin/incremental/js/FunctionWithSourceInfo;", "(Ljava/lang/String;Ljava/lang/String;Lorg/jetbrains/kotlin/incremental/js/FunctionWithSourceInfo;)V", "getFqName", "()Ljava/lang/String;", "getInlineFunction", "()Lorg/jetbrains/kotlin/incremental/js/FunctionWithSourceInfo;", "getSourceFilePath", "daemon"})
    private static final class JsInlineFunction {
        @NotNull
        private final String sourceFilePath;
        @NotNull
        private final String fqName;
        @NotNull
        private final FunctionWithSourceInfo inlineFunction;

        @NotNull
        public final String getSourceFilePath() {
            return this.sourceFilePath;
        }

        @NotNull
        public final String getFqName() {
            return this.fqName;
        }

        @NotNull
        public final FunctionWithSourceInfo getInlineFunction() {
            return this.inlineFunction;
        }

        public JsInlineFunction(@NotNull String sourceFilePath, @NotNull String fqName2, @NotNull FunctionWithSourceInfo inlineFunction) {
            Intrinsics.checkParameterIsNotNull((Object)sourceFilePath, (String)"sourceFilePath");
            Intrinsics.checkParameterIsNotNull((Object)fqName2, (String)"fqName");
            Intrinsics.checkParameterIsNotNull((Object)inlineFunction, (String)"inlineFunction");
            this.sourceFilePath = sourceFilePath;
            this.fqName = fqName2;
            this.inlineFunction = inlineFunction;
        }
    }
}

