/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.tasks;

import org.gradle.api.DefaultTask;
import org.gradle.api.Incubating;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.WorkResult;
import org.gradle.internal.Cast;
import org.gradle.internal.operations.logging.BuildOperationLogger;
import org.gradle.internal.operations.logging.BuildOperationLoggerFactory;
import org.gradle.language.base.internal.compile.CompileSpec;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.nativeplatform.internal.BuildOperationLoggingCompilerDecorator;
import org.gradle.nativeplatform.internal.DefaultStripperSpec;
import org.gradle.nativeplatform.internal.StripperSpec;
import org.gradle.nativeplatform.platform.NativePlatform;
import org.gradle.nativeplatform.platform.internal.NativePlatformInternal;
import org.gradle.nativeplatform.toolchain.NativeToolChain;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainInternal;
import org.gradle.nativeplatform.toolchain.internal.PlatformToolProvider;

@Incubating
public class StripSymbols
extends DefaultTask {
    private final RegularFileProperty binaryFile;
    private final RegularFileProperty outputFile;
    private final Property<NativePlatform> targetPlatform;
    private final Property<NativeToolChain> toolChain;

    public StripSymbols() {
        ObjectFactory objectFactory = this.getProject().getObjects();
        this.binaryFile = objectFactory.fileProperty();
        this.outputFile = objectFactory.fileProperty();
        this.targetPlatform = objectFactory.property(NativePlatform.class);
        this.toolChain = objectFactory.property(NativeToolChain.class);
    }

    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    public RegularFileProperty getBinaryFile() {
        return this.binaryFile;
    }

    @OutputFile
    public RegularFileProperty getOutputFile() {
        return this.outputFile;
    }

    @Internal
    public Property<NativeToolChain> getToolChain() {
        return this.toolChain;
    }

    @Nested
    public Property<NativePlatform> getTargetPlatform() {
        return this.targetPlatform;
    }

    @TaskAction
    public void stripSymbols() {
        BuildOperationLogger operationLogger = ((BuildOperationLoggerFactory)this.getServices().get(BuildOperationLoggerFactory.class)).newOperationLogger(this.getName(), this.getTemporaryDir());
        DefaultStripperSpec spec = new DefaultStripperSpec();
        spec.setBinaryFile(((RegularFile)this.binaryFile.get()).getAsFile());
        spec.setOutputFile(((RegularFile)this.outputFile.get()).getAsFile());
        spec.setOperationLogger(operationLogger);
        Compiler<StripperSpec> symbolStripper = this.createCompiler();
        symbolStripper = BuildOperationLoggingCompilerDecorator.wrap(symbolStripper);
        WorkResult result = symbolStripper.execute((CompileSpec)spec);
        this.setDidWork(result.getDidWork());
    }

    private Compiler<StripperSpec> createCompiler() {
        NativePlatformInternal targetPlatform = (NativePlatformInternal)Cast.cast(NativePlatformInternal.class, (Object)((NativePlatform)this.targetPlatform.get()));
        NativeToolChainInternal toolChain = (NativeToolChainInternal)Cast.cast(NativeToolChainInternal.class, (Object)((NativeToolChain)this.getToolChain().get()));
        PlatformToolProvider toolProvider = toolChain.select(targetPlatform);
        return toolProvider.newCompiler(StripperSpec.class);
    }
}

