/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.NonNullApi;
import org.gradle.api.Transformer;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.tasks.TaskDestroyablesInternal;
import org.gradle.api.internal.tasks.TaskLocalStateInternal;
import org.gradle.api.internal.tasks.properties.PropertyVisitor;
import org.gradle.api.internal.tasks.properties.PropertyWalker;
import org.gradle.api.tasks.TaskValidationException;
import org.gradle.internal.reflect.ParameterValidationContext;
import org.gradle.util.CollectionUtils;

@NonNullApi
public class TaskPropertyUtils {
    public static void visitProperties(PropertyWalker propertyWalker, TaskInternal task, PropertyVisitor visitor) {
        StrictErrorsOnlyContext validationContext = new StrictErrorsOnlyContext(task);
        propertyWalker.visitProperties(task, validationContext, visitor);
        validationContext.assertNoProblems();
        if (!visitor.visitOutputFilePropertiesOnly()) {
            task.getInputs().visitRegisteredProperties(visitor);
        }
        task.getOutputs().visitRegisteredProperties(visitor);
        if (visitor.visitOutputFilePropertiesOnly()) {
            return;
        }
        for (Object path : ((TaskDestroyablesInternal)task.getDestroyables()).getRegisteredPaths()) {
            visitor.visitDestroyableProperty(path);
        }
        for (Object path : ((TaskLocalStateInternal)task.getLocalState()).getRegisteredPaths()) {
            visitor.visitLocalStateProperty(path);
        }
    }

    public static String checkPropertyName(String propertyName) {
        if (propertyName.isEmpty()) {
            throw new IllegalArgumentException("Property name must not be empty string");
        }
        return propertyName;
    }

    private static class StrictErrorsOnlyContext
    implements ParameterValidationContext {
        private final TaskInternal task;
        List<String> problems;

        public StrictErrorsOnlyContext(TaskInternal task) {
            this.task = task;
        }

        void assertNoProblems() {
            String message;
            if (this.problems == null) {
                return;
            }
            if (this.problems.size() == 1) {
                message = String.format("A problem was found with the configuration of %s.", this.task);
            } else {
                Collections.sort(this.problems);
                message = String.format("Some problems were found with the configuration of %s.", this.task);
            }
            throw new TaskValidationException(message, CollectionUtils.collect(this.problems, (Transformer)new Transformer<InvalidUserDataException, String>(){

                public InvalidUserDataException transform(String message) {
                    return new InvalidUserDataException(message);
                }
            }));
        }

        public void visitError(@Nullable String ownerPath, String propertyName, String message) {
        }

        public void visitError(String message) {
        }

        public void visitErrorStrict(String message) {
            if (this.problems == null) {
                this.problems = new ArrayList<String>();
            }
            this.problems.add(message);
        }

        public void visitErrorStrict(@Nullable String ownerPath, String propertyName, String message) {
            this.visitErrorStrict(message);
        }
    }
}

