/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.service.scopes;

import java.util.Collections;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.changedetection.state.DefaultExecutionHistoryCacheAccess;
import org.gradle.api.invocation.Gradle;
import org.gradle.cache.CacheBuilder;
import org.gradle.cache.CacheRepository;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.LockOptions;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.internal.InMemoryCacheDecoratorFactory;
import org.gradle.cache.internal.filelock.LockOptionsBuilder;
import org.gradle.caching.internal.command.BuildCacheCommandFactory;
import org.gradle.caching.internal.controller.BuildCacheController;
import org.gradle.execution.plan.DefaultPlanExecutor;
import org.gradle.execution.plan.PlanExecutor;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.concurrent.ParallelismConfigurationManager;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.execution.CachingResult;
import org.gradle.internal.execution.IncrementalContext;
import org.gradle.internal.execution.OutputChangeListener;
import org.gradle.internal.execution.Step;
import org.gradle.internal.execution.WorkExecutor;
import org.gradle.internal.execution.history.ExecutionHistoryCacheAccess;
import org.gradle.internal.execution.history.ExecutionHistoryStore;
import org.gradle.internal.execution.history.OutputFilesRepository;
import org.gradle.internal.execution.history.changes.ExecutionStateChangeDetector;
import org.gradle.internal.execution.history.impl.DefaultExecutionHistoryStore;
import org.gradle.internal.execution.history.impl.DefaultOutputFilesRepository;
import org.gradle.internal.execution.impl.DefaultWorkExecutor;
import org.gradle.internal.execution.steps.BroadcastChangingOutputsStep;
import org.gradle.internal.execution.steps.CacheStep;
import org.gradle.internal.execution.steps.CancelExecutionStep;
import org.gradle.internal.execution.steps.CatchExceptionStep;
import org.gradle.internal.execution.steps.CleanupOutputsStep;
import org.gradle.internal.execution.steps.CreateOutputsStep;
import org.gradle.internal.execution.steps.ExecuteStep;
import org.gradle.internal.execution.steps.RecordOutputsStep;
import org.gradle.internal.execution.steps.ResolveCachingStateStep;
import org.gradle.internal.execution.steps.ResolveChangesStep;
import org.gradle.internal.execution.steps.ResolveInputChangesStep;
import org.gradle.internal.execution.steps.SkipUpToDateStep;
import org.gradle.internal.execution.steps.SnapshotOutputsStep;
import org.gradle.internal.execution.steps.StoreSnapshotsStep;
import org.gradle.internal.execution.steps.TimeoutStep;
import org.gradle.internal.execution.steps.legacy.MarkSnapshottingInputsFinishedStep;
import org.gradle.internal.execution.timeout.TimeoutHandler;
import org.gradle.internal.resources.ResourceLockCoordinationService;
import org.gradle.internal.scan.config.BuildScanPluginApplied;
import org.gradle.internal.scopeids.id.BuildInvocationScopeId;
import org.gradle.internal.work.WorkerLeaseService;
import org.gradle.util.GradleVersion;

public class ExecutionGradleServices {
    ExecutionHistoryCacheAccess createCacheAccess(Gradle gradle, CacheRepository cacheRepository, InMemoryCacheDecoratorFactory inMemoryCacheDecoratorFactory) {
        return new DefaultExecutionHistoryCacheAccess(gradle, cacheRepository, inMemoryCacheDecoratorFactory);
    }

    ExecutionHistoryStore createExecutionHistoryStore(ExecutionHistoryCacheAccess executionHistoryCacheAccess, StringInterner stringInterner) {
        return new DefaultExecutionHistoryStore(executionHistoryCacheAccess, stringInterner);
    }

    OutputFilesRepository createOutputFilesRepository(CacheRepository cacheRepository, Gradle gradle, InMemoryCacheDecoratorFactory inMemoryCacheDecoratorFactory) {
        PersistentCache cacheAccess = cacheRepository.cache((Object)gradle, "buildOutputCleanup").withCrossVersionCache(CacheBuilder.LockTarget.DefaultTarget).withDisplayName("Build Output Cleanup Cache").withLockOptions((LockOptions)LockOptionsBuilder.mode((FileLockManager.LockMode)FileLockManager.LockMode.None)).withProperties(Collections.singletonMap("gradle.version", GradleVersion.current().getVersion())).open();
        return new DefaultOutputFilesRepository(cacheAccess, inMemoryCacheDecoratorFactory);
    }

    PlanExecutor createPlanExecutor(ParallelismConfigurationManager parallelismConfigurationManager, ExecutorFactory executorFactory, WorkerLeaseService workerLeaseService, BuildCancellationToken cancellationToken, ResourceLockCoordinationService coordinationService) {
        int parallelThreads = parallelismConfigurationManager.getParallelismConfiguration().getMaxWorkerCount();
        if (parallelThreads < 1) {
            throw new IllegalStateException(String.format("Cannot create executor for requested number of worker threads: %s.", parallelThreads));
        }
        return new DefaultPlanExecutor(parallelismConfigurationManager.getParallelismConfiguration(), executorFactory, workerLeaseService, cancellationToken, coordinationService);
    }

    OutputChangeListener createOutputChangeListener(ListenerManager listenerManager) {
        return (OutputChangeListener)listenerManager.getBroadcaster(OutputChangeListener.class);
    }

    public WorkExecutor<IncrementalContext, CachingResult> createWorkExecutor(BuildCacheCommandFactory buildCacheCommandFactory, BuildCacheController buildCacheController, BuildScanPluginApplied buildScanPlugin, BuildCancellationToken cancellationToken, BuildInvocationScopeId buildInvocationScopeId, ExecutionStateChangeDetector changeDetector, OutputChangeListener outputChangeListener, OutputFilesRepository outputFilesRepository, TimeoutHandler timeoutHandler) {
        return new DefaultWorkExecutor((Step)new ResolveCachingStateStep(buildCacheController, buildScanPlugin.isBuildScanPluginApplied(), (Step)new MarkSnapshottingInputsFinishedStep((Step)new ResolveChangesStep(changeDetector, (Step)new SkipUpToDateStep((Step)new RecordOutputsStep(outputFilesRepository, (Step)new StoreSnapshotsStep((Step)new BroadcastChangingOutputsStep(outputChangeListener, (Step)new CacheStep(buildCacheController, buildCacheCommandFactory, (Step)new SnapshotOutputsStep(buildInvocationScopeId.getId(), (Step)new CreateOutputsStep((Step)new CatchExceptionStep((Step)new TimeoutStep(timeoutHandler, (Step)new CancelExecutionStep(cancellationToken, (Step)new ResolveInputChangesStep((Step)new CleanupOutputsStep((Step)new ExecuteStep()))))))))))))))));
    }
}

