/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.controller.service;

import java.io.IOException;
import java.io.InputStream;
import org.gradle.caching.BuildCacheEntryReader;
import org.gradle.caching.BuildCacheKey;
import org.gradle.caching.BuildCacheService;
import org.gradle.caching.internal.controller.operations.LoadOperationDetails;
import org.gradle.caching.internal.controller.operations.LoadOperationHitResult;
import org.gradle.caching.internal.controller.operations.LoadOperationMissResult;
import org.gradle.caching.internal.controller.operations.StoreOperationDetails;
import org.gradle.caching.internal.controller.operations.StoreOperationResult;
import org.gradle.caching.internal.controller.service.BaseBuildCacheServiceHandle;
import org.gradle.caching.internal.controller.service.BuildCacheServiceRole;
import org.gradle.caching.internal.controller.service.LoadTarget;
import org.gradle.caching.internal.controller.service.StoreTarget;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.RunnableBuildOperation;

public class OpFiringBuildCacheServiceHandle
extends BaseBuildCacheServiceHandle {
    private final BuildOperationExecutor buildOperationExecutor;

    public OpFiringBuildCacheServiceHandle(BuildCacheService service, boolean push, BuildCacheServiceRole role, BuildOperationExecutor buildOperationExecutor, boolean logStackTraces) {
        super(service, push, role, logStackTraces);
        this.buildOperationExecutor = buildOperationExecutor;
    }

    @Override
    protected void loadInner(final String description, final BuildCacheKey key, final LoadTarget loadTarget) {
        this.buildOperationExecutor.run(new RunnableBuildOperation(){

            public void run(BuildOperationContext context) {
                OpFiringBuildCacheServiceHandle.this.loadInner(key, new OpFiringEntryReader(loadTarget));
                context.setResult((Object)(loadTarget.isLoaded() ? new LoadOperationHitResult(loadTarget.getLoadedSize()) : LoadOperationMissResult.INSTANCE));
            }

            public BuildOperationDescriptor.Builder description() {
                return BuildOperationDescriptor.displayName((String)description).details((Object)new LoadOperationDetails(key)).progressDisplayName("Requesting from remote build cache");
            }
        });
    }

    @Override
    protected void storeInner(final String description, final BuildCacheKey key, final StoreTarget storeTarget) {
        this.buildOperationExecutor.run(new RunnableBuildOperation(){

            public void run(BuildOperationContext context) {
                OpFiringBuildCacheServiceHandle.super.storeInner(description, key, storeTarget);
                context.setResult((Object)(storeTarget.isStored() ? StoreOperationResult.STORED : StoreOperationResult.NOT_STORED));
            }

            public BuildOperationDescriptor.Builder description() {
                return BuildOperationDescriptor.displayName((String)description).details((Object)new StoreOperationDetails(key, storeTarget.getSize())).progressDisplayName("Uploading to remote build cache");
            }
        });
    }

    private static class UncheckedWrapper
    extends RuntimeException {
        UncheckedWrapper(IOException cause) {
            super(cause);
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }

        IOException getIOException() {
            return (IOException)this.getCause();
        }
    }

    private class OpFiringEntryReader
    implements BuildCacheEntryReader {
        private final BuildCacheEntryReader delegate;

        OpFiringEntryReader(BuildCacheEntryReader delegate) {
            this.delegate = delegate;
        }

        public void readFrom(final InputStream input) throws IOException {
            try {
                OpFiringBuildCacheServiceHandle.this.buildOperationExecutor.run(new RunnableBuildOperation(){

                    public void run(BuildOperationContext context) {
                        try {
                            OpFiringEntryReader.this.delegate.readFrom(input);
                        }
                        catch (IOException e) {
                            throw new UncheckedWrapper(e);
                        }
                    }

                    public BuildOperationDescriptor.Builder description() {
                        return BuildOperationDescriptor.displayName((String)"Download from remote build cache").progressDisplayName("Downloading");
                    }
                });
            }
            catch (UncheckedWrapper uncheckedWrapper) {
                throw uncheckedWrapper.getIOException();
            }
        }
    }
}

