/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.search;

import java.io.PushbackReader;
import java.io.StringReader;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Tagged;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.search.PushbackTokenizer;
import org.openstreetmap.josm.data.osm.search.SearchParseError;
import org.openstreetmap.josm.data.osm.search.SearchSetting;
import org.openstreetmap.josm.data.projection.ProjectionRegistry;
import org.openstreetmap.josm.gui.mappaint.Environment;
import org.openstreetmap.josm.gui.mappaint.mapcss.Selector;
import org.openstreetmap.josm.gui.mappaint.mapcss.parsergen.MapCSSParser;
import org.openstreetmap.josm.gui.mappaint.mapcss.parsergen.ParseException;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPreset;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetMenu;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetSeparator;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresets;
import org.openstreetmap.josm.tools.AlphanumComparator;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.UncheckedParseException;
import org.openstreetmap.josm.tools.date.DateUtils;

public class SearchCompiler {
    private final boolean caseSensitive;
    private final boolean regexSearch;
    private static String rxErrorMsg = I18n.marktr("The regex \"{0}\" had a parse error at offset {1}, full error:\n\n{2}");
    private static String rxErrorMsgNoPos = I18n.marktr("The regex \"{0}\" had a parse error, full error:\n\n{1}");
    private final PushbackTokenizer tokenizer;
    private static Map<String, SimpleMatchFactory> simpleMatchFactoryMap = new HashMap<String, SimpleMatchFactory>();
    private static Map<String, UnaryMatchFactory> unaryMatchFactoryMap = new HashMap<String, UnaryMatchFactory>();
    private static Map<String, BinaryMatchFactory> binaryMatchFactoryMap = new HashMap<String, BinaryMatchFactory>();

    public SearchCompiler(boolean caseSensitive, boolean regexSearch, PushbackTokenizer tokenizer) {
        this.caseSensitive = caseSensitive;
        this.regexSearch = regexSearch;
        this.tokenizer = tokenizer;
    }

    public static void addMatchFactory(MatchFactory factory) {
        for (String keyword : factory.getKeywords()) {
            MatchFactory existing;
            if (factory instanceof SimpleMatchFactory) {
                existing = simpleMatchFactoryMap.put(keyword, (SimpleMatchFactory)factory);
            } else if (factory instanceof UnaryMatchFactory) {
                existing = unaryMatchFactoryMap.put(keyword, (UnaryMatchFactory)factory);
            } else if (factory instanceof BinaryMatchFactory) {
                existing = binaryMatchFactoryMap.put(keyword, (BinaryMatchFactory)factory);
            } else {
                throw new AssertionError((Object)"Unknown match factory");
            }
            if (existing == null) continue;
            Logging.warn("SearchCompiler: for key ''{0}'', overriding match factory ''{1}'' with ''{2}''", keyword, existing, factory);
        }
    }

    public static Match compile(String searchStr) throws SearchParseError {
        return new SearchCompiler(false, false, new PushbackTokenizer(new PushbackReader(new StringReader(searchStr)))).parse();
    }

    public static Match compile(SearchSetting setting) throws SearchParseError {
        if (setting.mapCSSSearch) {
            return SearchCompiler.compileMapCSS(setting.text);
        }
        return new SearchCompiler(setting.caseSensitive, setting.regexSearch, new PushbackTokenizer(new PushbackReader(new StringReader(setting.text)))).parse();
    }

    static Match compileMapCSS(String mapCSS) throws SearchParseError {
        try {
            final List<Selector> selectors = new MapCSSParser(new StringReader(mapCSS)).selectors_for_search();
            return new Match(){

                @Override
                public boolean match(OsmPrimitive osm) {
                    for (Selector selector : selectors) {
                        if (!selector.matches(new Environment(osm))) continue;
                        return true;
                    }
                    return false;
                }
            };
        }
        catch (IllegalArgumentException | ParseException e) {
            throw new SearchParseError(I18n.tr("Failed to parse MapCSS selector", new Object[0]), e);
        }
    }

    public Match parse() throws SearchParseError {
        Match m = Optional.ofNullable(this.parseExpression()).orElse(Always.INSTANCE);
        if (!this.tokenizer.readIfEqual(PushbackTokenizer.Token.EOF)) {
            throw new SearchParseError(I18n.tr("Unexpected token: {0}", new Object[]{this.tokenizer.nextToken()}));
        }
        Logging.debug("Parsed search expression is {0}", m);
        return m;
    }

    private Match parseExpression() throws SearchParseError {
        List<Object> list = this.parseExpressionStep1();
        return SearchCompiler.parseExpressionStep2(list);
    }

    private List<Object> parseExpressionStep1() throws SearchParseError {
        Match factor;
        String token = null;
        String errorMessage = null;
        ArrayList<Object> list = new ArrayList<Object>();
        do {
            if ((factor = this.parseFactor()) != null) {
                if (token != null) {
                    list.add(token);
                }
                list.add(factor);
                if (this.tokenizer.readIfEqual(PushbackTokenizer.Token.OR)) {
                    token = "OR";
                    errorMessage = I18n.tr("Missing parameter for OR", new Object[0]);
                    continue;
                }
                if (this.tokenizer.readIfEqual(PushbackTokenizer.Token.XOR)) {
                    token = "XOR";
                    errorMessage = I18n.tr("Missing parameter for XOR", new Object[0]);
                    continue;
                }
                token = "AND";
                errorMessage = null;
                continue;
            }
            if (errorMessage == null) continue;
            throw new SearchParseError(errorMessage);
        } while (factor != null);
        return list;
    }

    private static Match parseExpressionStep2(List<Object> list) {
        Match result = null;
        for (int i = list.size() - 1; i >= 0; --i) {
            Object o = list.get(i);
            if (o instanceof Match && result == null) {
                result = (Match)o;
                continue;
            }
            if (o instanceof String && i > 0) {
                Match factor = (Match)list.get(i - 1);
                switch ((String)o) {
                    case "OR": {
                        result = new Or(factor, result);
                        break;
                    }
                    case "XOR": {
                        result = new Xor(factor, result);
                        break;
                    }
                    case "AND": {
                        result = new And(factor, result);
                        break;
                    }
                    default: {
                        throw new IllegalStateException(I18n.tr("Unexpected token: {0}", o));
                    }
                }
                --i;
                continue;
            }
            throw new IllegalStateException("i=" + i + "; o=" + o);
        }
        return result;
    }

    private Match parseFactor() throws SearchParseError {
        if (this.tokenizer.readIfEqual(PushbackTokenizer.Token.LEFT_PARENT)) {
            Match expression = this.parseExpression();
            if (!this.tokenizer.readIfEqual(PushbackTokenizer.Token.RIGHT_PARENT)) {
                throw new SearchParseError(PushbackTokenizer.Token.RIGHT_PARENT, this.tokenizer.nextToken());
            }
            return expression;
        }
        if (this.tokenizer.readIfEqual(PushbackTokenizer.Token.NOT)) {
            return new Not(this.parseFactor(I18n.tr("Missing operator for NOT", new Object[0])));
        }
        if (this.tokenizer.readIfEqual(PushbackTokenizer.Token.KEY)) {
            String key = this.tokenizer.getText();
            if (this.tokenizer.readIfEqual(PushbackTokenizer.Token.EQUALS)) {
                return new ExactKeyValue(this.regexSearch, key, this.tokenizer.readTextOrNumber());
            }
            if (this.tokenizer.readIfEqual(PushbackTokenizer.Token.LESS_THAN)) {
                return new ValueComparison(key, this.tokenizer.readTextOrNumber(), -1);
            }
            if (this.tokenizer.readIfEqual(PushbackTokenizer.Token.GREATER_THAN)) {
                return new ValueComparison(key, this.tokenizer.readTextOrNumber(), 1);
            }
            if (this.tokenizer.readIfEqual(PushbackTokenizer.Token.COLON)) {
                SimpleMatchFactory factory = simpleMatchFactoryMap.get(key);
                if (factory != null) {
                    return factory.get(key, this.caseSensitive, this.regexSearch, this.tokenizer);
                }
                UnaryMatchFactory unaryFactory = unaryMatchFactoryMap.get(key);
                if (unaryFactory != null) {
                    return unaryFactory.get(key, this.parseFactor(), this.tokenizer);
                }
                String value = this.tokenizer.readTextOrNumber();
                return new KeyValue(key, value != null ? value : "", this.regexSearch, this.caseSensitive);
            }
            if (this.tokenizer.readIfEqual(PushbackTokenizer.Token.QUESTION_MARK)) {
                return new BooleanMatch(key, false);
            }
            SimpleMatchFactory factory = simpleMatchFactoryMap.get(key);
            if (factory != null) {
                return factory.get(key, this.caseSensitive, this.regexSearch, null);
            }
            UnaryMatchFactory unaryFactory = unaryMatchFactoryMap.get(key);
            if (unaryFactory != null) {
                return unaryFactory.get(key, this.parseFactor(), null);
            }
            return new Any(key, this.regexSearch, this.caseSensitive);
        }
        return null;
    }

    private Match parseFactor(String errorMessage) throws SearchParseError {
        return Optional.ofNullable(this.parseFactor()).orElseThrow(() -> new SearchParseError(errorMessage));
    }

    private static int regexFlags(boolean caseSensitive) {
        int searchFlags = 0;
        searchFlags |= 0x80;
        searchFlags |= 0x20;
        if (!caseSensitive) {
            searchFlags |= 0x42;
        }
        return searchFlags;
    }

    static String escapeStringForSearch(String s) {
        return s.replace("\\", "\\\\").replace("\"", "\\\"");
    }

    public static String buildSearchStringForTag(String key, String value) {
        String forKey = '\"' + SearchCompiler.escapeStringForSearch(key) + '\"' + '=';
        if (value == null || value.isEmpty()) {
            return forKey + '*';
        }
        return forKey + '\"' + SearchCompiler.escapeStringForSearch(value) + '\"';
    }

    static {
        SearchCompiler.addMatchFactory(new CoreSimpleMatchFactory());
        SearchCompiler.addMatchFactory(new CoreUnaryMatchFactory());
    }

    private static class Preset
    extends Match {
        private final List<TaggingPreset> presets;

        Preset(String presetName) throws SearchParseError {
            if (presetName == null || presetName.isEmpty()) {
                throw new SearchParseError("The name of the preset is required");
            }
            int wildCardIdx = presetName.lastIndexOf(42);
            int length = presetName.length() - 1;
            boolean matchStrictly = wildCardIdx == -1 || wildCardIdx != length;
            this.presets = TaggingPresets.getTaggingPresets().stream().filter(preset -> !(preset instanceof TaggingPresetMenu) && !(preset instanceof TaggingPresetSeparator)).filter(preset -> Preset.presetNameMatch(presetName, preset, matchStrictly)).collect(Collectors.toList());
            if (this.presets.isEmpty()) {
                throw new SearchParseError(I18n.tr("Unknown preset name: ", new Object[0]) + presetName);
            }
        }

        @Override
        public boolean match(OsmPrimitive osm) {
            for (TaggingPreset preset : this.presets) {
                if (!preset.test(osm)) continue;
                return true;
            }
            return false;
        }

        private static boolean presetNameMatch(String name, TaggingPreset preset, boolean matchStrictly) {
            if (matchStrictly) {
                return name.equalsIgnoreCase(preset.getRawName());
            }
            try {
                String groupSuffix = name.substring(0, name.length() - 2);
                TaggingPresetMenu group = preset.group;
                return group != null && groupSuffix.equalsIgnoreCase(group.getRawName());
            }
            catch (StringIndexOutOfBoundsException ex) {
                Logging.trace(ex);
                return false;
            }
        }

        public int hashCode() {
            return 31 + (this.presets == null ? 0 : this.presets.hashCode());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Preset other = (Preset)obj;
            return !(this.presets == null ? other.presets != null : !this.presets.equals(other.presets));
        }
    }

    public static class NotOutsideDataSourceArea
    extends InDataSourceArea {
        public NotOutsideDataSourceArea() {
            super(false);
        }

        @Override
        protected Collection<Bounds> getBounds(OsmPrimitive primitive) {
            Collection<Bounds> bounds = super.getBounds(primitive);
            return bounds == null || bounds.isEmpty() ? Collections.singleton(ProjectionRegistry.getProjection().getWorldBoundsLatLon()) : bounds;
        }

        @Override
        public String toString() {
            return "NotOutsideDataSourceArea";
        }
    }

    public static class InDataSourceArea
    extends InArea {
        public InDataSourceArea(boolean all) {
            super(all);
        }

        @Override
        protected Collection<Bounds> getBounds(OsmPrimitive primitive) {
            return primitive.getDataSet() != null ? primitive.getDataSet().getDataSourceBounds() : null;
        }

        public String toString() {
            return this.all ? "allindownloadedarea" : "indownloadedarea";
        }
    }

    public static abstract class InArea
    extends Match {
        protected final boolean all;

        protected InArea(boolean all) {
            this.all = all;
        }

        protected abstract Collection<Bounds> getBounds(OsmPrimitive var1);

        @Override
        public boolean match(OsmPrimitive osm) {
            if (!osm.isUsable()) {
                return false;
            }
            if (osm instanceof Node) {
                LatLon coordinate = ((Node)osm).getCoor();
                Collection<Bounds> allBounds = this.getBounds(osm);
                return coordinate != null && allBounds != null && allBounds.stream().anyMatch(bounds -> bounds.contains(coordinate));
            }
            if (osm instanceof Way) {
                List<Node> nodes = ((Way)osm).getNodes();
                return this.all ? nodes.stream().allMatch(this) : nodes.stream().anyMatch(this);
            }
            if (osm instanceof Relation) {
                List<OsmPrimitive> primitives = ((Relation)osm).getMemberPrimitivesList();
                return this.all ? primitives.stream().allMatch(this) : primitives.stream().anyMatch(this);
            }
            return false;
        }

        public int hashCode() {
            return 31 + (this.all ? 1231 : 1237);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            InArea other = (InArea)obj;
            return this.all == other.all;
        }
    }

    private static class WayLength
    extends RangeMatch {
        WayLength(PushbackTokenizer.Range range) {
            super(range);
        }

        WayLength(PushbackTokenizer tokenizer) throws SearchParseError {
            this(tokenizer.readRange(I18n.tr("Range of numbers expected", new Object[0])));
        }

        @Override
        protected Long getNumber(OsmPrimitive osm) {
            if (!(osm instanceof Way)) {
                return null;
            }
            Way way = (Way)osm;
            return (long)way.getLength();
        }

        @Override
        protected String getString() {
            return "waylength";
        }
    }

    private static class AreaSize
    extends RangeMatch {
        AreaSize(PushbackTokenizer.Range range) {
            super(range);
        }

        AreaSize(PushbackTokenizer tokenizer) throws SearchParseError {
            this(tokenizer.readRange(I18n.tr("Range of numbers expected", new Object[0])));
        }

        @Override
        protected Long getNumber(OsmPrimitive osm) {
            Double area = Geometry.computeArea(osm);
            return area == null ? null : Long.valueOf(area.longValue());
        }

        @Override
        protected String getString() {
            return "areasize";
        }
    }

    public static class Child
    extends UnaryMatch {
        public Child(Match m) {
            super(m);
        }

        @Override
        public boolean match(OsmPrimitive osm) {
            boolean isChild = false;
            for (OsmPrimitive p : osm.getReferrers()) {
                isChild |= this.match.match(p);
            }
            return isChild;
        }

        public String toString() {
            return "child(" + this.match + ')';
        }
    }

    public static class Parent
    extends UnaryMatch {
        public Parent(Match m) {
            super(m);
        }

        @Override
        public boolean match(OsmPrimitive osm) {
            boolean isParent;
            block3: {
                block2: {
                    isParent = false;
                    if (!(osm instanceof Way)) break block2;
                    for (Node n : ((Way)osm).getNodes()) {
                        isParent |= this.match.match(n);
                    }
                    break block3;
                }
                if (!(osm instanceof Relation)) break block3;
                for (RelationMember member : ((Relation)osm).getMembers()) {
                    isParent |= this.match.match(member.getMember());
                }
            }
            return isParent;
        }

        public String toString() {
            return "parent(" + this.match + ')';
        }
    }

    private static class Closed
    extends Match {
        private Closed() {
        }

        @Override
        public boolean match(OsmPrimitive osm) {
            return osm instanceof Way && ((Way)osm).isClosed();
        }

        public String toString() {
            return "closed";
        }
    }

    private static class Untagged
    extends Match {
        private Untagged() {
        }

        @Override
        public boolean match(OsmPrimitive osm) {
            return !osm.isTagged() && !osm.isIncomplete();
        }

        public String toString() {
            return "untagged";
        }
    }

    private static class Incomplete
    extends Match {
        private Incomplete() {
        }

        @Override
        public boolean match(OsmPrimitive osm) {
            return osm.isIncomplete() || osm instanceof Relation && ((Relation)osm).hasIncompleteMembers();
        }

        public String toString() {
            return "incomplete";
        }
    }

    private static class Selected
    extends Match {
        private Selected() {
        }

        @Override
        public boolean match(OsmPrimitive osm) {
            return osm.getDataSet().isSelected(osm);
        }

        public String toString() {
            return "selected";
        }
    }

    private static class Deleted
    extends Match {
        private Deleted() {
        }

        @Override
        public boolean match(OsmPrimitive osm) {
            return osm.isDeleted();
        }

        public String toString() {
            return "deleted";
        }
    }

    private static class Modified
    extends Match {
        private Modified() {
        }

        @Override
        public boolean match(OsmPrimitive osm) {
            return osm.isModified() || osm.isNewOrUndeleted();
        }

        public String toString() {
            return "modified";
        }
    }

    private static class New
    extends Match {
        private New() {
        }

        @Override
        public boolean match(OsmPrimitive osm) {
            return osm.isNew();
        }

        public String toString() {
            return "new";
        }
    }

    private static class HasRole
    extends Match {
        private final String role;

        HasRole(PushbackTokenizer tokenizer) {
            this.role = tokenizer.readTextOrNumber();
        }

        @Override
        public boolean match(OsmPrimitive osm) {
            return osm instanceof Relation && ((Relation)osm).getMemberRoles().contains(this.role);
        }

        public int hashCode() {
            return 31 + (this.role == null ? 0 : this.role.hashCode());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            HasRole other = (HasRole)obj;
            return !(this.role == null ? other.role != null : !this.role.equals(other.role));
        }
    }

    private static class TimestampRange
    extends RangeMatch {
        TimestampRange(long minCount, long maxCount) {
            super(minCount, maxCount);
        }

        @Override
        protected Long getNumber(OsmPrimitive osm) {
            return osm.getTimestamp().getTime();
        }

        @Override
        protected String getString() {
            return "timestamp";
        }
    }

    private static class TagCountRange
    extends RangeMatch {
        TagCountRange(PushbackTokenizer.Range range) {
            super(range);
        }

        TagCountRange(PushbackTokenizer tokenizer) throws SearchParseError {
            this(tokenizer.readRange(I18n.tr("Range of numbers expected", new Object[0])));
        }

        @Override
        protected Long getNumber(OsmPrimitive osm) {
            return osm.getKeys().size();
        }

        @Override
        protected String getString() {
            return "tags";
        }
    }

    private static class WayCountRange
    extends RangeMatch {
        WayCountRange(PushbackTokenizer.Range range) {
            super(range);
        }

        WayCountRange(PushbackTokenizer tokenizer) throws SearchParseError {
            this(tokenizer.readRange(I18n.tr("Range of numbers expected", new Object[0])));
        }

        @Override
        protected Long getNumber(OsmPrimitive osm) {
            if (osm instanceof Node) {
                return osm.referrers(Way.class).count();
            }
            if (osm instanceof Relation) {
                return ((Relation)osm).getMemberPrimitives(Way.class).size();
            }
            return null;
        }

        @Override
        protected String getString() {
            return "ways";
        }
    }

    private static class NodeCountRange
    extends RangeMatch {
        NodeCountRange(PushbackTokenizer.Range range) {
            super(range);
        }

        NodeCountRange(PushbackTokenizer tokenizer) throws SearchParseError {
            this(tokenizer.readRange(I18n.tr("Range of numbers expected", new Object[0])));
        }

        @Override
        protected Long getNumber(OsmPrimitive osm) {
            if (osm instanceof Way) {
                return ((Way)osm).getRealNodesCount();
            }
            if (osm instanceof Relation) {
                return ((Relation)osm).getMemberPrimitives(Node.class).size();
            }
            return null;
        }

        @Override
        protected String getString() {
            return "nodes";
        }
    }

    private static abstract class RangeMatch
    extends Match {
        private final long min;
        private final long max;

        RangeMatch(long min, long max) {
            this.min = Math.min(min, max);
            this.max = Math.max(min, max);
        }

        RangeMatch(PushbackTokenizer.Range range) {
            this(range.getStart(), range.getEnd());
        }

        protected abstract Long getNumber(OsmPrimitive var1);

        protected abstract String getString();

        @Override
        public boolean match(OsmPrimitive osm) {
            Long num = this.getNumber(osm);
            if (num == null) {
                return false;
            }
            return num >= this.min && num <= this.max;
        }

        public String toString() {
            return this.getString() + '=' + this.min + '-' + this.max;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (int)(this.max ^ this.max >>> 32);
            result = 31 * result + (int)(this.min ^ this.min >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            RangeMatch other = (RangeMatch)obj;
            return this.max == other.max && this.min == other.min;
        }
    }

    private static class Nth
    extends Match {
        private final int nth;
        private final boolean modulo;

        Nth(PushbackTokenizer tokenizer, boolean modulo) throws SearchParseError {
            this((int)tokenizer.readNumber(I18n.tr("Positive integer expected", new Object[0])), modulo);
        }

        private Nth(int nth, boolean modulo) {
            this.nth = nth;
            this.modulo = modulo;
        }

        @Override
        public boolean match(OsmPrimitive osm) {
            for (OsmPrimitive p : osm.getReferrers()) {
                int maxIndex;
                int idx;
                if (p instanceof Way) {
                    Way w = (Way)p;
                    idx = w.getNodes().indexOf(osm);
                    maxIndex = w.getNodesCount();
                } else {
                    if (!(p instanceof Relation)) continue;
                    Relation r = (Relation)p;
                    idx = r.getMemberPrimitivesList().indexOf(osm);
                    maxIndex = r.getMembersCount();
                }
                if (this.nth < 0 && idx - maxIndex == this.nth) {
                    return true;
                }
                if (idx != this.nth && (!this.modulo || idx % this.nth != 0)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return "Nth{nth=" + this.nth + ", modulo=" + this.modulo + '}';
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.modulo ? 1231 : 1237);
            result = 31 * result + this.nth;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Nth other = (Nth)obj;
            return this.modulo == other.modulo && this.nth == other.nth;
        }
    }

    private static class RoleMatch
    extends Match {
        private String role;

        RoleMatch(String role) {
            this.role = role == null ? "" : role;
        }

        @Override
        public boolean match(OsmPrimitive osm) {
            for (OsmPrimitive ref : osm.getReferrers()) {
                if (!(ref instanceof Relation) || ref.isIncomplete() || ref.isDeleted()) continue;
                for (RelationMember m : ((Relation)ref).getMembers()) {
                    String testRole;
                    if (m.getMember() != osm || !this.role.equals((testRole = m.getRole()) == null ? "" : testRole)) continue;
                    return true;
                }
            }
            return false;
        }

        public String toString() {
            return "role=" + this.role;
        }

        public int hashCode() {
            return 31 + (this.role == null ? 0 : this.role.hashCode());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            RoleMatch other = (RoleMatch)obj;
            return !(this.role == null ? other.role != null : !this.role.equals(other.role));
        }
    }

    private static class UserMatch
    extends Match {
        private String user;

        UserMatch(String user) {
            this.user = "anonymous".equals(user) ? null : user;
        }

        @Override
        public boolean match(OsmPrimitive osm) {
            if (osm.getUser() == null) {
                return this.user == null;
            }
            return osm.getUser().hasName(this.user);
        }

        public String toString() {
            return "user=" + (this.user == null ? "" : this.user);
        }

        public int hashCode() {
            return 31 + (this.user == null ? 0 : this.user.hashCode());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            UserMatch other = (UserMatch)obj;
            return !(this.user == null ? other.user != null : !this.user.equals(other.user));
        }
    }

    private static class ExactType
    extends Match {
        private final OsmPrimitiveType type;

        ExactType(String type) throws SearchParseError {
            this.type = OsmPrimitiveType.from(type);
            if (this.type == null) {
                throw new SearchParseError(I18n.tr("Unknown primitive type: {0}. Allowed values are node, way or relation", type));
            }
        }

        @Override
        public boolean match(OsmPrimitive osm) {
            return this.type == osm.getType();
        }

        public String toString() {
            return "type=" + (Object)((Object)this.type);
        }

        public int hashCode() {
            return 31 + (this.type == null ? 0 : this.type.hashCode());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            ExactType other = (ExactType)obj;
            return this.type == other.type;
        }
    }

    private static class Any
    extends TaggedMatch {
        private final String search;
        private final Pattern searchRegex;
        private final boolean caseSensitive;

        Any(String s, boolean regexSearch, boolean caseSensitive) throws SearchParseError {
            s = Normalizer.normalize(s, Normalizer.Form.NFC);
            this.caseSensitive = caseSensitive;
            if (regexSearch) {
                this.searchRegex = Any.compilePattern(s, SearchCompiler.regexFlags(caseSensitive));
                this.search = s;
            } else if (caseSensitive) {
                this.search = s;
                this.searchRegex = null;
            } else {
                this.search = s.toLowerCase(Locale.ENGLISH);
                this.searchRegex = null;
            }
        }

        @Override
        public boolean match(Tagged osm) {
            if (!osm.hasKeys()) {
                return this.search.isEmpty();
            }
            for (String key : osm.keySet()) {
                String value = osm.get(key);
                if (this.searchRegex != null) {
                    value = Normalizer.normalize(value, Normalizer.Form.NFC);
                    Matcher keyMatcher = this.searchRegex.matcher(key);
                    Matcher valMatcher = this.searchRegex.matcher(value);
                    boolean keyMatchFound = keyMatcher.find();
                    boolean valMatchFound = valMatcher.find();
                    if (!keyMatchFound && !valMatchFound) continue;
                    return true;
                }
                if (!this.caseSensitive) {
                    key = key.toLowerCase(Locale.ENGLISH);
                    value = value.toLowerCase(Locale.ENGLISH);
                }
                value = Normalizer.normalize(value, Normalizer.Form.NFC);
                if (key.indexOf(this.search) == -1 && value.indexOf(this.search) == -1) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return this.search;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.caseSensitive ? 1231 : 1237);
            result = 31 * result + (this.search == null ? 0 : this.search.hashCode());
            result = 31 * result + (this.searchRegex == null ? 0 : this.searchRegex.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Any other = (Any)obj;
            if (this.caseSensitive != other.caseSensitive) {
                return false;
            }
            if (this.search == null ? other.search != null : !this.search.equals(other.search)) {
                return false;
            }
            return !(this.searchRegex == null ? other.searchRegex != null : !this.searchRegex.equals(other.searchRegex));
        }
    }

    public static class ExactKeyValue
    extends TaggedMatch {
        private final String key;
        private final String value;
        private final Pattern keyPattern;
        private final Pattern valuePattern;
        private final Mode mode;

        public ExactKeyValue(boolean regexp, String key, String value) throws SearchParseError {
            if ("".equals(key)) {
                throw new SearchParseError(I18n.tr("Key cannot be empty when tag operator is used. Sample use: key=value", new Object[0]));
            }
            this.key = key;
            String string = this.value = value == null ? "" : value;
            this.mode = "".equals(this.value) && "*".equals(key) ? Mode.NONE : ("".equals(this.value) ? (regexp ? Mode.MISSING_KEY_REGEXP : Mode.MISSING_KEY) : ("*".equals(key) && "*".equals(this.value) ? Mode.ANY : ("*".equals(key) ? (regexp ? Mode.ANY_KEY_REGEXP : Mode.ANY_KEY) : ("*".equals(this.value) ? (regexp ? Mode.ANY_VALUE_REGEXP : Mode.ANY_VALUE) : (regexp ? Mode.EXACT_REGEXP : Mode.EXACT)))));
            this.keyPattern = regexp && !key.isEmpty() && !"*".equals(key) ? ExactKeyValue.compilePattern(key, SearchCompiler.regexFlags(false)) : null;
            this.valuePattern = regexp && !this.value.isEmpty() && !"*".equals(this.value) ? ExactKeyValue.compilePattern(this.value, SearchCompiler.regexFlags(false)) : null;
        }

        @Override
        public boolean match(Tagged osm) {
            if (!osm.hasKeys()) {
                return this.mode == Mode.NONE;
            }
            switch (this.mode) {
                case NONE: {
                    return false;
                }
                case MISSING_KEY: {
                    return !osm.hasTag(this.key);
                }
                case ANY: {
                    return true;
                }
                case ANY_VALUE: {
                    return osm.hasTag(this.key);
                }
                case ANY_KEY: {
                    for (String v : osm.getKeys().values()) {
                        if (!v.equals(this.value)) continue;
                        return true;
                    }
                    return false;
                }
                case EXACT: {
                    return this.value.equals(osm.get(this.key));
                }
                case ANY_KEY_REGEXP: {
                    for (String v : osm.getKeys().values()) {
                        if (!this.valuePattern.matcher(v).matches()) continue;
                        return true;
                    }
                    return false;
                }
                case ANY_VALUE_REGEXP: 
                case EXACT_REGEXP: {
                    for (String k : osm.keySet()) {
                        if (!this.keyPattern.matcher(k).matches() || this.mode != Mode.ANY_VALUE_REGEXP && !this.valuePattern.matcher(osm.get(k)).matches()) continue;
                        return true;
                    }
                    return false;
                }
                case MISSING_KEY_REGEXP: {
                    for (String k : osm.keySet()) {
                        if (!this.keyPattern.matcher(k).matches()) continue;
                        return false;
                    }
                    return true;
                }
            }
            throw new AssertionError((Object)"Missed state");
        }

        public String toString() {
            return this.key + '=' + this.value;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
            result = 31 * result + (this.keyPattern == null ? 0 : this.keyPattern.hashCode());
            result = 31 * result + (this.mode == null ? 0 : this.mode.hashCode());
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            result = 31 * result + (this.valuePattern == null ? 0 : this.valuePattern.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            ExactKeyValue other = (ExactKeyValue)obj;
            if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
                return false;
            }
            if (this.keyPattern == null ? other.keyPattern != null : !this.keyPattern.equals(other.keyPattern)) {
                return false;
            }
            if (this.mode != other.mode) {
                return false;
            }
            if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
                return false;
            }
            return !(this.valuePattern == null ? other.valuePattern != null : !this.valuePattern.equals(other.valuePattern));
        }

        static enum Mode {
            ANY,
            ANY_KEY,
            ANY_VALUE,
            EXACT,
            NONE,
            MISSING_KEY,
            ANY_KEY_REGEXP,
            ANY_VALUE_REGEXP,
            EXACT_REGEXP,
            MISSING_KEY_REGEXP;

        }
    }

    public static class ValueComparison
    extends TaggedMatch {
        private final String key;
        private final String referenceValue;
        private final Double referenceNumber;
        private final int compareMode;
        private static final Pattern ISO8601 = Pattern.compile("\\d+-\\d+-\\d+");

        public ValueComparison(String key, String referenceValue, int compareMode) {
            this.key = key;
            this.referenceValue = referenceValue;
            Double v = null;
            try {
                if (referenceValue != null) {
                    v = Double.valueOf(referenceValue);
                }
            }
            catch (NumberFormatException ignore) {
                Logging.trace(ignore);
            }
            this.referenceNumber = v;
            this.compareMode = compareMode;
        }

        @Override
        public boolean match(Tagged osm) {
            int compareResult;
            String currentValue = osm.get(this.key);
            if (currentValue == null) {
                return false;
            }
            if (ISO8601.matcher(currentValue).matches() || ISO8601.matcher(this.referenceValue).matches()) {
                compareResult = currentValue.compareTo(this.referenceValue);
            } else if (this.referenceNumber != null) {
                try {
                    compareResult = Double.compare(Double.parseDouble(currentValue), this.referenceNumber);
                }
                catch (NumberFormatException ignore) {
                    return false;
                }
            } else {
                compareResult = AlphanumComparator.getInstance().compare(currentValue, this.referenceValue);
            }
            return this.compareMode < 0 ? compareResult < 0 : (this.compareMode > 0 ? compareResult > 0 : compareResult == 0);
        }

        public String toString() {
            return this.key + (this.compareMode == -1 ? "<" : (this.compareMode == 1 ? ">" : "")) + this.referenceValue;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.compareMode;
            result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
            result = 31 * result + (this.referenceNumber == null ? 0 : this.referenceNumber.hashCode());
            result = 31 * result + (this.referenceValue == null ? 0 : this.referenceValue.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            ValueComparison other = (ValueComparison)obj;
            if (this.compareMode != other.compareMode) {
                return false;
            }
            if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
                return false;
            }
            if (this.referenceNumber == null ? other.referenceNumber != null : !this.referenceNumber.equals(other.referenceNumber)) {
                return false;
            }
            return !(this.referenceValue == null ? other.referenceValue != null : !this.referenceValue.equals(other.referenceValue));
        }
    }

    private static class KeyValue
    extends TaggedMatch {
        private final String key;
        private final Pattern keyPattern;
        private final String value;
        private final Pattern valuePattern;
        private final boolean caseSensitive;

        KeyValue(String key, String value, boolean regexSearch, boolean caseSensitive) throws SearchParseError {
            this.caseSensitive = caseSensitive;
            if (regexSearch) {
                int searchFlags = SearchCompiler.regexFlags(caseSensitive);
                this.keyPattern = KeyValue.compilePattern(key, searchFlags);
                this.valuePattern = KeyValue.compilePattern(value, searchFlags);
                this.key = key;
                this.value = value;
            } else {
                this.key = key;
                this.value = value;
                this.keyPattern = null;
                this.valuePattern = null;
            }
        }

        @Override
        public boolean match(Tagged osm) {
            if (this.keyPattern != null) {
                if (!osm.hasKeys()) {
                    return false;
                }
                for (String k : osm.keySet()) {
                    Matcher matcherValue;
                    boolean matchedValue;
                    String v = osm.get(k);
                    Matcher matcherKey = this.keyPattern.matcher(k);
                    boolean matchedKey = matcherKey.find();
                    if (!matchedKey || !(matchedValue = (matcherValue = this.valuePattern.matcher(v)).find())) continue;
                    return true;
                }
            } else {
                String mv;
                if ("timestamp".equals(this.key) && osm instanceof OsmPrimitive) {
                    mv = DateUtils.fromTimestamp(((OsmPrimitive)osm).getRawTimestamp());
                } else {
                    mv = osm.get(this.key);
                    if (!this.caseSensitive && mv == null) {
                        for (String k : osm.keySet()) {
                            if (!this.key.equalsIgnoreCase(k)) continue;
                            mv = osm.get(k);
                            break;
                        }
                    }
                }
                if (mv == null) {
                    return false;
                }
                String v1 = this.caseSensitive ? mv : mv.toLowerCase(Locale.ENGLISH);
                String v2 = this.caseSensitive ? this.value : this.value.toLowerCase(Locale.ENGLISH);
                v1 = Normalizer.normalize(v1, Normalizer.Form.NFC);
                v2 = Normalizer.normalize(v2, Normalizer.Form.NFC);
                return v1.indexOf(v2) != -1;
            }
            return false;
        }

        public String toString() {
            return this.key + '=' + this.value;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.caseSensitive ? 1231 : 1237);
            result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
            result = 31 * result + (this.keyPattern == null ? 0 : this.keyPattern.hashCode());
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            result = 31 * result + (this.valuePattern == null ? 0 : this.valuePattern.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            KeyValue other = (KeyValue)obj;
            if (this.caseSensitive != other.caseSensitive) {
                return false;
            }
            if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
                return false;
            }
            if (this.keyPattern == null ? other.keyPattern != null : !this.keyPattern.equals(other.keyPattern)) {
                return false;
            }
            if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
                return false;
            }
            return !(this.valuePattern == null ? other.valuePattern != null : !this.valuePattern.equals(other.valuePattern));
        }
    }

    private static class Version
    extends RangeMatch {
        Version(PushbackTokenizer.Range range) {
            super(range);
        }

        Version(PushbackTokenizer tokenizer) throws SearchParseError {
            this(tokenizer.readRange(I18n.tr("Range of versions expected", new Object[0])));
        }

        @Override
        protected Long getNumber(OsmPrimitive osm) {
            return osm.getVersion();
        }

        @Override
        protected String getString() {
            return "version";
        }
    }

    private static class ChangesetId
    extends RangeMatch {
        ChangesetId(PushbackTokenizer.Range range) {
            super(range);
        }

        ChangesetId(PushbackTokenizer tokenizer) throws SearchParseError {
            this(tokenizer.readRange(I18n.tr("Range of changeset ids expected", new Object[0])));
        }

        @Override
        protected Long getNumber(OsmPrimitive osm) {
            return osm.getChangesetId();
        }

        @Override
        protected String getString() {
            return "changeset";
        }
    }

    private static class Id
    extends RangeMatch {
        Id(PushbackTokenizer.Range range) {
            super(range);
        }

        Id(PushbackTokenizer tokenizer) throws SearchParseError {
            this(tokenizer.readRange(I18n.tr("Range of primitive ids expected", new Object[0])));
        }

        @Override
        protected Long getNumber(OsmPrimitive osm) {
            return osm.isNew() ? 0L : osm.getUniqueId();
        }

        @Override
        protected String getString() {
            return "id";
        }
    }

    public static class Xor
    extends AbstractBinaryMatch {
        public Xor(Match lhs, Match rhs) {
            super(lhs, rhs);
        }

        @Override
        public boolean match(OsmPrimitive osm) {
            return this.lhs.match(osm) ^ this.rhs.match(osm);
        }

        @Override
        public boolean match(Tagged osm) {
            return this.lhs.match(osm) ^ this.rhs.match(osm);
        }

        public String toString() {
            return (this.lhs instanceof AbstractBinaryMatch && !(this.lhs instanceof Xor) ? Xor.parenthesis(this.lhs) : this.lhs) + " ^ " + (this.rhs instanceof AbstractBinaryMatch && !(this.rhs instanceof Xor) ? Xor.parenthesis(this.rhs) : this.rhs);
        }
    }

    public static class Or
    extends AbstractBinaryMatch {
        public Or(Match lhs, Match rhs) {
            super(lhs, rhs);
        }

        @Override
        public boolean match(OsmPrimitive osm) {
            return this.lhs.match(osm) || this.rhs.match(osm);
        }

        @Override
        public boolean match(Tagged osm) {
            return this.lhs.match(osm) || this.rhs.match(osm);
        }

        public String toString() {
            return (this.lhs instanceof AbstractBinaryMatch && !(this.lhs instanceof Or) ? Or.parenthesis(this.lhs) : this.lhs) + " || " + (this.rhs instanceof AbstractBinaryMatch && !(this.rhs instanceof Or) ? Or.parenthesis(this.rhs) : this.rhs);
        }
    }

    public static class And
    extends AbstractBinaryMatch {
        public And(Match lhs, Match rhs) {
            super(lhs, rhs);
        }

        @Override
        public boolean match(OsmPrimitive osm) {
            return this.lhs.match(osm) && this.rhs.match(osm);
        }

        @Override
        public boolean match(Tagged osm) {
            return this.lhs.match(osm) && this.rhs.match(osm);
        }

        public String toString() {
            return (this.lhs instanceof AbstractBinaryMatch && !(this.lhs instanceof And) ? And.parenthesis(this.lhs) : this.lhs) + " && " + (this.rhs instanceof AbstractBinaryMatch && !(this.rhs instanceof And) ? And.parenthesis(this.rhs) : this.rhs);
        }
    }

    private static class BooleanMatch
    extends TaggedMatch {
        private final String key;
        private final boolean defaultValue;

        BooleanMatch(String key, boolean defaultValue) {
            this.key = key;
            this.defaultValue = defaultValue;
        }

        @Override
        public boolean match(Tagged osm) {
            return Optional.ofNullable(OsmUtils.getOsmBoolean(osm.get(this.key))).orElse(this.defaultValue);
        }

        public String toString() {
            return this.key + '?';
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.defaultValue ? 1231 : 1237);
            result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            BooleanMatch other = (BooleanMatch)obj;
            if (this.defaultValue != other.defaultValue) {
                return false;
            }
            return !(this.key == null ? other.key != null : !this.key.equals(other.key));
        }
    }

    public static class Not
    extends UnaryMatch {
        public Not(Match match) {
            super(match);
        }

        @Override
        public boolean match(OsmPrimitive osm) {
            return !this.match.match(osm);
        }

        @Override
        public boolean match(Tagged osm) {
            return !this.match.match(osm);
        }

        public String toString() {
            return '!' + this.match.toString();
        }

        public Match getMatch() {
            return this.match;
        }
    }

    public static class Never
    extends TaggedMatch {
        public static final Never INSTANCE = new Never();

        @Override
        public boolean match(Tagged osm) {
            return false;
        }
    }

    public static class Always
    extends TaggedMatch {
        public static final Always INSTANCE = new Always();

        @Override
        public boolean match(Tagged osm) {
            return true;
        }
    }

    public static abstract class AbstractBinaryMatch
    extends Match {
        protected final Match lhs;
        protected final Match rhs;

        public AbstractBinaryMatch(Match lhs, Match rhs) {
            this.lhs = lhs;
            this.rhs = rhs;
        }

        public final Match getLhs() {
            return this.lhs;
        }

        public final Match getRhs() {
            return this.rhs;
        }

        protected static String parenthesis(Match m) {
            return '(' + m.toString() + ')';
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.lhs == null ? 0 : this.lhs.hashCode());
            result = 31 * result + (this.rhs == null ? 0 : this.rhs.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            AbstractBinaryMatch other = (AbstractBinaryMatch)obj;
            if (this.lhs == null ? other.lhs != null : !this.lhs.equals(other.lhs)) {
                return false;
            }
            return !(this.rhs == null ? other.rhs != null : !this.rhs.equals(other.rhs));
        }
    }

    public static abstract class UnaryMatch
    extends Match {
        protected final Match match;

        public UnaryMatch(Match match) {
            this.match = match == null ? Always.INSTANCE : match;
        }

        public Match getOperand() {
            return this.match;
        }

        public int hashCode() {
            return 31 + (this.match == null ? 0 : this.match.hashCode());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            UnaryMatch other = (UnaryMatch)obj;
            return !(this.match == null ? other.match != null : !this.match.equals(other.match));
        }
    }

    public static abstract class TaggedMatch
    extends Match {
        @Override
        public abstract boolean match(Tagged var1);

        @Override
        public final boolean match(OsmPrimitive osm) {
            return this.match((Tagged)osm);
        }

        protected static Pattern compilePattern(String regex, int flags) throws SearchParseError {
            try {
                return Pattern.compile(regex, flags);
            }
            catch (PatternSyntaxException e) {
                throw new SearchParseError(I18n.tr(rxErrorMsg, e.getPattern(), e.getIndex(), e.getMessage()), e);
            }
            catch (IllegalArgumentException | StringIndexOutOfBoundsException e) {
                throw new SearchParseError(I18n.tr(rxErrorMsgNoPos, regex, e.getMessage()), e);
            }
        }
    }

    public static abstract class Match
    implements Predicate<OsmPrimitive> {
        public abstract boolean match(OsmPrimitive var1);

        public boolean match(Tagged tagged) {
            return tagged instanceof OsmPrimitive && this.match((OsmPrimitive)tagged);
        }

        @Override
        public final boolean test(OsmPrimitive object) {
            return this.match(object);
        }
    }

    public static interface BinaryMatchFactory
    extends MatchFactory {
        public AbstractBinaryMatch get(String var1, Match var2, Match var3, PushbackTokenizer var4) throws SearchParseError;
    }

    public static interface UnaryMatchFactory
    extends MatchFactory {
        public UnaryMatch get(String var1, Match var2, PushbackTokenizer var3) throws SearchParseError;
    }

    public static interface SimpleMatchFactory
    extends MatchFactory {
        public Match get(String var1, boolean var2, boolean var3, PushbackTokenizer var4) throws SearchParseError;
    }

    @FunctionalInterface
    private static interface MatchFactory {
        public Collection<String> getKeywords();
    }

    public static class CoreUnaryMatchFactory
    implements UnaryMatchFactory {
        private static Collection<String> keywords = Arrays.asList("parent", "child");

        @Override
        public UnaryMatch get(String keyword, Match matchOperand, PushbackTokenizer tokenizer) {
            if ("parent".equals(keyword)) {
                return new Parent(matchOperand);
            }
            if ("child".equals(keyword)) {
                return new Child(matchOperand);
            }
            return null;
        }

        @Override
        public Collection<String> getKeywords() {
            return keywords;
        }
    }

    public static class CoreSimpleMatchFactory
    implements SimpleMatchFactory {
        private final Collection<String> keywords = Arrays.asList("id", "version", "type", "user", "role", "changeset", "nodes", "ways", "tags", "areasize", "waylength", "modified", "deleted", "selected", "incomplete", "untagged", "closed", "new", "indownloadedarea", "allindownloadedarea", "timestamp", "nth", "nth%", "hasRole", "preset");

        @Override
        public Match get(String keyword, boolean caseSensitive, boolean regexSearch, PushbackTokenizer tokenizer) throws SearchParseError {
            switch (keyword) {
                case "modified": {
                    return new Modified();
                }
                case "deleted": {
                    return new Deleted();
                }
                case "selected": {
                    return new Selected();
                }
                case "incomplete": {
                    return new Incomplete();
                }
                case "untagged": {
                    return new Untagged();
                }
                case "closed": {
                    return new Closed();
                }
                case "new": {
                    return new New();
                }
                case "indownloadedarea": {
                    return new InDataSourceArea(false);
                }
                case "allindownloadedarea": {
                    return new InDataSourceArea(true);
                }
            }
            if (tokenizer != null) {
                switch (keyword) {
                    case "id": {
                        return new Id(tokenizer);
                    }
                    case "version": {
                        return new Version(tokenizer);
                    }
                    case "type": {
                        return new ExactType(tokenizer.readTextOrNumber());
                    }
                    case "preset": {
                        return new Preset(tokenizer.readTextOrNumber());
                    }
                    case "user": {
                        return new UserMatch(tokenizer.readTextOrNumber());
                    }
                    case "role": {
                        return new RoleMatch(tokenizer.readTextOrNumber());
                    }
                    case "changeset": {
                        return new ChangesetId(tokenizer);
                    }
                    case "nodes": {
                        return new NodeCountRange(tokenizer);
                    }
                    case "ways": {
                        return new WayCountRange(tokenizer);
                    }
                    case "tags": {
                        return new TagCountRange(tokenizer);
                    }
                    case "areasize": {
                        return new AreaSize(tokenizer);
                    }
                    case "waylength": {
                        return new WayLength(tokenizer);
                    }
                    case "nth": {
                        return new Nth(tokenizer, false);
                    }
                    case "nth%": {
                        return new Nth(tokenizer, true);
                    }
                    case "hasRole": {
                        return new HasRole(tokenizer);
                    }
                    case "timestamp": {
                        String rangeS = ' ' + tokenizer.readTextOrNumber() + ' ';
                        String[] rangeA = rangeS.split("/");
                        if (rangeA.length == 1) {
                            return new KeyValue(keyword, rangeS.trim(), regexSearch, caseSensitive);
                        }
                        if (rangeA.length == 2) {
                            long maxDate;
                            long minDate;
                            String rangeA1 = rangeA[0].trim();
                            String rangeA2 = rangeA[1].trim();
                            try {
                                minDate = DateUtils.fromString(rangeA1.isEmpty() ? "1980" : rangeA1).getTime();
                            }
                            catch (UncheckedParseException ex) {
                                throw new SearchParseError(I18n.tr("Cannot parse timestamp ''{0}''", rangeA1), ex);
                            }
                            try {
                                maxDate = rangeA2.isEmpty() ? System.currentTimeMillis() : DateUtils.fromString(rangeA2).getTime();
                            }
                            catch (UncheckedParseException ex) {
                                throw new SearchParseError(I18n.tr("Cannot parse timestamp ''{0}''", rangeA2), ex);
                            }
                            return new TimestampRange(minDate, maxDate);
                        }
                        throw new SearchParseError("<html>" + I18n.tr("Expecting {0} after {1}", "<i>min</i>/<i>max</i>", "<i>timestamp</i>") + "</html>");
                    }
                }
            } else {
                throw new SearchParseError("<html>" + I18n.tr("Expecting {0} after {1}", "<code>:</code>", "<i>" + keyword + "</i>") + "</html>");
            }
            throw new IllegalStateException("Not expecting keyword " + keyword);
        }

        @Override
        public Collection<String> getKeywords() {
            return this.keywords;
        }
    }
}

