/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.DefaultListSelectionModel;
import javax.swing.FocusManager;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.openstreetmap.josm.actions.ExpertToggleAction;
import org.openstreetmap.josm.actions.relation.AddSelectionToRelations;
import org.openstreetmap.josm.actions.relation.DeleteRelationsAction;
import org.openstreetmap.josm.actions.relation.DuplicateRelationAction;
import org.openstreetmap.josm.actions.relation.EditRelationAction;
import org.openstreetmap.josm.actions.relation.ExportRelationToGpxAction;
import org.openstreetmap.josm.actions.relation.RecentRelationsAction;
import org.openstreetmap.josm.actions.relation.SelectInRelationListAction;
import org.openstreetmap.josm.actions.relation.SelectRelationAction;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DefaultNameFormatter;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.IRelation;
import org.openstreetmap.josm.data.osm.OsmData;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListener;
import org.openstreetmap.josm.data.osm.event.DatasetEventManager;
import org.openstreetmap.josm.data.osm.event.NodeMovedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesAddedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesRemovedEvent;
import org.openstreetmap.josm.data.osm.event.RelationMembersChangedEvent;
import org.openstreetmap.josm.data.osm.event.SelectionEventManager;
import org.openstreetmap.josm.data.osm.event.TagsChangedEvent;
import org.openstreetmap.josm.data.osm.event.WayNodesChangedEvent;
import org.openstreetmap.josm.data.osm.search.SearchCompiler;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.PopupMenuHandler;
import org.openstreetmap.josm.gui.PrimitiveRenderer;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.dialogs.relation.RelationEditor;
import org.openstreetmap.josm.gui.dialogs.relation.RelationPopupMenus;
import org.openstreetmap.josm.gui.layer.LayerManager;
import org.openstreetmap.josm.gui.layer.MainLayerManager;
import org.openstreetmap.josm.gui.util.HighlightHelper;
import org.openstreetmap.josm.gui.widgets.CompileSearchTextDecorator;
import org.openstreetmap.josm.gui.widgets.DisableShortcutsOnFocusGainedTextField;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.InputMapUtils;
import org.openstreetmap.josm.tools.PlatformManager;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.SubclassFilteredCollection;
import org.openstreetmap.josm.tools.Utils;

public class RelationListDialog
extends ToggleDialog
implements DataSetListener,
NavigatableComponent.ZoomChangeListener {
    private final JList<IRelation<?>> displaylist;
    private final RelationListModel model;
    private final NewAction newAction;
    private final JPopupMenu popupMenu = new JPopupMenu();
    private final transient PopupMenuHandler popupMenuHandler = new PopupMenuHandler(this.popupMenu);
    private final JosmTextField filter;
    private final EditRelationAction editAction = new EditRelationAction();
    private final DeleteRelationsAction deleteRelationsAction = new DeleteRelationsAction();
    private final DuplicateRelationAction duplicateAction = new DuplicateRelationAction();
    private final SelectRelationAction selectRelationAction = new SelectRelationAction(false);
    private final AddSelectionToRelations addSelectionToRelations = new AddSelectionToRelations();
    private final ExportRelationToGpxAction exportRelationFromFirstAction = new ExportRelationToGpxAction(EnumSet.of(ExportRelationToGpxAction.Mode.FROM_FIRST_MEMBER, ExportRelationToGpxAction.Mode.TO_FILE));
    private final ExportRelationToGpxAction exportRelationFromLastAction = new ExportRelationToGpxAction(EnumSet.of(ExportRelationToGpxAction.Mode.FROM_LAST_MEMBER, ExportRelationToGpxAction.Mode.TO_FILE));
    private final ExportRelationToGpxAction exportRelationFromFirstToLayerAction = new ExportRelationToGpxAction(EnumSet.of(ExportRelationToGpxAction.Mode.FROM_FIRST_MEMBER, ExportRelationToGpxAction.Mode.TO_LAYER));
    private final ExportRelationToGpxAction exportRelationFromLastToLayerAction = new ExportRelationToGpxAction(EnumSet.of(ExportRelationToGpxAction.Mode.FROM_LAST_MEMBER, ExportRelationToGpxAction.Mode.TO_LAYER));
    private final transient HighlightHelper highlightHelper = new HighlightHelper();
    private final boolean highlightEnabled = Config.getPref().getBoolean("draw.target-highlight", true);
    private final transient RecentRelationsAction recentRelationsAction;

    public RelationListDialog() {
        super(I18n.tr("Relations", new Object[0]), "relationlist", I18n.tr("Open a list of all relations.", new Object[0]), Shortcut.registerShortcut("subwindow:relations", I18n.tr("Toggle: {0}", I18n.tr("Relations", new Object[0])), 82, 5007), 150, true);
        DefaultListSelectionModel selectionModel = new DefaultListSelectionModel();
        this.model = new RelationListModel(selectionModel);
        this.displaylist = new JList(this.model);
        this.displaylist.setSelectionModel(selectionModel);
        this.displaylist.setCellRenderer(new NoTooltipOsmRenderer());
        this.displaylist.setSelectionMode(2);
        this.displaylist.addMouseListener(new MouseEventHandler());
        this.newAction = new NewAction();
        this.filter = this.setupFilter();
        this.displaylist.addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                this.updateActionsRelationLists();
            }
        });
        this.setupPopupMenuHandler();
        JPanel pane = new JPanel(new BorderLayout());
        pane.add((Component)this.filter, "North");
        pane.add((Component)new JScrollPane(this.displaylist), "Center");
        SideButton editButton = new SideButton((Action)this.editAction, false);
        this.recentRelationsAction = new RecentRelationsAction(editButton);
        this.createLayout(pane, false, Arrays.asList(new SideButton((Action)this.newAction, false), editButton, new SideButton((Action)this.duplicateAction, false), new SideButton((Action)this.deleteRelationsAction, false), new SideButton((Action)this.selectRelationAction, false)));
        InputMapUtils.unassignCtrlShiftUpDown(this.displaylist, 0);
        InputMapUtils.addEnterAction(this.displaylist, this.selectRelationAction);
        this.displaylist.getActionMap().put("edit", this.editAction);
        this.displaylist.getInputMap().put(KeyStroke.getKeyStroke(10, 128), "edit");
        this.displaylist.getActionMap().put("copy", MainApplication.getMenu().copy);
        this.displaylist.getInputMap().put(KeyStroke.getKeyStroke(67, PlatformManager.getPlatform().getMenuShortcutKeyMaskEx()), "copy");
        this.updateActionsRelationLists();
    }

    @Override
    public void destroy() {
        this.recentRelationsAction.destroy();
        this.popupMenuHandler.setPrimitives(Collections.emptyList());
        this.model.clear();
        super.destroy();
    }

    public void enableRecentRelations() {
        this.recentRelationsAction.enableArrow();
    }

    private void updateActionsRelationLists() {
        List<IRelation<?>> sel = this.model.getSelectedRelations();
        this.popupMenuHandler.setPrimitives(sel);
        this.selectRelationAction.setPrimitives(sel);
        Component focused = FocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (this.highlightEnabled && focused == this.displaylist && MainApplication.isDisplayingMapView() && this.highlightHelper.highlightOnly(Utils.filteredCollection(sel, Relation.class))) {
            MainApplication.getMap().mapView.repaint();
        }
    }

    @Override
    public void showNotify() {
        MainApplication.getLayerManager().addLayerChangeListener(this.newAction);
        MainApplication.getLayerManager().addActiveLayerChangeListener(this.newAction);
        MapView.addZoomChangeListener(this);
        this.newAction.updateEnabledState();
        DatasetEventManager.getInstance().addDatasetListener(this, DatasetEventManager.FireMode.IN_EDT);
        SelectionEventManager.getInstance().addSelectionListener(this.addSelectionToRelations);
        this.dataChanged(null);
    }

    @Override
    public void hideNotify() {
        MainApplication.getLayerManager().removeActiveLayerChangeListener(this.newAction);
        MainApplication.getLayerManager().removeLayerChangeListener(this.newAction);
        MapView.removeZoomChangeListener(this);
        DatasetEventManager.getInstance().removeDatasetListener(this);
        SelectionEventManager.getInstance().removeSelectionListener(this.addSelectionToRelations);
    }

    private void resetFilter() {
        this.filter.setText(null);
    }

    protected void initFromData(OsmData<?, ?, ?, ?> data) {
        if (data == null) {
            this.model.setRelations(null);
            return;
        }
        this.model.setRelations(data.getRelations());
        this.model.updateTitle();
        this.updateActionsRelationLists();
    }

    private IRelation<?> getSelected() {
        if (this.model.getSize() == 1) {
            this.displaylist.setSelectedIndex(0);
        }
        return this.displaylist.getSelectedValue();
    }

    public void selectRelation(Relation relation) {
        this.selectRelations(Collections.singleton(relation));
    }

    public void selectRelations(Collection<? extends IRelation<?>> relations) {
        if (relations == null || relations.isEmpty()) {
            this.model.setSelectedRelations(null);
        } else {
            this.model.setSelectedRelations(relations);
            Integer i = this.model.getVisibleRelationIndex(relations.iterator().next());
            if (i != null) {
                this.displaylist.scrollRectToVisible(this.displaylist.getCellBounds(i, i));
            }
        }
    }

    private JosmTextField setupFilter() {
        DisableShortcutsOnFocusGainedTextField f = new DisableShortcutsOnFocusGainedTextField();
        f.setToolTipText(I18n.tr("Relation list filter", new Object[0]));
        CompileSearchTextDecorator decorator = CompileSearchTextDecorator.decorate(f);
        f.addPropertyChangeListener("filter", evt -> this.model.setFilter(decorator.getMatch()));
        return f;
    }

    private void setupPopupMenuHandler() {
        final ArrayList<JMenuItem> checkDisabled = new ArrayList<JMenuItem>();
        RelationPopupMenus.setupHandler(this.popupMenuHandler, SelectInRelationListAction.class);
        this.popupMenuHandler.addSeparator();
        checkDisabled.add(this.popupMenuHandler.addAction(this.exportRelationFromFirstAction));
        checkDisabled.add(this.popupMenuHandler.addAction(this.exportRelationFromLastAction));
        this.popupMenuHandler.addSeparator();
        checkDisabled.add(this.popupMenuHandler.addAction(this.exportRelationFromFirstToLayerAction));
        checkDisabled.add(this.popupMenuHandler.addAction(this.exportRelationFromLastToLayerAction));
        this.popupMenuHandler.addSeparator();
        this.popupMenuHandler.addAction(this.editAction).setVisible(false);
        this.popupMenuHandler.addAction(this.duplicateAction).setVisible(false);
        this.popupMenuHandler.addAction(this.deleteRelationsAction).setVisible(false);
        ExpertToggleAction.addVisibilitySwitcher(this.popupMenuHandler.addAction(this.addSelectionToRelations));
        this.popupMenuHandler.addListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                for (JMenuItem mi : checkDisabled) {
                    mi.setVisible(mi.getAction().isEnabled());
                    Component sep = RelationListDialog.this.popupMenu.getComponent(Math.max(0, RelationListDialog.this.popupMenu.getComponentIndex(mi) - 1));
                    if (sep instanceof JMenuItem) continue;
                    sep.setVisible(mi.isVisible());
                }
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
    }

    public PopupMenuHandler getPopupMenuHandler() {
        return this.popupMenuHandler;
    }

    public Collection<IRelation<?>> getSelectedRelations() {
        return this.model.getSelectedRelations();
    }

    @Override
    public void nodeMoved(NodeMovedEvent event) {
    }

    @Override
    public void wayNodesChanged(WayNodesChangedEvent event) {
    }

    @Override
    public void primitivesAdded(PrimitivesAddedEvent event) {
        this.model.addRelations(event.getPrimitives());
        this.model.updateTitle();
    }

    @Override
    public void primitivesRemoved(PrimitivesRemovedEvent event) {
        this.model.removeRelations(event.getPrimitives());
        this.model.updateTitle();
    }

    @Override
    public void relationMembersChanged(RelationMembersChangedEvent event) {
        List<IRelation<?>> sel = this.model.getSelectedRelations();
        this.model.sort();
        this.model.setSelectedRelations(sel);
        this.displaylist.repaint();
    }

    @Override
    public void tagsChanged(TagsChangedEvent event) {
        OsmPrimitive prim = event.getPrimitive();
        if (!(prim instanceof Relation)) {
            return;
        }
        List<IRelation<?>> sel = this.model.getSelectedRelations();
        this.model.sort();
        this.model.setSelectedRelations(sel);
        this.displaylist.repaint();
    }

    @Override
    public void dataChanged(DataChangedEvent event) {
        this.initFromData(MainApplication.getLayerManager().getActiveData());
    }

    @Override
    public void otherDatasetChange(AbstractDatasetChangedEvent event) {
        if (event.getType() == AbstractDatasetChangedEvent.DatasetEventType.PRIMITIVE_FLAGS_CHANGED) {
            if (event.getPrimitives().stream().anyMatch(Relation.class::isInstance)) {
                this.initFromData(MainApplication.getLayerManager().getActiveData());
            }
        }
    }

    @Override
    public void zoomChanged() {
        if (this.model.filter != null) {
            this.model.setFilter(this.model.filter);
        }
    }

    private class RelationListModel
    extends AbstractListModel<IRelation<?>> {
        private final transient List<IRelation<?>> relations = new ArrayList();
        private transient List<IRelation<?>> filteredRelations;
        private final DefaultListSelectionModel selectionModel;
        private transient SearchCompiler.Match filter;

        RelationListModel(DefaultListSelectionModel selectionModel) {
            this.selectionModel = selectionModel;
        }

        public void clear() {
            this.relations.clear();
            if (this.filteredRelations != null) {
                this.filteredRelations.clear();
            }
            this.filter = null;
        }

        public void sort() {
            this.relations.sort(DefaultNameFormatter.getInstance().getRelationComparator());
        }

        private boolean isValid(IRelation<?> r) {
            return !r.isDeleted() && !r.isIncomplete();
        }

        public void setRelations(Collection<? extends IRelation<?>> relations) {
            List<IRelation<?>> sel = this.getSelectedRelations();
            this.relations.clear();
            this.filteredRelations = null;
            if (relations == null) {
                this.selectionModel.clearSelection();
                this.fireContentsChanged(this, 0, this.getSize());
                return;
            }
            for (IRelation<?> r : relations) {
                if (!this.isValid(r)) continue;
                this.relations.add(r);
            }
            this.sort();
            this.updateFilteredRelations();
            this.fireIntervalAdded(this, 0, this.getSize());
            this.setSelectedRelations(sel);
        }

        public void addRelations(Collection<? extends OsmPrimitive> addedPrimitives) {
            boolean added = false;
            for (OsmPrimitive osmPrimitive : addedPrimitives) {
                Relation r;
                if (!(osmPrimitive instanceof Relation) || this.relations.contains(r = (Relation)osmPrimitive) || !this.isValid(r)) continue;
                this.relations.add(r);
                added = true;
            }
            if (added) {
                List<IRelation<?>> sel = this.getSelectedRelations();
                this.sort();
                this.updateFilteredRelations();
                this.fireIntervalAdded(this, 0, this.getSize());
                this.setSelectedRelations(sel);
            }
        }

        public void removeRelations(Collection<? extends OsmPrimitive> removedPrimitives) {
            if (removedPrimitives == null) {
                return;
            }
            HashSet<Relation> removedRelations = new HashSet<Relation>();
            for (OsmPrimitive osmPrimitive : removedPrimitives) {
                if (!(osmPrimitive instanceof Relation)) continue;
                removedRelations.add((Relation)osmPrimitive);
            }
            if (removedRelations.isEmpty()) {
                return;
            }
            int size = this.relations.size();
            this.relations.removeAll(removedRelations);
            if (this.filteredRelations != null) {
                this.filteredRelations.removeAll(removedRelations);
            }
            if (size != this.relations.size()) {
                List<IRelation<?>> list = this.getSelectedRelations();
                this.sort();
                this.fireContentsChanged(this, 0, this.getSize());
                this.setSelectedRelations(list);
            }
        }

        private void updateFilteredRelations() {
            if (this.filter != null) {
                this.filteredRelations = new ArrayList(SubclassFilteredCollection.filter(this.relations, this.filter::match));
            } else if (this.filteredRelations != null) {
                this.filteredRelations = null;
            }
        }

        public void setFilter(SearchCompiler.Match filter) {
            this.filter = filter;
            this.updateFilteredRelations();
            List<IRelation<?>> sel = this.getSelectedRelations();
            this.fireContentsChanged(this, 0, this.getSize());
            this.setSelectedRelations(sel);
            this.updateTitle();
        }

        private List<IRelation<?>> getVisibleRelations() {
            return this.filteredRelations == null ? this.relations : this.filteredRelations;
        }

        private IRelation<?> getVisibleRelation(int index) {
            if (index < 0 || index >= this.getVisibleRelations().size()) {
                return null;
            }
            return this.getVisibleRelations().get(index);
        }

        @Override
        public IRelation<?> getElementAt(int index) {
            return this.getVisibleRelation(index);
        }

        @Override
        public int getSize() {
            return this.getVisibleRelations().size();
        }

        public List<IRelation<?>> getSelectedRelations() {
            ArrayList ret = new ArrayList();
            for (int i = 0; i < this.getSize(); ++i) {
                if (!this.selectionModel.isSelectedIndex(i)) continue;
                ret.add(this.getVisibleRelation(i));
            }
            return ret;
        }

        public void setSelectedRelations(Collection<? extends IRelation<?>> sel) {
            this.selectionModel.setValueIsAdjusting(true);
            this.selectionModel.clearSelection();
            if (sel != null && !sel.isEmpty()) {
                if (!this.getVisibleRelations().containsAll(sel)) {
                    RelationListDialog.this.resetFilter();
                }
                for (IRelation<?> r : sel) {
                    Integer i = this.getVisibleRelationIndex(r);
                    if (i == null) continue;
                    this.selectionModel.addSelectionInterval(i, i);
                }
            }
            this.selectionModel.setValueIsAdjusting(false);
        }

        private Integer getVisibleRelationIndex(IRelation<?> rel) {
            int i = this.getVisibleRelations().indexOf(rel);
            if (i < 0) {
                return null;
            }
            return i;
        }

        public void updateTitle() {
            if (!this.relations.isEmpty() && this.relations.size() != this.getSize()) {
                RelationListDialog.this.setTitle(I18n.tr("Relations: {0}/{1}", this.getSize(), this.relations.size()));
            } else if (this.getSize() > 0) {
                RelationListDialog.this.setTitle(I18n.tr("Relations: {0}", this.getSize()));
            } else {
                RelationListDialog.this.setTitle(I18n.tr("Relations", new Object[0]));
            }
        }
    }

    static class NewAction
    extends AbstractAction
    implements LayerManager.LayerChangeListener,
    MainLayerManager.ActiveLayerChangeListener {
        NewAction() {
            this.putValue("ShortDescription", I18n.tr("Create a new relation", new Object[0]));
            this.putValue("Name", I18n.tr("New", new Object[0]));
            new ImageProvider("dialogs", "addrelation").getResource().attachImageIcon(this, true);
            this.updateEnabledState();
        }

        public void run() {
            RelationEditor.getEditor(MainApplication.getLayerManager().getEditLayer(), null, null).setVisible(true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.run();
        }

        protected void updateEnabledState() {
            this.setEnabled(MainApplication.getLayerManager().getEditLayer() != null);
        }

        @Override
        public void activeOrEditLayerChanged(MainLayerManager.ActiveLayerChangeEvent e) {
            this.updateEnabledState();
        }

        @Override
        public void layerAdded(LayerManager.LayerAddEvent e) {
            this.updateEnabledState();
        }

        @Override
        public void layerRemoving(LayerManager.LayerRemoveEvent e) {
            this.updateEnabledState();
        }

        @Override
        public void layerOrderChanged(LayerManager.LayerOrderChangeEvent e) {
        }
    }

    class MouseEventHandler
    extends PopupMenuLauncher {
        MouseEventHandler() {
            super(RelationListDialog.this.popupMenu);
        }

        @Override
        public void mouseExited(MouseEvent me) {
            if (RelationListDialog.this.highlightEnabled) {
                RelationListDialog.this.highlightHelper.clear();
            }
        }

        protected void setCurrentRelationAsSelection() {
            MainApplication.getLayerManager().getActiveData().setSelected((PrimitiveId)RelationListDialog.this.displaylist.getSelectedValue());
        }

        protected void editCurrentRelation() {
            IRelation rel = RelationListDialog.this.getSelected();
            if (rel instanceof Relation) {
                EditRelationAction.launchEditor((Relation)rel);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            DataSet ds = MainApplication.getLayerManager().getActiveDataSet();
            if (ds != null && MouseEventHandler.isDoubleClick(e)) {
                if (e.isControlDown() && !ds.isLocked()) {
                    this.editCurrentRelation();
                } else {
                    this.setCurrentRelationAsSelection();
                }
            }
        }
    }

    static final class NoTooltipOsmRenderer
    extends PrimitiveRenderer {
        NoTooltipOsmRenderer() {
        }

        @Override
        protected String getComponentToolTipText(IPrimitive value) {
            return null;
        }
    }
}

