/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import com.sun.mail.util.ASCIIUtility;
import com.sun.mail.util.BASE64DecoderStream;
import com.sun.mail.util.BASE64EncoderStream;
import com.sun.mail.util.BEncoderStream;
import com.sun.mail.util.LineInputStream;
import com.sun.mail.util.QDecoderStream;
import com.sun.mail.util.QEncoderStream;
import com.sun.mail.util.QPDecoderStream;
import com.sun.mail.util.QPEncoderStream;
import com.sun.mail.util.UUDecoderStream;
import com.sun.mail.util.UUEncoderStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.MessagingException;
import javax.mail.internet.AsciiOutputStream;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeUtility;
import javax.mail.internet.ParseException;

public class MimeUtility {
    public static final int ALL = -1;
    private static boolean decodeStrict;
    private static boolean encodeEolStrict;
    private static boolean foldEncodedWords;
    private static boolean foldText;
    private static String defaultJavaCharset;
    private static String defaultMIMECharset;
    private static Hashtable mime2java;
    private static Hashtable java2mime;
    static final int ALL_ASCII = 1;
    static final int MOSTLY_ASCII = 2;
    static final int MOSTLY_NONASCII = 3;
    static /* synthetic */ Class class$javax$mail$internet$MimeUtility;

    private MimeUtility() {
    }

    public static String getEncoding(DataSource dataSource) {
        ContentType contentType = null;
        InputStream inputStream = null;
        String string = null;
        try {
            contentType = new ContentType(dataSource.getContentType());
            inputStream = dataSource.getInputStream();
        }
        catch (Exception exception) {
            return "base64";
        }
        boolean bl = contentType.match("text/*");
        int n = MimeUtility.checkAscii(inputStream, -1, !bl);
        switch (n) {
            case 1: {
                string = "7bit";
                break;
            }
            case 2: {
                string = "quoted-printable";
                break;
            }
            default: {
                string = "base64";
            }
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string;
    }

    public static String getEncoding(DataHandler dataHandler) {
        ContentType contentType = null;
        String string = null;
        if (dataHandler.getName() != null) {
            return MimeUtility.getEncoding(dataHandler.getDataSource());
        }
        try {
            contentType = new ContentType(dataHandler.getContentType());
        }
        catch (Exception exception) {
            return "base64";
        }
        if (contentType.match("text/*")) {
            AsciiOutputStream asciiOutputStream = new AsciiOutputStream(false, false);
            try {
                dataHandler.writeTo((OutputStream)asciiOutputStream);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            switch (asciiOutputStream.getAscii()) {
                case 1: {
                    string = "7bit";
                    break;
                }
                case 2: {
                    string = "quoted-printable";
                    break;
                }
                default: {
                    string = "base64";
                    break;
                }
            }
        } else {
            AsciiOutputStream asciiOutputStream = new AsciiOutputStream(true, encodeEolStrict);
            try {
                dataHandler.writeTo((OutputStream)asciiOutputStream);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            string = asciiOutputStream.getAscii() == 1 ? "7bit" : "base64";
        }
        return string;
    }

    public static InputStream decode(InputStream inputStream, String string) throws MessagingException {
        if (string.equalsIgnoreCase("base64")) {
            return new BASE64DecoderStream(inputStream);
        }
        if (string.equalsIgnoreCase("quoted-printable")) {
            return new QPDecoderStream(inputStream);
        }
        if (string.equalsIgnoreCase("uuencode") || string.equalsIgnoreCase("x-uuencode") || string.equalsIgnoreCase("x-uue")) {
            return new UUDecoderStream(inputStream);
        }
        if (string.equalsIgnoreCase("binary") || string.equalsIgnoreCase("7bit") || string.equalsIgnoreCase("8bit")) {
            return inputStream;
        }
        throw new MessagingException("Unknown encoding: " + string);
    }

    public static OutputStream encode(OutputStream outputStream, String string) throws MessagingException {
        if (string == null) {
            return outputStream;
        }
        if (string.equalsIgnoreCase("base64")) {
            return new BASE64EncoderStream(outputStream);
        }
        if (string.equalsIgnoreCase("quoted-printable")) {
            return new QPEncoderStream(outputStream);
        }
        if (string.equalsIgnoreCase("uuencode") || string.equalsIgnoreCase("x-uuencode") || string.equalsIgnoreCase("x-uue")) {
            return new UUEncoderStream(outputStream);
        }
        if (string.equalsIgnoreCase("binary") || string.equalsIgnoreCase("7bit") || string.equalsIgnoreCase("8bit")) {
            return outputStream;
        }
        throw new MessagingException("Unknown encoding: " + string);
    }

    public static OutputStream encode(OutputStream outputStream, String string, String string2) throws MessagingException {
        if (string == null) {
            return outputStream;
        }
        if (string.equalsIgnoreCase("base64")) {
            return new BASE64EncoderStream(outputStream);
        }
        if (string.equalsIgnoreCase("quoted-printable")) {
            return new QPEncoderStream(outputStream);
        }
        if (string.equalsIgnoreCase("uuencode") || string.equalsIgnoreCase("x-uuencode") || string.equalsIgnoreCase("x-uue")) {
            return new UUEncoderStream(outputStream, string2);
        }
        if (string.equalsIgnoreCase("binary") || string.equalsIgnoreCase("7bit") || string.equalsIgnoreCase("8bit")) {
            return outputStream;
        }
        throw new MessagingException("Unknown encoding: " + string);
    }

    public static String encodeText(String string) throws UnsupportedEncodingException {
        return MimeUtility.encodeText(string, null, null);
    }

    public static String encodeText(String string, String string2, String string3) throws UnsupportedEncodingException {
        return MimeUtility.encodeWord(string, string2, string3, false);
    }

    public static String decodeText(String string) throws UnsupportedEncodingException {
        String string2 = " \t\n\r";
        if (string.indexOf("=?") == -1) {
            return string;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2, true);
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        boolean bl = false;
        while (stringTokenizer.hasMoreTokens()) {
            String string3;
            String string4 = stringTokenizer.nextToken();
            char c = string4.charAt(0);
            if (c == ' ' || c == '\t' || c == '\r' || c == '\n') {
                stringBuffer2.append(c);
                continue;
            }
            try {
                string3 = MimeUtility.decodeWord(string4);
                if (!bl && stringBuffer2.length() > 0) {
                    stringBuffer.append(stringBuffer2);
                }
                bl = true;
            }
            catch (ParseException parseException) {
                string3 = string4;
                if (!decodeStrict) {
                    String string5 = MimeUtility.decodeInnerWords(string3);
                    if (string5 != string3) {
                        if (!(bl && string3.startsWith("=?") || stringBuffer2.length() <= 0)) {
                            stringBuffer.append(stringBuffer2);
                        }
                        bl = string3.endsWith("?=");
                        string3 = string5;
                    } else {
                        if (stringBuffer2.length() > 0) {
                            stringBuffer.append(stringBuffer2);
                        }
                        bl = false;
                    }
                }
                if (stringBuffer2.length() > 0) {
                    stringBuffer.append(stringBuffer2);
                }
                bl = false;
            }
            stringBuffer.append(string3);
            stringBuffer2.setLength(0);
        }
        stringBuffer.append(stringBuffer2);
        return stringBuffer.toString();
    }

    public static String encodeWord(String string) throws UnsupportedEncodingException {
        return MimeUtility.encodeWord(string, null, null);
    }

    public static String encodeWord(String string, String string2, String string3) throws UnsupportedEncodingException {
        return MimeUtility.encodeWord(string, string2, string3, true);
    }

    private static String encodeWord(String string, String string2, String string3, boolean bl) throws UnsupportedEncodingException {
        boolean bl2;
        String string4;
        int n = MimeUtility.checkAscii(string);
        if (n == 1) {
            return string;
        }
        if (string2 == null) {
            string4 = MimeUtility.getDefaultJavaCharset();
            string2 = MimeUtility.getDefaultMIMECharset();
        } else {
            string4 = MimeUtility.javaCharset(string2);
        }
        if (string3 == null) {
            string3 = n != 3 ? "Q" : "B";
        }
        if (string3.equalsIgnoreCase("B")) {
            bl2 = true;
        } else if (string3.equalsIgnoreCase("Q")) {
            bl2 = false;
        } else {
            throw new UnsupportedEncodingException("Unknown transfer encoding: " + string3);
        }
        StringBuffer stringBuffer = new StringBuffer();
        MimeUtility.doEncode(string, bl2, string4, 68 - string2.length(), "=?" + string2 + "?" + string3 + "?", true, bl, stringBuffer);
        return stringBuffer.toString();
    }

    private static void doEncode(String string, boolean bl, String string2, int n, String string3, boolean bl2, boolean bl3, StringBuffer stringBuffer) throws UnsupportedEncodingException {
        int n2;
        byte[] byArray = string.getBytes(string2);
        int n3 = bl ? BEncoderStream.encodedLength(byArray) : QEncoderStream.encodedLength(byArray, bl3);
        if (n3 > n && (n2 = string.length()) > 1) {
            MimeUtility.doEncode(string.substring(0, n2 / 2), bl, string2, n, string3, bl2, bl3, stringBuffer);
            MimeUtility.doEncode(string.substring(n2 / 2, n2), bl, string2, n, string3, false, bl3, stringBuffer);
        } else {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            FilterOutputStream filterOutputStream = bl ? new BEncoderStream(byteArrayOutputStream) : new QEncoderStream((OutputStream)byteArrayOutputStream, bl3);
            try {
                ((OutputStream)filterOutputStream).write(byArray);
                ((OutputStream)filterOutputStream).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            if (!bl2) {
                if (foldEncodedWords) {
                    stringBuffer.append("\r\n ");
                } else {
                    stringBuffer.append(" ");
                }
            }
            stringBuffer.append(string3);
            int n4 = 0;
            while (n4 < byArray2.length) {
                stringBuffer.append((char)byArray2[n4]);
                ++n4;
            }
            stringBuffer.append("?=");
        }
    }

    public static String decodeWord(String string) throws ParseException, UnsupportedEncodingException {
        if (!string.startsWith("=?")) {
            throw new ParseException("encoded word does not start with \"=?\": " + string);
        }
        int n = 2;
        int n2 = string.indexOf(63, n);
        if (n2 == -1) {
            throw new ParseException("encoded word does not include charset: " + string);
        }
        String string2 = MimeUtility.javaCharset(string.substring(n, n2));
        n = n2 + 1;
        if ((n2 = string.indexOf(63, n)) == -1) {
            throw new ParseException("encoded word does not include encoding: " + string);
        }
        String string3 = string.substring(n, n2);
        n = n2 + 1;
        if ((n2 = string.indexOf("?=", n)) == -1) {
            throw new ParseException("encoded word does not end with \"?=\": " + string);
        }
        String string4 = string.substring(n, n2);
        try {
            String string5;
            Object object;
            if (string4.length() > 0) {
                FilterInputStream filterInputStream;
                object = new ByteArrayInputStream(ASCIIUtility.getBytes(string4));
                if (string3.equalsIgnoreCase("B")) {
                    filterInputStream = new BASE64DecoderStream((InputStream)object);
                } else if (string3.equalsIgnoreCase("Q")) {
                    filterInputStream = new QDecoderStream((InputStream)object);
                } else {
                    throw new UnsupportedEncodingException("unknown encoding: " + string3);
                }
                int n3 = ((ByteArrayInputStream)object).available();
                byte[] byArray = new byte[n3];
                n3 = ((InputStream)filterInputStream).read(byArray, 0, n3);
                string5 = n3 <= 0 ? "" : new String(byArray, 0, n3, string2);
            } else {
                string5 = "";
            }
            if (n2 + 2 < string.length()) {
                object = string.substring(n2 + 2);
                if (!decodeStrict) {
                    object = MimeUtility.decodeInnerWords((String)object);
                }
                string5 = string5 + (String)object;
            }
            return string5;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw unsupportedEncodingException;
        }
        catch (IOException iOException) {
            throw new ParseException(iOException.toString());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new UnsupportedEncodingException(string2);
        }
    }

    private static String decodeInnerWords(String string) throws UnsupportedEncodingException {
        int n;
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = string.indexOf("=?", n2)) >= 0) {
            stringBuffer.append(string.substring(n2, n));
            int n3 = string.indexOf(63, n + 2);
            if (n3 < 0 || (n3 = string.indexOf(63, n3 + 1)) < 0 || (n3 = string.indexOf("?=", n3 + 1)) < 0) break;
            String string2 = string.substring(n, n3 + 2);
            try {
                string2 = MimeUtility.decodeWord(string2);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            stringBuffer.append(string2);
            n2 = n3 + 2;
        }
        if (n2 == 0) {
            return string;
        }
        if (n2 < string.length()) {
            stringBuffer.append(string.substring(n2));
        }
        return stringBuffer.toString();
    }

    public static String quote(String string, String string2) {
        int n = string.length();
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c == '\"' || c == '\\' || c == '\r' || c == '\n') {
                StringBuffer stringBuffer = new StringBuffer(n + 3);
                stringBuffer.append('\"');
                stringBuffer.append(string.substring(0, n2));
                int n3 = 0;
                int n4 = n2;
                while (n4 < n) {
                    char c2 = string.charAt(n4);
                    if (!(c2 != '\"' && c2 != '\\' && c2 != '\r' && c2 != '\n' || c2 == '\n' && n3 == 13)) {
                        stringBuffer.append('\\');
                    }
                    stringBuffer.append(c2);
                    n3 = c2;
                    ++n4;
                }
                stringBuffer.append('\"');
                return stringBuffer.toString();
            }
            if (c < ' ' || c >= '\u007f' || string2.indexOf(c) >= 0) {
                bl = true;
            }
            ++n2;
        }
        if (bl) {
            StringBuffer stringBuffer = new StringBuffer(n + 2);
            stringBuffer.append('\"').append(string).append('\"');
            return stringBuffer.toString();
        }
        return string;
    }

    public static String fold(int n, String string) {
        char c;
        if (!foldText) {
            return string;
        }
        int n2 = string.length() - 1;
        while (n2 >= 0) {
            c = string.charAt(n2);
            if (c != ' ' && c != '\t' && c != '\r' && c != '\n') break;
            --n2;
        }
        if (n2 != string.length() - 1) {
            string = string.substring(0, n2 + 1);
        }
        if (n + string.length() <= 76) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() + 4);
        char c2 = '\u0000';
        while (n + string.length() > 76) {
            int n3 = -1;
            int n4 = 0;
            while (n4 < string.length()) {
                if (n3 != -1 && n + n4 > 76) break;
                c = string.charAt(n4);
                if ((c == ' ' || c == '\t') && c2 != ' ' && c2 != '\t') {
                    n3 = n4;
                }
                c2 = c;
                ++n4;
            }
            if (n3 == -1) {
                stringBuffer.append(string);
                string = "";
                n = 0;
                break;
            }
            stringBuffer.append(string.substring(0, n3));
            stringBuffer.append("\r\n");
            c2 = string.charAt(n3);
            stringBuffer.append(c2);
            string = string.substring(n3 + 1);
            n = 1;
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public static String unfold(String string) {
        int n;
        if (!foldText) {
            return string;
        }
        StringBuffer stringBuffer = null;
        while ((n = MimeUtility.indexOfAny(string, "\r\n")) >= 0) {
            int n2 = n++;
            int n3 = string.length();
            if (n < n3 && string.charAt(n - 1) == '\r' && string.charAt(n) == '\n') {
                ++n;
            }
            if (n2 == 0 || string.charAt(n2 - 1) != '\\') {
                char c;
                if (n < n3 && ((c = string.charAt(n)) == ' ' || c == '\t')) {
                    ++n;
                    while (n < n3 && ((c = string.charAt(n)) == ' ' || c == '\t')) {
                        ++n;
                    }
                    if (stringBuffer == null) {
                        stringBuffer = new StringBuffer(string.length());
                    }
                    if (n2 != 0) {
                        stringBuffer.append(string.substring(0, n2));
                        stringBuffer.append(' ');
                    }
                    string = string.substring(n);
                    continue;
                }
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer(string.length());
                }
                stringBuffer.append(string.substring(0, n));
                string = string.substring(n);
                continue;
            }
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer(string.length());
            }
            stringBuffer.append(string.substring(0, n2 - 1));
            stringBuffer.append(string.substring(n2, n));
            string = string.substring(n);
        }
        if (stringBuffer != null) {
            stringBuffer.append(string);
            return stringBuffer.toString();
        }
        return string;
    }

    private static int indexOfAny(String string, String string2) {
        return MimeUtility.indexOfAny(string, string2, 0);
    }

    private static int indexOfAny(String string, String string2, int n) {
        try {
            int n2 = string.length();
            int n3 = n;
            while (n3 < n2) {
                if (string2.indexOf(string.charAt(n3)) >= 0) {
                    return n3;
                }
                ++n3;
            }
            return -1;
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            return -1;
        }
    }

    public static String javaCharset(String string) {
        if (mime2java == null || string == null) {
            return string;
        }
        String string2 = (String)mime2java.get(string.toLowerCase(Locale.ENGLISH));
        return string2 == null ? string : string2;
    }

    public static String mimeCharset(String string) {
        if (java2mime == null || string == null) {
            return string;
        }
        String string2 = (String)java2mime.get(string.toLowerCase(Locale.ENGLISH));
        return string2 == null ? string : string2;
    }

    public static String getDefaultJavaCharset() {
        block6: {
            if (defaultJavaCharset == null) {
                String string = null;
                try {
                    string = System.getProperty("mail.mime.charset");
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                if (string != null && string.length() > 0) {
                    defaultJavaCharset = MimeUtility.javaCharset(string);
                    return defaultJavaCharset;
                }
                try {
                    defaultJavaCharset = System.getProperty("file.encoding", "8859_1");
                }
                catch (SecurityException securityException) {
                    class NullInputStream
                    extends InputStream {
                        NullInputStream() {
                        }

                        public int read() {
                            return 0;
                        }
                    }
                    InputStreamReader inputStreamReader = new InputStreamReader(new NullInputStream());
                    defaultJavaCharset = inputStreamReader.getEncoding();
                    if (defaultJavaCharset != null) break block6;
                    defaultJavaCharset = "8859_1";
                }
            }
        }
        return defaultJavaCharset;
    }

    static String getDefaultMIMECharset() {
        if (defaultMIMECharset == null) {
            try {
                defaultMIMECharset = System.getProperty("mail.mime.charset");
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        if (defaultMIMECharset == null) {
            defaultMIMECharset = MimeUtility.mimeCharset(MimeUtility.getDefaultJavaCharset());
        }
        return defaultMIMECharset;
    }

    private static void loadMappings(LineInputStream lineInputStream, Hashtable hashtable) {
        while (true) {
            String string;
            try {
                string = lineInputStream.readLine();
            }
            catch (IOException iOException) {
                break;
            }
            if (string == null || string.startsWith("--") && string.endsWith("--")) break;
            if (string.trim().length() == 0 || string.startsWith("#")) continue;
            StringTokenizer stringTokenizer = new StringTokenizer(string, " \t");
            try {
                String string2 = stringTokenizer.nextToken();
                String string3 = stringTokenizer.nextToken();
                hashtable.put(string2.toLowerCase(Locale.ENGLISH), string3);
            }
            catch (NoSuchElementException noSuchElementException) {}
        }
    }

    static int checkAscii(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = string.length();
        int n4 = 0;
        while (n4 < n3) {
            if (MimeUtility.nonascii(string.charAt(n4))) {
                ++n2;
            } else {
                ++n;
            }
            ++n4;
        }
        if (n2 == 0) {
            return 1;
        }
        if (n > n2) {
            return 2;
        }
        return 3;
    }

    static int checkAscii(byte[] byArray) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < byArray.length) {
            if (MimeUtility.nonascii(byArray[n3] & 0xFF)) {
                ++n2;
            } else {
                ++n;
            }
            ++n3;
        }
        if (n2 == 0) {
            return 1;
        }
        if (n > n2) {
            return 2;
        }
        return 3;
    }

    static int checkAscii(InputStream inputStream, int n, boolean bl) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 4096;
        int n5 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = encodeEolStrict && bl;
        byte[] byArray = null;
        if (n != 0) {
            n4 = n == -1 ? 4096 : Math.min(n, 4096);
            byArray = new byte[n4];
        }
        while (n != 0) {
            int n6;
            try {
                n6 = inputStream.read(byArray, 0, n4);
                if (n6 == -1) break;
                int n7 = 0;
                int n8 = 0;
                while (n8 < n6) {
                    int n9 = byArray[n8] & 0xFF;
                    if (bl4 && (n7 == 13 && n9 != 10 || n7 != 13 && n9 == 10)) {
                        bl3 = true;
                    }
                    if (n9 == 13 || n9 == 10) {
                        n5 = 0;
                    } else if (++n5 > 998) {
                        bl2 = true;
                    }
                    if (MimeUtility.nonascii(n9)) {
                        if (bl) {
                            return 3;
                        }
                        ++n3;
                    } else {
                        ++n2;
                    }
                    n7 = n9;
                    ++n8;
                }
            }
            catch (IOException iOException) {
                break;
            }
            if (n == -1) continue;
            n -= n6;
        }
        if (n == 0 && bl) {
            return 3;
        }
        if (n3 == 0) {
            if (bl3) {
                return 3;
            }
            if (bl2) {
                return 2;
            }
            return 1;
        }
        if (n2 > n3) {
            return 2;
        }
        return 3;
    }

    static final boolean nonascii(int n) {
        return n >= 127 || n < 32 && n != 13 && n != 10 && n != 9;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        block11: {
            Object object;
            decodeStrict = true;
            encodeEolStrict = false;
            foldEncodedWords = false;
            foldText = true;
            try {
                object = System.getProperty("mail.mime.decodetext.strict");
                decodeStrict = object == null || !((String)object).equalsIgnoreCase("false");
                object = System.getProperty("mail.mime.encodeeol.strict");
                encodeEolStrict = object != null && ((String)object).equalsIgnoreCase("true");
                object = System.getProperty("mail.mime.foldencodedwords");
                foldEncodedWords = object != null && ((String)object).equalsIgnoreCase("true");
                object = System.getProperty("mail.mime.foldtext");
                foldText = object == null || !((String)object).equalsIgnoreCase("false");
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            java2mime = new Hashtable(40);
            mime2java = new Hashtable(10);
            try {
                object = (class$javax$mail$internet$MimeUtility == null ? (class$javax$mail$internet$MimeUtility = MimeUtility.class$("javax.mail.internet.MimeUtility")) : class$javax$mail$internet$MimeUtility).getResourceAsStream("/META-INF/javamail.charset.map");
                if (object == null) break block11;
                try {
                    object = new LineInputStream((InputStream)object);
                    MimeUtility.loadMappings((LineInputStream)object, java2mime);
                    MimeUtility.loadMappings((LineInputStream)object, mime2java);
                    Object var2_3 = null;
                }
                catch (Throwable throwable) {
                    Object var2_4 = null;
                    try {
                        ((InputStream)object).close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    ((InputStream)object).close();
                }
                catch (Exception exception) {}
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (java2mime.isEmpty()) {
            java2mime.put("8859_1", "ISO-8859-1");
            java2mime.put("iso8859_1", "ISO-8859-1");
            java2mime.put("iso8859-1", "ISO-8859-1");
            java2mime.put("8859_2", "ISO-8859-2");
            java2mime.put("iso8859_2", "ISO-8859-2");
            java2mime.put("iso8859-2", "ISO-8859-2");
            java2mime.put("8859_3", "ISO-8859-3");
            java2mime.put("iso8859_3", "ISO-8859-3");
            java2mime.put("iso8859-3", "ISO-8859-3");
            java2mime.put("8859_4", "ISO-8859-4");
            java2mime.put("iso8859_4", "ISO-8859-4");
            java2mime.put("iso8859-4", "ISO-8859-4");
            java2mime.put("8859_5", "ISO-8859-5");
            java2mime.put("iso8859_5", "ISO-8859-5");
            java2mime.put("iso8859-5", "ISO-8859-5");
            java2mime.put("8859_6", "ISO-8859-6");
            java2mime.put("iso8859_6", "ISO-8859-6");
            java2mime.put("iso8859-6", "ISO-8859-6");
            java2mime.put("8859_7", "ISO-8859-7");
            java2mime.put("iso8859_7", "ISO-8859-7");
            java2mime.put("iso8859-7", "ISO-8859-7");
            java2mime.put("8859_8", "ISO-8859-8");
            java2mime.put("iso8859_8", "ISO-8859-8");
            java2mime.put("iso8859-8", "ISO-8859-8");
            java2mime.put("8859_9", "ISO-8859-9");
            java2mime.put("iso8859_9", "ISO-8859-9");
            java2mime.put("iso8859-9", "ISO-8859-9");
            java2mime.put("sjis", "Shift_JIS");
            java2mime.put("jis", "ISO-2022-JP");
            java2mime.put("iso2022jp", "ISO-2022-JP");
            java2mime.put("euc_jp", "euc-jp");
            java2mime.put("koi8_r", "koi8-r");
            java2mime.put("euc_cn", "euc-cn");
            java2mime.put("euc_tw", "euc-tw");
            java2mime.put("euc_kr", "euc-kr");
        }
        if (mime2java.isEmpty()) {
            mime2java.put("iso-2022-cn", "ISO2022CN");
            mime2java.put("iso-2022-kr", "ISO2022KR");
            mime2java.put("utf-8", "UTF8");
            mime2java.put("utf8", "UTF8");
            mime2java.put("ja_jp.iso2022-7", "ISO2022JP");
            mime2java.put("ja_jp.eucjp", "EUCJIS");
            mime2java.put("euc-kr", "KSC5601");
            mime2java.put("euckr", "KSC5601");
            mime2java.put("us-ascii", "ISO-8859-1");
            mime2java.put("x-us-ascii", "ISO-8859-1");
        }
    }
}

