/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.frame.objectproperty;

import java.util.Comparator;
import java.util.List;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.editor.OWLObjectEditor;
import org.protege.editor.owl.ui.editor.OWLObjectPropertyChainEditor;
import org.protege.editor.owl.ui.frame.AbstractOWLFrameSection;
import org.protege.editor.owl.ui.frame.OWLFrame;
import org.protege.editor.owl.ui.frame.OWLFrameSectionRow;
import org.protege.editor.owl.ui.frame.objectproperty.OWLPropertyChainAxiomFrameSectionRow;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;

public class OWLPropertyChainAxiomFrameSection
extends AbstractOWLFrameSection<OWLObjectProperty, OWLSubPropertyChainOfAxiom, List<OWLObjectPropertyExpression>> {
    public static final String LABEL = "SuperProperty Of (Chain)";

    public OWLPropertyChainAxiomFrameSection(OWLEditorKit owlEditorKit, OWLFrame<? extends OWLObjectProperty> frame) {
        super(owlEditorKit, LABEL, "Property chain", frame);
        this.setCacheEditor(false);
    }

    @Override
    protected void clear() {
    }

    @Override
    protected void refill(OWLOntology ontology) {
        for (OWLSubPropertyChainOfAxiom ax : ontology.getAxioms(AxiomType.SUB_PROPERTY_CHAIN_OF)) {
            if (!ax.getSuperProperty().equals(this.getRootObject())) continue;
            this.addRow(new OWLPropertyChainAxiomFrameSectionRow(this.getOWLEditorKit(), this, ontology, (OWLObjectProperty)this.getRootObject(), ax));
        }
    }

    @Override
    protected OWLSubPropertyChainOfAxiom createAxiom(List<OWLObjectPropertyExpression> object) {
        return this.getOWLDataFactory().getOWLSubPropertyChainOfAxiom(object, (OWLObjectPropertyExpression)this.getRootObject());
    }

    @Override
    public OWLObjectEditor<List<OWLObjectPropertyExpression>> getObjectEditor() {
        OWLObjectPropertyChainEditor editor = new OWLObjectPropertyChainEditor(this.getOWLEditorKit());
        editor.setSuperProperty((OWLObjectPropertyExpression)this.getRootObject());
        return editor;
    }

    @Override
    public Comparator<OWLFrameSectionRow<OWLObjectProperty, OWLSubPropertyChainOfAxiom, List<OWLObjectPropertyExpression>>> getRowComparator() {
        return null;
    }

    @Override
    protected boolean isResettingChange(OWLOntologyChange change) {
        if (!change.isAxiomChange()) {
            return false;
        }
        OWLAxiom axiom = change.getAxiom();
        if (axiom instanceof OWLSubPropertyChainOfAxiom) {
            return ((OWLSubPropertyChainOfAxiom)axiom).getSuperProperty().equals(this.getRootObject());
        }
        return false;
    }
}

