/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.util;

import java.util.List;
import org.apache.ivy.Ivy;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.util.Checks;
import org.apache.ivy.util.DefaultMessageLogger;
import org.apache.ivy.util.MessageLogger;

public final class Message {
    public static final int MSG_ERR = 0;
    public static final int MSG_WARN = 1;
    public static final int MSG_INFO = 2;
    public static final int MSG_VERBOSE = 3;
    public static final int MSG_DEBUG = 4;
    private static boolean showedInfo = false;
    private static MessageLogger defaultLogger = new DefaultMessageLogger(2);

    public static MessageLogger getDefaultLogger() {
        return defaultLogger;
    }

    public static void setDefaultLogger(MessageLogger messageLogger) {
        Checks.checkNotNull(messageLogger, "logger");
        defaultLogger = messageLogger;
    }

    private static MessageLogger getLogger() {
        return IvyContext.getContext().getMessageLogger();
    }

    public static void showInfo() {
        if (!showedInfo) {
            Message.info(":: Apache Ivy " + Ivy.getIvyVersion() + " - " + Ivy.getIvyDate() + " :: " + Ivy.getIvyHomeURL() + " ::");
            showedInfo = true;
        }
    }

    public static void debug(String string) {
        Message.getLogger().debug(string);
    }

    public static void verbose(String string) {
        Message.getLogger().verbose(string);
    }

    public static void info(String string) {
        Message.getLogger().info(string);
    }

    public static void rawinfo(String string) {
        Message.getLogger().rawinfo(string);
    }

    public static void deprecated(String string) {
        Message.getLogger().deprecated(string);
    }

    public static void warn(String string) {
        Message.getLogger().warn(string);
    }

    public static void error(String string) {
        Message.getLogger().error(string);
    }

    public static void log(int n, String string) {
        switch (n) {
            case 4: {
                Message.debug(string);
                break;
            }
            case 3: {
                Message.verbose(string);
                break;
            }
            case 2: {
                Message.info(string);
                break;
            }
            case 1: {
                Message.warn(string);
                break;
            }
            case 0: {
                Message.error(string);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown log level " + n);
            }
        }
    }

    public static List getProblems() {
        return Message.getLogger().getProblems();
    }

    public static void sumupProblems() {
        Message.getLogger().sumupProblems();
    }

    public static void progress() {
        Message.getLogger().progress();
    }

    public static void endProgress() {
        Message.getLogger().endProgress();
    }

    public static void endProgress(String string) {
        Message.getLogger().endProgress(string);
    }

    public static boolean isShowProgress() {
        return Message.getLogger().isShowProgress();
    }

    public static void setShowProgress(boolean bl) {
        Message.getLogger().setShowProgress(bl);
    }

    private Message() {
    }
}

