/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap.pool;

import com.sun.jndi.ldap.LdapPoolManager;
import com.sun.jndi.ldap.pool.ConnectionDesc;
import com.sun.jndi.ldap.pool.Pool;
import com.sun.jndi.ldap.pool.PoolCallback;
import com.sun.jndi.ldap.pool.PooledConnection;
import com.sun.jndi.ldap.pool.PooledConnectionFactory;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.List;
import javax.naming.CommunicationException;
import javax.naming.InterruptedNamingException;
import javax.naming.NamingException;

final class Connections
implements PoolCallback {
    private static final boolean debug = Pool.debug;
    private static final boolean trace = LdapPoolManager.trace;
    private static final int DEFAULT_SIZE = 10;
    private final int maxSize;
    private final int prefSize;
    private final List<ConnectionDesc> conns;
    private boolean closed = false;
    private Reference<Object> ref;

    Connections(Object id, int initSize, int prefSize, int maxSize, PooledConnectionFactory factory) throws NamingException {
        this.maxSize = maxSize;
        if (maxSize > 0) {
            this.prefSize = Math.min(prefSize, maxSize);
            initSize = Math.min(initSize, maxSize);
        } else {
            this.prefSize = prefSize;
        }
        this.conns = new ArrayList<ConnectionDesc>(maxSize > 0 ? maxSize : 10);
        this.ref = new SoftReference<Object>(id);
        this.d("init size=", initSize);
        this.d("max size=", maxSize);
        this.d("preferred size=", prefSize);
        for (int i = 0; i < initSize; ++i) {
            PooledConnection conn = factory.createPooledConnection(this);
            this.td("Create ", conn, factory);
            this.conns.add(new ConnectionDesc(conn));
        }
    }

    synchronized PooledConnection get(long timeout, PooledConnectionFactory factory) throws NamingException {
        PooledConnection conn;
        long start = timeout > 0L ? System.currentTimeMillis() : 0L;
        long waittime = timeout;
        this.d("get(): before");
        while ((conn = this.getOrCreateConnection(factory)) == null) {
            if (timeout > 0L && waittime <= 0L) {
                throw new CommunicationException("Timeout exceeded while waiting for a connection: " + timeout + "ms");
            }
            try {
                this.d("get(): waiting");
                if (waittime > 0L) {
                    this.wait(waittime);
                } else {
                    this.wait();
                }
            }
            catch (InterruptedException e) {
                throw new InterruptedNamingException("Interrupted while waiting for a connection");
            }
            if (timeout <= 0L) continue;
            long now = System.currentTimeMillis();
            waittime = timeout - (now - start);
        }
        this.d("get(): after");
        return conn;
    }

    private PooledConnection getOrCreateConnection(PooledConnectionFactory factory) throws NamingException {
        int size = this.conns.size();
        PooledConnection conn = null;
        if (this.prefSize <= 0 || size >= this.prefSize) {
            for (int i = 0; i < size; ++i) {
                ConnectionDesc entry = this.conns.get(i);
                conn = entry.tryUse();
                if (conn == null) continue;
                this.d("get(): use ", conn);
                this.td("Use ", conn);
                return conn;
            }
        }
        if (this.maxSize > 0 && size >= this.maxSize) {
            return null;
        }
        conn = factory.createPooledConnection(this);
        this.td("Create and use ", conn, factory);
        this.conns.add(new ConnectionDesc(conn, true));
        return conn;
    }

    @Override
    public synchronized boolean releasePooledConnection(PooledConnection conn) {
        ConnectionDesc entry = new ConnectionDesc(conn);
        int loc = this.conns.indexOf(entry);
        this.d("release(): ", conn);
        if (loc >= 0) {
            if (this.closed || this.prefSize > 0 && this.conns.size() > this.prefSize) {
                this.d("release(): closing ", conn);
                this.td("Close ", conn);
                this.conns.remove(entry);
                conn.closeConnection();
            } else {
                this.d("release(): release ", conn);
                this.td("Release ", conn);
                entry = this.conns.get(loc);
                entry.release();
            }
            this.notifyAll();
            this.d("release(): notify");
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean removePooledConnection(PooledConnection conn) {
        if (this.conns.remove(new ConnectionDesc(conn))) {
            this.d("remove(): ", conn);
            this.notifyAll();
            this.d("remove(): notify");
            this.td("Remove ", conn);
            if (this.conns.isEmpty()) {
                this.ref = null;
            }
            return true;
        }
        this.d("remove(): not found ", conn);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean expire(long threshold) {
        ArrayList<ConnectionDesc> clonedConns;
        Connections connections = this;
        synchronized (connections) {
            clonedConns = new ArrayList<ConnectionDesc>(this.conns);
        }
        ArrayList<ConnectionDesc> expired = new ArrayList<ConnectionDesc>();
        for (ConnectionDesc entry : clonedConns) {
            this.d("expire(): ", entry);
            if (!entry.expire(threshold)) continue;
            expired.add(entry);
            this.td("expire(): Expired ", entry);
        }
        Connections connections2 = this;
        synchronized (connections2) {
            this.conns.removeAll(expired);
            return this.conns.isEmpty();
        }
    }

    synchronized void close() {
        this.expire(System.currentTimeMillis());
        this.closed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getStats() {
        int len;
        int idle = 0;
        int busy = 0;
        int expired = 0;
        long use = 0L;
        Connections connections = this;
        synchronized (connections) {
            len = this.conns.size();
            block8: for (int i = 0; i < len; ++i) {
                ConnectionDesc entry = this.conns.get(i);
                use += entry.getUseCount();
                switch (entry.getState()) {
                    case 0: {
                        ++busy;
                        continue block8;
                    }
                    case 1: {
                        ++idle;
                        continue block8;
                    }
                    case 2: {
                        ++expired;
                    }
                }
            }
        }
        return "size=" + len + "; use=" + use + "; busy=" + busy + "; idle=" + idle + "; expired=" + expired;
    }

    private void d(String msg, Object o1) {
        if (debug) {
            this.d(msg + o1);
        }
    }

    private void d(String msg, int i) {
        if (debug) {
            this.d(msg + i);
        }
    }

    private void d(String msg) {
        if (debug) {
            System.err.println(this + "." + msg + "; size: " + this.conns.size());
        }
    }

    private void td(String msg, Object o1, Object o2) {
        if (trace) {
            this.td(msg + o1 + "[" + o2 + "]");
        }
    }

    private void td(String msg, Object o1) {
        if (trace) {
            this.td(msg + o1);
        }
    }

    private void td(String msg) {
        if (trace) {
            System.err.println(msg);
        }
    }
}

