/*
 * Copyright (c) 2017, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/**
 * <p>
 * Compile-time representation of Java type system.
 *
 * <p>
 * These classes are used as TypeT and ClassDeclT of the model parameterization. This implementaion is designed to be
 * capable of representing pre-existing classes (such as java.lang.String) as well as the generated classes (represented
 * as JDefinedClass.)
 *
 * <h2>Handling of Primitive Types</h2>
 * <p>
 * Primitive types have two forms (int and Integer), and this complicates the binding process. For this reason, inside
 * the front end, we always use the boxed types. We'll use the unboxed form only in the back end when we know the field
 * doesn't need to represent the null value.
 */
package com.sun.tools.internal.xjc.model.nav;
