#
#  Plex Media Framework
#  Copyright (C) 2008-2009 Plex, Inc. (James Clarke, Elan Feingold). All Rights Reserved.
#

import hashlib, zlib

####################################################################################################

def __generateHash(data, obj):
  obj.update(data)
  return obj.hexdigest()

####################################################################################################

def MD5(data):
  return __generateHash(data, hashlib.md5())

####################################################################################################
  
def SHA1(data):
  return __generateHash(data, hashlib.sha1())

####################################################################################################

def SHA224(data):
  return __generateHash(data, hashlib.sha224())

####################################################################################################
  
def SHA256(data):
  return __generateHash(data, hashlib.sha256())

####################################################################################################
  
def SHA384(data):
  return __generateHash(data, hashlib.sha384())

####################################################################################################

def SHA512(data):
  return __generateHash(data, hashlib.sha512())

####################################################################################################
  
def CRC32(data):
  return zlib.crc32(data) & 0xffffffff
  
####################################################################################################
