/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.oql.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Rectangle;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.NoCaret;
import org.netbeans.modules.profiler.oql.engine.api.OQLEngine;
import org.netbeans.modules.profiler.oql.engine.api.OQLException;
import org.netbeans.modules.profiler.oql.spi.OQLEditorImpl;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public class OQLEditor
extends JPanel {
    public static final String VALIDITY_PROPERTY = "document#valid";
    private volatile boolean lexervalid = false;
    private volatile boolean parserValid = false;
    private volatile boolean oldValidity = false;
    private JEditorPane queryEditor = null;
    private final OQLEngine engine;
    private final Color disabledBgColor = UIUtils.isGTKLookAndFeel() ? UIManager.getLookAndFeel().getDefaults().getColor("desktop") : UIManager.getColor("TextField.disabledBackground");
    private final transient Caret nullCaret = new NoCaret();
    private Color lastBgColor = null;
    private Caret lastCaret = null;
    private Font font;

    public OQLEditor(OQLEngine oQLEngine) {
        this.engine = oQLEngine;
    }

    private void init() {
        final DocumentListener documentListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                OQLEditor.this.validateScript();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                OQLEditor.this.validateScript();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                OQLEditor.this.validateScript();
            }
        };
        OQLEditorImpl oQLEditorImpl = (OQLEditorImpl)Lookup.getDefault().lookup(OQLEditorImpl.class);
        if (oQLEditorImpl != null) {
            this.queryEditor = oQLEditorImpl.getEditorPane();
            this.queryEditor.getDocument().putProperty(OQLEngine.class, this.engine);
            this.queryEditor.getDocument().putProperty(OQLEditorImpl.ValidationCallback.class, new OQLEditorImpl.ValidationCallback(){

                public void callback(boolean bl) {
                    OQLEditor.this.lexervalid = bl;
                    OQLEditor.this.validateScript();
                }
            });
            this.queryEditor.getCaret().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    try {
                        Rectangle rectangle;
                        Rectangle rectangle2 = rectangle = OQLEditor.this.queryEditor == null ? null : OQLEditor.this.queryEditor.getUI().modelToView(OQLEditor.this.queryEditor, OQLEditor.this.queryEditor.getCaretPosition());
                        if (rectangle != null) {
                            OQLEditor.this.queryEditor.scrollRectToVisible(rectangle);
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        Exceptions.printStackTrace((Throwable)badLocationException);
                    }
                }
            });
            Element element = this.queryEditor.getDocument().getDefaultRootElement();
            String string = StyleConstants.getFontFamily(element.getAttributes());
            int n = StyleConstants.getFontSize(element.getAttributes());
            this.font = new Font(string, 0, n);
        } else {
            this.queryEditor = new JEditorPane(){

                @Override
                public void setText(String string) {
                    Document document = this.getDocument();
                    if (document != null) {
                        document.removeDocumentListener(documentListener);
                    }
                    this.setDocument(this.getEditorKit().createDefaultDocument());
                    document = this.getDocument();
                    if (document != null) {
                        document.addDocumentListener(documentListener);
                    }
                    super.setText(string);
                }
            };
            try {
                this.queryEditor.setContentType("text/x-oql");
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            this.font = Font.decode("Monospaced");
            this.queryEditor.setFont(this.font);
            this.lexervalid = true;
        }
        this.queryEditor.setOpaque(this.isOpaque());
        this.queryEditor.setBackground(this.getBackground());
        this.queryEditor.putClientProperty("nb.ctrltab.popupswitcher.disable", Boolean.TRUE);
        this.setLayout(new BorderLayout());
        this.add((Component)this.queryEditor, "Center");
    }

    public void setScript(String string) {
        this.getEditor().setText(string);
    }

    public String getScript() {
        return this.getEditor().getText();
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.queryEditor != null) {
            this.queryEditor.setBackground(color);
        }
    }

    @Override
    public void setOpaque(boolean bl) {
        super.setOpaque(bl);
        if (this.queryEditor != null) {
            this.queryEditor.setOpaque(bl);
        }
    }

    @Override
    public void requestFocus() {
        this.getEditor().requestFocus();
    }

    private final void validateScript() {
        if (this.lexervalid || !this.parserValid) {
            try {
                this.engine.parseQuery(this.getScript());
                this.parserValid = true;
            }
            catch (OQLException oQLException) {
                StatusDisplayer.getDefault().setStatusText(oQLException.getLocalizedMessage());
                this.parserValid = false;
            }
        }
        this.firePropertyChange(VALIDITY_PROPERTY, this.oldValidity, this.lexervalid && this.parserValid);
        this.oldValidity = this.lexervalid && this.parserValid;
    }

    public void setEditable(boolean bl) {
        JEditorPane jEditorPane = this.getEditor();
        if (jEditorPane.isEditable() == bl) {
            return;
        }
        jEditorPane.setEditable(bl);
        if (bl) {
            if (this.lastBgColor != null) {
                jEditorPane.setBackground(this.lastBgColor);
            }
            if (this.lastCaret != null) {
                jEditorPane.setCaret(this.lastCaret);
            }
        } else {
            this.lastBgColor = jEditorPane.getBackground();
            this.lastCaret = jEditorPane.getCaret();
            jEditorPane.setBackground(this.disabledBgColor);
            jEditorPane.setCaret(this.nullCaret);
        }
    }

    public boolean isEditable() {
        return this.getEditor().isEditable();
    }

    @Override
    public Font getFont() {
        if (this.queryEditor == null) {
            this.init();
        }
        return this.font;
    }

    public JEditorPane getEditor() {
        if (this.queryEditor == null) {
            this.init();
        }
        return this.queryEditor;
    }
}

