/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.File;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.internal.storage.file.LazyObjectIdSetFile;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectChecker;
import org.eclipse.jgit.lib.ObjectIdSet;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.RefFilter;
import org.eclipse.jgit.util.StringUtils;
import org.eclipse.jgit.util.SystemReader;

public class TransferConfig {
    private static final String FSCK = "fsck";
    public static final Config.SectionParser<TransferConfig> KEY = TransferConfig::new;
    private final boolean fetchFsck;
    private final boolean receiveFsck;
    private final String fsckSkipList;
    private final EnumSet<ObjectChecker.ErrorType> ignore;
    private final boolean allowInvalidPersonIdent;
    private final boolean safeForWindows;
    private final boolean safeForMacOS;
    private final boolean allowTipSha1InWant;
    private final boolean allowReachableSha1InWant;
    final String[] hideRefs;

    TransferConfig(Repository db) {
        this(db.getConfig());
    }

    TransferConfig(Config rc) {
        boolean fsck = rc.getBoolean("transfer", "fsckobjects", false);
        this.fetchFsck = rc.getBoolean("fetch", "fsckobjects", fsck);
        this.receiveFsck = rc.getBoolean("receive", "fsckobjects", fsck);
        this.fsckSkipList = rc.getString(FSCK, null, "skipList");
        this.allowInvalidPersonIdent = rc.getBoolean(FSCK, "allowInvalidPersonIdent", false);
        this.safeForWindows = rc.getBoolean(FSCK, "safeForWindows", SystemReader.getInstance().isWindows());
        this.safeForMacOS = rc.getBoolean(FSCK, "safeForMacOS", SystemReader.getInstance().isMacOS());
        this.ignore = EnumSet.noneOf(ObjectChecker.ErrorType.class);
        EnumSet<ObjectChecker.ErrorType> set2 = EnumSet.noneOf(ObjectChecker.ErrorType.class);
        for (String key2 : rc.getNames(FSCK)) {
            ObjectChecker.ErrorType id;
            if (StringUtils.equalsIgnoreCase(key2, "skipList") || StringUtils.equalsIgnoreCase(key2, "allowLeadingZeroFileMode") || StringUtils.equalsIgnoreCase(key2, "allowInvalidPersonIdent") || StringUtils.equalsIgnoreCase(key2, "safeForWindows") || StringUtils.equalsIgnoreCase(key2, "safeForMacOS") || (id = FsckKeyNameHolder.parse(key2)) == null) continue;
            switch (rc.getEnum(FSCK, null, key2, FsckMode.ERROR)) {
                case ERROR: {
                    this.ignore.remove((Object)id);
                    break;
                }
                case WARN: 
                case IGNORE: {
                    this.ignore.add(id);
                }
            }
            set2.add(id);
        }
        if (!set2.contains((Object)ObjectChecker.ErrorType.ZERO_PADDED_FILEMODE) && rc.getBoolean(FSCK, "allowLeadingZeroFileMode", false)) {
            this.ignore.add(ObjectChecker.ErrorType.ZERO_PADDED_FILEMODE);
        }
        this.allowTipSha1InWant = rc.getBoolean("uploadpack", "allowtipsha1inwant", false);
        this.allowReachableSha1InWant = rc.getBoolean("uploadpack", "allowreachablesha1inwant", false);
        this.hideRefs = rc.getStringList("uploadpack", null, "hiderefs");
    }

    @Nullable
    public ObjectChecker newObjectChecker() {
        return this.newObjectChecker(this.fetchFsck);
    }

    @Nullable
    public ObjectChecker newReceiveObjectChecker() {
        return this.newObjectChecker(this.receiveFsck);
    }

    private ObjectChecker newObjectChecker(boolean check2) {
        if (!check2) {
            return null;
        }
        return new ObjectChecker().setIgnore(this.ignore).setAllowInvalidPersonIdent(this.allowInvalidPersonIdent).setSafeForWindows(this.safeForWindows).setSafeForMacOS(this.safeForMacOS).setSkipList(this.skipList());
    }

    private ObjectIdSet skipList() {
        if (this.fsckSkipList != null && !this.fsckSkipList.isEmpty()) {
            return new LazyObjectIdSetFile(new File(this.fsckSkipList));
        }
        return null;
    }

    public boolean isAllowTipSha1InWant() {
        return this.allowTipSha1InWant;
    }

    public boolean isAllowReachableSha1InWant() {
        return this.allowReachableSha1InWant;
    }

    public RefFilter getRefFilter() {
        if (this.hideRefs.length == 0) {
            return RefFilter.DEFAULT;
        }
        return new RefFilter(){

            @Override
            public Map<String, Ref> filter(Map<String, Ref> refs) {
                HashMap<String, Ref> result = new HashMap<String, Ref>();
                for (Map.Entry<String, Ref> e2 : refs.entrySet()) {
                    boolean add = true;
                    for (String hide : TransferConfig.this.hideRefs) {
                        if (!e2.getKey().equals(hide) && !this.prefixMatch(hide, e2.getKey())) continue;
                        add = false;
                        break;
                    }
                    if (!add) continue;
                    result.put(e2.getKey(), e2.getValue());
                }
                return result;
            }

            private boolean prefixMatch(String p, String s) {
                return p.charAt(p.length() - 1) == '/' && s.startsWith(p);
            }
        };
    }

    static class FsckKeyNameHolder {
        private static final Map<String, ObjectChecker.ErrorType> errors = new HashMap<String, ObjectChecker.ErrorType>();

        @Nullable
        static ObjectChecker.ErrorType parse(String key2) {
            return errors.get(StringUtils.toLowerCase(key2));
        }

        private static String keyNameFor(String name2) {
            StringBuilder r = new StringBuilder(name2.length());
            for (int i = 0; i < name2.length(); ++i) {
                char c = name2.charAt(i);
                if (c == '_') continue;
                r.append(c);
            }
            return StringUtils.toLowerCase(r.toString());
        }

        private FsckKeyNameHolder() {
        }

        static {
            for (ObjectChecker.ErrorType m : ObjectChecker.ErrorType.values()) {
                errors.put(FsckKeyNameHolder.keyNameFor(m.name()), m);
            }
        }
    }

    public static enum FsckMode {
        ERROR,
        WARN,
        IGNORE;

    }
}

