/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.pipeline;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.PipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.pipeline.AbstractPipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.pipeline.BucketHelpers;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.pipeline.SerialDiffPipelineAggregator;

public class SerialDiffPipelineAggregationBuilder
extends AbstractPipelineAggregationBuilder<SerialDiffPipelineAggregationBuilder> {
    public static final String NAME = "serial_diff";
    private static final ParseField GAP_POLICY = new ParseField("gap_policy", new String[0]);
    private static final ParseField LAG = new ParseField("lag", new String[0]);
    private String format;
    private BucketHelpers.GapPolicy gapPolicy = BucketHelpers.GapPolicy.SKIP;
    private int lag = 1;

    public SerialDiffPipelineAggregationBuilder(String name, String bucketsPath) {
        super(name, NAME, new String[]{bucketsPath});
    }

    public SerialDiffPipelineAggregationBuilder(StreamInput in) throws IOException {
        super(in, NAME);
        this.format = in.readOptionalString();
        this.gapPolicy = BucketHelpers.GapPolicy.readFrom(in);
        this.lag = in.readVInt();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.format);
        this.gapPolicy.writeTo(out);
        out.writeVInt(this.lag);
    }

    public SerialDiffPipelineAggregationBuilder lag(int lag) {
        if (lag <= 0) {
            throw new IllegalArgumentException("[lag] must be a positive integer: [" + this.name + "]");
        }
        this.lag = lag;
        return this;
    }

    public int lag() {
        return this.lag;
    }

    public SerialDiffPipelineAggregationBuilder format(String format) {
        if (format == null) {
            throw new IllegalArgumentException("[format] must not be null: [" + this.name + "]");
        }
        this.format = format;
        return this;
    }

    public String format() {
        return this.format;
    }

    public SerialDiffPipelineAggregationBuilder gapPolicy(BucketHelpers.GapPolicy gapPolicy) {
        if (gapPolicy == null) {
            throw new IllegalArgumentException("[gapPolicy] must not be null: [" + this.name + "]");
        }
        this.gapPolicy = gapPolicy;
        return this;
    }

    public BucketHelpers.GapPolicy gapPolicy() {
        return this.gapPolicy;
    }

    protected DocValueFormat formatter() {
        if (this.format != null) {
            return new DocValueFormat.Decimal(this.format);
        }
        return DocValueFormat.RAW;
    }

    @Override
    protected PipelineAggregator createInternal(Map<String, Object> metaData) {
        return new SerialDiffPipelineAggregator(this.name, this.bucketsPaths, this.formatter(), this.gapPolicy, this.lag, metaData);
    }

    @Override
    public void doValidate(AggregatorFactory<?> parent, Collection<AggregationBuilder> aggFactories, Collection<PipelineAggregationBuilder> pipelineAggregatoractories) {
        SerialDiffPipelineAggregationBuilder.validateSequentiallyOrderedParentAggs(parent, NAME, this.name);
    }

    @Override
    protected XContentBuilder internalXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.format != null) {
            builder.field(PipelineAggregator.Parser.FORMAT.getPreferredName(), this.format);
        }
        builder.field(GAP_POLICY.getPreferredName(), this.gapPolicy.getName());
        builder.field(LAG.getPreferredName(), this.lag);
        return builder;
    }

    public static SerialDiffPipelineAggregationBuilder parse(String reducerName, XContentParser parser) throws IOException {
        XContentParser.Token token;
        String currentFieldName = null;
        String[] bucketsPaths = null;
        String format = null;
        BucketHelpers.GapPolicy gapPolicy = null;
        Integer lag = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.VALUE_STRING) {
                if (PipelineAggregator.Parser.FORMAT.match(currentFieldName, parser.getDeprecationHandler())) {
                    format = parser.text();
                    continue;
                }
                if (PipelineAggregator.Parser.BUCKETS_PATH.match(currentFieldName, parser.getDeprecationHandler())) {
                    bucketsPaths = new String[]{parser.text()};
                    continue;
                }
                if (GAP_POLICY.match(currentFieldName, parser.getDeprecationHandler())) {
                    gapPolicy = BucketHelpers.GapPolicy.parse(parser.text(), parser.getTokenLocation());
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "Unknown key for a " + token + " in [" + reducerName + "]: [" + currentFieldName + "].", new Object[0]);
            }
            if (token == XContentParser.Token.VALUE_NUMBER) {
                if (LAG.match(currentFieldName, parser.getDeprecationHandler())) {
                    lag = parser.intValue(true);
                    if (lag > 0) continue;
                    throw new ParsingException(parser.getTokenLocation(), "Lag must be a positive, non-zero integer.  Value supplied was" + lag + " in [" + reducerName + "]: [" + currentFieldName + "].", new Object[0]);
                }
                throw new ParsingException(parser.getTokenLocation(), "Unknown key for a " + token + " in [" + reducerName + "]: [" + currentFieldName + "].", new Object[0]);
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if (PipelineAggregator.Parser.BUCKETS_PATH.match(currentFieldName, parser.getDeprecationHandler())) {
                    ArrayList<String> paths = new ArrayList<String>();
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        String path = parser.text();
                        paths.add(path);
                    }
                    bucketsPaths = paths.toArray(new String[paths.size()]);
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "Unknown key for a " + token + " in [" + reducerName + "]: [" + currentFieldName + "].", new Object[0]);
            }
            throw new ParsingException(parser.getTokenLocation(), "Unexpected token " + token + " in [" + reducerName + "].", parser.getTokenLocation());
        }
        if (bucketsPaths == null) {
            throw new ParsingException(parser.getTokenLocation(), "Missing required field [" + PipelineAggregator.Parser.BUCKETS_PATH.getPreferredName() + "] for derivative aggregation [" + reducerName + "]", new Object[0]);
        }
        SerialDiffPipelineAggregationBuilder factory = new SerialDiffPipelineAggregationBuilder(reducerName, (String)bucketsPaths[0]);
        if (lag != null) {
            factory.lag(lag);
        }
        if (format != null) {
            factory.format(format);
        }
        if (gapPolicy != null) {
            factory.gapPolicy(gapPolicy);
        }
        return factory;
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(new Object[]{this.format, this.gapPolicy, this.lag});
    }

    @Override
    protected boolean doEquals(Object obj) {
        SerialDiffPipelineAggregationBuilder other = (SerialDiffPipelineAggregationBuilder)obj;
        return Objects.equals(this.format, other.format) && Objects.equals((Object)this.gapPolicy, (Object)other.gapPolicy) && Objects.equals(this.lag, other.lag);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }
}

