/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.net;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPClientConfig;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.FileScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Delete;
import org.apache.tools.ant.taskdefs.optional.net.FTPConfigurator;
import org.apache.tools.ant.taskdefs.optional.net.FTPTaskConfig;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.selectors.SelectorUtils;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.RetryHandler;
import org.apache.tools.ant.util.Retryable;
import org.apache.tools.ant.util.VectorSet;

public class FTP
extends Task
implements FTPTaskConfig {
    protected static final int SEND_FILES = 0;
    protected static final int GET_FILES = 1;
    protected static final int DEL_FILES = 2;
    protected static final int LIST_FILES = 3;
    protected static final int MK_DIR = 4;
    protected static final int CHMOD = 5;
    protected static final int RM_DIR = 6;
    protected static final int SITE_CMD = 7;
    private static final int CODE_521 = 521;
    private static final int CODE_550 = 550;
    private static final int CODE_553 = 553;
    private static final long GRANULARITY_MINUTE = 60000L;
    private static final SimpleDateFormat TIMESTAMP_LOGGING_SDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static final int DEFAULT_FTP_PORT = 21;
    private static final FileUtils FILE_UTILS = FileUtils.getFileUtils();
    private String remotedir;
    private String server;
    private String userid;
    private String password;
    private String account;
    private File listing;
    private boolean binary = true;
    private boolean passive = false;
    private boolean verbose = false;
    private boolean newerOnly = false;
    private long timeDiffMillis = 0L;
    private long granularityMillis = 0L;
    private boolean timeDiffAuto = false;
    private int action = 0;
    private Vector<FileSet> filesets = new Vector();
    private Set<File> dirCache = new HashSet<File>();
    private int transferred = 0;
    private String remoteFileSep = "/";
    private int port = 21;
    private boolean skipFailedTransfers = false;
    private int skipped = 0;
    private boolean ignoreNoncriticalErrors = false;
    private boolean preserveLastModified = false;
    private String chmod = null;
    private String umask = null;
    private FTPSystemType systemTypeKey = FTPSystemType.getDefault();
    private String defaultDateFormatConfig = null;
    private String recentDateFormatConfig = null;
    private LanguageCode serverLanguageCodeConfig = LanguageCode.getDefault();
    private String serverTimeZoneConfig = null;
    private String shortMonthNamesConfig = null;
    private Granularity timestampGranularity = Granularity.getDefault();
    private boolean isConfigurationSet = false;
    private int retriesAllowed = 0;
    private String siteCommand = null;
    private String initialSiteCommand = null;
    private boolean enableRemoteVerification = true;
    protected static final String[] ACTION_STRS = new String[]{"sending", "getting", "deleting", "listing", "making directory", "chmod", "removing", "site"};
    protected static final String[] COMPLETED_ACTION_STRS = new String[]{"sent", "retrieved", "deleted", "listed", "created directory", "mode changed", "removed", "site command executed"};
    protected static final String[] ACTION_TARGET_STRS = new String[]{"files", "files", "files", "files", "directory", "files", "directories", "site command"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isFunctioningAsDirectory(FTPClient ftp, String dir, FTPFile file) {
        if (file.isDirectory()) {
            return true;
        }
        if (file.isFile()) {
            return false;
        }
        String currentWorkingDir = null;
        try {
            currentWorkingDir = ftp.printWorkingDirectory();
        }
        catch (IOException ioe) {
            this.getProject().log("could not find current working directory " + dir + " while checking a symlink", 4);
        }
        boolean result = false;
        if (currentWorkingDir == null) return result;
        try {
            result = ftp.changeWorkingDirectory(file.getLink());
        }
        catch (IOException ioe) {
            this.getProject().log("could not cd to " + file.getLink() + " while checking a symlink", 4);
        }
        if (!result) return result;
        boolean comeback = false;
        try {
            comeback = ftp.changeWorkingDirectory(currentWorkingDir);
            if (comeback) return result;
        }
        catch (IOException ioe) {
            try {
                this.getProject().log("could not cd back to " + dir + " while checking a symlink", 0);
                if (comeback) return result;
            }
            catch (Throwable throwable) {
                if (comeback) throw throwable;
                throw new BuildException("could not cd back to %s while checking a symlink", new Object[]{dir});
            }
            throw new BuildException("could not cd back to %s while checking a symlink", new Object[]{dir});
        }
        throw new BuildException("could not cd back to %s while checking a symlink", new Object[]{dir});
    }

    private boolean isFunctioningAsFile(FTPClient ftp, String dir, FTPFile file) {
        return !file.isDirectory() && (file.isFile() || !this.isFunctioningAsDirectory(ftp, dir, file));
    }

    public void setRemotedir(String dir) {
        this.remotedir = dir;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setUserid(String userid) {
        this.userid = userid;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setAccount(String pAccount) {
        this.account = pAccount;
    }

    public void setBinary(boolean binary) {
        this.binary = binary;
    }

    public void setPassive(boolean passive) {
        this.passive = passive;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setNewer(boolean newer) {
        this.newerOnly = newer;
    }

    public void setTimeDiffMillis(long timeDiffMillis) {
        this.timeDiffMillis = timeDiffMillis;
    }

    public void setTimeDiffAuto(boolean timeDiffAuto) {
        this.timeDiffAuto = timeDiffAuto;
    }

    public void setPreserveLastModified(boolean preserveLastModified) {
        this.preserveLastModified = preserveLastModified;
    }

    public void setDepends(boolean depends) {
        this.newerOnly = depends;
    }

    public void setSeparator(String separator) {
        this.remoteFileSep = separator;
    }

    public void setChmod(String theMode) {
        this.chmod = theMode;
    }

    public void setUmask(String theUmask) {
        this.umask = theUmask;
    }

    public void addFileset(FileSet set) {
        this.filesets.addElement(set);
    }

    @Deprecated
    public void setAction(String action) throws BuildException {
        this.log("DEPRECATED - The setAction(String) method has been deprecated. Use setAction(FTP.Action) instead.");
        Action a = new Action();
        a.setValue(action);
        this.action = a.getAction();
    }

    public void setAction(Action action) throws BuildException {
        this.action = action.getAction();
    }

    public void setListing(File listing) {
        this.listing = listing;
    }

    public void setSkipFailedTransfers(boolean skipFailedTransfers) {
        this.skipFailedTransfers = skipFailedTransfers;
    }

    public void setIgnoreNoncriticalErrors(boolean ignoreNoncriticalErrors) {
        this.ignoreNoncriticalErrors = ignoreNoncriticalErrors;
    }

    private void configurationHasBeenSet() {
        this.isConfigurationSet = true;
    }

    public void setSystemTypeKey(FTPSystemType systemKey) {
        if (systemKey != null && !systemKey.getValue().isEmpty()) {
            this.systemTypeKey = systemKey;
            this.configurationHasBeenSet();
        }
    }

    public void setDefaultDateFormatConfig(String defaultDateFormat) {
        if (defaultDateFormat != null && !defaultDateFormat.isEmpty()) {
            this.defaultDateFormatConfig = defaultDateFormat;
            this.configurationHasBeenSet();
        }
    }

    public void setRecentDateFormatConfig(String recentDateFormat) {
        if (recentDateFormat != null && !recentDateFormat.isEmpty()) {
            this.recentDateFormatConfig = recentDateFormat;
            this.configurationHasBeenSet();
        }
    }

    public void setServerLanguageCodeConfig(LanguageCode serverLanguageCode) {
        if (serverLanguageCode != null && !serverLanguageCode.getValue().isEmpty()) {
            this.serverLanguageCodeConfig = serverLanguageCode;
            this.configurationHasBeenSet();
        }
    }

    public void setServerTimeZoneConfig(String serverTimeZoneId) {
        if (serverTimeZoneId != null && !serverTimeZoneId.isEmpty()) {
            this.serverTimeZoneConfig = serverTimeZoneId;
            this.configurationHasBeenSet();
        }
    }

    public void setShortMonthNamesConfig(String shortMonthNames) {
        if (shortMonthNames != null && !shortMonthNames.isEmpty()) {
            this.shortMonthNamesConfig = shortMonthNames;
            this.configurationHasBeenSet();
        }
    }

    public void setRetriesAllowed(String retriesAllowed) {
        if ("FOREVER".equalsIgnoreCase(retriesAllowed)) {
            this.retriesAllowed = -1;
        } else {
            try {
                int retries = Integer.parseInt(retriesAllowed);
                if (retries < -1) {
                    throw new BuildException("Invalid value for retriesAllowed attribute: %s", new Object[]{retriesAllowed});
                }
                this.retriesAllowed = retries;
            }
            catch (NumberFormatException px) {
                throw new BuildException("Invalid value for retriesAllowed attribute: %s", new Object[]{retriesAllowed});
            }
        }
    }

    @Override
    public String getSystemTypeKey() {
        return this.systemTypeKey.getValue();
    }

    @Override
    public String getDefaultDateFormatConfig() {
        return this.defaultDateFormatConfig;
    }

    @Override
    public String getRecentDateFormatConfig() {
        return this.recentDateFormatConfig;
    }

    @Override
    public String getServerLanguageCodeConfig() {
        return this.serverLanguageCodeConfig.getValue();
    }

    @Override
    public String getServerTimeZoneConfig() {
        return this.serverTimeZoneConfig;
    }

    @Override
    public String getShortMonthNamesConfig() {
        return this.shortMonthNamesConfig;
    }

    Granularity getTimestampGranularity() {
        return this.timestampGranularity;
    }

    public void setTimestampGranularity(Granularity timestampGranularity) {
        if (null == timestampGranularity || timestampGranularity.getValue().isEmpty()) {
            return;
        }
        this.timestampGranularity = timestampGranularity;
    }

    public void setSiteCommand(String siteCommand) {
        this.siteCommand = siteCommand;
    }

    public void setInitialSiteCommand(String initialCommand) {
        this.initialSiteCommand = initialCommand;
    }

    public void setEnableRemoteVerification(boolean b) {
        this.enableRemoteVerification = b;
    }

    protected void checkAttributes() throws BuildException {
        if (this.server == null) {
            throw new BuildException("server attribute must be set!");
        }
        if (this.userid == null) {
            throw new BuildException("userid attribute must be set!");
        }
        if (this.password == null) {
            throw new BuildException("password attribute must be set!");
        }
        if (this.action == 3 && this.listing == null) {
            throw new BuildException("listing attribute must be set for list action!");
        }
        if (this.action == 4 && this.remotedir == null) {
            throw new BuildException("remotedir attribute must be set for mkdir action!");
        }
        if (this.action == 5 && this.chmod == null) {
            throw new BuildException("chmod attribute must be set for chmod action!");
        }
        if (this.action == 7 && this.siteCommand == null) {
            throw new BuildException("sitecommand attribute must be set for site action!");
        }
        if (this.isConfigurationSet) {
            try {
                Class.forName("org.apache.commons.net.ftp.FTPClientConfig");
            }
            catch (ClassNotFoundException e) {
                throw new BuildException("commons-net.jar >= 1.4.0 is required for at least one of the attributes specified.");
            }
        }
    }

    protected void executeRetryable(RetryHandler h, Retryable r, String descr) throws IOException {
        h.execute(r, descr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int transferFiles(FTPClient ftp, FileSet fs) throws IOException, BuildException {
        DirectoryScanner ds;
        if (this.action == 0) {
            ds = fs.getDirectoryScanner(this.getProject());
        } else {
            ds = new FTPDirectoryScanner(ftp);
            fs.setupDirectoryScanner((FileScanner)ds, this.getProject());
            ds.setFollowSymlinks(fs.isFollowSymlinks());
            ds.scan();
        }
        String[] dsfiles = this.action == 6 ? ds.getIncludedDirectories() : ds.getIncludedFiles();
        String dir = null;
        if (ds.getBasedir() == null && (this.action == 0 || this.action == 1)) {
            throw new BuildException("the dir attribute must be set for send and get actions");
        }
        if (this.action == 0 || this.action == 1) {
            dir = ds.getBasedir().getAbsolutePath();
        }
        BufferedWriter bw = null;
        try {
            if (this.action == 3) {
                File pd = this.listing.getParentFile();
                if (!pd.exists()) {
                    pd.mkdirs();
                }
                bw = new BufferedWriter(new FileWriter(this.listing));
            }
            RetryHandler h = new RetryHandler(this.retriesAllowed, (Task)this);
            if (this.action == 6) {
                for (int i = dsfiles.length - 1; i >= 0; --i) {
                    String dsfile = dsfiles[i];
                    this.executeRetryable(h, () -> this.rmDir(ftp, dsfile), dsfile);
                }
            } else {
                BufferedWriter fbw = bw;
                String fdir = dir;
                if (this.newerOnly) {
                    this.granularityMillis = this.timestampGranularity.getMilliseconds(this.action);
                }
                for (String dsfile : dsfiles) {
                    this.executeRetryable(h, () -> {
                        switch (this.action) {
                            case 0: {
                                this.sendFile(ftp, fdir, dsfile);
                                break;
                            }
                            case 1: {
                                this.getFile(ftp, fdir, dsfile);
                                break;
                            }
                            case 2: {
                                this.delFile(ftp, dsfile);
                                break;
                            }
                            case 3: {
                                this.listFile(ftp, fbw, dsfile);
                                break;
                            }
                            case 5: {
                                this.doSiteCommand(ftp, "chmod " + this.chmod + " " + this.resolveFile(dsfile));
                                ++this.transferred;
                                break;
                            }
                            default: {
                                throw new BuildException("unknown ftp action " + this.action);
                            }
                        }
                    }, dsfile);
                }
            }
        }
        catch (Throwable throwable) {
            FileUtils.close(bw);
            throw throwable;
        }
        FileUtils.close((Writer)bw);
        return dsfiles.length;
    }

    protected void transferFiles(FTPClient ftp) throws IOException, BuildException {
        this.transferred = 0;
        this.skipped = 0;
        if (this.filesets.isEmpty()) {
            throw new BuildException("at least one fileset must be specified.");
        }
        for (FileSet fs : this.filesets) {
            if (fs == null) continue;
            this.transferFiles(ftp, fs);
        }
        this.log(this.transferred + " " + ACTION_TARGET_STRS[this.action] + " " + COMPLETED_ACTION_STRS[this.action]);
        if (this.skipped != 0) {
            this.log(this.skipped + " " + ACTION_TARGET_STRS[this.action] + " were not successfully " + COMPLETED_ACTION_STRS[this.action]);
        }
    }

    protected String resolveFile(String file) {
        return file.replace(File.separator.charAt(0), this.remoteFileSep.charAt(0));
    }

    protected void createParents(FTPClient ftp, String filename) throws IOException, BuildException {
        File checkDir;
        String dirname;
        File dir = new File(filename);
        if (this.dirCache.contains(dir)) {
            return;
        }
        Vector<File> parents = new Vector<File>();
        while ((dirname = dir.getParent()) != null && !this.dirCache.contains(checkDir = new File(dirname))) {
            dir = checkDir;
            parents.add(dir);
        }
        int i = parents.size() - 1;
        if (i >= 0) {
            String cwd = ftp.printWorkingDirectory();
            String parent = dir.getParent();
            if (parent != null && !ftp.changeWorkingDirectory(this.resolveFile(parent))) {
                throw new BuildException("could not change to directory: %s", new Object[]{ftp.getReplyString()});
            }
            while (i >= 0) {
                if (!ftp.changeWorkingDirectory((dir = (File)parents.get(i--)).getName())) {
                    this.log("creating remote directory " + this.resolveFile(dir.getPath()), 3);
                    if (!ftp.makeDirectory(dir.getName())) {
                        this.handleMkDirFailure(ftp);
                    }
                    if (!ftp.changeWorkingDirectory(dir.getName())) {
                        throw new BuildException("could not change to directory: %s", new Object[]{ftp.getReplyString()});
                    }
                }
                this.dirCache.add(dir);
            }
            ftp.changeWorkingDirectory(cwd);
        }
    }

    private long getTimeDiff(FTPClient ftp) {
        long returnValue = 0L;
        File tempFile = this.findFileName(ftp);
        try {
            FILE_UTILS.createNewFile(tempFile);
            long localTimeStamp = tempFile.lastModified();
            BufferedInputStream instream = new BufferedInputStream(Files.newInputStream(tempFile.toPath(), new OpenOption[0]));
            ftp.storeFile(tempFile.getName(), (InputStream)instream);
            instream.close();
            boolean success = FTPReply.isPositiveCompletion((int)ftp.getReplyCode());
            if (success) {
                FTPFile[] ftpFiles = ftp.listFiles(tempFile.getName());
                if (ftpFiles.length == 1) {
                    long remoteTimeStamp = ftpFiles[0].getTimestamp().getTime().getTime();
                    returnValue = localTimeStamp - remoteTimeStamp;
                }
                ftp.deleteFile(ftpFiles[0].getName());
            }
            Delete mydelete = new Delete();
            mydelete.bindToOwner((Task)this);
            mydelete.setFile(tempFile.getCanonicalFile());
            mydelete.execute();
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e, this.getLocation());
        }
        return returnValue;
    }

    private File findFileName(FTPClient ftp) {
        FTPFile[] files = null;
        int maxIterations = 1000;
        for (int counter = 1; counter < 1000; ++counter) {
            File localFile = FILE_UTILS.createTempFile("ant" + Integer.toString(counter), ".tmp", null, false, false);
            String fileName = localFile.getName();
            boolean found = false;
            try {
                if (files == null) {
                    files = ftp.listFiles();
                }
                for (FTPFile file : files) {
                    if (file == null || !file.getName().equals(fileName)) continue;
                    found = true;
                    break;
                }
            }
            catch (IOException ioe) {
                throw new BuildException((Throwable)ioe, this.getLocation());
            }
            if (found) continue;
            localFile.deleteOnExit();
            return localFile;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isUpToDate(FTPClient ftp, File localFile, String remoteFile) throws IOException, BuildException {
        StringBuilder msg;
        this.log("checking date for " + remoteFile, 3);
        FTPFile[] files = ftp.listFiles(remoteFile);
        if (files == null || files.length == 0) {
            if (this.action == 0) {
                this.log("Could not date test remote file: " + remoteFile + "assuming out of date.", 3);
                return false;
            }
            throw new BuildException("could not date test remote file: %s", new Object[]{ftp.getReplyString()});
        }
        long remoteTimestamp = files[0].getTimestamp().getTime().getTime();
        long localTimestamp = localFile.lastModified();
        long adjustedRemoteTimestamp = remoteTimestamp + this.timeDiffMillis + this.granularityMillis;
        SimpleDateFormat simpleDateFormat = TIMESTAMP_LOGGING_SDF;
        synchronized (simpleDateFormat) {
            msg = new StringBuilder("   [").append(TIMESTAMP_LOGGING_SDF.format(new Date(localTimestamp))).append("] local");
        }
        this.log(msg.toString(), 3);
        simpleDateFormat = TIMESTAMP_LOGGING_SDF;
        synchronized (simpleDateFormat) {
            msg = new StringBuilder("   [").append(TIMESTAMP_LOGGING_SDF.format(new Date(adjustedRemoteTimestamp))).append("] remote");
        }
        if (remoteTimestamp != adjustedRemoteTimestamp) {
            simpleDateFormat = TIMESTAMP_LOGGING_SDF;
            synchronized (simpleDateFormat) {
                msg.append(" - (raw: ").append(TIMESTAMP_LOGGING_SDF.format(new Date(remoteTimestamp))).append(")");
            }
        }
        this.log(msg.toString(), 3);
        if (this.action == 0) {
            return adjustedRemoteTimestamp >= localTimestamp;
        }
        return localTimestamp >= adjustedRemoteTimestamp;
    }

    protected void doSiteCommand(FTPClient ftp, String theCMD) throws IOException, BuildException {
        this.log("Doing Site Command: " + theCMD, 3);
        if (!ftp.sendSiteCommand(theCMD)) {
            this.log("Failed to issue Site Command: " + theCMD, 1);
        } else {
            for (String reply : ftp.getReplyStrings()) {
                if (reply == null || reply.contains("200")) continue;
                this.log(reply, 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendFile(FTPClient ftp, String dir, String filename) throws IOException, BuildException {
        BufferedInputStream instream;
        block8: {
            File file;
            block7: {
                instream = null;
                try {
                    file = this.getProject().resolveFile(new File(dir, filename).getPath());
                    if (!this.newerOnly || !this.isUpToDate(ftp, file, this.resolveFile(filename))) break block7;
                }
                catch (Throwable throwable) {
                    FileUtils.close(instream);
                    throw throwable;
                }
                FileUtils.close(instream);
                return;
            }
            if (this.verbose) {
                this.log("transferring " + file.getAbsolutePath());
            }
            instream = new BufferedInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]));
            this.createParents(ftp, filename);
            ftp.storeFile(this.resolveFile(filename), (InputStream)instream);
            boolean success = FTPReply.isPositiveCompletion((int)ftp.getReplyCode());
            if (!success) {
                String s = "could not put file: " + ftp.getReplyString();
                if (this.skipFailedTransfers) {
                    this.log(s, 1);
                    ++this.skipped;
                    break block8;
                }
                throw new BuildException(s);
            }
            if (this.chmod != null) {
                this.doSiteCommand(ftp, "chmod " + this.chmod + " " + this.resolveFile(filename));
            }
            this.log("File " + file.getAbsolutePath() + " copied to " + this.server, 3);
            ++this.transferred;
        }
        FileUtils.close((InputStream)instream);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void delFile(FTPClient ftp, String filename) throws IOException, BuildException {
        if (this.verbose) {
            this.log("deleting " + filename);
        }
        if (!ftp.deleteFile(this.resolveFile(filename))) {
            String s = "could not delete file: " + ftp.getReplyString();
            if (!this.skipFailedTransfers) throw new BuildException(s);
            this.log(s, 1);
            ++this.skipped;
            return;
        } else {
            this.log("File " + filename + " deleted from " + this.server, 3);
            ++this.transferred;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void rmDir(FTPClient ftp, String dirname) throws IOException, BuildException {
        if (this.verbose) {
            this.log("removing " + dirname);
        }
        if (!ftp.removeDirectory(this.resolveFile(dirname))) {
            String s = "could not remove directory: " + ftp.getReplyString();
            if (!this.skipFailedTransfers) throw new BuildException(s);
            this.log(s, 1);
            ++this.skipped;
            return;
        } else {
            this.log("Directory " + dirname + " removed from " + this.server, 3);
            ++this.transferred;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getFile(FTPClient ftp, String dir, String filename) throws IOException, BuildException {
        BufferedOutputStream outstream;
        block9: {
            File pdir;
            File file;
            block8: {
                file = this.getProject().resolveFile(new File(dir, filename).getPath());
                outstream = null;
                try {
                    if (!this.newerOnly || !this.isUpToDate(ftp, file, this.resolveFile(filename))) break block8;
                }
                catch (Throwable throwable) {
                    FileUtils.close(outstream);
                    throw throwable;
                }
                FileUtils.close(outstream);
                return;
            }
            if (this.verbose) {
                this.log("transferring " + filename + " to " + file.getAbsolutePath());
            }
            if (!(pdir = file.getParentFile()).exists()) {
                pdir.mkdirs();
            }
            outstream = new BufferedOutputStream(Files.newOutputStream(file.toPath(), new OpenOption[0]));
            ftp.retrieveFile(this.resolveFile(filename), (OutputStream)outstream);
            if (!FTPReply.isPositiveCompletion((int)ftp.getReplyCode())) {
                String s = "could not get file: " + ftp.getReplyString();
                if (this.skipFailedTransfers) {
                    this.log(s, 1);
                    ++this.skipped;
                    break block9;
                }
                throw new BuildException(s);
            }
            this.log("File " + file.getAbsolutePath() + " copied from " + this.server, 3);
            ++this.transferred;
            if (!this.preserveLastModified) break block9;
            ((OutputStream)outstream).close();
            outstream = null;
            FTPFile[] remote = ftp.listFiles(this.resolveFile(filename));
            if (remote.length > 0) {
                FILE_UTILS.setFileLastModified(file, remote[0].getTimestamp().getTime().getTime());
            }
        }
        FileUtils.close((OutputStream)outstream);
    }

    protected void listFile(FTPClient ftp, BufferedWriter bw, String filename) throws IOException, BuildException {
        FTPFile[] ftpfiles;
        if (this.verbose) {
            this.log("listing " + filename);
        }
        if ((ftpfiles = ftp.listFiles(this.resolveFile(filename))) != null && ftpfiles.length > 0) {
            bw.write(ftpfiles[0].toString());
            bw.newLine();
            ++this.transferred;
        }
    }

    protected void makeRemoteDir(FTPClient ftp, String dir) throws IOException, BuildException {
        String workingDirectory = ftp.printWorkingDirectory();
        boolean absolute = dir.startsWith("/");
        if (this.verbose) {
            if (absolute || workingDirectory == null) {
                this.log("Creating directory: " + dir + " in /");
            } else {
                this.log("Creating directory: " + dir + " in " + workingDirectory);
            }
        }
        if (absolute) {
            ftp.changeWorkingDirectory("/");
        }
        StringTokenizer st = new StringTokenizer(dir, "/");
        while (st.hasMoreTokens()) {
            String subdir = st.nextToken();
            this.log("Checking " + subdir, 4);
            if (ftp.changeWorkingDirectory(subdir)) continue;
            if (ftp.makeDirectory(subdir)) {
                if (this.verbose) {
                    this.log("Directory created OK");
                }
                ftp.changeWorkingDirectory(subdir);
                continue;
            }
            int rc = ftp.getReplyCode();
            if (!this.ignoreNoncriticalErrors || rc != 550 && rc != 553 && rc != 521) {
                throw new BuildException("could not create directory: %s", new Object[]{ftp.getReplyString()});
            }
            if (!this.verbose) continue;
            this.log("Directory already exists");
        }
        if (workingDirectory != null) {
            ftp.changeWorkingDirectory(workingDirectory);
        }
    }

    private void handleMkDirFailure(FTPClient ftp) throws BuildException {
        int rc = ftp.getReplyCode();
        if (!this.ignoreNoncriticalErrors || rc != 550 && rc != 553 && rc != 521) {
            throw new BuildException("could not create directory: %s", new Object[]{ftp.getReplyString()});
        }
    }

    public void execute() throws BuildException {
        this.checkAttributes();
        FTPClient ftp = null;
        try {
            FTPClient lftp;
            this.log("Opening FTP connection to " + this.server, 3);
            ftp = new FTPClient();
            if (this.isConfigurationSet) {
                ftp = FTPConfigurator.configure(ftp, this);
            }
            ftp.setRemoteVerificationEnabled(this.enableRemoteVerification);
            ftp.connect(this.server, this.port);
            if (!FTPReply.isPositiveCompletion((int)ftp.getReplyCode())) {
                throw new BuildException("FTP connection failed: %s", new Object[]{ftp.getReplyString()});
            }
            this.log("connected", 3);
            this.log("logging in to FTP server", 3);
            if (this.account != null && !ftp.login(this.userid, this.password, this.account) || this.account == null && !ftp.login(this.userid, this.password)) {
                throw new BuildException("Could not login to FTP server");
            }
            this.log("login succeeded", 3);
            if (this.binary) {
                ftp.setFileType(2);
                if (!FTPReply.isPositiveCompletion((int)ftp.getReplyCode())) {
                    throw new BuildException("could not set transfer type: %s", new Object[]{ftp.getReplyString()});
                }
            } else {
                ftp.setFileType(0);
                if (!FTPReply.isPositiveCompletion((int)ftp.getReplyCode())) {
                    throw new BuildException("could not set transfer type: %s", new Object[]{ftp.getReplyString()});
                }
            }
            if (this.passive) {
                this.log("entering passive mode", 3);
                ftp.enterLocalPassiveMode();
                if (!FTPReply.isPositiveCompletion((int)ftp.getReplyCode())) {
                    throw new BuildException("could not enter into passive mode: %s", new Object[]{ftp.getReplyString()});
                }
            }
            if (this.initialSiteCommand != null) {
                lftp = ftp;
                this.executeRetryable(new RetryHandler(this.retriesAllowed, (Task)this), () -> this.doSiteCommand(lftp, this.initialSiteCommand), "initial site command: " + this.initialSiteCommand);
            }
            if (this.umask != null) {
                lftp = ftp;
                this.executeRetryable(new RetryHandler(this.retriesAllowed, (Task)this), () -> this.doSiteCommand(lftp, "umask " + this.umask), "umask " + this.umask);
            }
            if (this.action == 4) {
                lftp = ftp;
                this.executeRetryable(new RetryHandler(this.retriesAllowed, (Task)this), () -> this.makeRemoteDir(lftp, this.remotedir), this.remotedir);
            } else if (this.action == 7) {
                lftp = ftp;
                this.executeRetryable(new RetryHandler(this.retriesAllowed, (Task)this), () -> this.doSiteCommand(lftp, this.siteCommand), "Site Command: " + this.siteCommand);
            } else {
                if (this.remotedir != null) {
                    this.log("changing the remote directory to " + this.remotedir, 3);
                    ftp.changeWorkingDirectory(this.remotedir);
                    if (!FTPReply.isPositiveCompletion((int)ftp.getReplyCode())) {
                        throw new BuildException("could not change remote directory: %s", new Object[]{ftp.getReplyString()});
                    }
                }
                if (this.newerOnly && this.timeDiffAuto) {
                    this.timeDiffMillis = this.getTimeDiff(ftp);
                }
                this.log(ACTION_STRS[this.action] + " " + ACTION_TARGET_STRS[this.action]);
                this.transferFiles(ftp);
            }
        }
        catch (IOException ex) {
            throw new BuildException("error during FTP transfer: " + ex, (Throwable)ex);
        }
        finally {
            if (ftp != null && ftp.isConnected()) {
                try {
                    this.log("disconnecting", 3);
                    ftp.logout();
                    ftp.disconnect();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static class LanguageCode
    extends EnumeratedAttribute {
        private static final String[] VALID_LANGUAGE_CODES = LanguageCode.getValidLanguageCodes();

        private static String[] getValidLanguageCodes() {
            Collection c = FTPClientConfig.getSupportedLanguageCodes();
            String[] ret = new String[c.size() + 1];
            int i = 0;
            ret[i++] = "";
            for (String element : c) {
                ret[i++] = element;
            }
            return ret;
        }

        public String[] getValues() {
            return VALID_LANGUAGE_CODES;
        }

        static final LanguageCode getDefault() {
            LanguageCode lc = new LanguageCode();
            lc.setValue("");
            return lc;
        }
    }

    public static class FTPSystemType
    extends EnumeratedAttribute {
        private static final String[] VALID_SYSTEM_TYPES = new String[]{"", "UNIX", "VMS", "WINDOWS", "OS/2", "OS/400", "MVS"};

        public String[] getValues() {
            return VALID_SYSTEM_TYPES;
        }

        static final FTPSystemType getDefault() {
            FTPSystemType ftpst = new FTPSystemType();
            ftpst.setValue("");
            return ftpst;
        }
    }

    public static class Granularity
    extends EnumeratedAttribute {
        private static final String[] VALID_GRANULARITIES = new String[]{"", "MINUTE", "NONE"};

        public String[] getValues() {
            return VALID_GRANULARITIES;
        }

        public long getMilliseconds(int action) {
            String granularityU = this.getValue().toUpperCase(Locale.ENGLISH);
            if (granularityU.isEmpty() ? action == 0 : "MINUTE".equals(granularityU)) {
                return 60000L;
            }
            return 0L;
        }

        static final Granularity getDefault() {
            Granularity g = new Granularity();
            g.setValue("");
            return g;
        }
    }

    public static class Action
    extends EnumeratedAttribute {
        private static final String[] VALID_ACTIONS = new String[]{"send", "put", "recv", "get", "del", "delete", "list", "mkdir", "chmod", "rmdir", "site"};

        public String[] getValues() {
            return VALID_ACTIONS;
        }

        public int getAction() {
            switch (this.getValue().toLowerCase(Locale.ENGLISH)) {
                case "send": 
                case "put": {
                    return 0;
                }
                case "recv": 
                case "get": {
                    return 1;
                }
                case "del": 
                case "delete": {
                    return 2;
                }
                case "list": {
                    return 3;
                }
                case "chmod": {
                    return 5;
                }
                case "mkdir": {
                    return 4;
                }
                case "rmdir": {
                    return 6;
                }
                case "site": {
                    return 7;
                }
            }
            return 0;
        }
    }

    protected class FTPDirectoryScanner
    extends DirectoryScanner {
        protected FTPClient ftp = null;
        private String rootPath = null;
        private boolean remoteSystemCaseSensitive = false;
        private boolean remoteSensitivityChecked = false;
        private Map<String, FTPFile[]> fileListMap = new HashMap<String, FTPFile[]>();
        private Map<String, FTPFileProxy> scannedDirs = new HashMap<String, FTPFileProxy>();

        public FTPDirectoryScanner(FTPClient ftp) {
            this.ftp = ftp;
            this.setFollowSymlinks(false);
        }

        public void scan() {
            if (this.includes == null) {
                this.includes = new String[1];
                this.includes[0] = "**";
            }
            if (this.excludes == null) {
                this.excludes = new String[0];
            }
            this.filesIncluded = new VectorSet();
            this.filesNotIncluded = new Vector();
            this.filesExcluded = new VectorSet();
            this.dirsIncluded = new VectorSet();
            this.dirsNotIncluded = new Vector();
            this.dirsExcluded = new VectorSet();
            try {
                String cwd = this.ftp.printWorkingDirectory();
                this.forceRemoteSensitivityCheck();
                this.checkIncludePatterns();
                this.clearCaches();
                this.ftp.changeWorkingDirectory(cwd);
            }
            catch (IOException e) {
                throw new BuildException("Unable to scan FTP server: ", (Throwable)e);
            }
        }

        private void checkIncludePatterns() {
            HashMap<String, String> newroots = new HashMap<String, String>();
            for (String include : this.includes) {
                String newpattern = SelectorUtils.rtrimWildcardTokens((String)include);
                newroots.put(newpattern, include);
            }
            if (FTP.this.remotedir == null) {
                try {
                    FTP.this.remotedir = this.ftp.printWorkingDirectory();
                }
                catch (IOException e) {
                    throw new BuildException("could not read current ftp directory", FTP.this.getLocation());
                }
            }
            AntFTPRootFile baseFTPFile = new AntFTPRootFile(this.ftp, FTP.this.remotedir);
            this.rootPath = ((AntFTPFile)baseFTPFile).getAbsolutePath();
            if (newroots.containsKey("")) {
                this.scandir(this.rootPath, "", true);
            } else {
                newroots.forEach((k, v) -> this.scanRoots(baseFTPFile, (String)k, (String)v));
            }
        }

        private void scanRoots(AntFTPFile baseFTPFile, String currentelement, String originalpattern) {
            AntFTPFile myfile = new AntFTPFile(baseFTPFile, currentelement);
            boolean isOK = true;
            boolean traversesSymlinks = false;
            String path = null;
            if (myfile.exists()) {
                this.forceRemoteSensitivityCheck();
                if (this.remoteSensitivityChecked && this.remoteSystemCaseSensitive && this.isFollowSymlinks()) {
                    path = myfile.getFastRelativePath();
                } else {
                    try {
                        path = myfile.getRelativePath();
                        traversesSymlinks = myfile.isTraverseSymlinks();
                    }
                    catch (IOException be) {
                        throw new BuildException((Throwable)be, FTP.this.getLocation());
                    }
                    catch (BuildException be) {
                        isOK = false;
                    }
                }
            } else {
                isOK = false;
            }
            if (isOK) {
                currentelement = path.replace(FTP.this.remoteFileSep.charAt(0), File.separatorChar);
                if (!this.isFollowSymlinks() && traversesSymlinks) {
                    return;
                }
                if (myfile.isDirectory()) {
                    if (this.isIncluded(currentelement) && !currentelement.isEmpty()) {
                        this.accountForIncludedDir(currentelement, myfile, true);
                    } else {
                        if (!currentelement.isEmpty() && currentelement.charAt(currentelement.length() - 1) != File.separatorChar) {
                            currentelement = currentelement + File.separatorChar;
                        }
                        this.scandir(myfile.getAbsolutePath(), currentelement, true);
                    }
                } else if (this.isCaseSensitive && originalpattern.equals(currentelement)) {
                    this.accountForIncludedFile(currentelement);
                } else if (!this.isCaseSensitive && originalpattern.equalsIgnoreCase(currentelement)) {
                    this.accountForIncludedFile(currentelement);
                }
            }
        }

        protected void scandir(String dir, String vpath, boolean fast) {
            if (fast && this.hasBeenScanned(vpath)) {
                return;
            }
            try {
                if (!this.ftp.changeWorkingDirectory(dir)) {
                    return;
                }
                String completePath = null;
                completePath = !vpath.isEmpty() ? this.rootPath + FTP.this.remoteFileSep + vpath.replace(File.separatorChar, FTP.this.remoteFileSep.charAt(0)) : this.rootPath;
                FTPFile[] newfiles = this.listFiles(completePath, false);
                if (newfiles == null) {
                    this.ftp.changeToParentDirectory();
                    return;
                }
                for (FTPFile file : newfiles) {
                    if (file == null || ".".equals(file.getName()) || "..".equals(file.getName())) continue;
                    String name = vpath + file.getName();
                    this.scannedDirs.put(name, new FTPFileProxy(file));
                    if (FTP.this.isFunctioningAsDirectory(this.ftp, dir, file)) {
                        boolean slowScanAllowed = true;
                        if (!this.isFollowSymlinks() && file.isSymbolicLink()) {
                            this.dirsExcluded.addElement(name);
                            slowScanAllowed = false;
                        } else if (this.isIncluded(name)) {
                            this.accountForIncludedDir(name, new AntFTPFile(this.ftp, file, completePath), fast);
                        } else {
                            this.dirsNotIncluded.addElement(name);
                            if (fast && this.couldHoldIncluded(name)) {
                                this.scandir(file.getName(), name + File.separator, fast);
                            }
                        }
                        if (fast || !slowScanAllowed) continue;
                        this.scandir(file.getName(), name + File.separator, fast);
                        continue;
                    }
                    if (!this.isFollowSymlinks() && file.isSymbolicLink()) {
                        this.filesExcluded.addElement(name);
                        continue;
                    }
                    if (!FTP.this.isFunctioningAsFile(this.ftp, dir, file)) continue;
                    this.accountForIncludedFile(name);
                }
                this.ftp.changeToParentDirectory();
            }
            catch (IOException e) {
                throw new BuildException("Error while communicating with FTP server: ", (Throwable)e);
            }
        }

        private void accountForIncludedFile(String name) {
            if (!this.filesIncluded.contains(name) && !this.filesExcluded.contains(name)) {
                if (this.isIncluded(name)) {
                    if (!this.isExcluded(name) && this.isSelected(name, this.scannedDirs.get(name))) {
                        this.filesIncluded.addElement(name);
                    } else {
                        this.filesExcluded.addElement(name);
                    }
                } else {
                    this.filesNotIncluded.addElement(name);
                }
            }
        }

        private void accountForIncludedDir(String name, AntFTPFile file, boolean fast) {
            if (!this.dirsIncluded.contains(name) && !this.dirsExcluded.contains(name)) {
                if (!this.isExcluded(name)) {
                    if (fast) {
                        if (file.isSymbolicLink()) {
                            try {
                                file.getClient().changeWorkingDirectory(file.curpwd);
                            }
                            catch (IOException ioe) {
                                throw new BuildException("could not change directory to curpwd");
                            }
                            this.scandir(file.getLink(), name + File.separator, fast);
                        } else {
                            try {
                                file.getClient().changeWorkingDirectory(file.curpwd);
                            }
                            catch (IOException ioe) {
                                throw new BuildException("could not change directory to curpwd");
                            }
                            this.scandir(file.getName(), name + File.separator, fast);
                        }
                    }
                    this.dirsIncluded.addElement(name);
                } else {
                    this.dirsExcluded.addElement(name);
                    if (fast && this.couldHoldIncluded(name)) {
                        try {
                            file.getClient().changeWorkingDirectory(file.curpwd);
                        }
                        catch (IOException ioe) {
                            throw new BuildException("could not change directory to curpwd");
                        }
                        this.scandir(file.getName(), name + File.separator, fast);
                    }
                }
            }
        }

        private boolean hasBeenScanned(String vpath) {
            return this.scannedDirs.containsKey(vpath);
        }

        private void clearCaches() {
            this.fileListMap.clear();
            this.scannedDirs.clear();
        }

        public FTPFile[] listFiles(String directory, boolean changedir) {
            FTPFile[] result;
            String currentPath = directory;
            if (changedir) {
                try {
                    if (!this.ftp.changeWorkingDirectory(directory)) {
                        return null;
                    }
                    currentPath = this.ftp.printWorkingDirectory();
                }
                catch (IOException ioe) {
                    throw new BuildException((Throwable)ioe, FTP.this.getLocation());
                }
            }
            if (this.fileListMap.containsKey(currentPath)) {
                FTP.this.getProject().log("filelist map used in listing files", 4);
                return this.fileListMap.get(currentPath);
            }
            try {
                result = this.ftp.listFiles();
            }
            catch (IOException ioe) {
                throw new BuildException((Throwable)ioe, FTP.this.getLocation());
            }
            this.fileListMap.put(currentPath, result);
            if (!this.remoteSensitivityChecked) {
                this.checkRemoteSensitivity(result, directory);
            }
            return result;
        }

        private void forceRemoteSensitivityCheck() {
            if (!this.remoteSensitivityChecked) {
                try {
                    this.checkRemoteSensitivity(this.ftp.listFiles(), this.ftp.printWorkingDirectory());
                }
                catch (IOException ioe) {
                    throw new BuildException((Throwable)ioe, FTP.this.getLocation());
                }
            }
        }

        public FTPFile[] listFiles(String directory) {
            return this.listFiles(directory, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkRemoteSensitivity(FTPFile[] array, String directory) {
            if (array == null) {
                return;
            }
            boolean candidateFound = false;
            String target = null;
            for (int icounter = 0; icounter < array.length; ++icounter) {
                if (array[icounter] == null || !array[icounter].isDirectory() || ".".equals(array[icounter].getName()) || "..".equals(array[icounter].getName())) continue;
                candidateFound = true;
                target = this.fiddleName(array[icounter].getName());
                FTP.this.getProject().log("will try to cd to " + target + " where a directory called " + array[icounter].getName() + " exists", 4);
                for (int pcounter = 0; pcounter < array.length; ++pcounter) {
                    if (array[pcounter] == null || pcounter == icounter || !target.equals(array[pcounter].getName())) continue;
                    candidateFound = false;
                    break;
                }
                if (candidateFound) break;
            }
            if (candidateFound) {
                try {
                    FTP.this.getProject().log("testing case sensitivity, attempting to cd to " + target, 4);
                    this.remoteSystemCaseSensitive = !this.ftp.changeWorkingDirectory(target);
                }
                catch (IOException ioe) {
                    this.remoteSystemCaseSensitive = true;
                }
                finally {
                    try {
                        this.ftp.changeWorkingDirectory(directory);
                    }
                    catch (IOException ioe) {
                        throw new BuildException((Throwable)ioe, FTP.this.getLocation());
                    }
                }
                FTP.this.getProject().log("remote system is case sensitive : " + this.remoteSystemCaseSensitive, 3);
                this.remoteSensitivityChecked = true;
            }
        }

        private String fiddleName(String origin) {
            StringBuilder result = new StringBuilder();
            for (char ch : origin.toCharArray()) {
                if (Character.isLowerCase(ch)) {
                    result.append(Character.toUpperCase(ch));
                    continue;
                }
                if (Character.isUpperCase(ch)) {
                    result.append(Character.toLowerCase(ch));
                    continue;
                }
                result.append(ch);
            }
            return result.toString();
        }

        protected class AntFTPRootFile
        extends AntFTPFile {
            private String remotedir;

            public AntFTPRootFile(FTPClient aclient, String remotedir) {
                super(aclient, null, remotedir);
                this.remotedir = remotedir;
                try {
                    this.getClient().changeWorkingDirectory(this.remotedir);
                    this.setCurpwd(this.getClient().printWorkingDirectory());
                }
                catch (IOException ioe) {
                    throw new BuildException((Throwable)ioe, FTP.this.getLocation());
                }
            }

            @Override
            public String getAbsolutePath() {
                return this.getCurpwd();
            }

            @Override
            public String getRelativePath() throws BuildException, IOException {
                return "";
            }
        }

        protected class AntFTPFile {
            private FTPClient client;
            private String curpwd;
            private FTPFile ftpFile;
            private AntFTPFile parent = null;
            private boolean relativePathCalculated = false;
            private boolean traversesSymlinks = false;
            private String relativePath = "";

            public AntFTPFile(FTPClient client, FTPFile ftpFile, String curpwd) {
                this.client = client;
                this.ftpFile = ftpFile;
                this.curpwd = curpwd;
            }

            public AntFTPFile(AntFTPFile parent, String path) {
                this.parent = parent;
                this.client = parent.client;
                Vector pathElements = SelectorUtils.tokenizePath((String)path);
                try {
                    if (!this.client.changeWorkingDirectory(parent.getAbsolutePath())) {
                        return;
                    }
                    this.curpwd = parent.getAbsolutePath();
                }
                catch (IOException ioe) {
                    throw new BuildException("could not change working dir to %s", new Object[]{parent.curpwd});
                }
                for (String currentPathElement : pathElements) {
                    try {
                        if (!this.client.changeWorkingDirectory(currentPathElement)) {
                            if (!(FTPDirectoryScanner.this.isCaseSensitive() || !FTPDirectoryScanner.this.remoteSystemCaseSensitive && FTPDirectoryScanner.this.remoteSensitivityChecked || (currentPathElement = this.findPathElementCaseUnsensitive(this.curpwd, currentPathElement)) != null)) {
                                return;
                            }
                            return;
                        }
                        this.curpwd = this.getCurpwdPlusFileSep() + currentPathElement;
                    }
                    catch (IOException ioe) {
                        throw new BuildException("could not change working dir to %s from %s", new Object[]{currentPathElement, this.curpwd});
                    }
                }
                String lastpathelement = (String)pathElements.get(pathElements.size() - 1);
                FTPFile[] theFiles = FTPDirectoryScanner.this.listFiles(this.curpwd);
                this.ftpFile = this.getFile(theFiles, lastpathelement);
            }

            private String findPathElementCaseUnsensitive(String parentPath, String soughtPathElement) {
                FTPFile[] files = FTPDirectoryScanner.this.listFiles(parentPath, false);
                if (files == null) {
                    return null;
                }
                for (FTPFile file : files) {
                    if (file == null || !file.getName().equalsIgnoreCase(soughtPathElement)) continue;
                    return file.getName();
                }
                return null;
            }

            public boolean exists() {
                return this.ftpFile != null;
            }

            public String getLink() {
                return this.ftpFile.getLink();
            }

            public String getName() {
                return this.ftpFile.getName();
            }

            public String getAbsolutePath() {
                return this.getCurpwdPlusFileSep() + this.ftpFile.getName();
            }

            public String getFastRelativePath() {
                String absPath = this.getAbsolutePath();
                if (absPath.startsWith(FTPDirectoryScanner.this.rootPath + FTP.this.remoteFileSep)) {
                    return absPath.substring(FTPDirectoryScanner.this.rootPath.length() + FTP.this.remoteFileSep.length());
                }
                return null;
            }

            public String getRelativePath() throws IOException, BuildException {
                if (!this.relativePathCalculated) {
                    if (this.parent != null) {
                        this.traversesSymlinks = this.parent.isTraverseSymlinks();
                        this.relativePath = this.getRelativePath(this.parent.getAbsolutePath(), this.parent.getRelativePath());
                    } else {
                        this.relativePath = this.getRelativePath(FTPDirectoryScanner.this.rootPath, "");
                        this.relativePathCalculated = true;
                    }
                }
                return this.relativePath;
            }

            private String getRelativePath(String currentPath, String currentRelativePath) {
                Vector pathElements = SelectorUtils.tokenizePath((String)this.getAbsolutePath(), (String)FTP.this.remoteFileSep);
                StringBuilder relPath = new StringBuilder(currentRelativePath == null ? "" : currentRelativePath);
                for (String currentElement : pathElements.subList(SelectorUtils.tokenizePath((String)currentPath, (String)FTP.this.remoteFileSep).size(), pathElements.size())) {
                    FTPFile[] theFiles = FTPDirectoryScanner.this.listFiles(currentPath);
                    FTPFile theFile = null;
                    if (theFiles != null) {
                        theFile = this.getFile(theFiles, currentElement);
                    }
                    if (relPath.length() > 0) {
                        relPath.append(FTP.this.remoteFileSep);
                    }
                    if (theFile == null) {
                        relPath.append(currentElement);
                        currentPath = currentPath + FTP.this.remoteFileSep + currentElement;
                        FTP.this.log("Hidden file " + relPath + " assumed to not be a symlink.", 3);
                        continue;
                    }
                    this.traversesSymlinks = this.traversesSymlinks || theFile.isSymbolicLink();
                    relPath.append(theFile.getName());
                    currentPath = currentPath + FTP.this.remoteFileSep + theFile.getName();
                }
                return relPath.toString();
            }

            public FTPFile getFile(FTPFile[] theFiles, String lastpathelement) {
                if (theFiles == null) {
                    return null;
                }
                Predicate<String> test = FTPDirectoryScanner.this.isCaseSensitive() ? lastpathelement::equals : lastpathelement::equalsIgnoreCase;
                return Stream.of(theFiles).filter(Objects::nonNull).filter(f -> test.test(f.getName())).findFirst().orElse(null);
            }

            public boolean isDirectory() {
                return this.ftpFile.isDirectory();
            }

            public boolean isSymbolicLink() {
                return this.ftpFile.isSymbolicLink();
            }

            protected FTPClient getClient() {
                return this.client;
            }

            protected void setCurpwd(String curpwd) {
                this.curpwd = curpwd;
            }

            public String getCurpwd() {
                return this.curpwd;
            }

            public String getCurpwdPlusFileSep() {
                return this.curpwd.endsWith(FTP.this.remoteFileSep) ? this.curpwd : this.curpwd + FTP.this.remoteFileSep;
            }

            public boolean isTraverseSymlinks() throws IOException, BuildException {
                if (!this.relativePathCalculated) {
                    this.getRelativePath();
                }
                return this.traversesSymlinks;
            }

            public String toString() {
                return "AntFtpFile: " + this.curpwd + "%" + this.ftpFile;
            }
        }
    }

    protected static class FTPFileProxy
    extends File {
        private static final long serialVersionUID = 1L;
        private final FTPFile file;
        private final String[] parts;
        private final String name;

        public FTPFileProxy(FTPFile file) {
            super(file.getName());
            this.name = file.getName();
            this.file = file;
            this.parts = FileUtils.getPathStack((String)this.name);
        }

        public FTPFileProxy(String completePath) {
            super(completePath);
            this.file = null;
            this.name = completePath;
            this.parts = FileUtils.getPathStack((String)completePath);
        }

        @Override
        public boolean exists() {
            return true;
        }

        @Override
        public String getAbsolutePath() {
            return this.name;
        }

        @Override
        public String getName() {
            return this.parts.length > 0 ? this.parts[this.parts.length - 1] : this.name;
        }

        @Override
        public String getParent() {
            return File.separator + String.join((CharSequence)File.separator, this.parts);
        }

        @Override
        public String getPath() {
            return this.name;
        }

        @Override
        public boolean isAbsolute() {
            return true;
        }

        @Override
        public boolean isDirectory() {
            return this.file == null;
        }

        @Override
        public boolean isFile() {
            return this.file != null;
        }

        @Override
        public boolean isHidden() {
            return false;
        }

        @Override
        public long lastModified() {
            if (this.file != null) {
                return this.file.getTimestamp().getTimeInMillis();
            }
            return 0L;
        }

        @Override
        public long length() {
            if (this.file != null) {
                return this.file.getSize();
            }
            return 0L;
        }
    }
}

