/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.geo.geometry;

import org.elasticsearch.geo.geometry.Geometry;
import org.elasticsearch.geo.geometry.GeometryUtils;
import org.elasticsearch.geo.geometry.GeometryVisitor;
import org.elasticsearch.geo.geometry.ShapeType;

public class Rectangle
implements Geometry {
    public static final Rectangle EMPTY = new Rectangle();
    private final double minLat;
    private final double minLon;
    private final double minAlt;
    private final double maxLat;
    private final double maxLon;
    private final double maxAlt;
    private final boolean empty;

    private Rectangle() {
        this.minLat = 0.0;
        this.minLon = 0.0;
        this.maxLat = 0.0;
        this.maxLon = 0.0;
        this.minAlt = Double.NaN;
        this.maxAlt = Double.NaN;
        this.empty = true;
    }

    public Rectangle(double minLat, double maxLat, double minLon, double maxLon) {
        this(minLat, maxLat, minLon, maxLon, Double.NaN, Double.NaN);
    }

    public Rectangle(double minLat, double maxLat, double minLon, double maxLon, double minAlt, double maxAlt) {
        GeometryUtils.checkLatitude(minLat);
        GeometryUtils.checkLatitude(maxLat);
        GeometryUtils.checkLongitude(minLon);
        GeometryUtils.checkLongitude(maxLon);
        this.minLon = minLon;
        this.maxLon = maxLon;
        this.minLat = minLat;
        this.maxLat = maxLat;
        this.minAlt = minAlt;
        this.maxAlt = maxAlt;
        this.empty = false;
        if (maxLat < minLat) {
            throw new IllegalArgumentException("max lat cannot be less than min lat");
        }
        if (Double.isNaN(minAlt) != Double.isNaN(maxAlt)) {
            throw new IllegalArgumentException("only one altitude value is specified");
        }
    }

    public double getWidth() {
        if (this.crossesDateline()) {
            return 180.0 - this.minLon + this.maxLon - -180.0;
        }
        return this.maxLon - this.minLon;
    }

    public double getHeight() {
        return this.maxLat - this.minLat;
    }

    public double getMinLat() {
        return this.minLat;
    }

    public double getMinLon() {
        return this.minLon;
    }

    public double getMinAlt() {
        return this.minAlt;
    }

    public double getMaxLat() {
        return this.maxLat;
    }

    public double getMaxLon() {
        return this.maxLon;
    }

    public double getMaxAlt() {
        return this.maxAlt;
    }

    @Override
    public ShapeType type() {
        return ShapeType.ENVELOPE;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Rectangle(lat=");
        b.append(this.minLat);
        b.append(" TO ");
        b.append(this.maxLat);
        b.append(" lon=");
        b.append(this.minLon);
        b.append(" TO ");
        b.append(this.maxLon);
        if (this.maxLon < this.minLon) {
            b.append(" [crosses dateline!]");
        }
        if (this.hasAlt()) {
            b.append(" alt=");
            b.append(this.minAlt);
            b.append(" TO ");
            b.append(this.maxAlt);
        }
        b.append(")");
        return b.toString();
    }

    public boolean crossesDateline() {
        return this.maxLon < this.minLon;
    }

    public boolean containsPoint(double lat, double lon) {
        if (lat >= this.minLat && lat <= this.maxLat) {
            return this.crossesDateline() ? lon >= this.minLon || lon <= this.maxLon : lon >= this.minLon && lon <= this.maxLon;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Rectangle rectangle = (Rectangle)o;
        if (Double.compare(rectangle.minLat, this.minLat) != 0) {
            return false;
        }
        if (Double.compare(rectangle.minLon, this.minLon) != 0) {
            return false;
        }
        if (Double.compare(rectangle.maxLat, this.maxLat) != 0) {
            return false;
        }
        if (Double.compare(rectangle.maxLon, this.maxLon) != 0) {
            return false;
        }
        if (Double.compare(rectangle.minAlt, this.minAlt) != 0) {
            return false;
        }
        return Double.compare(rectangle.maxAlt, this.maxAlt) == 0;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.minLat);
        int result = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.minLon);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.maxLat);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.maxLon);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.minAlt);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.maxAlt);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    @Override
    public <T, E extends Exception> T visit(GeometryVisitor<T, E> visitor) throws E {
        return visitor.visit(this);
    }

    @Override
    public boolean isEmpty() {
        return this.empty;
    }

    @Override
    public boolean hasAlt() {
        return !Double.isNaN(this.maxAlt);
    }
}

